function pseudorange = my_computePseudorange(taus, tau_ref, idx_firstBitSubframe)
%COMPUTEPSEUDORANGE Compute pseudorange for one GPS satellite
%   PSEUDORANGE = COMPUTEPSEUDORANGE(TAUS, TAU_REF, TAU_FIRSTBITSUBFRAME)
%   TAUS: vector of indices into the received samples where each decoded 
%   bit begins. The length of TAUS is equal to the number of decoded bits.
%   TAU_REF: (scalar) index into the vector of received samples where the 
%   position of the receiver is to be computed.
%   IDX_FIRSTBITSUBRAME: index into the sequence of bits where the first 
%   subframe starts for this satellite.
%   PSEUDORANGE: computed pseudorange for the satellite (in meters).

% tau_ref should be bigger than 0 (the reference time should be after
% turning on the receiver)
% tau_ref is considered to be lower than the start of the first complete
% subframe