% fonction retournant l'hydrogramme de crue. si t est un vecteur la
% fonction retourne un vecteur et si q est un scalaire la fonction retourne
% un scalaire

function [q] = qt(t, tc, qp)
[m,n] = size(t);
if(m > 1 || n > 1)
    q = zeros(m,n);
    for i = 1 : length(t)
        if(t(i) < tc)
            q(i) = qp.*t(i)./tc;
        elseif(t(i) >= tc && t(i) <= 2*tc)
            q(i) = (2 - t(i)./tc).*qp;
        else
            q(i) = 0;
        end
    end

elseif(m == 1 && n == 1)
    if(t < tc)
        q = qp*t/tc;
    else
        q = (2- t/tc)*qp;
    end
else
    q = 0;
end