% fonction retournant la hauteur d'eau au bord. si t est un vecteur la
% fonction retourne un vecteur et si q est un scalaire la fonction retourne
% un scalaire. on utilise la loi de Manning-Strickler pour transformer le
% dbit en hauteur d'eau.


function [h] = hl(t, K, j, tc, qp, h0)

[m,n] = size(t);

if(m > 1 || n > 1)
    h = zeros(m,n);
    for i = 1 : length(t)
        if(t(i) < tc)
            h(i) = (qp.*t(i)./(K.*tc.*sqrt(j))).^(3/5) + h0;
        elseif(t(i) >= tc && t(i) <= 2*tc)
            h(i) = ((2 - t(i)./tc).*qp/(K.*sqrt(j))).^(3/5) + h0;
        else
            h(i) = 0;
        end
    end
elseif(m == 1 && n == 1)
    if(t < tc)
        h = (qp.*t./(K.*tc.*sqrt(j))).^(3/5) + h0;
    elseif(t >= tc && t <= 2*tc)
        h = ((2 - t./tc).*qp/(K.*sqrt(j))).^(3/5) + h0;
    else
        h = 0;
    end
else
    h = 0;
end