% paramtres d'affichage par dfault, tel que la taille de le police,
% l'paisseur des lignes des courbes, l'interpreteur de text (afin
% d'utiliser les commandes LaTeX ainsi que la police LaTeX : CMU Serif)

fontSize = 32;
lineWidth = 2.5;
set(groot,'defaulttextinterpreter','latex');
set(groot,'DefaultAxesFontSize', fontSize);
set(groot,'DefaultAxesFontName','CMU Serif');
set(groot,'DefaultTextFontName','CMU Serif');

%%  mthode des caractristiques pour un problme aux valeurs initiales

% dfinition des chelles de temps et d'espace pour la rsolution du
% problme aux valeurs initiales

tini = 0;   % temps initial (t_0)
dt = 0.01;  % pas de temps
tend = 1;   % temps final (t_f)
t = tini:dt:tend;
xini = -40; % position initiale
dx = 0.1;   % pas d'espace
xend = 80;  % position finale
x = xini:dx:xend;

% facteurs de forme de la fonction hauteur initiale hi
hn = 2;
deltah = 6;
l0 = 10;

% calcul de la condition initiale  travers la fonction hi. cette fonction
% retourne un vecteur si la valeur de l'argument x est un vecteur et
% retournr un scalaire si la valeur de x est scalaire

hini = hi(x, hn, deltah, l0);

figure
plot(x, hini, 'k-', 'LineWidth', lineWidth)
xlabel('$x$')
ylabel('$h$')
axis([xini xend 0 10])

%   paramtres hydrauliques

K = 75;     % rugosit de Manning-Strickler
j = 0.01;   % pente 

% vecteur contenant les positions sur lesquelles on va calculer les courbes
% caractristiques

da = 5; % pas d'espace des courbes caractristiques (tous les 5 m)
a = xini : da : xend - 40;

% on dessine les caractristiques sur les positions dfinies par le vecteur
% a

figure
for i = 1 : length(a)
    % calcul de la pente de la courbe caractristique
    ch = 5*K*sqrt(j)*hi(a(i), hn, deltah, l0)^(2/3)/3;
    % courbe caractristique x = ct + x_0
    cara = ch*t + a(i);
    plot(cara, t, 'k-', 'LineWidth', 1.5)
    hold on;
    
end
% on dessine par dessus les courbes caractristiques la hauteur initiale
% afin de mieux remarquer la diffrence de pente des courbes dues aux
% diffrences de hauteur d'eau initiale
plot(x, hini/20-0.1, 'b-', 'LineWidth', lineWidth)
text(60, 0.35, '$h_{i}(x)$', 'Color', 'b', 'FontSize', 24)
h = text(-20, 0.6, 'caracteristique', 'Color', 'k', 'FontSize', 24);
set(h, 'Rotation', 72)
xlabel('$x$')
ylabel('$t$')
axis([xini xend tini tend])

% vecteur contenant les temps auxquels vont tre calculs la hauteur d'eau
% qui va tre dform

dta = 0.1;
ta = tini : dta : tend;

% condition initiale

hini = hi(x, hn, deltah, l0);

lgnd = cell(length(ta), 1);
lgnd{1} = '$h_i$';
figure
plot(x, hini, 'k-', 'LineWidth', lineWidth)
hold on
for k = 2 : length(ta)
    
    % calcul de l'volution du vecteur condition initiale. pour ce faire on
    % dtermine l'volution de la position x dans le temps de chaque point
    % le long de la courbe caractristique correspondante. on met ensuite 
    % jour le vecteur hauteur initial hini dans le temps
    for i = 1 : length(hini)
        
        ch = 5*K*sqrt(j)*hi(x(i), hn, deltah, l0)^(2/3)/3;
        xp(i) = x(i) + ch*ta(k);
        
    end
    
    plot(xp, hini, 'LineWidth', 1.5, 'Color', [rand rand rand])
    hold on
    lgnd{k} = ['$h$ a $t =$ ' num2str(ta(k)) ' s'];
    
end
xlabel('$x$')
ylabel('$h$')
axis([xini xend 0 10])
lhnd =legend(lgnd,  'Location', 'EastOutside','Interpreter','latex',...
    'FontSize', fontSize-6);


%%  mthode des caractristiques pour un problme aux limites

% paramtres temporels de la contition  la limite (hydrogramme de crue)

h0 = 0;     % hauteur initiale d'eau
tc = 2000;  % temps de concentration de la crue
Qp = 20;    % dbit de pointe
W = 10;     % largeur de la section
qp = Qp/W;  % dbit de pointe par unit de longeur

% pas de temps
dt = 1; 
% vecteur temporel
t = 0 : dt : 6*tc;
% hydrogramme de crue
q = qt(t, tc, qp);

figure
plot(t, q, 'k-', 'LineWidth', lineWidth)
xlabel('$t$')
ylabel('$q$')

% calcul de la condition  la limite (hauteur d'eau)  partir de
% l'hydrogramme de crue. cette fonction transforme le dbit en hauteur
% d'eau par une loi de Manning-Strickler
h_l = hl(t, K, j, tc, qp, h0);

figure
plot(t, h_l, 'k-', 'LineWidth', lineWidth)
xlabel('$t$')
ylabel('$h_l$')

% vecteur contenant les temps auxquels vont tre calculs les courbes
% caractristiques.

tauini = 0;
dtau = 400*dt;
tauend = 2*tc;
tau = tauini : dtau : tauend;

lgnd = cell(length(tau)-2, 1);
figure
for i = 2 : length(tau) - 1
    % calcul de la pente de la courbe caractristique
    ch = 5*K*sqrt(j)*hl(tau(i), K, j, tc, qp, h0)^(2/3)/3;
    % calcul de la courbe caractristique
    cara = 1/ch*(t - tau(i));
    % on va dessiner en gras les deux premires courbes caractristiques
    % ainsi que la courbe correspondant au temps de concentration de la
    % crue.
    if(i == 2 || i ==  length(tau) - 1)
        plot(cara, t, 'LineWidth', 4.5, 'Color', 'k')
    elseif(tau(i) == tc)
        plot(cara, t, 'LineWidth', 4.5, 'Color', 'k')
    else
        plot(cara, t, 'LineWidth', 1.5, 'Color', 'k')
    end
    hold on;
    lgnd{i-1} = ['$t = $ ' num2str(tau(i)/tc) ' $t_c$, $c[h_l(t)] = $ ' ...
        num2str(ch)];
    
end
plot([], [], 'LineWidth', 1.5, 'LineStyle','--', 'Color', 'k')
hold on
xlabel('$x$')
ylabel('$t$')
axis([0 2000 0 4*tc])

