% paramtres d'affichage par dfault, tel que la taille de le police,
% l'paisseur des lignes des courbes, l'interpreteur de text (afin
% d'utiliser les commandes LaTeX ainsi que la police LaTeX : CMU Serif)

fontSize = 32;
lineWidth = 2.5;
set(groot,'defaulttextinterpreter','latex');
set(groot,'DefaultAxesFontSize', fontSize);
set(groot,'DefaultAxesFontName','CMU Serif');
set(groot,'DefaultTextFontName','CMU Serif');

%%  chargement des donnes

% chargement des hydrogrammes calculs avec Iber. ces hydrogrammes sont
% stocks dans les variables Q [m^3/s] et t [s]
nsection = 14;
% t = zeros(1, nsection);
% Q = zeros(1, nsection);
for i = 1 : nsection
    A = load(['section' num2str(i) '.txt']);
    t(:,i) = A(:,1);
    Q(:,i) = A(:,2);
end

% chargement des distances entre chacune des sections, les distances ont
% t calcules avec Iber. ces distances sont en [m]
distances = load('distances.txt');

% chargement des profils d'altitude de chacune des sections. on les
% sauvegarde dans une cell car ces donnes ne sont pas homognes (chaque
% couple de vecteur X et Z ne fait pas la mme longueur)
nprofil = 14;
X = cell(nprofil, 1);
Z = cell(nprofil, 1);
for i = 1 : nprofil
    A = load(['profil' num2str(i) '.txt']);
    X{i} = A(:,1);
    Z{i} = A(:,2);
end

%%  dessin des donnes

%   dessin des hydrogrammes
lgnd = cell(nprofil,1); % on cr une cell (vide) contenant les lgende que l'on va afficher sur le graphe
figure
title('hydrogrammes')
for i = 1 : 14
    plot(t(:,i), Q(:,i), 'Color', [rand rand rand])
    hold on
    lgnd{i} = ['section ' num2str(i)];  % on rdige dans chaque lments de la cellule la lgende lui correspondant 
end
xlabel('$t$ [s]')
ylabel('$Q$ [m$^3$/s]')
lgd = legend(lgnd,  'Location', 'EastOutside', 'Interpreter','latex',...
    'FontSize', fontSize-6);

%   dessin des profils d'altitude

figure
title('profils')
for i = 1 : nprofil
    plot(X{i}, Z{i}, 'Color', [rand rand rand])
    hold on
end
xlabel('$x$ [m]')
ylabel('$z$ [m]')
legend('profil 1', 'profil 2', 'profil 3', 'profil 4')

%   calculs des pentes

pente = zeros(nprofil-1,1);
% on calcul la pente entre diffrentes section en prenant comme altitude de
% rfrence le point le plus bas de chaque profil d'altitude. on calcul la
% la pente en considrant la distance entre deux profils conscutifs et la
% diffrence d'altitude entre ces deux profils. la pentes ainsi value est
% exprime en [%] (elle correspond  la tangente de l'angle).
for i = 1 : nprofil-1

    pente(i) = abs(min(Z{i+1}) - min(Z{i}))/distances(i);
    
end

% on calcul la pente moyenne comme la moyenne des pentes successives
pente_moyenne = mean(pente);

% on calcul la pente totale comme la pente entre le premier et le dernier
% profil d'altitude
pente_tot = abs(min(Z{1}) - min(Z{end}))/(sum(distances));

% les deux estimations tant trs proches l'une de l'autre, on va utliser
% par la suite la pente moyenne

figure
plot(1:nprofil-1, pente, 'kd', 'MarkerSize', 16)
xlabel('section')
ylabel('pente [\%]')
text(7, 0.04, ['pente moyenne = ' num2str(pente_moyenne) ' [\%]'],...
    'FontSize', fontSize)

%%  estimation de la vitesse de propagation de l'onde de crue

%   calcul du temps d'arriver de la crue de pointe

% on dtermine le temps d'occurence du dbit de pointe
for i = 1 : nsection
    
    qmax = max(Q(:,i));
    tmax(i) = t(find(Q(:, i) == qmax), i);
    Qmax(i) = qmax;
    tmax(i);
    
end
% on calcul les intervalles de temps entre chaque arrive de dbit de
% pointe
dt = diff(tmax);
dt = dt';

% on calcul les vitesses de crues
v_crue = distances./dt;

figure
plot(1:nsection-1, v_crue)
xlabel('section')
ylabel('$c_{crue}$ m/s')

% certaine crue ayant une valeur ngative (non-physique), on supprime
% manuellement ces valeurs en leur assignant comme valeur NaN (not a
% number)

for i = 1 : length(dt)
    if(dt(i) < 0)
        dt2(i) = NaN;
    elseif(dt(i) == 0)
        dt2(i) = NaN;
    else
        dt2(i) = dt(i);
    end
end
dt2 = dt2';
% calcul des vitesses
v_crue2 = distances./dt2;

figure
plot(1:nsection-1, v_crue2, 'kd', 'MarkerSize', 16)
xlabel('section')
ylabel('$c_{crue}$ [m/s]')
title('vitesse de propagation de la crue')


%%  Calcul de la vitesse de propagation de la crue avec la formule de Kleitz-Seddon

%   interpolation des donnes des profils d'altitude

% tous les profils d'altitude n'ont pas la mme taille et de plus certaines
% valeur de X sont rptes (du  des imprcisions de l'outil d'exportation
% de la topographie). il faut "corriger" ces erreurs en interpolant les
% donnes afin de remplir les "trous" et aussi afin d'avoir des vecteurs
% suffisement dense pour que les courbes aient une certaine rgularit.

% taille d'interpolation (nombre d'lments des vecteurs interpols)
n_interp = 500; 
% pr-allocation des donnes (afin d'acclrer les calculs)
Xinterp = zeros(n_interp, nprofil);
Zinterp = zeros(n_interp, nprofil);

for i = 1 : nprofil
    xmin = min(X{i});
    xmax = max(X{i});
    x = linspace(xmin, xmax, length(Z{i}))';
    % interpolation du vecteur x
    x_interp = linspace(xmin, xmax, n_interp);
    x_interp = x_interp';
    % interpolation du vecteur z
    z_interp = interp1(x, Z{i}, x_interp, 'linear');
    Xinterp(:, i) = x_interp;
    Zinterp(:, i) = z_interp;
end

% on va maintenant calculer les courbes de dbitances Q = f(h) par une loi
% de Manning-Strickler. il nous faut pour cela valuer les sections
% mouilles ainsi que les primtre mouills. ceci est fait  travers la
% fonction debitance.m. on va tester cette fonction sur une section test de
% forme rectangulaire de largeur l = 20 m et profondeur h = 10.

%   section test

xtest = [0 1 1.1 20.9 21 25];
ztest = [10 10 0 0 10 10];
xmin = min(xtest);
xmax = max(xtest);
xtest_interp = linspace(xmin, xmax, n_interp)';
ztest_interp = interp1(xtest, ztest, xtest_interp, 'linear');

figure
plot(xtest, ztest, 'k-','LineWidth', lineWidth)
xlabel('$x$ [m]')
ylabel('$z$ [m]')
title('section rectangulaire')

% rugosit du lit
K = 25;
% pente du lit
i = 0.01;

[h, S, chi] = debitance(xtest_interp, ztest_interp, K, i);
% dbitance par loi de Manning-Strickler
QQ = K.*S.*sqrt(i).*(S./chi).^(2/3);

figure
plot(h, S, 'k-','LineWidth', lineWidth)
xlabel('$h$ [m]')
ylabel('$S$ [m$^2$]')
title('section rectangulaire')

figure
plot(h, chi, 'k-','LineWidth', lineWidth)
xlabel('$h$ [m]')
ylabel('$\chi$ [m]')
title('section rectangulaire')

figure
plot(h, QQ, 'k-','LineWidth', lineWidth)
xlabel('$h$ [m]')
ylabel('$Q$ [m$^3$/s]')
title('section rectangulaire')



%   calcul de la dbitance pour les profils rls

Q = zeros(n_interp,nprofil);
S = zeros(n_interp,nprofil);
chi = zeros(n_interp,nprofil);
h = zeros(n_interp,nprofil);

for i = 1 : nprofil
    
    [hh, SS, chichi] = debitance(Xinterp(:,i), Zinterp(:,i),...
        K, pente_moyenne);
    h(:,i) = hh;
    S(:,i) = SS;
    chi(:,i) = chichi;
    Q(:,i) = K.*SS.*sqrt(i).*(SS./chichi).^(2/3);

end

% on va afficher les rsultats

%   surface mouille en fonction de la hauteur d'eau

figure
for i = 1 : nprofil
    plot(h(:, i), S(:, i), 'Color', [rand rand rand], 'LineWidth', lineWidth)
    hold on

end
xlabel('$h$ [m]')
ylabel('$S$ [m$^2$]')
title('surface mouillee')
lgd = legend(lgnd,  'Location', 'EastOutside', 'Interpreter','latex',...
    'FontSize', fontSize - 6);
axis([0 0.32 0 2])

%   dbit en fonction de la surface mouille

figure
for i = 1 : nprofil
    plot(S(:, i), Q(:, i), 'Color', [rand rand rand], 'LineWidth', lineWidth)
    hold on
    
end
plot([0 1.2], [20 20], 'k-.', 'LineWidth', lineWidth)
text(0.25, 18, 'crue de pointe', 'FontSize', fontSize)
xlabel('$S$ [m$^2$]')
ylabel('$Q$ [m$^3$/s]')
title('debitances')
lgd = legend(lgnd,  'Location', 'EastOutside', 'Interpreter','latex',...
    'FontSize', fontSize - 6);
axis([0 1.2 0 40])

%   dbit en fonction de la hauteur d'eau

figure
for i = 1 : nprofil
    plot(h(:, i), Q(:, i), 'Color', [rand rand rand], 'LineWidth', lineWidth)
    hold on
    
end
plot([0 0.32], [20 20], 'k-.', 'LineWidth', lineWidth)
text(0.07, 18, 'crue de pointe', 'FontSize', fontSize)
xlabel('$h$ [m]')
ylabel('$Q$ [m$^3$/s]')
title('debitances')
lgd = legend(lgnd,  'Location', 'EastOutside', 'Interpreter','latex',...
    'FontSize', fontSize - 6);
axis([0 0.32 0 40])

%%  on va calculer la clrit de l'onde de crue avec la formule de Kleitz-Seldon

%   trouver les indices correspondant a Q = 20 m^3/s

ind = zeros(nprofil, 1);
inds = cell(nprofil, 1);
for i = 1 : nprofil
    
    id = find(Q(:, i) > 15 & Q(:, i) < 25);
    inds{i} = id;
    ind(i) = round(mean(id));
    
end

%   calcul de c = dQ/dS valu aux indices correspondants a Q = 20 m^3/s

dQ = zeros(n_interp - 1, nprofil);
dS = zeros(n_interp - 1, nprofil);
C2 = cell(nprofil, 1);
for i = 1 : nprofil
    % calcul de dQ/dh
    dQ(:,i) = diff(Q(:, i));
    % calcul de dS/dh
    dS(:,i) = diff(Q(:, i));
    % calcul de dQ/dh*1/S'(h) valu aux indices correspondants a Q = 20 m^3/s
    C2{i} = dQ(ind(i),i)*1./dS(inds{i},i);
end

for i = 1 : length(C)
    
    CC2(i) = mean(C2{i});

end

% on fixe la taille des marqueurs sur le graphe
markerSize = 18;

% on calcul la clrit moyenne
C_mean = mean(CC2);

% on calcul une clrit par la formule analytique en considrant une
% hauteur moyenne
h_mean = 0.12;
C_analytic = 5*K*sqrt(pente_moyenne)*h_mean^(2/3)/3;


figure
plot(1:nprofil, CC2, 'kd', 'MarkerSize', markerSize)
hold on
plot([0 nprofil], [C_mean C_mean], 'b-.', 'LineWidth', 1.5)
text(6, 0.96, ['$\bar{c}_{crue} = $ ' num2str(C_mean) ' m/s'], ...
    'Color', 'b', 'FontSize', fontSize)
text(6, 0.86, ['$c(h) = 5 K \sqrt{i} h^{2/3}/3 =$ ' num2str(C_analytic) ' m/s'], ...
    'Color', 'b', 'FontSize', fontSize)
xlabel('section')
ylabel('$c_{crue}$ [m/s]')
axis([1 nprofil 0.7 1.1])


