(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[   1372926,      30138]
NotebookOptionsPosition[   1254978,      27705]
NotebookOutlinePosition[   1255349,      27721]
CellTagsIndexPosition[   1255306,      27718]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[{
 RowBox[{"UserDirectory", "=", 
  RowBox[{"ToFileName", "[", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"\"\<FileName\>\"", "/.", 
      RowBox[{"NotebookInformation", "[", 
       RowBox[{"EvaluationNotebook", "[", "]"}], "]"}]}], ")"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", "UserDirectory", "]"}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.72622512596*^9, 3.726225151383*^9}, {3.726225195583*^9, 
  3.726225212439*^9}, {3.7262253007679996`*^9, 3.726225305223*^9}, {
  3.7262323563269997`*^9, 
  3.726232359961*^9}},ExpressionUUID->"7b63bcc3-ac6b-49a3-9794-f0dc41351568"],

Cell[BoxData["\<\"D:\\\\d\[EAcute]bit-section\\\\\"\>"], "Output",
 CellChangeTimes->{{3.726225127341*^9, 3.7262251307460003`*^9}, {
   3.726225200656*^9, 3.726225213309*^9}, 3.726232719043*^9, 
   3.7262327638780003`*^9, 3.7262329494519997`*^9, 3.7262332071070004`*^9, 
   3.7262332696140003`*^9, 
   3.726235888821*^9},ExpressionUUID->"7c37f880-d54b-4ed3-adbb-ef28878d9d72"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Profil 1", "Section",
 CellChangeTimes->{{3.726232366929*^9, 
  3.726232384227*^9}},ExpressionUUID->"6395f8e4-eee6-4051-8e19-4ea2428b7951"],

Cell[CellGroupData[{

Cell["lecture", "Subsection",
 CellChangeTimes->{{3.726232366929*^9, 3.726232384227*^9}, {3.726232447131*^9,
   3.726232449347*^9}},ExpressionUUID->"0516bc94-587c-423d-adac-d050e37d9470"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"profil", "=", 
  RowBox[{"ToExpression", "@", 
   RowBox[{"ReadList", "[", 
    RowBox[{"\"\<profil_1.txt\>\"", ",", "Word", ",", 
     RowBox[{"RecordLists", "\[Rule]", "True"}], ",", 
     RowBox[{"WordSeparators", "\[Rule]", "\"\<,\>\""}]}], 
    "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{"ListLinePlot", "[", 
  RowBox[{"profil", ",", 
   RowBox[{"AspectRatio", "\[Rule]", "1"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"n", "=", 
  RowBox[{"Length", "[", "profil", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"profilInterp", "=", 
  RowBox[{"Interpolation", "[", 
   RowBox[{"profil", ",", 
    RowBox[{"InterpolationOrder", "\[Rule]", "1"}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"zmin", "=", 
  RowBox[{"Min", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"#", "[", 
      RowBox[{"[", "2", "]"}], "]"}], "&"}], "/@", "profil"}], 
   "]"}]}]}], "Input",
 CellChangeTimes->{{3.7262252160959997`*^9, 3.7262252218710003`*^9}, {
  3.726225308633*^9, 3.72622531775*^9}, {3.7262259504639997`*^9, 
  3.726225965406*^9}, {3.726232362781*^9, 3.726232363865*^9}, {
  3.726232403023*^9, 3.726232429034*^9}, {3.72624411688*^9, 
  3.726244131276*^9}},ExpressionUUID->"9438dcb8-749c-4e10-a6b6-29cc4b5e29f3"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.`", ",", "1226.7`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"12.12`", ",", "1226.4`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"25.56`", ",", "1225.9`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"39.38`", ",", "1225.6`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"50.94`", ",", "1225.2`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"62.5`", ",", "1225.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"73.94`", ",", "1224.7`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"81.94`", ",", "1224.6`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"91.81`", ",", "1224.2`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"103.25`", ",", "1224.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"114.38`", ",", "1223.7`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"125.12`", ",", "1223.5`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"136.38`", ",", "1223.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"143.31`", ",", "1223.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"152.31`", ",", "1222.8`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"156.62`", ",", "1223.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"163.75`", ",", "1222.9`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"167.81`", ",", "1223.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"170.38`", ",", "1221.7`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"172.88`", ",", "1221.6`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"173.94`", ",", "1220.5`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"175.31`", ",", "1220.6`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"176.94`", ",", "1221.2`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"178.44`", ",", "1220.9`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"179.75`", ",", "1221.9`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"184.`", ",", "1222.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"187.19`", ",", "1222.5`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"189.88`", ",", "1223.4`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"191.88`", ",", "1224.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"193.94`", ",", "1224.8`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"195.94`", ",", "1225.4`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"198.62`", ",", "1226.3`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"202.`", ",", "1226.8`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"205.5`", ",", "1227.2`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"208.94`", ",", "1227.8`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"213.25`", ",", "1227.8`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"216.88`", ",", "1228.2`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"220.38`", ",", "1228.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"223.31`", ",", "1228.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"226.12`", ",", "1228.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"229.31`", ",", "1227.9`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"231.88`", ",", "1227.7`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"234.31`", ",", "1227.3`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"237.25`", ",", "1227.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"239.`", ",", "1227.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"243.19`", ",", "1227.4`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"245.31`", ",", "1227.7`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"247.94`", ",", "1228.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"250.81`", ",", "1228.3`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"253.25`", ",", "1228.3`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"255.69`", ",", "1228.7`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"258.75`", ",", "1228.9`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"261.25`", ",", "1229.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"263.62`", ",", "1229.4`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"265.62`", ",", "1230.6`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"268.94`", ",", "1231.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"272.31`", ",", "1231.3`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"275.69`", ",", "1231.6`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"278.5`", ",", "1232.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"282.12`", ",", "1232.6`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"285.75`", ",", "1233.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"289.06`", ",", "1233.5`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"292.25`", ",", "1234.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"293.12`", ",", "1234.3`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"295.38`", ",", "1234.5`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"298.94`", ",", "1234.4`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"305.69`", ",", "1234.8`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"312.62`", ",", "1235.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"318.88`", ",", "1235.5`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"324.12`", ",", "1235.9`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"329.81`", ",", "1236.5`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"333.94`", ",", "1237.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"339.19`", ",", "1238.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"344.62`", ",", "1238.7`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"351.12`", ",", "1239.2`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"356.25`", ",", "1239.6`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"361.31`", ",", "1240.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"366.44`", ",", "1240.4`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"371.5`", ",", "1240.8`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"375.69`", ",", "1241.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"380.75`", ",", "1241.2`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"386.12`", ",", "1241.5`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"390.5`", ",", "1241.8`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"394.44`", ",", "1242.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"398.69`", ",", "1242.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"403.62`", ",", "1241.9`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"408.38`", ",", "1241.9`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"412.88`", ",", "1241.8`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"417.19`", ",", "1241.8`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"421.44`", ",", "1241.9`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"425.19`", ",", "1241.8`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"429.81`", ",", "1241.8`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"435.12`", ",", "1241.6`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"438.81`", ",", "1241.3`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"442.81`", ",", "1240.9`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"446.88`", ",", "1240.7`"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.726225222749*^9, {3.726225313972*^9, 3.726225318549*^9}, 
   3.726225966208*^9, {3.7262323876540003`*^9, 3.726232430127*^9}, 
   3.726232721483*^9, 3.726232768483*^9, 3.72623296151*^9, 3.726233207597*^9, 
   3.7262332696619997`*^9, 3.726235891734*^9, 3.7262432013900003`*^9, 
   3.726243998084*^9, 
   3.7262441317980003`*^9},ExpressionUUID->"e99b0fd2-ef0f-45af-aac7-\
527c4a5eded7"],

Cell[BoxData[
 GraphicsBox[{{}, {{{}, {}, {
      {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
       0.016666666666666666`], AbsoluteThickness[1.6], LineBox[CompressedData["
1:eJxdk01oE0EcxYN4sXiQtqiYGFI/G001NQpWTRltsY2WloagVoK2TbKbmjRf
TfMp3hQEoYfxYKUXUVBBao8exIPnVgUPXgrqSaQgiCgIRdzd9yZLOhCW3773
f29mlnRMZsOJTQ6HY9z4mU+1VpaNdUiKYMunx7lgp3g4byyvFHNvf3dG53rA
B6XIm4alPqGZ64AUr9y310YrIWHN75PCChMj0A2OmgE3w9D3KI5AN/hJzgj8
dQm6h/MfxqB7mP8gCt0txeDXWvviwHX43MzbOgG/S4qwOfB9A2+JiYC5nOyT
Mcy72FeJ43xO+v/GG7qVP5RA/3byQgL5Bi8OGBt6k4C/VfVTb6Xu1jDfTh7W
0Nem+sk7yA4d8zvp13S838X+1zr8u8nr1D309yZx3r3kW0n49/P8H6l71fea
Ah8mL01hvz61/xvQj1J/ZrPV70rB7yffS8HnV/eRwnn87O9LN+vP09ifyltP
I+8I9dA0+rpU/zTyfOQvNuO+MsjrUvmZRp6l/8s0949lkd+t8m22/H+ymD9G
3ZdDfoAcyaH/OPOq1E+Q56mfksL8d7W8z2HujBRe88Cb8+gLUj+dh7+X+Umy
YN4j8jnqq3k8+5m3rQA+T72/AP8g50cL6AvxfCX6L7D/ZQH7D5GdM/Bf5Pzd
GfiHOP+DPEz9bBHzI9zPQhF6mHmfi9hPhByYhX5F5c/ivq+Sf5Kj6jwlzF9j
/v0S3o8z71sJ/RP0nyxj/zHq9TLex6kvl5EfZ19HBe81df8VzOucf0o9SV6z
2ZrvqaJf5/3c2cDvqs15bbVmvlxr+C2Wtm6dd9Vmq6+7jvvQqKfr0BPkF3Xk
xdT3quO8k1L8B6ktRdg=
        "]]}}}}, {}, {}, {{}, {}}, {{}, {}}},
  AspectRatio->1,
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 1219.4250000000002`},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->{941., Automatic},
  Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 446.88}, {1220.5, 1242.}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.726225222749*^9, {3.726225313972*^9, 3.726225318549*^9}, 
   3.726225966208*^9, {3.7262323876540003`*^9, 3.726232430127*^9}, 
   3.726232721483*^9, 3.726232768483*^9, 3.72623296151*^9, 3.726233207597*^9, 
   3.7262332696619997`*^9, 3.726235891734*^9, 3.7262432013900003`*^9, 
   3.726243998084*^9, 
   3.7262441318310003`*^9},ExpressionUUID->"446f94fb-8f74-4f8c-aaa1-\
24697cad1d65"],

Cell[BoxData["96"], "Output",
 CellChangeTimes->{
  3.726225222749*^9, {3.726225313972*^9, 3.726225318549*^9}, 
   3.726225966208*^9, {3.7262323876540003`*^9, 3.726232430127*^9}, 
   3.726232721483*^9, 3.726232768483*^9, 3.72623296151*^9, 3.726233207597*^9, 
   3.7262332696619997`*^9, 3.726235891734*^9, 3.7262432013900003`*^9, 
   3.726243998084*^9, 
   3.726244131835*^9},ExpressionUUID->"da25c742-e361-416d-bf34-013a37bbc0a4"],

Cell[BoxData[
 TagBox[
  TemplateBox[{RowBox[{
      StyleBox[
       TagBox["InterpolatingFunction", "SummaryHead"], 
       "NonInterpretableSummary"], 
      StyleBox["[", "NonInterpretableSummary"], 
      DynamicModuleBox[{Typeset`open$$ = False}, 
       PanelBox[
        PaneSelectorBox[{False -> GridBox[{{
              PaneBox[
               ButtonBox[
                DynamicBox[
                 FEPrivate`FrontEndResource[
                 "FEBitmaps", "SquarePlusIconMedium"]], 
                ButtonFunction :> (Typeset`open$$ = True), Appearance -> None,
                 Evaluator -> Automatic, Method -> "Preemptive"], 
               Alignment -> {Center, Center}, ImageSize -> 
               Dynamic[{
                 Automatic, 3.5 CurrentValue["FontCapHeight"]/
                  AbsoluteCurrentValue[Magnification]}]], 
              GraphicsBox[{{{{}, {}, 
                  TagBox[{
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    LineBox[CompressedData["
1:eJwl0Q8wFFgcB/A9dQ0X3Tk7FP1bVrS5uHQdwnyrw9i9tc6fLldkV7vryPq3
1qJxuhvq2Lg80iQ52eJcky5rNoeJQmTdUFyGc2RwtOyIdKk77jX3Zt68+cz7
/X5v3u/HEsUHiY0YDIYn3W9P/yHzzI62Ue+pT1t0Og5Bwb+/G9rttuCy9+IO
JnVwraD1dPhufGmonmPvJBi8WT1ZlL8PKjsxw9SR4FmWsieyywtXTLqv7Xcg
0I9352f3HsQ11cagczsIBibG14Wn+SJM6GZTYU/g9COrrjKBC9nI6bJGNsHS
4INASWgArrPUVxXUl+54lBe/CYSmUblQaUcQL7S/VbsYBM9Zs0mNLcFKg8UM
92EIqhzymlypffvqrdUlhzHKVRcbswh82mOn9qqOQFpYUEu20/ho+yHf419B
IPdcw6SWzSxIfwg7BtlA//j8VoILjnJDCTcCmofB0Tzq5rxTAR+YRSI066Lo
7BaC3OedSQnGQsxvc66I2Uyw19lql/miEAGfq9XHqN2Pxt/iPxdBznJI4dsQ
lEpYe2aeRSG2jTE7SD3kP+DX/vgEODeVhqfUchvC8eoVo6/PO4bzIe1XW1DF
UqMEORGi+VUrgrv8k0yzSik6uqo7VLS+oa0gpKUsGnEjTQtztJ+vLeodNWe+
Rs+vPJm7E4Hwi4muQ9kxcH27nAnsZXHSPZmxmL0TcnaTC0GH6NVFoeQkeKYN
YSP0/p7PuRInURzSAockKzS/lMHmuPFlOM4Yq4z8iKDvErPhqms8TB6tZ9fR
/F/On8ntt0yA8Mnf6w+4EvzVmm2kzEvAe8OfpO13I+DNGAtnTBKhEYwFC7wI
rvyjMnnzTSJcLGxFHgcIyle9XJoWE+GcXqqY/Izgt+VkL15iEvKyLkxM+NP/
j9YUpU8lgdEZPhzLJdjXLHmUKk7GjbyXPzfxCJxzBfns8WS41/z0+h6fwPKQ
e1HiYTnqrxfasAMJdi1WZan65ZhenRhaG0LjC6y0ftwU+AxPN989QvDUWhN7
uzkFUba367qPErSUDazTeygweONjpnsEQb7pK/39WgWmmXP3syPpvJPKtTG7
U7GiDdUaRdF5dya/01qTig3ma+qUJwh0Jv7F2q1K1DwRql6ICQoPVr5/6rIS
a43C6kekBH7Slcdj5mkw+HYV9VDv/O7PTIvzaeBp3n35PXVDvr5qySz9/3lR
u+UsWyu/TYdu0+YMAfWkXCXvZGQgZ6x38A8JQZZg+8YGRQb0yynaF/T9DZbz
SUxDBrY9mNTpRAT/AWQnv2o=
                    "]]}, 
                   Annotation[#, 
                    "Charting`Private`Tag$50323#1"]& ]}}, {}, {}}, {
               DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
                AxesOrigin -> {0, 1220.541420918995}, 
                FrameTicks -> {{{}, {}}, {{}, {}}}, GridLines -> {None, None},
                 DisplayFunction -> Identity, PlotRangePadding -> {{
                   Scaled[0.1], 
                   Scaled[0.1]}, {
                   Scaled[0.1], 
                   Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                All, DisplayFunction -> Identity, AspectRatio -> 1, 
                Axes -> {False, False}, AxesLabel -> {None, None}, 
                AxesOrigin -> {0, 1220.541420918995}, DisplayFunction :> 
                Identity, Frame -> {{True, True}, {True, True}}, 
                FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                Directive[
                  Opacity[0.5], 
                  Thickness[Tiny], 
                  RGBColor[0.368417, 0.506779, 0.709798]], 
                FrameTicks -> {{None, None}, {None, None}}, 
                GridLines -> {None, None}, GridLinesStyle -> Directive[
                  GrayLevel[0.5, 0.4]], ImageSize -> 
                Dynamic[{
                  Automatic, 3.5 CurrentValue["FontCapHeight"]/
                   AbsoluteCurrentValue[Magnification]}], 
                Method -> {
                 "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
                  AbsolutePointSize[6], "ScalingFunctions" -> None, 
                  "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                    (Identity[#]& )[
                    Part[#, 1]], 
                    (Identity[#]& )[
                    Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                    (Identity[#]& )[
                    Part[#, 1]], 
                    (Identity[#]& )[
                    Part[#, 2]]}& )}}, 
                PlotRange -> {{0., 446.88}, {1220.541420918995, 
                 1241.9665120990257`}}, PlotRangeClipping -> True, 
                PlotRangePadding -> {{
                   Scaled[0.1], 
                   Scaled[0.1]}, {
                   Scaled[0.1], 
                   Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
              GridBox[{{
                 RowBox[{
                   TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"0.`", ",", "446.88`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["\"scalar\"", "SummaryItem"]}]}}, 
               GridBoxAlignment -> {
                "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, AutoDelete -> 
               False, GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
               GridBoxSpacings -> {
                "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
               BaseStyle -> {
                ShowStringCharacters -> False, NumberMarks -> False, 
                 PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
            GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> False, 
            GridBoxItemSize -> {
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
            BaselinePosition -> {1, 1}], True -> GridBox[{{
              PaneBox[
               ButtonBox[
                DynamicBox[
                 FEPrivate`FrontEndResource[
                 "FEBitmaps", "SquareMinusIconMedium"]], 
                ButtonFunction :> (Typeset`open$$ = False), Appearance -> 
                None, Evaluator -> Automatic, Method -> "Preemptive"], 
               Alignment -> {Center, Center}, ImageSize -> 
               Dynamic[{
                 Automatic, 3.5 CurrentValue["FontCapHeight"]/
                  AbsoluteCurrentValue[Magnification]}]], 
              GraphicsBox[{{{{}, {}, 
                  TagBox[{
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    LineBox[CompressedData["
1:eJwl0Q8wFFgcB/A9dQ0X3Tk7FP1bVrS5uHQdwnyrw9i9tc6fLldkV7vryPq3
1qJxuhvq2Lg80iQ52eJcky5rNoeJQmTdUFyGc2RwtOyIdKk77jX3Zt68+cz7
/X5v3u/HEsUHiY0YDIYn3W9P/yHzzI62Ue+pT1t0Og5Bwb+/G9rttuCy9+IO
JnVwraD1dPhufGmonmPvJBi8WT1ZlL8PKjsxw9SR4FmWsieyywtXTLqv7Xcg
0I9352f3HsQ11cagczsIBibG14Wn+SJM6GZTYU/g9COrrjKBC9nI6bJGNsHS
4INASWgArrPUVxXUl+54lBe/CYSmUblQaUcQL7S/VbsYBM9Zs0mNLcFKg8UM
92EIqhzymlypffvqrdUlhzHKVRcbswh82mOn9qqOQFpYUEu20/ho+yHf419B
IPdcw6SWzSxIfwg7BtlA//j8VoILjnJDCTcCmofB0Tzq5rxTAR+YRSI066Lo
7BaC3OedSQnGQsxvc66I2Uyw19lql/miEAGfq9XHqN2Pxt/iPxdBznJI4dsQ
lEpYe2aeRSG2jTE7SD3kP+DX/vgEODeVhqfUchvC8eoVo6/PO4bzIe1XW1DF
UqMEORGi+VUrgrv8k0yzSik6uqo7VLS+oa0gpKUsGnEjTQtztJ+vLeodNWe+
Rs+vPJm7E4Hwi4muQ9kxcH27nAnsZXHSPZmxmL0TcnaTC0GH6NVFoeQkeKYN
YSP0/p7PuRInURzSAockKzS/lMHmuPFlOM4Yq4z8iKDvErPhqms8TB6tZ9fR
/F/On8ntt0yA8Mnf6w+4EvzVmm2kzEvAe8OfpO13I+DNGAtnTBKhEYwFC7wI
rvyjMnnzTSJcLGxFHgcIyle9XJoWE+GcXqqY/Izgt+VkL15iEvKyLkxM+NP/
j9YUpU8lgdEZPhzLJdjXLHmUKk7GjbyXPzfxCJxzBfns8WS41/z0+h6fwPKQ
e1HiYTnqrxfasAMJdi1WZan65ZhenRhaG0LjC6y0ftwU+AxPN989QvDUWhN7
uzkFUba367qPErSUDazTeygweONjpnsEQb7pK/39WgWmmXP3syPpvJPKtTG7
U7GiDdUaRdF5dya/01qTig3ma+qUJwh0Jv7F2q1K1DwRql6ICQoPVr5/6rIS
a43C6kekBH7Slcdj5mkw+HYV9VDv/O7PTIvzaeBp3n35PXVDvr5qySz9/3lR
u+UsWyu/TYdu0+YMAfWkXCXvZGQgZ6x38A8JQZZg+8YGRQb0yynaF/T9DZbz
SUxDBrY9mNTpRAT/AWQnv2o=
                    "]]}, 
                   Annotation[#, 
                    "Charting`Private`Tag$50323#1"]& ]}}, {}, {}}, {
               DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
                AxesOrigin -> {0, 1220.541420918995}, 
                FrameTicks -> {{{}, {}}, {{}, {}}}, GridLines -> {None, None},
                 DisplayFunction -> Identity, PlotRangePadding -> {{
                   Scaled[0.1], 
                   Scaled[0.1]}, {
                   Scaled[0.1], 
                   Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                All, DisplayFunction -> Identity, AspectRatio -> 1, 
                Axes -> {False, False}, AxesLabel -> {None, None}, 
                AxesOrigin -> {0, 1220.541420918995}, DisplayFunction :> 
                Identity, Frame -> {{True, True}, {True, True}}, 
                FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                Directive[
                  Opacity[0.5], 
                  Thickness[Tiny], 
                  RGBColor[0.368417, 0.506779, 0.709798]], 
                FrameTicks -> {{None, None}, {None, None}}, 
                GridLines -> {None, None}, GridLinesStyle -> Directive[
                  GrayLevel[0.5, 0.4]], ImageSize -> 
                Dynamic[{
                  Automatic, 3.5 CurrentValue["FontCapHeight"]/
                   AbsoluteCurrentValue[Magnification]}], 
                Method -> {
                 "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
                  AbsolutePointSize[6], "ScalingFunctions" -> None, 
                  "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                    (Identity[#]& )[
                    Part[#, 1]], 
                    (Identity[#]& )[
                    Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                    (Identity[#]& )[
                    Part[#, 1]], 
                    (Identity[#]& )[
                    Part[#, 2]]}& )}}, 
                PlotRange -> {{0., 446.88}, {1220.541420918995, 
                 1241.9665120990257`}}, PlotRangeClipping -> True, 
                PlotRangePadding -> {{
                   Scaled[0.1], 
                   Scaled[0.1]}, {
                   Scaled[0.1], 
                   Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
              GridBox[{{
                 RowBox[{
                   TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"0.`", ",", "446.88`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["\"scalar\"", "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Order: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["1", "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Method: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["\"Hermite\"", "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Periodic: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["False", "SummaryItem"]}]}}, 
               GridBoxAlignment -> {
                "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, AutoDelete -> 
               False, GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
               GridBoxSpacings -> {
                "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
               BaseStyle -> {
                ShowStringCharacters -> False, NumberMarks -> False, 
                 PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
            GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> False, 
            GridBoxItemSize -> {
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
            BaselinePosition -> {1, 1}]}, 
         Dynamic[Typeset`open$$], ImageSize -> Automatic], BaselinePosition -> 
        Baseline], DynamicModuleValues :> {}], 
      StyleBox["]", "NonInterpretableSummary"]}]},
   "CopyTag",
   DisplayFunction->(#& ),
   InterpretationFunction->("InterpolatingFunction[{{0., 446.88}}, <>]"& )],
  False,
  Editable->False,
  SelectWithContents->True,
  Selectable->False]], "Output",
 CellChangeTimes->{
  3.726225222749*^9, {3.726225313972*^9, 3.726225318549*^9}, 
   3.726225966208*^9, {3.7262323876540003`*^9, 3.726232430127*^9}, 
   3.726232721483*^9, 3.726232768483*^9, 3.72623296151*^9, 3.726233207597*^9, 
   3.7262332696619997`*^9, 3.726235891734*^9, 3.7262432013900003`*^9, 
   3.726243998084*^9, 
   3.7262441318459997`*^9},ExpressionUUID->"c702c091-195d-419a-944e-\
d218dcc2a570"],

Cell[BoxData["1220.5`"], "Output",
 CellChangeTimes->{
  3.726225222749*^9, {3.726225313972*^9, 3.726225318549*^9}, 
   3.726225966208*^9, {3.7262323876540003`*^9, 3.726232430127*^9}, 
   3.726232721483*^9, 3.726232768483*^9, 3.72623296151*^9, 3.726233207597*^9, 
   3.7262332696619997`*^9, 3.726235891734*^9, 3.7262432013900003`*^9, 
   3.726243998084*^9, 
   3.7262441318529997`*^9},ExpressionUUID->"6eee3949-e859-4a98-b395-\
e272316060fc"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"pro1", "=", 
   RowBox[{"Select", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Import", "[", 
       RowBox[{"\"\<profilQgis1.xlsx\>\"", ",", "\"\<Data\>\""}], "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"#", "[", 
        RowBox[{"[", "1", "]"}], "]"}], "<", "360"}], "&"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"comp", "=", 
  RowBox[{"Show", "[", 
   RowBox[{
    RowBox[{"ListLinePlot", "[", "pro1", "]"}], ",", "\[IndentingNewLine]", 
    RowBox[{"ListLinePlot", "[", 
     RowBox[{
      RowBox[{"Select", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"#", "[", 
              RowBox[{"[", "1", "]"}], "]"}], "-", "100"}], ",", 
            RowBox[{"#", "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], "}"}], "&"}], "/@", "profil"}],
         ",", 
        RowBox[{
         RowBox[{
          RowBox[{"#", "[", 
           RowBox[{"[", "1", "]"}], "]"}], ">", "0"}], "&"}]}], "]"}], ",", 
      RowBox[{"AspectRatio", "\[Rule]", "1"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Dashed", ",", "Black"}], "}"}]}]}], "]"}], ",", 
    RowBox[{"Frame", "\[Rule]", "True"}], ",", 
    RowBox[{"FrameLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<\!\(\*
StyleBox[\"x\",
FontSlant->\"Italic\"]\) (m)\>\"", ",", "\"\<\!\(\*
StyleBox[\"z\",
FontSlant->\"Italic\"]\)\!\(\*
StyleBox[\" \",
FontSlant->\"Italic\"]\)(m)\>\""}], "}"}]}], ",", 
    RowBox[{"BaseStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"FontFamily", "->", "\"\<Times\>\""}], ",", "14"}], "}"}]}], 
    ",", 
    RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.726243934638*^9, 3.726244011373*^9}, {3.726244071303*^9,
   3.726244073582*^9}, {3.726244136024*^9, 3.726244179918*^9}, {
  3.726244220483*^9, 3.726244244935*^9}, {3.7262442882720003`*^9, 
  3.7262443087019997`*^9}},ExpressionUUID->"fe40d855-3d13-4a5d-a2fd-\
141d0148cd78"],

Cell[BoxData[
 GraphicsBox[{{{}, {{{}, {}, {
       {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
        0.011111111111111112`], AbsoluteThickness[1.6], 
        LineBox[CompressedData["
1:eJxNl3lcz1kXxzMh20OLyFZRQ1L9KoqicVHR8gtttNHvV79fi+pXqWyRiRoT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         "]]}}}}, {}, {}, {{}, {}}, {{}, {}}}, {{}, {{{}, {}, {
       {GrayLevel[0], PointSize[0.016666666666666666`], AbsoluteThickness[
        1.6], Dashing[{Small, Small}], LineBox[CompressedData["
1:eJxdUk1IFGEYXqpDeDRJ6WfZkGiX1tyywErlQ8rUpNVZddW2bXdmZ3eqNcf9
iYiILhFBVDCXCi9h4CHYSxB2CzsFdvJgXSIvXboUYRh06Jt5nm+W7YNleOb5
e7939oA+p5nbAoFAUv7cJ06TyLsn5Ih3m+HU45Wo+LgqT9ARoXvfx5aDJ4Un
k9jubVpfjPVDv88Rgxu3WmpLZxvxoWHR5Z69jniyIgPjI/BL3nt+jYvnz+SR
/Es38Neozy8HZeHTMfTvJu7WkC+xHG4zfFuDvpn+NfLN5HsS8LcQLyTQt4v9
P4hbiQMT8LdRvzqB93vYf3MS+v3EW5PgQ2qeJO7bTvw3Cf1BtZ8p8BH23Z0G
PkycmcG8UTX/RfCd5EdTPsY+LkEfI25LQxdT+0jjPjH237/s85priGQwX6ea
P4O8I+Q/ZNDXwf5wFnlRNW8d187Jgm9Z5HWofN3P8/g7emP/Zx35R1W+4WNP
f8OA/xj5Twbyu5Q+h/7jvG85B/4E8Wvyp5gXNOHrYf8DE3295H+b0PepfeeB
BfPeE/eT7y7geYZ5L4gHyO+0oB+kv91C3xD3XbSgG2b/FwvzDxG/uQL9efqd
q9CP0J+6BnyB/PYi/HHO87YIXmNe3yzmGVffaxb8lMq/jn3PEBtzwCneZ4cN
f9oREXeAcZv/A0esL0rDko3+LPVbNuY3yJ+ex/sc+YfzyM9x3g3yefV9S/AX
6C+U8N4iflXHnv9PCf0F3m+g3IgflRvz1v7DrRVf7+FExee9+y7Usdf3s4J9
5MlHq+BN4mIVeQb7a1XcV3fEP2ko/zA=
         "]]}}}}, {}, {}, {{}, {}}, {{}, {}}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 1221.1299999999999`},
  BaseStyle->{FontFamily -> "Times", 14},
  DisplayFunction->Identity,
  Frame->True,
  FrameLabel->{
    FormBox[
    "\"\\!\\(\\*\\nStyleBox[\\\"x\\\",\\nFontSlant->\\\"Italic\\\"]\\) (m)\"",
      TraditionalForm], 
    FormBox[
    "\"\\!\\(\\*\\nStyleBox[\\\"z\\\",\\nFontSlant->\\\"Italic\\\"]\\)\\!\\(\\\
*\\nStyleBox[\\\" \\\",\\nFontSlant->\\\"Italic\\\"]\\)(m)\"", 
     TraditionalForm]},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->All,
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.726225222749*^9, {3.726225313972*^9, 3.726225318549*^9}, 
   3.726225966208*^9, {3.7262323876540003`*^9, 3.726232430127*^9}, 
   3.726232721483*^9, 3.726232768483*^9, 3.72623296151*^9, 3.726233207597*^9, 
   3.7262332696619997`*^9, 3.726235891734*^9, 3.726243201448*^9, {
   3.7262439445950003`*^9, 3.7262440122679996`*^9}, {3.7262441491429996`*^9, 
   3.7262441829639997`*^9}, 3.72624424527*^9, 
   3.726244309546*^9},ExpressionUUID->"d5d3bc6d-056f-4734-96c8-18050941621a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<comparaisonTN1.eps\>\"", ",", "comp", ",", "\"\<EPS\>\""}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.72624435655*^9, 
  3.726244362148*^9}},ExpressionUUID->"f32ec630-8031-427e-b72e-95240dbf3d20"],

Cell[BoxData["\<\"comparaisonTN1.eps\"\>"], "Output",
 CellChangeTimes->{
  3.7262443626540003`*^9},ExpressionUUID->"922759bd-ef7b-4063-959d-\
09d51763c11f"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["test", "Subsection",
 CellChangeTimes->{{3.726232366929*^9, 3.726232384227*^9}, {3.726232447131*^9,
   3.726232462184*^9}},ExpressionUUID->"acdf9999-4b47-40f4-80d7-0b57b78e7d27"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"profilInterp", "[", "x", "]"}], "\[Equal]", "1223"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "100"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7262254266029997`*^9, 3.726225465616*^9}, 
   3.726232970962*^9},ExpressionUUID->"d3dc0ac2-efb1-458d-8a26-77f6c88c883f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", "\[Rule]", "146.30999999999798`"}], "}"}]], "Output",
 CellChangeTimes->{{3.726225455278*^9, 3.7262254659440002`*^9}, 
   3.726232971256*^9, 3.726233213766*^9, 
   3.72623327438*^9},ExpressionUUID->"1159f59e-89e7-4a4d-b5e7-5b8fe5a3771b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"alt", "=", "1224"}], "\[IndentingNewLine]", 
 RowBox[{" ", 
  RowBox[{
   RowBox[{"ival", "=", 
    RowBox[{"{", "}"}]}], ";"}]}], "\[IndentingNewLine]", 
 RowBox[{"xval", "=", 
  RowBox[{"{", "}"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Do", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"profil", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "2"}], "]"}], "]"}], "\[LessEqual]", "alt", "<=", 
        RowBox[{"profil", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"i", "+", "1"}], ",", "2"}], "]"}], "]"}]}], "||", 
       RowBox[{
        RowBox[{"profil", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "2"}], "]"}], "]"}], "\[GreaterEqual]", " ", 
        "alt", "\[GreaterEqual]", 
        RowBox[{"profil", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"i", "+", "1"}], ",", "2"}], "]"}], "]"}]}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"AppendTo", "[", 
        RowBox[{"ival", ",", "i"}], "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"interp", "=", 
        RowBox[{"Interpolation", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"profil", "[", 
             RowBox[{"[", "i", "  ", "]"}], "]"}], ",", 
            RowBox[{"profil", "[", 
             RowBox[{"[", 
              RowBox[{"i", "+", "1"}], " ", "]"}], "]"}]}], "}"}], ",", 
          RowBox[{"InterpolationOrder", "\[Rule]", "1"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"xc", "=", 
        RowBox[{"x", "/.", 
         RowBox[{
          RowBox[{"FindRoot", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"interp", "[", "x", "]"}], "\[Equal]", "alt"}], ",", 
            RowBox[{"{", 
             RowBox[{"x", ",", 
              RowBox[{"profil", "[", 
               RowBox[{"[", 
                RowBox[{
                 RowBox[{"i", "+", "1"}], ",", "1"}], "]"}], "]"}]}], "}"}]}],
            "]"}], "[", 
          RowBox[{"[", "1", "]"}], "]"}]}]}], ";", 
       RowBox[{"Print", "[", 
        RowBox[{"\"\<i =\>\"", ",", "i", ",", "\"\< x = \>\"", ",", "xc"}], 
        "]"}], ";", 
       RowBox[{"AppendTo", "[", 
        RowBox[{"xval", ",", "xc"}], "]"}], ";"}]}], "\[IndentingNewLine]", 
     "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", 
      RowBox[{"n", "-", "1"}]}], "}"}]}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.7262258536730003`*^9, 3.726225974487*^9}, {
   3.726226108792*^9, 3.726226133618*^9}, {3.726226317785*^9, 
   3.7262264099820004`*^9}, {3.726226449434*^9, 3.72622647455*^9}, {
   3.726226514075*^9, 3.726226570517*^9}, {3.726227020848*^9, 
   3.726227075016*^9}, {3.726227423367*^9, 3.726227427098*^9}, 
   3.7262329678929996`*^9, 
   3.726233299344*^9},ExpressionUUID->"2b505907-a146-4f14-8eaf-e4be164dd96d"],

Cell[BoxData["1224"], "Output",
 CellChangeTimes->{
  3.7262258573529997`*^9, 3.726225974858*^9, 3.726226134086*^9, 
   3.7262264111689997`*^9, {3.7262264709849997`*^9, 3.7262264752460003`*^9}, 
   3.726226519617*^9, {3.726226556707*^9, 3.726226571341*^9}, {
   3.7262270628599997`*^9, 3.726227075238*^9}, 3.726232968212*^9, 
   3.726233213925*^9, {3.7262332761470003`*^9, 
   3.726233300748*^9}},ExpressionUUID->"d875d027-204b-4d65-8c04-335ae16dc849"],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 CellChangeTimes->{
  3.7262258573529997`*^9, 3.726225974858*^9, 3.726226134086*^9, 
   3.7262264111689997`*^9, {3.7262264709849997`*^9, 3.7262264752460003`*^9}, 
   3.726226519617*^9, {3.726226556707*^9, 3.726226571341*^9}, {
   3.7262270628599997`*^9, 3.726227075238*^9}, 3.726232968212*^9, 
   3.726233213925*^9, {3.7262332761470003`*^9, 
   3.726233300751*^9}},ExpressionUUID->"6f373335-daa1-4f44-9ab2-c3e166a3d9e0"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "106.03249999999842`"}],
  SequenceForm["i =", 10, " x = ", 106.03249999999842`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232968219*^9, 3.726233213933*^9, {3.7262332761540003`*^9, 
   3.7262333007530003`*^9}},ExpressionUUID->"84d7cdf9-d4eb-4acf-b458-\
2dd21e0c48ce"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "28", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", "191.88`"}],
  SequenceForm["i =", 28, " x = ", 191.88],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232968219*^9, 3.726233213933*^9, {3.7262332761540003`*^9, 
   3.7262333007539997`*^9}},ExpressionUUID->"8513c54a-5489-4448-b997-\
b35aab097c5e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "29", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", "191.88`"}],
  SequenceForm["i =", 29, " x = ", 191.88],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232968219*^9, 3.726233213933*^9, {3.7262332761540003`*^9, 
   3.726233300759*^9}},ExpressionUUID->"3c9ebe7e-e618-4345-ba78-449164123dba"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.726226008226*^9, 3.7262260121280003`*^9}, {
  3.7262260723859997`*^9, 3.726226090521*^9}, {3.726227012104*^9, 
  3.726227018509*^9}},ExpressionUUID->"f51da9e4-b34f-4a8d-8b89-1a785b3ea733"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"170.38`", ",", "1221.7`"}], "}"}]], "Output",
 CellChangeTimes->{
  3.726226017889*^9, {3.7262260727609997`*^9, 
   3.726226090895*^9}},ExpressionUUID->"adbb80e0-3dde-4fb1-a2bf-e2801eaef22a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"{", 
   RowBox[{"il", ",", "ir"}], "}"}], "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"First", "@", "ival"}], ",", 
    RowBox[{"Last", "@", "ival"}]}], "}"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"{", 
   RowBox[{"xl", ",", "xr"}], "}"}], "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"First", "@", "xval"}], ",", 
    RowBox[{"Last", "@", "xval"}]}], "}"}]}]}], "Input",
 CellChangeTimes->{{3.726227096816*^9, 3.726227114612*^9}, {
  3.7262329959960003`*^9, 
  3.72623301877*^9}},ExpressionUUID->"45e3db08-7073-4baa-b563-f210cf249b25"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"10", ",", "29"}], "}"}]], "Output",
 CellChangeTimes->{
  3.726227114851*^9, 3.7262330197679996`*^9, 3.726233216243*^9, {
   3.726233281072*^9, 
   3.726233302632*^9}},ExpressionUUID->"c996d64d-a2db-49ee-8060-93b14d1fd1eb"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"106.03249999999842`", ",", "191.88`"}], "}"}]], "Output",
 CellChangeTimes->{
  3.726227114851*^9, 3.7262330197679996`*^9, 3.726233216243*^9, {
   3.726233281072*^9, 
   3.7262333026359997`*^9}},ExpressionUUID->"aa0b520f-25b0-4611-af6a-\
259c8fa46de1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{
   RowBox[{"alt", " ", "-", 
    RowBox[{"profilInterp", "[", "x", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "xl", ",", "xr"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7262264846289997`*^9, 3.726226486635*^9}, {
  3.726227089087*^9, 3.726227149316*^9}, {3.726227313462*^9, 
  3.7262273437720003`*^9}},ExpressionUUID->"98046aaf-aeb6-40a9-ac31-\
aef6b871f9f8"],

Cell[BoxData["93.80812500000039`"], "Output",
 CellChangeTimes->{
  3.7262264869230003`*^9, {3.7262271299820004`*^9, 3.72622715016*^9}, {
   3.726227314823*^9, 3.72622734446*^9}, 3.7262330246099997`*^9, 
   3.726233217365*^9, {3.726233284427*^9, 
   3.726233303733*^9}},ExpressionUUID->"7821e0ab-2c49-4398-a948-cbeafdb2a605"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"long", "=", 
  RowBox[{
   RowBox[{"Sqrt", "[", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"profil", "[", 
        RowBox[{"[", 
         RowBox[{"il", " ", "+", "1"}], " ", "]"}], "]"}], "-", 
       RowBox[{"{", 
        RowBox[{"xl", ",", "alt"}], "}"}]}], ")"}], ".", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"profil", "[", 
        RowBox[{"[", 
         RowBox[{"il", "+", "1"}], "  ", "]"}], "]"}], "-", " ", 
       RowBox[{"{", 
        RowBox[{"xl", ",", "alt"}], "}"}]}], ")"}]}], "]"}], "+", 
   RowBox[{"Sqrt", "[", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"profil", "[", 
        RowBox[{"[", "ir", "  ", "]"}], "]"}], "-", 
       RowBox[{"{", 
        RowBox[{"xr", ",", "alt"}], "}"}]}], ")"}], ".", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"profil", "[", 
        RowBox[{"[", "ir", "  ", "]"}], "]"}], "-", " ", 
       RowBox[{"{", 
        RowBox[{"xr", ",", "alt"}], "}"}]}], ")"}]}], 
    "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{"long", "+=", 
    RowBox[{"Sqrt", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"profil", "[", 
         RowBox[{"[", "i", "  ", "]"}], "]"}], "-", 
        RowBox[{"profil", "[", 
         RowBox[{"[", 
          RowBox[{"i", "+", "1"}], " ", "]"}], "]"}]}], ")"}], ".", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"profil", "[", 
         RowBox[{"[", "i", "  ", "]"}], "]"}], "-", 
        RowBox[{"profil", "[", 
         RowBox[{"[", 
          RowBox[{"i", "+", "1"}], " ", "]"}], "]"}]}], ")"}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", 
     RowBox[{"il", "+", "1"}], ",", 
     RowBox[{"ir", "-", "1"}]}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.726227405042*^9, 3.72622753533*^9}, {3.726230013764*^9, 
   3.72623004948*^9}, {3.726230121551*^9, 3.726230163789*^9}, 
   3.726230250789*^9, {3.726230292102*^9, 3.7262302936070004`*^9}, {
   3.726231386196*^9, 3.726231407833*^9}, {3.726231510461*^9, 
   3.726231515076*^9}},ExpressionUUID->"da21f9e2-e633-4000-bf1c-8e6d895eb175"],

Cell[BoxData["8.35288909599704`"], "Output",
 CellChangeTimes->{{3.726227502731*^9, 3.72622751404*^9}, 
   3.7262300505439997`*^9, 3.7262301643120003`*^9, 3.726230299375*^9, {
   3.726231402686*^9, 3.726231408664*^9}, 3.7262315157*^9, 
   3.7262330274890003`*^9, 3.7262332177609997`*^9, 
   3.726233304427*^9},ExpressionUUID->"482d14c5-b51e-480f-b172-d34af2d9b31e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["long"], "Input",
 CellChangeTimes->{{3.726227504414*^9, 
  3.726227506013*^9}},ExpressionUUID->"310e4bde-f0fb-4b98-a678-aaea26083381"],

Cell[BoxData["43.7534872311104`"], "Output",
 CellChangeTimes->{{3.7262275064630003`*^9, 3.726227517608*^9}, 
   3.726230226168*^9, 3.72623030192*^9, 3.726231412692*^9, 3.726231517759*^9, 
   3.726233029825*^9, 
   3.726233218606*^9},ExpressionUUID->"639c2748-e2cd-404d-a6bd-75fa3c6f6306"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"profilInterp", "[", "x", "]"}], "-", "alt"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "xl", ",", "xr"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.726230927082*^9, 
  3.72623095363*^9}},ExpressionUUID->"883c904a-2e66-465c-b27e-17e5892123fb"],

Cell[BoxData[
 GraphicsBox[{{{{}, {}, 
     TagBox[{
       {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
        Opacity[1.], LineBox[CompressedData["
1:eJxF2nk4FUwXAPDrEpebrSQhVJaSCm+kFOpFUiRtQpElKknZW2ULLZYWSkmU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         "]]}},
      Annotation[#, "Charting`Private`Tag$3252#1"]& ]}}, {}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{106.03249999999842`, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{106.03249999999842`, 191.88}, {-3.499486454708631, 0.}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.726230943987*^9, 3.726230954277*^9}, 
   3.7262330320889997`*^9, 3.7262332194960003`*^9, 
   3.7262333061610003`*^9},ExpressionUUID->"aa194dc7-dc46-4e18-a63d-\
00313d2ea3e5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcLength", "[", 
  RowBox[{"Line", "[", 
   RowBox[{"Join", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"xl", ",", "alt"}], "}"}], "}"}], ",", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"profil", "[", 
        RowBox[{"[", "i", "]"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", 
         RowBox[{"il", "+", "1"}], ",", "ir"}], "}"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"xr", ",", "alt"}], "}"}], "}"}]}], "]"}], "]"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.726231119546*^9, 3.726231184574*^9}, {3.726231351102*^9,
   3.726231360666*^9}},ExpressionUUID->"2dec5f7e-0f00-4dfb-8696-6fcec570c7d9"],

Cell[BoxData["87.39576390177173`"], "Output",
 CellChangeTimes->{
  3.726231185449*^9, {3.7262313517019997`*^9, 3.726231361546*^9}, 
   3.726233041178*^9, 
   3.726233318613*^9},ExpressionUUID->"af98a283-b909-4bca-b819-e46344ae646c"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"set", "=", 
    RowBox[{"Join", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"xl", ",", "alt"}], "}"}], "}"}], ",", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"profil", "[", 
         RowBox[{"[", "i", "]"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", 
          RowBox[{"il", "+", "1"}], ",", "ir"}], "}"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"xr", ",", "alt"}], "}"}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{" "}]}], "Input",
 CellChangeTimes->{{3.726231312764*^9, 3.7262313401540003`*^9}, {
   3.726231469883*^9, 3.726231486217*^9}, {3.726232056657*^9, 
   3.726232132025*^9}, 
   3.7262332233929996`*^9},ExpressionUUID->"55fc4db2-074b-4ec1-8d38-\
139866c083bb"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Rh", "=", 
   RowBox[{"ArcLength", "@", 
    RowBox[{"Line", "[", "set", "]"}]}]}], "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{
  3.726233231824*^9},ExpressionUUID->"fe4310fc-97f0-454a-827a-f41b0b1bbee9"],

Cell[BoxData["87.39576390177173`"], "Output",
 CellChangeTimes->{3.726233232759*^9, 
  3.726233320042*^9},ExpressionUUID->"ad6defb4-27fa-494d-b64d-2558ed8186c4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"S", "=", 
  RowBox[{"Area", "@", " ", 
   RowBox[{"Polygon", "[", "set", "]"}]}]}]], "Input",
 CellChangeTimes->{{3.726231875073*^9, 3.726231890429*^9}, {3.7262319287*^9, 
   3.726231947594*^9}, {3.7262320226219997`*^9, 3.726232061264*^9}, 
   3.7262332347720003`*^9},ExpressionUUID->"171d865d-9b90-44b9-a1b6-\
534cdc305e48"],

Cell[BoxData["93.80812500002503`"], "Output",
 CellChangeTimes->{
  3.7262318915030003`*^9, {3.726231930817*^9, 3.726231948278*^9}, {
   3.726232027523*^9, 3.726232031013*^9}, 
   3.726233321311*^9},ExpressionUUID->"b61f3c11-6026-4458-be9c-ee465ca187db"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"pente", "=", 
  RowBox[{"2", "/", "66."}]}], "\[IndentingNewLine]", 
 RowBox[{"K", "=", "30"}], "\[IndentingNewLine]", 
 RowBox[{"Q", "=", 
  RowBox[{"S", " ", 
   RowBox[{"Rh", "^", 
    RowBox[{"(", 
     RowBox[{"2", "/", "3"}], ")"}]}], " ", 
   RowBox[{"Sqrt", "[", "pente", "]"}], " ", "K"}]}]}], "Input",
 CellChangeTimes->{{3.726231714743*^9, 3.726231727738*^9}, {
  3.7262321378970003`*^9, 3.726232154474*^9}, {3.726232297094*^9, 
  3.726232315158*^9}},ExpressionUUID->"0d829cff-5f1a-49a6-92f5-13408b55eaaf"],

Cell[BoxData["0.030303030303030304`"], "Output",
 CellChangeTimes->{
  3.726232155381*^9, {3.726232302566*^9, 3.726232316356*^9}, 
   3.726233323672*^9},ExpressionUUID->"8aaa2a41-c103-4629-9ab5-b6a137282d53"],

Cell[BoxData["30"], "Output",
 CellChangeTimes->{
  3.726232155381*^9, {3.726232302566*^9, 3.726232316356*^9}, 
   3.726233323674*^9},ExpressionUUID->"c30923e0-ec5b-4bac-a4c5-80dd11c08cfb"],

Cell[BoxData["9647.874869994726`"], "Output",
 CellChangeTimes->{
  3.726232155381*^9, {3.726232302566*^9, 3.726232316356*^9}, 
   3.726233323678*^9},ExpressionUUID->"86463bed-8496-406b-a85e-39c628e350f1"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["calcul", "Subsection",
 CellChangeTimes->{{3.726232366929*^9, 3.726232384227*^9}, {3.726232447131*^9,
   3.726232470816*^9}},ExpressionUUID->"4089b75d-0bc6-4f15-9daa-0a3f16ae7728"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"pente", "=", 
  RowBox[{"2", "/", "66."}]}], "\[IndentingNewLine]", 
 RowBox[{"K", "=", "25"}], "\[IndentingNewLine]", 
 RowBox[{"sol", "=", 
  RowBox[{"{", "}"}]}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"ival", "=", 
     RowBox[{"{", "}"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"xval", "=", 
     RowBox[{"{", "}"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"Do", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"profil", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "2"}], "]"}], "]"}], "\[LessEqual]", "alt", "<=", 
          RowBox[{"profil", "[", 
           RowBox[{"[", 
            RowBox[{
             RowBox[{"i", "+", "1"}], ",", "2"}], "]"}], "]"}]}], "||", 
         RowBox[{
          RowBox[{"profil", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "2"}], "]"}], "]"}], "\[GreaterEqual]", " ", 
          "alt", "\[GreaterEqual]", 
          RowBox[{"profil", "[", 
           RowBox[{"[", 
            RowBox[{
             RowBox[{"i", "+", "1"}], ",", "2"}], "]"}], "]"}]}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"AppendTo", "[", 
          RowBox[{"ival", ",", "i"}], "]"}], ";", "\[IndentingNewLine]", 
         RowBox[{"interp", "=", 
          RowBox[{"Interpolation", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"profil", "[", 
               RowBox[{"[", "i", "  ", "]"}], "]"}], ",", 
              RowBox[{"profil", "[", 
               RowBox[{"[", 
                RowBox[{"i", "+", "1"}], " ", "]"}], "]"}]}], "}"}], ",", 
            RowBox[{"InterpolationOrder", "\[Rule]", "1"}]}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"xc", "=", 
          RowBox[{"x", "/.", 
           RowBox[{
            RowBox[{"FindRoot", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"interp", "[", "x", "]"}], "\[Equal]", "alt"}], ",", 
              RowBox[{"{", 
               RowBox[{"x", ",", 
                RowBox[{"profil", "[", 
                 RowBox[{"[", 
                  RowBox[{
                   RowBox[{"i", "+", "1"}], ",", "1"}], "]"}], "]"}]}], 
               "}"}]}], "]"}], "[", 
            RowBox[{"[", "1", "]"}], "]"}]}]}], ";", 
         RowBox[{"Print", "[", 
          RowBox[{"\"\<i =\>\"", ",", "i", ",", "\"\< x = \>\"", ",", "xc"}], 
          "]"}], ";", 
         RowBox[{"AppendTo", "[", 
          RowBox[{"xval", ",", "xc"}], "]"}], ";"}]}], "\[IndentingNewLine]", 
       "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", 
        RowBox[{"n", "-", "1"}]}], "}"}]}], "]"}], ";", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"il", ",", "ir"}], "}"}], "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"First", "@", "ival"}], ",", 
       RowBox[{"Last", "@", "ival"}]}], "}"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"xl", ",", "xr"}], "}"}], "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"First", "@", "xval"}], ",", 
       RowBox[{"Last", "@", "xval"}]}], "}"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"set", "=", 
     RowBox[{"Join", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"xl", ",", "alt"}], "}"}], "}"}], ",", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"profil", "[", 
          RowBox[{"[", "i", "]"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", 
           RowBox[{"il", "+", "1"}], ",", "ir"}], "}"}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"xr", ",", "alt"}], "}"}], "}"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"\[Chi]", "=", 
     RowBox[{"ArcLength", "@", 
      RowBox[{"Line", "[", "set", "]"}]}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"S", "=", 
     RowBox[{"NIntegrate", "[", 
      RowBox[{
       RowBox[{"alt", " ", "-", 
        RowBox[{"profilInterp", "[", "x", "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "xl", ",", "xr"}], "}"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"Rh", "=", 
     RowBox[{"S", "/", "\[Chi]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"Q", "=", 
     RowBox[{"S", " ", 
      RowBox[{"Rh", "^", 
       RowBox[{"(", 
        RowBox[{"2", "/", "3"}], ")"}]}], " ", 
      RowBox[{"Sqrt", "[", "pente", "]"}], " ", "K"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"AppendTo", "[", 
     RowBox[{"sol", ",", 
      RowBox[{"{", 
       RowBox[{"alt", ",", 
        RowBox[{"alt", "-", "zmin"}], ",", "Q", ",", "S", ",", "Rh"}], 
       "}"}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"alt", ",", 
     RowBox[{"zmin", "+", "0.2"}], ",", 
     RowBox[{"zmin", "+", "4"}], ",", "0.05"}], "}"}]}], 
  "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.7262258536730003`*^9, 3.726225974487*^9}, {
   3.726226108792*^9, 3.726226133618*^9}, {3.726226317785*^9, 
   3.7262264099820004`*^9}, {3.726226449434*^9, 3.72622647455*^9}, {
   3.726226514075*^9, 3.726226570517*^9}, {3.726227020848*^9, 
   3.726227075016*^9}, {3.726227423367*^9, 3.726227427098*^9}, {
   3.726232510858*^9, 3.726232631461*^9}, {3.726232669826*^9, 
   3.726232693715*^9}, {3.726233371703*^9, 3.7262334043640003`*^9}, 
   3.726233638984*^9, {3.726235938874*^9, 3.726235945443*^9}, {
   3.7262390861689997`*^9, 3.72623913842*^9}, 
   3.7262391871289997`*^9},ExpressionUUID->"9991d507-343b-4eef-afeb-\
096b668cd42d"],

Cell[BoxData["0.030303030303030304`"], "Output",
 CellChangeTimes->{
  3.7262258573529997`*^9, 3.726225974858*^9, 3.726226134086*^9, 
   3.7262264111689997`*^9, {3.7262264709849997`*^9, 3.7262264752460003`*^9}, 
   3.726226519617*^9, {3.726226556707*^9, 3.726226571341*^9}, {
   3.7262270628599997`*^9, 3.726227075238*^9}, 3.7262326354440002`*^9, 
   3.726232694592*^9, 3.726232735284*^9, {3.726233379144*^9, 
   3.7262334054709997`*^9}, 3.726233639807*^9, {3.7262359223310003`*^9, 
   3.7262359457139997`*^9}, {3.72623911376*^9, 3.726239138712*^9}, 
   3.726239187417*^9, 
   3.726243209344*^9},ExpressionUUID->"6069ffac-cb32-492a-ba02-17b416f57543"],

Cell[BoxData["25"], "Output",
 CellChangeTimes->{
  3.7262258573529997`*^9, 3.726225974858*^9, 3.726226134086*^9, 
   3.7262264111689997`*^9, {3.7262264709849997`*^9, 3.7262264752460003`*^9}, 
   3.726226519617*^9, {3.726226556707*^9, 3.726226571341*^9}, {
   3.7262270628599997`*^9, 3.726227075238*^9}, 3.7262326354440002`*^9, 
   3.726232694592*^9, 3.726232735284*^9, {3.726233379144*^9, 
   3.7262334054709997`*^9}, 3.726233639807*^9, {3.7262359223310003`*^9, 
   3.7262359457139997`*^9}, {3.72623911376*^9, 3.726239138712*^9}, 
   3.726239187417*^9, 
   3.7262432093459997`*^9},ExpressionUUID->"93cade9e-73bf-4337-a3d4-\
46e1bf5c6f08"],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 CellChangeTimes->{
  3.7262258573529997`*^9, 3.726225974858*^9, 3.726226134086*^9, 
   3.7262264111689997`*^9, {3.7262264709849997`*^9, 3.7262264752460003`*^9}, 
   3.726226519617*^9, {3.726226556707*^9, 3.726226571341*^9}, {
   3.7262270628599997`*^9, 3.726227075238*^9}, 3.7262326354440002`*^9, 
   3.726232694592*^9, 3.726232735284*^9, {3.726233379144*^9, 
   3.7262334054709997`*^9}, 3.726233639807*^9, {3.7262359223310003`*^9, 
   3.7262359457139997`*^9}, {3.72623911376*^9, 3.726239138712*^9}, 
   3.726239187417*^9, 
   3.726243209349*^9},ExpressionUUID->"b22c5f04-94c9-46c2-86ab-1d0e8789ec60"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "20", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "173.74727272727267`"}],
  SequenceForm["i =", 20, " x = ", 173.74727272727267`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243209352*^9},ExpressionUUID->"18f593e2-1b4a-49d3-9eb3-118cde48b7c7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "22", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "175.581666666667`"}],
  SequenceForm["i =", 22, " x = ", 175.581666666667],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243209354*^9},ExpressionUUID->"bafb8aff-cd1e-483f-96fd-019889b7ad82"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "20", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "173.6990909090909`"}],
  SequenceForm["i =", 20, " x = ", 173.6990909090909],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.7262432093570004`*^9},ExpressionUUID->"05f7c0e2-331f-494a-8f21-\
bdf971cb5c93"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "22", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "175.71750000000014`"}],
  SequenceForm["i =", 22, " x = ", 175.71750000000014`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243209361*^9},ExpressionUUID->"70d5286b-fce2-4690-aebf-cb97b85d9b06"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "20", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "173.6509090909091`"}],
  SequenceForm["i =", 20, " x = ", 173.6509090909091],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.7262432093640003`*^9},ExpressionUUID->"41a748a9-369a-4fcd-ac41-\
f99c3e70f2e9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "22", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "175.85333333333332`"}],
  SequenceForm["i =", 22, " x = ", 175.85333333333332`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243209368*^9},ExpressionUUID->"b03c9023-7c03-4576-bde1-1b66a2d69b0f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "20", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "173.60272727272712`"}],
  SequenceForm["i =", 20, " x = ", 173.60272727272712`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243209374*^9},ExpressionUUID->"68d87c09-b03c-4be5-8aa3-6173e1abf4e1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "22", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "175.98916666666713`"}],
  SequenceForm["i =", 22, " x = ", 175.98916666666713`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.7262432093789997`*^9},ExpressionUUID->"4fb68f77-8354-4a4e-bdf2-\
095a2bcfab44"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "20", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "173.55454545454532`"}],
  SequenceForm["i =", 20, " x = ", 173.55454545454532`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243209382*^9},ExpressionUUID->"44f1ce72-9c85-4468-9284-aa0db83f3c80"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "22", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "176.1250000000003`"}],
  SequenceForm["i =", 22, " x = ", 176.1250000000003],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243209384*^9},ExpressionUUID->"672293a4-ea03-4506-92fe-7c18f7a6a408"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "23", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", "178.44`"}],
  SequenceForm["i =", 23, " x = ", 178.44],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243209387*^9},ExpressionUUID->"0059e99b-3524-4f12-bd20-5000cf1d73ad"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "24", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", "178.44`"}],
  SequenceForm["i =", 24, " x = ", 178.44],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243209391*^9},ExpressionUUID->"720ffc64-0137-4209-afe0-9103078a5250"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "20", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "173.50636363636355`"}],
  SequenceForm["i =", 20, " x = ", 173.50636363636355`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243209394*^9},ExpressionUUID->"7be951e9-1df8-4ade-9812-8c5e34ee4a86"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "22", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "176.2608333333335`"}],
  SequenceForm["i =", 22, " x = ", 176.2608333333335],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.7262432093970003`*^9},ExpressionUUID->"b4a033a0-d4ef-47f1-babc-\
86ea7f8d8ae9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "23", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "178.1900000000002`"}],
  SequenceForm["i =", 23, " x = ", 178.1900000000002],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.7262432094*^9},ExpressionUUID->"19db96f6-30bf-455a-a4c8-a5fc5281ef29"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "24", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "178.50549999999993`"}],
  SequenceForm["i =", 24, " x = ", 178.50549999999993`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243209403*^9},ExpressionUUID->"a14414f7-a3e8-4c41-90ee-a7496d625ef7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "20", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "173.45818181818177`"}],
  SequenceForm["i =", 20, " x = ", 173.45818181818177`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243209407*^9},ExpressionUUID->"e2553741-f2bc-4211-a775-e01280e6207d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "22", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "176.39666666666668`"}],
  SequenceForm["i =", 22, " x = ", 176.39666666666668`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.72624320941*^9},ExpressionUUID->"0f6d7aeb-e3d2-44fb-a8b9-ce0ef798772e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "23", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "177.94000000000037`"}],
  SequenceForm["i =", 23, " x = ", 177.94000000000037`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243209413*^9},ExpressionUUID->"6caf4be9-44e9-46a6-b7f5-005493b6e79b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "24", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "178.57099999999988`"}],
  SequenceForm["i =", 24, " x = ", 178.57099999999988`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243209416*^9},ExpressionUUID->"858150dc-f0a5-46aa-bca5-74cec9e75311"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "20", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", "173.41`"}],
  SequenceForm["i =", 20, " x = ", 173.41],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.7262432094189997`*^9},ExpressionUUID->"a16b96c9-c9ef-49db-bf61-\
c4e77ffd8e18"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "22", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "176.53249999999986`"}],
  SequenceForm["i =", 22, " x = ", 176.53249999999986`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243209422*^9},ExpressionUUID->"f5b6ac62-0b63-4ebd-8091-de082910f451"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "23", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "177.69000000000057`"}],
  SequenceForm["i =", 23, " x = ", 177.69000000000057`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243209425*^9},ExpressionUUID->"fe875dd6-9ef0-46df-a52b-6a6490e4a1e5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "24", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "178.6364999999998`"}],
  SequenceForm["i =", 24, " x = ", 178.6364999999998],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243209428*^9},ExpressionUUID->"59b54890-96ec-41f2-acab-02e6e4ff509c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "20", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "173.361818181818`"}],
  SequenceForm["i =", 20, " x = ", 173.361818181818],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.7262432094309998`*^9},ExpressionUUID->"67e4c51f-52cb-4898-a405-\
9be9dbbffe40"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "22", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "176.66833333333363`"}],
  SequenceForm["i =", 22, " x = ", 176.66833333333363`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243209433*^9},ExpressionUUID->"1af16800-2c42-4f5d-9124-b0aa1778aabc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "23", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "177.43999999999963`"}],
  SequenceForm["i =", 23, " x = ", 177.43999999999963`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243209436*^9},ExpressionUUID->"9202c6d7-70f4-4fa7-84aa-25e1b6e29ac1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "24", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "178.70200000000006`"}],
  SequenceForm["i =", 24, " x = ", 178.70200000000006`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.72624320944*^9},ExpressionUUID->"a463c754-79be-46a5-a15b-218307e1495d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "20", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "173.31363636363622`"}],
  SequenceForm["i =", 20, " x = ", 173.31363636363622`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243209442*^9},ExpressionUUID->"348fb6aa-91ef-4c2f-9c89-79576e15e6b4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "22", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "176.80416666666682`"}],
  SequenceForm["i =", 22, " x = ", 176.80416666666682`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.7262432094449997`*^9},ExpressionUUID->"6e691da6-8aa9-4c1f-988b-\
d7d1786f4404"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "23", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "177.1899999999998`"}],
  SequenceForm["i =", 23, " x = ", 177.1899999999998],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243209448*^9},ExpressionUUID->"f9996212-e54f-4845-9c67-4a6726a02e5c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "24", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "178.76749999999998`"}],
  SequenceForm["i =", 24, " x = ", 178.76749999999998`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243209451*^9},ExpressionUUID->"835df582-0b1a-4195-9555-8ec5f6b4cb93"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "20", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "173.26545454545445`"}],
  SequenceForm["i =", 20, " x = ", 173.26545454545445`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243209455*^9},ExpressionUUID->"d15ef7a9-96ea-4aaa-b216-3ca94c0bd112"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "22", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", "176.94`"}],
  SequenceForm["i =", 22, " x = ", 176.94],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243209459*^9},ExpressionUUID->"a5e94deb-1472-4bc4-95fb-47824e4fbb42"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "23", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", "176.94`"}],
  SequenceForm["i =", 23, " x = ", 176.94],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243209461*^9},ExpressionUUID->"1cd5f15f-7cb4-480d-b1cc-91e6edd9174a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "24", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "178.83299999999994`"}],
  SequenceForm["i =", 24, " x = ", 178.83299999999994`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.7262432094639997`*^9},ExpressionUUID->"11759d20-181e-4b8d-93e3-\
b379b5d4465b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "20", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "173.21727272727267`"}],
  SequenceForm["i =", 20, " x = ", 173.21727272727267`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243209466*^9},ExpressionUUID->"b7abe1e3-2379-4a89-97d1-c8255ed2b456"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "24", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "178.89849999999987`"}],
  SequenceForm["i =", 24, " x = ", 178.89849999999987`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.7262432094700003`*^9},ExpressionUUID->"43bf3d42-0a7d-4bdd-abcb-\
ecb6b74278e5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "20", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "173.1690909090909`"}],
  SequenceForm["i =", 20, " x = ", 173.1690909090909],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243209473*^9},ExpressionUUID->"99f2576f-8abc-489d-b18f-8215dbbef157"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "24", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "178.96399999999983`"}],
  SequenceForm["i =", 24, " x = ", 178.96399999999983`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243209476*^9},ExpressionUUID->"9573d526-531c-4793-b1f4-d9b9c95479f2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "20", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "173.1209090909089`"}],
  SequenceForm["i =", 20, " x = ", 173.1209090909089],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243209479*^9},ExpressionUUID->"6845c86a-472b-4189-a9e7-d8efe867ec81"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "24", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "179.02950000000007`"}],
  SequenceForm["i =", 24, " x = ", 179.02950000000007`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.7262432094820004`*^9},ExpressionUUID->"64d8a5c8-e5ab-4df4-8e8b-\
c9069b8bc973"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "20", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "173.07272727272712`"}],
  SequenceForm["i =", 20, " x = ", 173.07272727272712`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243209484*^9},ExpressionUUID->"d96ced1d-d5e8-4bde-acf7-5cb446eeb620"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "24", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", "179.095`"}],
  SequenceForm["i =", 24, " x = ", 179.095],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243209487*^9},ExpressionUUID->"b434d4ac-62fe-4c59-8c37-fa39e0bfbfb0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "20", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "173.02454545454532`"}],
  SequenceForm["i =", 20, " x = ", 173.02454545454532`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.72624320949*^9},ExpressionUUID->"3d9713aa-bda7-43a6-a262-783908a67308"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "24", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "179.16049999999993`"}],
  SequenceForm["i =", 24, " x = ", 179.16049999999993`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243209492*^9},ExpressionUUID->"c0119806-cad4-494f-978e-ca10310c7bb1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "20", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "172.97636363636354`"}],
  SequenceForm["i =", 20, " x = ", 172.97636363636354`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243209495*^9},ExpressionUUID->"c33d46b8-24b0-4593-a14b-9db236498b32"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "24", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "179.22599999999989`"}],
  SequenceForm["i =", 24, " x = ", 179.22599999999989`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243209498*^9},ExpressionUUID->"881f7acb-7633-4cad-accf-3bb3211ac3f1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "20", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "172.92818181818177`"}],
  SequenceForm["i =", 20, " x = ", 172.92818181818177`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243209501*^9},ExpressionUUID->"2f352a6f-026c-47d0-9223-77aa589d6f61"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "24", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "179.29149999999981`"}],
  SequenceForm["i =", 24, " x = ", 179.29149999999981`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.7262432095039997`*^9},ExpressionUUID->"57bfa0ac-28b7-4067-a863-\
a4fd8a313b7b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "19", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "172.8799999999943`"}],
  SequenceForm["i =", 19, " x = ", 172.8799999999943],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243209506*^9},ExpressionUUID->"da5cae49-7473-40cf-9bd8-3be0ece9ec72"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "20", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "172.87999999999977`"}],
  SequenceForm["i =", 20, " x = ", 172.87999999999977`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243209509*^9},ExpressionUUID->"2447b2f3-1180-4425-bf76-687061a8bd34"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "24", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "179.35700000000006`"}],
  SequenceForm["i =", 24, " x = ", 179.35700000000006`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243209512*^9},ExpressionUUID->"88c6d3e4-994e-4b52-9168-c5062a10d29e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "19", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "171.62999999999715`"}],
  SequenceForm["i =", 19, " x = ", 171.62999999999715`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243209514*^9},ExpressionUUID->"9adbb5fd-6d99-4dfe-a1ab-6b0ec324edf5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "24", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", "179.4225`"}],
  SequenceForm["i =", 24, " x = ", 179.4225],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243209517*^9},ExpressionUUID->"d0eb7379-9db2-4fbd-add0-2577f04ccc77"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "18", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", "170.38`"}],
  SequenceForm["i =", 18, " x = ", 170.38],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243209521*^9},ExpressionUUID->"ebf45dc1-7f35-4d21-b396-c1ccc61fdc57"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "19", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", "170.38`"}],
  SequenceForm["i =", 19, " x = ", 170.38],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243209524*^9},ExpressionUUID->"43ce99f5-5de3-49b0-ae58-92d5ffb6c28d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "24", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "179.48799999999994`"}],
  SequenceForm["i =", 24, " x = ", 179.48799999999994`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243209526*^9},ExpressionUUID->"8cb41370-36bf-420a-852f-ee39b1d1680f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "18", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "170.28115384615393`"}],
  SequenceForm["i =", 18, " x = ", 170.28115384615393`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.7262432095290003`*^9},ExpressionUUID->"c4a164dd-658e-4b7c-a691-\
4165742b94b8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "24", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "179.55349999999987`"}],
  SequenceForm["i =", 24, " x = ", 179.55349999999987`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243209533*^9},ExpressionUUID->"d349c042-df42-4fe1-815d-aef10e25d0e1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "18", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "170.18230769230786`"}],
  SequenceForm["i =", 18, " x = ", 170.18230769230786`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.7262432095369997`*^9},ExpressionUUID->"c1a8fd47-9fa3-4315-8d19-\
74dbf262acfd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "24", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "179.61899999999983`"}],
  SequenceForm["i =", 24, " x = ", 179.61899999999983`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243209539*^9},ExpressionUUID->"f0f072e2-129d-4cca-b25d-e9abd9037721"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "18", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "170.08346153846134`"}],
  SequenceForm["i =", 18, " x = ", 170.08346153846134`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243209542*^9},ExpressionUUID->"1153a110-4129-4c3f-8ed8-6ce8119a1d69"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "24", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "179.68450000000007`"}],
  SequenceForm["i =", 24, " x = ", 179.68450000000007`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243209547*^9},ExpressionUUID->"a10792a7-76ef-40f7-8706-e21cc7a1b4b6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "18", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "169.98461538461527`"}],
  SequenceForm["i =", 18, " x = ", 169.98461538461527`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243209549*^9},ExpressionUUID->"bcdd8478-29e1-47a7-9e61-5d1ebfcba5d8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "24", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", "179.75`"}],
  SequenceForm["i =", 24, " x = ", 179.75],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243209552*^9},ExpressionUUID->"e13cff68-cd74-45a8-b499-8c79b61d3914"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "25", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", "179.75`"}],
  SequenceForm["i =", 25, " x = ", 179.75],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.7262432095550003`*^9},ExpressionUUID->"4b4c597a-9220-4087-a192-\
08a09d1a0fca"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "18", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "169.8857692307692`"}],
  SequenceForm["i =", 18, " x = ", 169.8857692307692],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243209558*^9},ExpressionUUID->"a0dd2dc9-d1b1-4e15-a519-b9630d4fa057"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "25", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", "180.8125`"}],
  SequenceForm["i =", 25, " x = ", 180.8125],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243209561*^9},ExpressionUUID->"9e47e49f-303b-4a86-b480-aaad25fe71d6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "18", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "169.78692307692313`"}],
  SequenceForm["i =", 18, " x = ", 169.78692307692313`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243209564*^9},ExpressionUUID->"6281cb4b-3f5f-4f80-945d-087a057b7614"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "25", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", "181.875`"}],
  SequenceForm["i =", 25, " x = ", 181.875],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243209566*^9},ExpressionUUID->"39940204-2f39-4355-af01-2294dfbfc67a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "18", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "169.68807692307706`"}],
  SequenceForm["i =", 18, " x = ", 169.68807692307706`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.7262432095690002`*^9},ExpressionUUID->"f3a67bca-11aa-4b63-9cdc-\
777f017fee49"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "25", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", "182.9375`"}],
  SequenceForm["i =", 25, " x = ", 182.9375],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243209573*^9},ExpressionUUID->"3debf5ff-4ed3-475f-b3de-129956df3a29"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "18", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "169.58923076923057`"}],
  SequenceForm["i =", 18, " x = ", 169.58923076923057`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243209576*^9},ExpressionUUID->"9a2b2d66-7a75-483a-8cc8-0e1226b33f98"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "25", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "184.00000000000483`"}],
  SequenceForm["i =", 25, " x = ", 184.00000000000483`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243209578*^9},ExpressionUUID->"0d4137e0-e885-430f-afeb-5e0486c27663"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "26", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "184.00000000000182`"}],
  SequenceForm["i =", 26, " x = ", 184.00000000000182`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243209582*^9},ExpressionUUID->"f7fdb787-1560-4886-801e-ac013c009c67"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "18", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "169.4903846153845`"}],
  SequenceForm["i =", 18, " x = ", 169.4903846153845],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243209586*^9},ExpressionUUID->"3c2d2dff-217a-4c09-83cb-e467f5647f91"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "26", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "184.39875000000137`"}],
  SequenceForm["i =", 26, " x = ", 184.39875000000137`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.72624320959*^9},ExpressionUUID->"8c771ed7-eea8-4d8e-a465-a1ae32ec91ab"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "18", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "169.39153846153843`"}],
  SequenceForm["i =", 18, " x = ", 169.39153846153843`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243209593*^9},ExpressionUUID->"ddefb76c-a866-4eee-96d0-6680fb876867"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "26", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "184.7975000000009`"}],
  SequenceForm["i =", 26, " x = ", 184.7975000000009],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.7262432095959997`*^9},ExpressionUUID->"288b3e14-c1fd-40de-b17c-\
e01fe0fee3eb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "18", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "169.29269230769236`"}],
  SequenceForm["i =", 18, " x = ", 169.29269230769236`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243209599*^9},ExpressionUUID->"09312687-4172-4e0a-bc46-02425f4b5e21"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "26", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "185.19625000000045`"}],
  SequenceForm["i =", 26, " x = ", 185.19625000000045`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243209602*^9},ExpressionUUID->"10aceb00-28f6-439f-ba03-647ec487aa4f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "18", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "169.1938461538463`"}],
  SequenceForm["i =", 18, " x = ", 169.1938461538463],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243209605*^9},ExpressionUUID->"74b18046-fb71-4859-b85f-72fd1cbae51c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "26", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", "185.595`"}],
  SequenceForm["i =", 26, " x = ", 185.595],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243209608*^9},ExpressionUUID->"d5e16f8c-c684-49f6-812b-02bbe8d613a7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "18", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "169.09499999999977`"}],
  SequenceForm["i =", 18, " x = ", 169.09499999999977`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243209611*^9},ExpressionUUID->"885c7bac-ba2c-4b47-8b06-a8e282a77b68"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "26", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "185.99375000000137`"}],
  SequenceForm["i =", 26, " x = ", 185.99375000000137`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.7262432096140003`*^9},ExpressionUUID->"5a00464e-c7ef-43f5-ba7f-\
b1d094f374a3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "18", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "168.9961538461537`"}],
  SequenceForm["i =", 18, " x = ", 168.9961538461537],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243209617*^9},ExpressionUUID->"6ffccb8c-afc1-4fb0-83f0-6429e5141e7d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "26", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "186.3925000000009`"}],
  SequenceForm["i =", 26, " x = ", 186.3925000000009],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.72624320962*^9},ExpressionUUID->"db14ab0c-31d7-4160-b66d-2f6a81928269"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "18", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "168.89730769230763`"}],
  SequenceForm["i =", 18, " x = ", 168.89730769230763`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243209631*^9},ExpressionUUID->"29b59c82-db76-42c7-ba94-7afebcfb2a17"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "26", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "186.79125000000045`"}],
  SequenceForm["i =", 26, " x = ", 186.79125000000045`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243209635*^9},ExpressionUUID->"0a6d6186-073a-45d8-bfea-44a0e429b615"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "18", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "168.79846153846157`"}],
  SequenceForm["i =", 18, " x = ", 168.79846153846157`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243209639*^9},ExpressionUUID->"7cadeb86-61de-48d9-957d-d69d98ba485f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "26", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", "187.19`"}],
  SequenceForm["i =", 26, " x = ", 187.19],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243209642*^9},ExpressionUUID->"a96c4851-2fd4-4ed7-accb-30d268cf3255"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "27", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", "187.19`"}],
  SequenceForm["i =", 27, " x = ", 187.19],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243209644*^9},ExpressionUUID->"2c66dcbb-5cf7-4ee1-a976-1fc62c2fbb7c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "18", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "168.6996153846155`"}],
  SequenceForm["i =", 18, " x = ", 168.6996153846155],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.7262432096470003`*^9},ExpressionUUID->"ec38dc99-1838-4ad3-ba4d-\
4e42d314d3e7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "27", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "187.3394444444443`"}],
  SequenceForm["i =", 27, " x = ", 187.3394444444443],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.72624320965*^9},ExpressionUUID->"88e1e94f-a774-48fe-b38f-ebff5cd23e76"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "18", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "168.60076923076898`"}],
  SequenceForm["i =", 18, " x = ", 168.60076923076898`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243209659*^9},ExpressionUUID->"6f76fb01-93a3-4cfb-9eb8-95b822d192b8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "27", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "187.48888888888928`"}],
  SequenceForm["i =", 27, " x = ", 187.48888888888928`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243209663*^9},ExpressionUUID->"893f6db7-60a5-4b9f-a806-8cca02bf7e5d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "18", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "168.50192307692294`"}],
  SequenceForm["i =", 18, " x = ", 168.50192307692294`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.72624320967*^9},ExpressionUUID->"16a7e7c3-c0e6-4205-ba4e-7ab923c7b68a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "27", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "187.63833333333355`"}],
  SequenceForm["i =", 27, " x = ", 187.63833333333355`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243209674*^9},ExpressionUUID->"112ac9a7-81ab-44dc-a74b-ce675eb10246"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "18", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "168.40307692307687`"}],
  SequenceForm["i =", 18, " x = ", 168.40307692307687`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243209683*^9},ExpressionUUID->"2a17fb8c-10b4-41cd-a8a4-5418ce1637bf"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "27", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "187.78777777777785`"}],
  SequenceForm["i =", 27, " x = ", 187.78777777777785`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.7262432096879997`*^9},ExpressionUUID->"7967782e-b9d0-44d3-a6a8-\
b1502663e830"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "18", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "168.3042307692308`"}],
  SequenceForm["i =", 18, " x = ", 168.3042307692308],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.7262432096949997`*^9},ExpressionUUID->"246760ec-c404-4bf6-99e3-\
69a5ae532c11"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "27", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "187.93722222222215`"}],
  SequenceForm["i =", 27, " x = ", 187.93722222222215`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243209699*^9},ExpressionUUID->"c9525071-7d2a-4339-bb39-82e694ed4e67"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "14", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", "152.31`"}],
  SequenceForm["i =", 14, " x = ", 152.31],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243209708*^9},ExpressionUUID->"eb04fd18-2d1c-4f97-b217-595696eb07d5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "15", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", "152.31`"}],
  SequenceForm["i =", 15, " x = ", 152.31],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243209711*^9},ExpressionUUID->"54295290-7cb9-43f8-a69a-625bd5dd4363"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "18", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "168.20538461538473`"}],
  SequenceForm["i =", 18, " x = ", 168.20538461538473`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.7262432097139997`*^9},ExpressionUUID->"e5528047-4dfb-4599-9e42-\
9465472d9516"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "27", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "188.08666666666645`"}],
  SequenceForm["i =", 27, " x = ", 188.08666666666645`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243209717*^9},ExpressionUUID->"1d406542-0054-4364-a067-7333a0426941"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "14", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "150.80999999999432`"}],
  SequenceForm["i =", 14, " x = ", 150.80999999999432`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.7262432097209997`*^9},ExpressionUUID->"def8f8be-783d-435c-be06-\
db164a99b864"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "15", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "153.38750000000368`"}],
  SequenceForm["i =", 15, " x = ", 153.38750000000368`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243209724*^9},ExpressionUUID->"3e58cee5-02f1-4745-aba5-dc9d1e357ceb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "18", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "168.1065384615382`"}],
  SequenceForm["i =", 18, " x = ", 168.1065384615382],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243209727*^9},ExpressionUUID->"e59faf4d-1ec0-4527-8942-7b796bd7142b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "27", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "188.2361111111114`"}],
  SequenceForm["i =", 27, " x = ", 188.2361111111114],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243209729*^9},ExpressionUUID->"a947fe31-44d7-439c-a72e-3822502eec9e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "14", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "149.30999999999545`"}],
  SequenceForm["i =", 14, " x = ", 149.30999999999545`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.7262432097320004`*^9},ExpressionUUID->"dd7cd84b-f870-45f7-b0af-\
138c141d7708"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "15", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "154.46500000000245`"}],
  SequenceForm["i =", 15, " x = ", 154.46500000000245`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.7262432097349997`*^9},ExpressionUUID->"adcd8642-3884-47ad-9d32-\
bdcb25c7841b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "16", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", "163.75`"}],
  SequenceForm["i =", 16, " x = ", 163.75],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.7262432097390003`*^9},ExpressionUUID->"383ccac4-944c-4a06-8216-\
819c82a0a8f6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "17", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", "163.75`"}],
  SequenceForm["i =", 17, " x = ", 163.75],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243209742*^9},ExpressionUUID->"f0e92ef3-fa06-4e70-8538-3819a2f25af0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "18", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "168.00769230769214`"}],
  SequenceForm["i =", 18, " x = ", 168.00769230769214`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243209745*^9},ExpressionUUID->"ddde05a4-c59c-4d87-8997-2c9e4cf8b463"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "27", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "188.3855555555557`"}],
  SequenceForm["i =", 27, " x = ", 188.3855555555557],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243209748*^9},ExpressionUUID->"0f8844f3-c44d-4046-9431-64be808127a7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "14", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "147.8099999999966`"}],
  SequenceForm["i =", 14, " x = ", 147.8099999999966],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243209751*^9},ExpressionUUID->"a235f16f-29dd-47ec-80b8-7e698fd20750"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "15", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "155.54250000000124`"}],
  SequenceForm["i =", 15, " x = ", 155.54250000000124`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243209755*^9},ExpressionUUID->"3e551bd4-bb7f-4bd5-91a8-96dadafb3b80"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "16", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", "160.185`"}],
  SequenceForm["i =", 16, " x = ", 160.185],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243209758*^9},ExpressionUUID->"0f005bef-231e-44a8-84ca-6d4dd4491ddb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "17", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", "165.78`"}],
  SequenceForm["i =", 17, " x = ", 165.78],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.7262432097609997`*^9},ExpressionUUID->"f9a3538e-6d83-4a3f-858f-\
59a5c92215e4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "18", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "167.90884615384607`"}],
  SequenceForm["i =", 18, " x = ", 167.90884615384607`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.7262432097650003`*^9},ExpressionUUID->"ac697f92-03ae-48d6-be45-\
602014901a3c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "27", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", "188.535`"}],
  SequenceForm["i =", 27, " x = ", 188.535],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243209767*^9},ExpressionUUID->"667fdfb4-076e-4ba8-a644-62b30fa8c5ca"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "14", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "146.30999999999773`"}],
  SequenceForm["i =", 14, " x = ", 146.30999999999773`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243209771*^9},ExpressionUUID->"4f99db1a-005b-464e-8397-f40d07e66927"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "15", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", "156.62`"}],
  SequenceForm["i =", 15, " x = ", 156.62],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243209774*^9},ExpressionUUID->"832a2dff-2907-42bf-a776-5f9526ba2aa5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "16", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", "156.62`"}],
  SequenceForm["i =", 16, " x = ", 156.62],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243209777*^9},ExpressionUUID->"13a6079b-6ce6-48a8-b7ba-6c8ad050699b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "17", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", "167.81`"}],
  SequenceForm["i =", 17, " x = ", 167.81],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.7262432097799997`*^9},ExpressionUUID->"606c5224-9ddd-46e6-870b-\
aafaf36ee4a8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "18", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", "167.81`"}],
  SequenceForm["i =", 18, " x = ", 167.81],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243209784*^9},ExpressionUUID->"43370afc-c85c-44f5-83fe-016412c309a4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "27", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "188.6844444444443`"}],
  SequenceForm["i =", 27, " x = ", 188.6844444444443],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.7262432097869997`*^9},ExpressionUUID->"bbc20766-dc2e-47ed-8b71-\
38ab83faa392"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "14", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "144.80999999999887`"}],
  SequenceForm["i =", 14, " x = ", 144.80999999999887`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.72624320979*^9},ExpressionUUID->"edbc8232-dced-4d17-9071-e615f145542a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "27", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "188.8338888888886`"}],
  SequenceForm["i =", 27, " x = ", 188.8338888888886],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243209793*^9},ExpressionUUID->"b1440c49-cdc1-4e3c-8abf-d8176f0f0684"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "12", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "136.3799999999936`"}],
  SequenceForm["i =", 12, " x = ", 136.3799999999936],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243209797*^9},ExpressionUUID->"ab1493f4-f4d6-4a62-a911-245ecb1a729b"]
}, Open  ]],

Cell[BoxData[
 TemplateBox[{
  "FindRoot","jsing",
   "\"Encountered a singular Jacobian at the point \
\\!\\(\\*RowBox[{\\\"{\\\", \\\"x\\\", \\\"}\\\"}]\\) = \
\\!\\(\\*RowBox[{\\\"{\\\", \\\"143.31`\\\", \\\"}\\\"}]\\). Try perturbing \
the initial point(s).\"",2,308,22,21554243663432278208,"Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.726239139165*^9, 3.726239187876*^9, 
  3.7262432098*^9},ExpressionUUID->"c24584f6-2b9b-4f17-91e2-0a436b80e850"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "13", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", "143.31`"}],
  SequenceForm["i =", 13, " x = ", 143.31],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243209821*^9},ExpressionUUID->"d7ca5d41-3a92-4e1e-a867-9610b4031b08"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "14", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "143.30999999999318`"}],
  SequenceForm["i =", 14, " x = ", 143.30999999999318`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243209823*^9},ExpressionUUID->"f651b4b9-84d4-4fad-b663-8a7074625ead"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "27", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "188.98333333333355`"}],
  SequenceForm["i =", 27, " x = ", 188.98333333333355`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.7262432098269997`*^9},ExpressionUUID->"be280504-a6cd-4dba-b03d-\
ece66c7b2ea0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "12", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "134.9724999999952`"}],
  SequenceForm["i =", 12, " x = ", 134.9724999999952],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.72624320983*^9},ExpressionUUID->"16073b09-f6a3-435d-a568-30f3dd19cae6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "27", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "189.13277777777785`"}],
  SequenceForm["i =", 27, " x = ", 189.13277777777785`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243209833*^9},ExpressionUUID->"1ae57af1-b308-45ff-81cf-6307bf4e7845"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "12", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "133.5649999999968`"}],
  SequenceForm["i =", 12, " x = ", 133.5649999999968],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243209836*^9},ExpressionUUID->"f03714e2-822f-4fe4-a387-5b179de136a9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "27", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "189.28222222222215`"}],
  SequenceForm["i =", 27, " x = ", 189.28222222222215`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.7262432098389997`*^9},ExpressionUUID->"0fe7932b-79ef-4edf-be68-\
6b74bea360fd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "12", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "132.1574999999984`"}],
  SequenceForm["i =", 12, " x = ", 132.1574999999984],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243209842*^9},ExpressionUUID->"8d8fed4d-81b6-462b-98e0-7b5d4b787217"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "27", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "189.43166666666644`"}],
  SequenceForm["i =", 27, " x = ", 189.43166666666644`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243209844*^9},ExpressionUUID->"a74e9a54-d5d2-4cf0-8039-2c8078aa085f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "12", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", "130.75`"}],
  SequenceForm["i =", 12, " x = ", 130.75],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243209854*^9},ExpressionUUID->"0939e5c1-e367-4fef-9885-6c55dd31672c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "27", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "189.58111111111072`"}],
  SequenceForm["i =", 27, " x = ", 189.58111111111072`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243209858*^9},ExpressionUUID->"90959736-5bd5-475b-84b7-a82294779bba"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "12", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "129.3424999999952`"}],
  SequenceForm["i =", 12, " x = ", 129.3424999999952],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.7262432098719997`*^9},ExpressionUUID->"ff2cf531-31b0-4af9-929a-\
4e590ee868b8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "27", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "189.7305555555557`"}],
  SequenceForm["i =", 27, " x = ", 189.7305555555557],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243209877*^9},ExpressionUUID->"fc7c295e-b2fc-42c7-8b80-c51d6bcaae43"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "12", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "127.9349999999968`"}],
  SequenceForm["i =", 12, " x = ", 127.9349999999968],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243209885*^9},ExpressionUUID->"43a0d69e-0080-4123-9098-b28dfa1cb84c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "27", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", "189.88`"}],
  SequenceForm["i =", 27, " x = ", 189.88],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.7262432098900003`*^9},ExpressionUUID->"f312065a-0c6e-4c1c-a127-\
0fa402545f90"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "28", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", "189.88`"}],
  SequenceForm["i =", 28, " x = ", 189.88],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243209894*^9},ExpressionUUID->"3f15c1f6-0cb3-42e9-a5ec-88c91cdcc12e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "12", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "126.5274999999984`"}],
  SequenceForm["i =", 12, " x = ", 126.5274999999984],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243209903*^9},ExpressionUUID->"2408d802-628c-4e2f-8147-761319c71983"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "28", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "190.04666666666654`"}],
  SequenceForm["i =", 28, " x = ", 190.04666666666654`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243209908*^9},ExpressionUUID->"131dac1e-4af5-4159-bc9d-2d49d6b0711d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", "125.12`"}],
  SequenceForm["i =", 11, " x = ", 125.12],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243209916*^9},ExpressionUUID->"9d0b6d1b-62e3-46a2-b0c2-cd6eb08359d1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "12", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", "125.12`"}],
  SequenceForm["i =", 12, " x = ", 125.12],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243209921*^9},ExpressionUUID->"744f31ac-c381-42bc-8d15-c722fc920060"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "28", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "190.21333333333308`"}],
  SequenceForm["i =", 28, " x = ", 190.21333333333308`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243209926*^9},ExpressionUUID->"36d1dfa5-f8a4-46d8-b245-e078d14ac424"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "122.43500000000306`"}],
  SequenceForm["i =", 11, " x = ", 122.43500000000306`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243209935*^9},ExpressionUUID->"70bd0a28-e947-4a77-94b7-a9f5a05e102a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "28", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "190.37999999999963`"}],
  SequenceForm["i =", 28, " x = ", 190.37999999999963`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243209941*^9},ExpressionUUID->"1edede9d-3204-4a8a-8e30-f3a10ab6ebec"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "119.74999999999389`"}],
  SequenceForm["i =", 11, " x = ", 119.74999999999389`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.72624320995*^9},ExpressionUUID->"5938eb9e-cd62-4537-a895-44951670a15f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "28", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "190.5466666666669`"}],
  SequenceForm["i =", 28, " x = ", 190.5466666666669],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243209954*^9},ExpressionUUID->"1db49c11-1bae-4da0-8339-ff2bec81e012"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "117.06499999999694`"}],
  SequenceForm["i =", 11, " x = ", 117.06499999999694`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.7262432099639997`*^9},ExpressionUUID->"575f4d4b-beda-4c82-a9b7-\
9f7c3d105f28"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "28", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "190.71333333333345`"}],
  SequenceForm["i =", 28, " x = ", 190.71333333333345`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.7262432099700003`*^9},ExpressionUUID->"61f028a6-3a7d-4204-b5ae-\
9f8720afde17"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", "114.38`"}],
  SequenceForm["i =", 10, " x = ", 114.38],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243209995*^9},ExpressionUUID->"f6b03864-6746-464b-98f2-3547975a59ba"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", "114.38`"}],
  SequenceForm["i =", 11, " x = ", 114.38],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.72624321*^9},ExpressionUUID->"7744d8c5-769a-4635-8c62-3602c6ec1f56"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "28", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", "190.88`"}],
  SequenceForm["i =", 28, " x = ", 190.88],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243210006*^9},ExpressionUUID->"b8071616-3720-49d3-923c-0c98b2fd30ff"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "112.98875000000079`"}],
  SequenceForm["i =", 10, " x = ", 112.98875000000079`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.7262432100109997`*^9},ExpressionUUID->"e893fdf8-df07-4492-a66c-\
49970ac3df2c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "28", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "191.04666666666654`"}],
  SequenceForm["i =", 28, " x = ", 191.04666666666654`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243210017*^9},ExpressionUUID->"5bffba25-b71c-425a-8019-b1031213e96f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "111.59750000000157`"}],
  SequenceForm["i =", 10, " x = ", 111.59750000000157`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.7262432100220003`*^9},ExpressionUUID->"35ebd930-d463-4bee-b83f-\
21827bd72dd8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "28", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "191.21333333333308`"}],
  SequenceForm["i =", 28, " x = ", 191.21333333333308`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243210027*^9},ExpressionUUID->"0d7427b5-2314-4e63-93ff-9e69e3e3e32d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "110.20624999999605`"}],
  SequenceForm["i =", 10, " x = ", 110.20624999999605`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243210032*^9},ExpressionUUID->"1e4be4db-6a1d-44f2-bf73-4119dc7b21d8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "28", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "191.38000000000036`"}],
  SequenceForm["i =", 28, " x = ", 191.38000000000036`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.7262432100369997`*^9},ExpressionUUID->"394f83f7-b784-43f6-9001-\
0c324ae93f5c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "108.81499999999683`"}],
  SequenceForm["i =", 10, " x = ", 108.81499999999683`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243210047*^9},ExpressionUUID->"c27e1c05-d7ff-4da1-b77a-9e7fe6885fa4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "28", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "191.5466666666669`"}],
  SequenceForm["i =", 28, " x = ", 191.5466666666669],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243210053*^9},ExpressionUUID->"d65c0a62-4847-49ca-9aca-b50e291fd5f8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "107.42374999999763`"}],
  SequenceForm["i =", 10, " x = ", 107.42374999999763`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.7262432100810003`*^9},ExpressionUUID->"d5013502-1571-4652-a14d-\
b3e429c73300"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "28", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "191.71333333333345`"}],
  SequenceForm["i =", 28, " x = ", 191.71333333333345`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243210086*^9},ExpressionUUID->"c119f872-2acb-40ea-9a13-fdf466ef009b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "106.03249999999842`"}],
  SequenceForm["i =", 10, " x = ", 106.03249999999842`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243210092*^9},ExpressionUUID->"afeea0d2-d2ed-4897-a88f-d1296e3e0867"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "28", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", "191.88`"}],
  SequenceForm["i =", 28, " x = ", 191.88],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243210099*^9},ExpressionUUID->"8d0d2f19-726a-427f-adc7-79af8176a6de"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "29", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", "191.88`"}],
  SequenceForm["i =", 29, " x = ", 191.88],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243210104*^9},ExpressionUUID->"9312a9bc-e705-4e4b-9ef3-93be9c98fced"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "104.6412499999992`"}],
  SequenceForm["i =", 10, " x = ", 104.6412499999992],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243210111*^9},ExpressionUUID->"908b4fe0-18ca-45b3-bd49-0a7511786b0e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "29", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "192.00874999999988`"}],
  SequenceForm["i =", 29, " x = ", 192.00874999999988`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243210116*^9},ExpressionUUID->"81f09e2c-0d3c-49f7-a751-7cbbf27ec334"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "103.249999999974`"}],
  SequenceForm["i =", 9, " x = ", 103.249999999974],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.7262432101219997`*^9},ExpressionUUID->"d8ff15c4-78fa-4561-b4e5-\
757d68f903fc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "103.24999999999368`"}],
  SequenceForm["i =", 10, " x = ", 103.24999999999368`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243210127*^9},ExpressionUUID->"5e834b5f-9a8a-4f28-b2bc-eb9371fa62d7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "29", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "192.13750000000036`"}],
  SequenceForm["i =", 29, " x = ", 192.13750000000036`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243210132*^9},ExpressionUUID->"4a047ac5-fe6a-48b2-98e7-a6c4254095de"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "97.529999999987`"}],
  SequenceForm["i =", 9, " x = ", 97.529999999987],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243210139*^9},ExpressionUUID->"1db4357d-d7f1-4d4a-b281-943edc15a3db"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "29", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "192.26625000000024`"}],
  SequenceForm["i =", 29, " x = ", 192.26625000000024`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243210144*^9},ExpressionUUID->"556c617f-64a2-4f93-ba3e-d8f6a20166b7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", "91.81`"}],
  SequenceForm["i =", 8, " x = ", 91.81],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243210156*^9},ExpressionUUID->"d7eff897-525d-47ef-8ff6-3ce007384e76"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", "91.81`"}],
  SequenceForm["i =", 9, " x = ", 91.81],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.7262432101619997`*^9},ExpressionUUID->"fb2a470c-6451-4644-a77d-\
f69349504b29"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "29", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "192.39500000000015`"}],
  SequenceForm["i =", 29, " x = ", 192.39500000000015`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243210166*^9},ExpressionUUID->"fc113149-620c-421e-b0dc-44819c7b2a4a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "90.5762500000007`"}],
  SequenceForm["i =", 8, " x = ", 90.5762500000007],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243210178*^9},ExpressionUUID->"281da694-be00-4e31-859d-af634c3c536a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "29", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "192.52375000000004`"}],
  SequenceForm["i =", 29, " x = ", 192.52375000000004`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243210183*^9},ExpressionUUID->"8894a40c-54fd-4143-a33f-bd84511f0096"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "89.34250000000141`"}],
  SequenceForm["i =", 8, " x = ", 89.34250000000141],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.7262432101940002`*^9},ExpressionUUID->"f99499c3-4b44-4297-a4bb-\
5e5b7f5d2c7e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "29", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "192.65249999999992`"}],
  SequenceForm["i =", 29, " x = ", 192.65249999999992`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243210199*^9},ExpressionUUID->"0f03b0dc-5a73-4d6f-9047-3ef3aa3bf4e5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "88.10874999999649`"}],
  SequenceForm["i =", 8, " x = ", 88.10874999999649],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243210226*^9},ExpressionUUID->"1db6ce37-7773-40d3-a2a0-13f27afca0a0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "29", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "192.7812500000004`"}],
  SequenceForm["i =", 29, " x = ", 192.7812500000004],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243210231*^9},ExpressionUUID->"a7b024a5-580c-4d8a-a891-4bd7bd9310b6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "86.8749999999972`"}],
  SequenceForm["i =", 8, " x = ", 86.8749999999972],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243210237*^9},ExpressionUUID->"5ad5d645-5b04-44e0-aef8-b9ad9ca63c1a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "29", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "192.91000000000028`"}],
  SequenceForm["i =", 29, " x = ", 192.91000000000028`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243210242*^9},ExpressionUUID->"d4c580e2-922c-4b48-a4f3-6db99f599a64"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "85.6412499999979`"}],
  SequenceForm["i =", 8, " x = ", 85.6412499999979],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.7262432102530003`*^9},ExpressionUUID->"426a74c5-4caf-4532-9cde-\
cb4e50044091"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "29", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "193.0387500000002`"}],
  SequenceForm["i =", 29, " x = ", 193.0387500000002],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243210258*^9},ExpressionUUID->"bc9bda18-681d-407b-82d3-6608b470d388"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "84.40749999999859`"}],
  SequenceForm["i =", 8, " x = ", 84.40749999999859],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243210283*^9},ExpressionUUID->"3ea197a3-f4fa-42e4-a95c-b421a99c353f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "29", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "193.16750000000008`"}],
  SequenceForm["i =", 29, " x = ", 193.16750000000008`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 
   3.726243210289*^9},ExpressionUUID->"66fa81c4-91e6-414c-a046-bb89b2a2eafa"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["sol"], "Input",
 CellChangeTimes->{{3.726232703135*^9, 
  3.726232703691*^9}},ExpressionUUID->"b0351630-f1e5-44ce-8c4d-f20b5435c41e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1220.7`", ",", "0.20000000000004547`", ",", "0.25628762624645407`", ",", 
     "0.23835606060621603`", ",", "0.12280826653273086`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1220.75`", ",", "0.25`", ",", "0.42080868405645194`", ",", 
     "0.3346761363637345`", ",", "0.15529782105209441`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1220.8`", ",", "0.2999999999999545`", ",", "0.6237664505823584`", ",", 
     "0.4401969696969677`", ",", "0.1857966536378973`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1220.8500000000001`", ",", "0.3500000000001364`", ",", 
     "0.8661670551517068`", ",", "0.5549185606065083`", ",", 
     "0.21479989122128673`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1220.9`", ",", "0.40000000000009095`", ",", "0.23045573842759803`", ",", 
     "0.33159090909135214`", ",", "0.06381941351370314`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1220.95`", ",", "0.4500000000000455`", ",", "0.5719256073997381`", ",", 
     "0.5787056818183546`", ",", "0.10821765915015893`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1221.`", ",", "0.5`", ",", "1.0270178526176617`", ",", 
     "0.831504545454496`", ",", "0.15119780622785522`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1221.05`", ",", "0.5499999999999545`", ",", "1.5835091891694923`", ",", 
     "1.0899874999996988`", ",", "0.19287415998317872`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1221.1000000000001`", ",", "0.6000000000001364`", ",", 
     "2.2336852551744975`", ",", "1.3541545454552149`", ",", 
     "0.23334906238362468`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1221.15`", ",", "0.650000000000091`", ",", "2.9721859832561734`", ",", 
     "1.6240056818186013`", ",", "0.27271441732548557`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1221.2`", ",", "0.7000000000000455`", ",", "3.795082970401852`", ",", 
     "1.8995409090910873`", ",", "0.3110529882978776`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1221.25`", ",", "0.75`", ",", "4.699401492562771`", ",", 
     "2.180760227272649`", ",", "0.3484395071507195`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1221.3`", ",", "0.7999999999999545`", ",", "5.68284203031382`", ",", 
     "2.4676636363632722`", ",", "0.38494162528875314`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1221.3500000000001`", ",", "0.8500000000001364`", ",", 
     "6.743604418380759`", ",", "2.7602511363643423`", ",", 
     "0.42062073281254747`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1221.4`", ",", "0.900000000000091`", ",", "7.88027006303327`", ",", 
     "3.0585227272731688`", ",", "0.45553266651016733`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1221.45`", ",", "0.9500000000000455`", ",", "9.09171942705978`", ",", 
     "3.3624784090911213`", ",", "0.48972832390814885`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1221.5`", ",", "1.`", ",", "10.377072141208616`", ",", 
     "3.672118181818074`", ",", "0.5232541976063632`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1221.55`", ",", "1.0499999999999545`", ",", "11.735642280686443`", ",", 
     "3.987442045454195`", ",", "0.5561528417167256`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1221.6000000000001`", ",", "1.1000000000001364`", ",", 
     "13.166904174693991`", ",", "4.308450000000741`", ",", 
     "0.5884632802609586`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1221.65`", ",", "1.150000000000091`", ",", "13.446910274812163`", ",", 
     "4.665187500000656`", ",", "0.5390208288254337`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1221.7`", ",", "1.2000000000000455`", ",", "14.121804762619663`", ",", 
     "5.087700000000365`", ",", "0.5093643010224873`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1221.75`", ",", "1.25`", ",", "16.103952076268772`", ",", 
     "5.547208653846045`", ",", "0.544831731508946`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1221.8`", ",", "1.2999999999999545`", ",", "18.200555780952755`", ",", 
     "6.014934615384078`", ",", "0.5797704159834881`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1221.8500000000001`", ",", "1.3500000000001364`", ",", 
     "20.410991085005055`", ",", "6.49087788461657`", ",", 
     "0.614209350138743`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1221.9`", ",", "1.400000000000091`", ",", "22.734811775279372`", ",", 
     "6.9750384615392065`", ",", "0.6481754476148083`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1221.95`", ",", "1.4500000000000455`", ",", "23.904828405119982`", ",", 
     "7.492341346154113`", ",", "0.62773675026758`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1222.`", ",", "1.5`", ",", "25.40192879335149`", ",", 
     "8.067711538461312`", ",", "0.6153893002696318`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1222.05`", ",", "1.5499999999999545`", ",", "27.210495985785034`", ",", 
     "8.70114903846075`", ",", "0.6091373331857652`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1222.1000000000001`", ",", "1.6000000000001364`", ",", 
     "29.32327814933039`", ",", "9.392653846155481`", ",", 
     "0.6075915787582175`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1222.15`", ",", "1.650000000000091`", ",", "32.520456416244976`", ",", 
     "10.125632211539687`", ",", "0.6339823497428992`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1222.2`", ",", "1.7000000000000455`", ",", "35.91309904546259`", ",", 
     "10.883490384615987`", ",", "0.6602409696970813`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1222.25`", ",", "1.75`", ",", "39.505388562757794`", ",", 
     "11.66622836538453`", ",", "0.68637939617661`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1222.3`", ",", "1.7999999999999545`", ",", "43.30147494750656`", ",", 
     "12.473846153845354`", ",", "0.7124081863512941`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1222.3500000000001`", ",", "1.8500000000001364`", ",", 
     "47.305475613916684`", ",", "13.306343750002267`", ",", 
     "0.7383366961779603`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1222.4`", ",", "1.900000000000091`", ",", "51.52147559119139`", ",", 
     "14.16372115384781`", ",", "0.7641732465197868`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1222.45`", ",", "1.9500000000000455`", ",", "55.95352784906719`", ",", 
     "15.045978365385443`", ",", "0.7899252624408153`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1222.5`", ",", "2.`", ",", "60.60565372811242`", ",", 
     "15.95311538461538`", ",", "0.8155993905949773`"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.726232705207*^9, {3.726233387874*^9, 3.726233413979*^9}, 
   3.7262391205*^9},ExpressionUUID->"2fa70e60-9846-4642-ac40-f8e9a2788810"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"deb1", "=", 
  RowBox[{"ListLinePlot", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"#", "[", 
         RowBox[{"[", "2", "]"}], "]"}], ",", 
        RowBox[{"#", "[", 
         RowBox[{"[", "3", "]"}], "]"}]}], "}"}], "&"}], "/@", "sol"}], ",", 
    RowBox[{"Frame", "\[Rule]", "True"}], ",", 
    RowBox[{"FrameLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<\!\(\*
StyleBox[\"h\",
FontSlant->\"Italic\"]\)\!\(\*
StyleBox[\" \",
FontSlant->\"Italic\"]\)(m)\>\"", ",", "\"\<\!\(\*
StyleBox[\"Q\",
FontSlant->\"Italic\"]\)\!\(\*
StyleBox[\" \",
FontSlant->\"Italic\"]\)(\!\(\*SuperscriptBox[\(m\), \(3\)]\)/s)\>\""}], 
      "}"}]}], ",", 
    RowBox[{"BaseStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"FontFamily", "->", "\"\<Times\>\""}], ",", "14"}], "}"}]}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.726233420135*^9, 3.726233470976*^9}, {3.726233515049*^9,
   3.726233620692*^9}, {3.726239494539*^9, 
  3.726239498554*^9}},ExpressionUUID->"cbd48a7e-b976-414d-9f4f-4b498c9ea6a0"],

Cell[BoxData[
 GraphicsBox[{{}, {{{}, {}, {
      {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
       0.016666666666666666`], AbsoluteThickness[1.6], 
       StyleBox[LineBox[CompressedData["
1:eJwtzQtM01cUBvALVgqFUgOZCbjEQVDcMl3HezI8hw6U0dRVkGKCbG2RyhTk
oSKbDnHYNWK2RDYZNQ0gDuYkWZZlU7NS24mCJKAlbhoeY6yFIZN0RVpGBcb6
X8+X3Nyc5Hy/E6Uuzyn2Z4zJvI/7WZvem36ozdyZzDtoBfZ/rDAt9ZzXOUaA
ieO9eQjdS3GiKbcdWIXGm0eg9TxevHLjKfj6w9BcOjbceHoQmHXAmzFoH61w
JMls5E3A2UNNmdeOOIE1c/t/gEC50yhUeIClcL4dpOk8ZdO4H/r6kyC8+Vtl
UB8fWQl370+IGRs9vnd/KPq8J9CW0zH92kAY+rwZGH/pmXO7cT36vKfAK7tX
ftQTSd4s3K2bqy/WbiTPAYWSXcPubdHkOeFclVYv+jkGGbc+4ITBBFtkZ00s
MgPnz8Ggpa/6WN4r1H8GL0SVlQ5NeucE7t48XJ5qfb1wx6vkucAzW37JECkm
zwWYfLU1Pz6OPDfkBSdeT3o/gbwFKG74vfXF7iTy/oHyk82/tk8nk7cIcz3b
7k9q3iBvEYZsLevsiankeaDLpii4nZNG3nNYUY3KWyRI3hJ8Fe0um3Clk7cM
+pKGxu8sb5G3DHLhFmNTZyZ5K/CDeevDiK93kfcvbP5Lft18+23yVuHBvfx4
4XMpeQzNNT+KPpHtRsataxhGwN3pplo5svucz3B3TPP4Lfse6vvhluQvb6Yo
cpFd4u75Yatjagfv0V7y/FHdIVmNLlKQ548XF+vmpUYpef54WN0b2J3xDnlr
8BfdhMJ0bg95a7CvQf9y/xe55PGw21rkV38njzweLhWl2Z9E7COPh5v5m4xH
JfvIW4sZrmuWrO0F5K3FsLpU8wblu+QF4MybcVezR5TkBeCFx8bLYoOavADs
5y/Pr68+QB4fsytumfJKNOTx8bMZ3aqsqoS8QFw6XO0ovHiIvEBcudOSbfqo
lLxA7BJ43C7tEfKCUHUBrfvzK8gLwhO9hlnVqUryBFgY3jD/ua2KPAG6M8xR
qvxj5AnwwcY0vnPkOHnB+J6yxnCw7AR5wah3WsR/h35AXgjGOjcVfGv+kLwQ
lKVVyTvOnCIvBGs628PCc2vJE2Jjj6T3p6zT5AmxMuvGgW/i6sgLxXCTPV2c
dYa8UIzdmpNYr/mYvFBsG1o+2fVpPXkilG1IHfredJY8EfaHqdRXFrTkrcOx
BUuPLkWH/wHBbPQf
         "]],
        FontFamily->"Times"]}}}}, {}, {}, {{}, {}}, {{}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  BaseStyle->{FontFamily -> "Times", 14},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox[
     "\"\\!\\(\\*\\nStyleBox[\\\"Q\\\",\\nFontSlant->\\\"Italic\\\"]\\)\\!\\(\
\\*\\nStyleBox[\\\" \
\\\",\\nFontSlant->\\\"Italic\\\"]\\)(\\!\\(\\*SuperscriptBox[\\(m\\), \
\\(3\\)]\\)/s)\"", TraditionalForm], None}, {
     FormBox[
     "\"\\!\\(\\*\\nStyleBox[\\\"h\\\",\\nFontSlant->\\\"Italic\\\"]\\)\\!\\(\
\\*\\nStyleBox[\\\" \\\",\\nFontSlant->\\\"Italic\\\"]\\)(m)\"", 
      TraditionalForm], None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 4.}, {0, 743.0662913394294}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.726233465073*^9, 3.726233471862*^9}, 
   3.7262335163380003`*^9, {3.72623355809*^9, 3.726233586823*^9}, {
   3.726233623099*^9, 3.7262336445109997`*^9}, {3.726235927736*^9, 
   3.726235950542*^9}, {3.726239125174*^9, 3.726239144913*^9}, 
   3.7262391952720003`*^9, 
   3.726239499711*^9},ExpressionUUID->"de7a2f2a-6f7e-44d0-ac16-2a91d44ec037"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"interQ", "=", 
  RowBox[{"Interpolation", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"#", "[", 
        RowBox[{"[", "2", "]"}], "]"}], ",", 
       RowBox[{"#", "[", 
        RowBox[{"[", "3", "]"}], "]"}]}], "}"}], "&"}], "/@", "sol"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"interQ", "[", "h", "]"}], "\[Equal]", "200"}], ",", 
   RowBox[{"{", 
    RowBox[{"h", ",", "3"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.726235960135*^9, 3.726235994193*^9}, 
   3.7262392067139997`*^9, 
   3.726243223666*^9},ExpressionUUID->"b236dbe4-a266-4f7d-862f-8869e180c31f"],

Cell[BoxData[
 TagBox[
  TemplateBox[{RowBox[{
      StyleBox[
       TagBox["InterpolatingFunction", "SummaryHead"], 
       "NonInterpretableSummary"], 
      StyleBox["[", "NonInterpretableSummary"], 
      DynamicModuleBox[{Typeset`open$$ = False}, 
       PanelBox[
        PaneSelectorBox[{False -> GridBox[{{
              PaneBox[
               ButtonBox[
                DynamicBox[
                 FEPrivate`FrontEndResource[
                 "FEBitmaps", "SquarePlusIconMedium"]], 
                ButtonFunction :> (Typeset`open$$ = True), Appearance -> None,
                 Evaluator -> Automatic, Method -> "Preemptive"], 
               Alignment -> {Center, Center}, ImageSize -> 
               Dynamic[{
                 Automatic, 3.5 CurrentValue["FontCapHeight"]/
                  AbsoluteCurrentValue[Magnification]}]], 
              GraphicsBox[{{{{}, {}, 
                  TagBox[{
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    LineBox[CompressedData["
1:eJwB0QMu/CFib1JlAgAAADwAAAACAAAAZ6DpI5qZyT9J0LUABWfQP0WwNjG8
w9A/flL78ivP3T8WA986ChDVP1yGqkKZNOo/qdn38G0T2T+7mJPJzEjUP6qD
KGiqAt0/JnXeJtsm4z800N/koqPgPwgRVHM8zfM/daDja3uh4j/3VnEHKN//
PxWqGmgDyuQ/2g8daCe8B0Bsnd3Ed+jmP9HaCLlMSxBApNLY93bi6D8P3ErG
E+8UQDxBB6AlB+s/ZuC22t6AGkC18W0eXwftPzZRvegOGSBA5Ytg/YT97j9A
n/JeYB0jQLovwygtj/A/iA8XDGyjJkByOvI9XY3xP4FOWAoDNCpA2uG6DeWg
8j9f73OAdh4rQB1+yQ1jr/M/WpRMvud8LkBRO/R4pqv0P9iBSe972jFANZW4
nkG99T8Em2kN1Nc0QAoQmS+ivPY/0c3RBFhIN0COJxN7WtH3PxjHW8FxCDlA
7TPT9gjh+D8jyM1lmmQ7QD1hr9183vk/ug5tuWVSPkA9KyV/SPH6Pyr2jOtX
ZkFALha3i9nx+z8c99BNFqBDQPr1jshg7fw/ve/xZ1L2RUB2cgDAP/79PwK8
pUjjrEhA4g+OIuT8/j++yn8R5GBLQP+k2h9wCABAvg5iwpiDTkB7PJFG6Y8A
QASnk8TEDVFAb+TVIkUOAUApDs94E89SQLtaZ9xMlwFArVeTNkDNVEB/4YZL
NxcCQA60RKO9m1RAsWLJ0pyUAkCZe/7uBf9LQDuyWDeuHANAl00YrogbUUA9
EnZRopsDQJzzmDKLn1NAl0DgSEIlBECpgci4zLhWQGl/2PXEpQRAmPHdUHUj
WECpuPO6wiMFQCKo2tE9tFpAQcBbXWysBUDcZfHBSvleQFHYUbX4KwZAN48M
S5CYYUC5vpTqMLYGQJpnfgNgC2RAj5/6N+Q9B0AGacJTs51mQN2Q7jp6vAdA
HlNrTQUuaUCDUC8bvEUIQK00s6fQ4mtAoSD+sODFCEBIBRCexWFuQC3r716A
QwlAm4IJFKSDcEARhC7qy8sJQFAfCw73JnJAbS37KvpKCkCHD604GvJzQCGl
FEnU1ApANKAXYfT5dUBDF1F/KVwLQFDlpuObEnhA3Zkba2HaC0BNtWYHzh56
QM/qMjRFYwxAXBnIxqdzfEA5TNiyC+MMQOLFGMszkn5A+3vKDn5tDUA32RzG
Hdd/QCum34Jr9Q1A1/fL6vMogUDT4IKsO3QOQEtEVT3ejYJA0+lys7f9DkDg
ZgJozB2EQEsD8W8Wfg9AM98gZa6hhUD6/1r3//8PQPBpM6iHOIdAChm+nQ==

                    "]]}, 
                   Annotation[#, 
                    "Charting`Private`Tag$37093#1"]& ]}}, {}, {}}, {
               DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
                AxesOrigin -> {0, 0}, FrameTicks -> {{{}, {}}, {{}, {}}}, 
                GridLines -> {None, None}, DisplayFunction -> Identity, 
                PlotRangePadding -> {{
                   Scaled[0.1], 
                   Scaled[0.1]}, {
                   Scaled[0.1], 
                   Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                All, DisplayFunction -> Identity, AspectRatio -> 1, 
                Axes -> {False, False}, AxesLabel -> {None, None}, 
                AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
                Frame -> {{True, True}, {True, True}}, 
                FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                Directive[
                  Opacity[0.5], 
                  Thickness[Tiny], 
                  RGBColor[0.368417, 0.506779, 0.709798]], 
                FrameTicks -> {{None, None}, {None, None}}, 
                GridLines -> {None, None}, GridLinesStyle -> Directive[
                  GrayLevel[0.5, 0.4]], ImageSize -> 
                Dynamic[{
                  Automatic, 3.5 CurrentValue["FontCapHeight"]/
                   AbsoluteCurrentValue[Magnification]}], 
                Method -> {
                 "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
                  AbsolutePointSize[6], "ScalingFunctions" -> None, 
                  "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                    (Identity[#]& )[
                    Part[#, 1]], 
                    (Identity[#]& )[
                    Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                    (Identity[#]& )[
                    Part[#, 1]], 
                    (Identity[#]& )[
                    Part[#, 2]]}& )}}, 
                PlotRange -> {{0.20000000000004547`, 4.}, {0., 
                 743.0662387863831}}, PlotRangeClipping -> True, 
                PlotRangePadding -> {{
                   Scaled[0.1], 
                   Scaled[0.1]}, {
                   Scaled[0.1], 
                   Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
              GridBox[{{
                 RowBox[{
                   TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"0.20000000000004547`", ",", "4.`"}], "}"}], 
                    "}"}], "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["\"scalar\"", "SummaryItem"]}]}}, 
               GridBoxAlignment -> {
                "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, AutoDelete -> 
               False, GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
               GridBoxSpacings -> {
                "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
               BaseStyle -> {
                ShowStringCharacters -> False, NumberMarks -> False, 
                 PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
            GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> False, 
            GridBoxItemSize -> {
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
            BaselinePosition -> {1, 1}], True -> GridBox[{{
              PaneBox[
               ButtonBox[
                DynamicBox[
                 FEPrivate`FrontEndResource[
                 "FEBitmaps", "SquareMinusIconMedium"]], 
                ButtonFunction :> (Typeset`open$$ = False), Appearance -> 
                None, Evaluator -> Automatic, Method -> "Preemptive"], 
               Alignment -> {Center, Center}, ImageSize -> 
               Dynamic[{
                 Automatic, 3.5 CurrentValue["FontCapHeight"]/
                  AbsoluteCurrentValue[Magnification]}]], 
              GraphicsBox[{{{{}, {}, 
                  TagBox[{
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    LineBox[CompressedData["
1:eJwB0QMu/CFib1JlAgAAADwAAAACAAAAZ6DpI5qZyT9J0LUABWfQP0WwNjG8
w9A/flL78ivP3T8WA986ChDVP1yGqkKZNOo/qdn38G0T2T+7mJPJzEjUP6qD
KGiqAt0/JnXeJtsm4z800N/koqPgPwgRVHM8zfM/daDja3uh4j/3VnEHKN//
PxWqGmgDyuQ/2g8daCe8B0Bsnd3Ed+jmP9HaCLlMSxBApNLY93bi6D8P3ErG
E+8UQDxBB6AlB+s/ZuC22t6AGkC18W0eXwftPzZRvegOGSBA5Ytg/YT97j9A
n/JeYB0jQLovwygtj/A/iA8XDGyjJkByOvI9XY3xP4FOWAoDNCpA2uG6DeWg
8j9f73OAdh4rQB1+yQ1jr/M/WpRMvud8LkBRO/R4pqv0P9iBSe972jFANZW4
nkG99T8Em2kN1Nc0QAoQmS+ivPY/0c3RBFhIN0COJxN7WtH3PxjHW8FxCDlA
7TPT9gjh+D8jyM1lmmQ7QD1hr9183vk/ug5tuWVSPkA9KyV/SPH6Pyr2jOtX
ZkFALha3i9nx+z8c99BNFqBDQPr1jshg7fw/ve/xZ1L2RUB2cgDAP/79PwK8
pUjjrEhA4g+OIuT8/j++yn8R5GBLQP+k2h9wCABAvg5iwpiDTkB7PJFG6Y8A
QASnk8TEDVFAb+TVIkUOAUApDs94E89SQLtaZ9xMlwFArVeTNkDNVEB/4YZL
NxcCQA60RKO9m1RAsWLJ0pyUAkCZe/7uBf9LQDuyWDeuHANAl00YrogbUUA9
EnZRopsDQJzzmDKLn1NAl0DgSEIlBECpgci4zLhWQGl/2PXEpQRAmPHdUHUj
WECpuPO6wiMFQCKo2tE9tFpAQcBbXWysBUDcZfHBSvleQFHYUbX4KwZAN48M
S5CYYUC5vpTqMLYGQJpnfgNgC2RAj5/6N+Q9B0AGacJTs51mQN2Q7jp6vAdA
HlNrTQUuaUCDUC8bvEUIQK00s6fQ4mtAoSD+sODFCEBIBRCexWFuQC3r716A
QwlAm4IJFKSDcEARhC7qy8sJQFAfCw73JnJAbS37KvpKCkCHD604GvJzQCGl
FEnU1ApANKAXYfT5dUBDF1F/KVwLQFDlpuObEnhA3Zkba2HaC0BNtWYHzh56
QM/qMjRFYwxAXBnIxqdzfEA5TNiyC+MMQOLFGMszkn5A+3vKDn5tDUA32RzG
Hdd/QCum34Jr9Q1A1/fL6vMogUDT4IKsO3QOQEtEVT3ejYJA0+lys7f9DkDg
ZgJozB2EQEsD8W8Wfg9AM98gZa6hhUD6/1r3//8PQPBpM6iHOIdAChm+nQ==

                    "]]}, 
                   Annotation[#, 
                    "Charting`Private`Tag$37093#1"]& ]}}, {}, {}}, {
               DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
                AxesOrigin -> {0, 0}, FrameTicks -> {{{}, {}}, {{}, {}}}, 
                GridLines -> {None, None}, DisplayFunction -> Identity, 
                PlotRangePadding -> {{
                   Scaled[0.1], 
                   Scaled[0.1]}, {
                   Scaled[0.1], 
                   Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                All, DisplayFunction -> Identity, AspectRatio -> 1, 
                Axes -> {False, False}, AxesLabel -> {None, None}, 
                AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
                Frame -> {{True, True}, {True, True}}, 
                FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                Directive[
                  Opacity[0.5], 
                  Thickness[Tiny], 
                  RGBColor[0.368417, 0.506779, 0.709798]], 
                FrameTicks -> {{None, None}, {None, None}}, 
                GridLines -> {None, None}, GridLinesStyle -> Directive[
                  GrayLevel[0.5, 0.4]], ImageSize -> 
                Dynamic[{
                  Automatic, 3.5 CurrentValue["FontCapHeight"]/
                   AbsoluteCurrentValue[Magnification]}], 
                Method -> {
                 "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
                  AbsolutePointSize[6], "ScalingFunctions" -> None, 
                  "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                    (Identity[#]& )[
                    Part[#, 1]], 
                    (Identity[#]& )[
                    Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                    (Identity[#]& )[
                    Part[#, 1]], 
                    (Identity[#]& )[
                    Part[#, 2]]}& )}}, 
                PlotRange -> {{0.20000000000004547`, 4.}, {0., 
                 743.0662387863831}}, PlotRangeClipping -> True, 
                PlotRangePadding -> {{
                   Scaled[0.1], 
                   Scaled[0.1]}, {
                   Scaled[0.1], 
                   Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
              GridBox[{{
                 RowBox[{
                   TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"0.20000000000004547`", ",", "4.`"}], "}"}], 
                    "}"}], "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["\"scalar\"", "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Order: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["3", "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Method: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["\"Hermite\"", "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Periodic: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["False", "SummaryItem"]}]}}, 
               GridBoxAlignment -> {
                "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, AutoDelete -> 
               False, GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
               GridBoxSpacings -> {
                "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
               BaseStyle -> {
                ShowStringCharacters -> False, NumberMarks -> False, 
                 PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
            GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> False, 
            GridBoxItemSize -> {
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
            BaselinePosition -> {1, 1}]}, 
         Dynamic[Typeset`open$$], ImageSize -> Automatic], BaselinePosition -> 
        Baseline], DynamicModuleValues :> {}], 
      StyleBox["]", "NonInterpretableSummary"]}]},
   "CopyTag",
   DisplayFunction->(#& ),
   InterpretationFunction->("InterpolatingFunction[{{0.2, 4.}}, <>]"& )],
  False,
  Editable->False,
  SelectWithContents->True,
  Selectable->False]], "Output",
 CellChangeTimes->{3.726235995255*^9, 3.726239207005*^9, 
  3.726243225663*^9},ExpressionUUID->"bcfa82fc-f658-45fb-ad7b-90a7e74f0ad1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"h", "\[Rule]", "2.9628630756830674`"}], "}"}]], "Output",
 CellChangeTimes->{3.726235995255*^9, 3.726239207005*^9, 
  3.7262432256730003`*^9},ExpressionUUID->"c9394aae-32ed-4151-bfaf-\
7bb56ae650b6"]
}, Open  ]],

Cell[BoxData[" "], "Input",
 CellChangeTimes->{{3.726236029142*^9, 3.72623603277*^9}, 
   3.7262360919820004`*^9},ExpressionUUID->"eafa4467-443a-46fe-ba5b-\
cdc4f1516938"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{
   RowBox[{"alt", "=", 
    RowBox[{"zmin", "+", "2.96"}]}], "\[IndentingNewLine]", " ", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ival", "=", 
     RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"xval", "=", 
     RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Do", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"profil", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "2"}], "]"}], "]"}], "\[LessEqual]", "alt", "<=", 
          RowBox[{"profil", "[", 
           RowBox[{"[", 
            RowBox[{
             RowBox[{"i", "+", "1"}], ",", "2"}], "]"}], "]"}]}], "||", 
         RowBox[{
          RowBox[{"profil", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "2"}], "]"}], "]"}], "\[GreaterEqual]", " ", 
          "alt", "\[GreaterEqual]", 
          RowBox[{"profil", "[", 
           RowBox[{"[", 
            RowBox[{
             RowBox[{"i", "+", "1"}], ",", "2"}], "]"}], "]"}]}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"AppendTo", "[", 
          RowBox[{"ival", ",", "i"}], "]"}], ";", "\[IndentingNewLine]", 
         RowBox[{"interp", "=", 
          RowBox[{"Interpolation", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"profil", "[", 
               RowBox[{"[", "i", "  ", "]"}], "]"}], ",", 
              RowBox[{"profil", "[", 
               RowBox[{"[", 
                RowBox[{"i", "+", "1"}], " ", "]"}], "]"}]}], "}"}], ",", 
            RowBox[{"InterpolationOrder", "\[Rule]", "1"}]}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"xc", "=", 
          RowBox[{"x", "/.", 
           RowBox[{
            RowBox[{"FindRoot", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"interp", "[", "x", "]"}], "\[Equal]", "alt"}], ",", 
              RowBox[{"{", 
               RowBox[{"x", ",", 
                RowBox[{"profil", "[", 
                 RowBox[{"[", 
                  RowBox[{
                   RowBox[{"i", "+", "1"}], ",", "1"}], "]"}], "]"}]}], 
               "}"}]}], "]"}], "[", 
            RowBox[{"[", "1", "]"}], "]"}]}]}], ";", 
         RowBox[{"Print", "[", 
          RowBox[{"\"\<i =\>\"", ",", "i", ",", "\"\< x = \>\"", ",", "xc"}], 
          "]"}], ";", 
         RowBox[{"AppendTo", "[", 
          RowBox[{"xval", ",", "xc"}], "]"}], ";"}]}], "\[IndentingNewLine]", 
       "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", 
        RowBox[{"n", "-", "1"}]}], "}"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"il", ",", "ir"}], "}"}], "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"First", "@", "ival"}], ",", 
       RowBox[{"Last", "@", "ival"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"xl", ",", "xr"}], "}"}], "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"First", "@", "xval"}], ",", 
       RowBox[{"Last", "@", "xval"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"set", "=", 
     RowBox[{"Join", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"xl", ",", "alt"}], "}"}], "}"}], ",", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"profil", "[", 
          RowBox[{"[", "i", "]"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", 
           RowBox[{"il", "+", "1"}], ",", "ir"}], "}"}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"xr", ",", "alt"}], "}"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[Chi]", "=", 
     RowBox[{"ArcLength", "@", 
      RowBox[{"Line", "[", "set", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"S", "=", 
     RowBox[{"NIntegrate", "[", 
      RowBox[{
       RowBox[{"alt", " ", "-", 
        RowBox[{"profilInterp", "[", "x", "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "xl", ",", "xr"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Rh", "=", 
     RowBox[{"S", "/", "\[Chi]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"Q", "=", 
    RowBox[{"S", " ", 
     RowBox[{"Rh", "^", 
      RowBox[{"(", 
       RowBox[{"2", "/", "3"}], ")"}]}], " ", 
     RowBox[{"Sqrt", "[", "pente", "]"}], " ", "K"}]}], "\[IndentingNewLine]",
    " "}]}]], "Input",
 CellChangeTimes->{{3.726236096017*^9, 3.726236139051*^9}, {3.726239212269*^9,
   3.726239247734*^9}, {3.7262432308129997`*^9, 
  3.726243231465*^9}},ExpressionUUID->"7d4995c6-7f7e-40f8-b8ce-de910d6cc688"],

Cell[BoxData["1223.46`"], "Output",
 CellChangeTimes->{{3.726236135211*^9, 3.7262361397939997`*^9}, {
   3.726239214106*^9, 3.726239247984*^9}, 
   3.726243232361*^9},ExpressionUUID->"9da59003-01b5-41b5-9720-a38d9edce166"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "12", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "126.24599999999873`"}],
  SequenceForm["i =", 12, " x = ", 126.24599999999873`],
  Editable->False]], "Print",
 CellChangeTimes->{{3.726236135215*^9, 3.726236139803*^9}, {3.726239214113*^9,
    3.726239247988*^9}, 
   3.726243232367*^9},ExpressionUUID->"db22449a-7d3f-4130-84cd-fd10a8246349"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "28", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "190.07999999999984`"}],
  SequenceForm["i =", 28, " x = ", 190.07999999999984`],
  Editable->False]], "Print",
 CellChangeTimes->{{3.726236135215*^9, 3.726236139803*^9}, {3.726239214113*^9,
    3.726239247988*^9}, 
   3.7262432323710003`*^9},ExpressionUUID->"862b685c-b1f8-4dc8-9c3c-\
8ad9d9322722"]
}, Open  ]],

Cell[BoxData["198.9280697343001`"], "Output",
 CellChangeTimes->{{3.726236135211*^9, 3.7262361397939997`*^9}, {
   3.726239214106*^9, 3.726239247984*^9}, 
   3.726243232384*^9},ExpressionUUID->"83bbe145-c7a4-4df2-8029-3befb133c51d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"des1", "=", 
  RowBox[{"Show", "[", 
   RowBox[{
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"profilInterp", "[", "x", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "xl", ",", "xr"}], "}"}]}], "]"}], ",", 
    RowBox[{"Plot", "[", 
     RowBox[{"alt", ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "xl", ",", "xr"}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", "Dashed"}]}], " ", "]"}], " ", ",", 
    RowBox[{"Frame", "\[Rule]", "True"}], ",", 
    RowBox[{"FrameLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<\!\(\*
StyleBox[\"x\",
FontSlant->\"Italic\"]\)\!\(\*
StyleBox[\" \",
FontSlant->\"Italic\"]\)(m)\>\"", ",", "\"\<\!\(\*
StyleBox[\"z\",
FontSlant->\"Italic\"]\)\!\(\*
StyleBox[\" \",
FontSlant->\"Italic\"]\)(m)\>\""}], "}"}]}], ",", 
    RowBox[{"BaseStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"FontFamily", "->", "\"\<Times\>\""}], ",", "14"}], "}"}]}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.7262361432539997`*^9, 3.726236190376*^9}, {
  3.7262389987869997`*^9, 3.726239033442*^9}, {3.7262392680439997`*^9, 
  3.726239281119*^9}, {3.7262394803380003`*^9, 
  3.7262394844560003`*^9}},ExpressionUUID->"7e5b17a0-09cb-4fcc-90fc-\
7eabb9e69ffc"],

Cell[BoxData[
 GraphicsBox[{{{{{}, {}, 
      TagBox[{
        {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
         Opacity[1.], LineBox[CompressedData["
1:eJxN2nc4Vu//AHBklJQRDZKRNGgYiQZvSkoilBV5eM45Dx+FZJSMykyhIklm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          "]]}},
       Annotation[#, "Charting`Private`Tag$37202#1"]& ]}}, {}, {}}, {{{{}, {}, 
      TagBox[{
        {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
         Opacity[1.], Dashing[{Small, Small}], LineBox[CompressedData["
1:eJxTTMoPSmViYGAwAWIQfafBvmZff7zDkgJbruuykx0+/O+9dW07gs9Sf8fi
/X0E/+a2SzH50glw/vbVaZtYXRB8NvczZheyEfzpt9xlf01D8De8/jTDaT+C
z/N1c9mrVwj+jSVuzcdEE+F8nUscqgdtEfxD3x9oSGci+A9mvTg4eSKCn//k
YKfDTgTfQW3jZp8nCP7Mp+eLynmS4HyTuSxTGC0QfIffXE/2JyH4V645nJzT
heCvWtUjcHMrgs/xh/2t8T0Ef4XrTO13nMlw/k7TPzPumCD4QYv7Zr+MQfB1
Oc0ZwjoQ/Alv+H492IDgJ5ftUFpwA8Gv/FG+dh9zCpwv9iPt7G9tBP/b+2z/
GeEIvnufE0NmE4Ivv8rDLWIVgm+1L+XdsqsI/h3/Ddoi/xD89+1np29VTYXz
XXYwpG0LQPAV05JPXq1A8B157vSFLEHwX+i3vPx4BsFn+PW36PAXBD9qT2/c
F/k0ON/mj899Zw8EP9FE6dCnYgT/m9DJy1fnIfjC+fOrrh9D8IsOdzdbfELw
I6cuV9whlQ7nb+Sd+i7bCcH3rpshW5+L4OfmnH64YSqCf612jqzCGgTfvj83
sv8Qgg8ArTBslw==
          "]]}},
       Annotation[#, "Charting`Private`Tag$37243#1"]& ]}}, {}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{126.24599999999873`, 1220.5006137644834`},
  BaseStyle->{FontFamily -> "Times", 14},
  DisplayFunction->Identity,
  Frame->True,
  FrameLabel->{
    FormBox[
    "\"\\!\\(\\*\\nStyleBox[\\\"x\\\",\\nFontSlant->\\\"Italic\\\"]\\)\\!\\(\\\
*\\nStyleBox[\\\" \\\",\\nFontSlant->\\\"Italic\\\"]\\)(m)\"", 
     TraditionalForm], 
    FormBox[
    "\"\\!\\(\\*\\nStyleBox[\\\"z\\\",\\nFontSlant->\\\"Italic\\\"]\\)\\!\\(\\\
*\\nStyleBox[\\\" \\\",\\nFontSlant->\\\"Italic\\\"]\\)(m)\"", 
     TraditionalForm]},
  FrameTicks->FrontEndValueCache[{{Automatic, 
      Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
      Charting`ScaledFrameTicks[{Identity, Identity}]}}, {{
     Automatic, {{1220.5, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.01, 
        0.}, {
         AbsoluteThickness[0.1]}}, {1221., 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.01, 
        0.}, {
         AbsoluteThickness[0.1]}}, {1221.5, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.01, 
        0.}, {
         AbsoluteThickness[0.1]}}, {1222., 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.01, 
        0.}, {
         AbsoluteThickness[0.1]}}, {1222.5, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.01, 
        0.}, {
         AbsoluteThickness[0.1]}}, {1223., 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.01, 
        0.}, {
         AbsoluteThickness[0.1]}}, {1223.5, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.01, 
        0.}, {
         AbsoluteThickness[0.1]}}, {1220., 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {1220.1, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {1220.2, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {1220.3, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {1220.4, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {1220.6, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {1220.7, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {1220.8, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {1220.9, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {1221.1, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {1221.2, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {1221.3, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {1221.4, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {1221.6, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {1221.7, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {1221.8, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {1221.9, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {1222.1, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {1222.2, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {1222.3, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {1222.4, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {1222.6, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {1222.7, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {1222.8, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {1222.9, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {1223.1, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {1223.2, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {1223.3, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {1223.4, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {1223.6, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {1223.7, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {1223.8, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {1223.9, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {1224., 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}}}, {Automatic, {{130., 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.01, 
        0.}, {
         AbsoluteThickness[0.1]}}, {140., 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.01, 
        0.}, {
         AbsoluteThickness[0.1]}}, {150., 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.01, 
        0.}, {
         AbsoluteThickness[0.1]}}, {160., 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.01, 
        0.}, {
         AbsoluteThickness[0.1]}}, {170., 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.01, 
        0.}, {
         AbsoluteThickness[0.1]}}, {180., 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.01, 
        0.}, {
         AbsoluteThickness[0.1]}}, {190., 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.01, 
        0.}, {
         AbsoluteThickness[0.1]}}, {120., 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {122., 
        FormBox[
         InterpretationBox[
          StyleBox[
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {124., 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {126., 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {128., 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {132., 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {134., 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {136., 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {138., 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {142., 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {144., 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {146., 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {148., 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {152., 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {154., 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {156., 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {158., 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {162., 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {164., 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {166., 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {168., 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {172., 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {174., 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {176., 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {178., 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {182., 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {184., 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {186., 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {188., 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {192., 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {194., 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {196., 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {198., 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {200., 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}}}}],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{126.24599999999873`, 190.07999999999984`}, {
   1220.5006137644834`, 1223.4599999537218`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.726239034332*^9, 3.7262392514110003`*^9, 
  3.72623928192*^9, 3.72623948565*^9, 
  3.726243235837*^9},ExpressionUUID->"796c44fa-f225-4dfd-8cac-220d527c521e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"14", "*", 
  RowBox[{
  "1.5", "/", 
   "2"}]}], "\[IndentingNewLine]", "S", "\[IndentingNewLine]", "Rh"}], "Input",
 CellChangeTimes->{{3.726236222825*^9, 
  3.7262362778780003`*^9}},ExpressionUUID->"a088065c-b676-4470-8cdf-\
6147cf5c2f7f"],

Cell[BoxData["10.5`"], "Output",
 CellChangeTimes->{{3.726236254389*^9, 
  3.726236279014*^9}},ExpressionUUID->"e552464f-5a10-4e02-a62d-74c8a8da68b2"],

Cell[BoxData["9.392653846152372`"], "Output",
 CellChangeTimes->{{3.726236254389*^9, 
  3.726236279025*^9}},ExpressionUUID->"a154774d-d738-456b-b652-d4fdb209504c"],

Cell[BoxData["15.458828223640888`"], "Output",
 CellChangeTimes->{{3.726236254389*^9, 
  3.7262362790290003`*^9}},ExpressionUUID->"7e2744d3-41d4-43a0-afc1-\
3d40e2fc86ad"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Export", "[", 
  RowBox[{"\"\<section1.eps\>\"", ",", "des1", ",", "\"\<EPS\>\""}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Export", "[", 
  RowBox[{"\"\<debitance1.eps\>\"", ",", "deb1", ",", "\"\<EPS\>\""}], 
  "]"}], "\[IndentingNewLine]", "pente", "\[IndentingNewLine]", 
 RowBox[{"alt", "-", "zmin"}], "\[IndentingNewLine]", "alt"}], "Input",
 CellChangeTimes->{{3.726239511822*^9, 3.726239544264*^9}, {3.726240284528*^9,
   3.726240313686*^9}, {3.726240349039*^9, 
  3.7262403552390003`*^9}},ExpressionUUID->"374fbf02-6f1e-4e78-91de-\
d8bd5c6160e3"],

Cell[BoxData["\<\"section1.eps\"\>"], "Output",
 CellChangeTimes->{
  3.726239546244*^9, {3.726240286729*^9, 3.7262403149449997`*^9}, 
   3.726240356417*^9, 
   3.726243266512*^9},ExpressionUUID->"c060358a-d1ec-44f6-84d1-d90010755f69"],

Cell[BoxData["\<\"debitance1.eps\"\>"], "Output",
 CellChangeTimes->{
  3.726239546244*^9, {3.726240286729*^9, 3.7262403149449997`*^9}, 
   3.726240356417*^9, 
   3.726243266763*^9},ExpressionUUID->"e0530e80-6380-47b2-8ce3-914eabe92236"],

Cell[BoxData["0.030303030303030304`"], "Output",
 CellChangeTimes->{
  3.726239546244*^9, {3.726240286729*^9, 3.7262403149449997`*^9}, 
   3.726240356417*^9, 
   3.726243266767*^9},ExpressionUUID->"5f1952c9-2108-4fe2-92fd-e2ed241c3a7f"],

Cell[BoxData["2.9600000000000364`"], "Output",
 CellChangeTimes->{
  3.726239546244*^9, {3.726240286729*^9, 3.7262403149449997`*^9}, 
   3.726240356417*^9, 
   3.726243266771*^9},ExpressionUUID->"3eb7e5d2-a993-4327-8211-bc5780389d42"],

Cell[BoxData["1223.46`"], "Output",
 CellChangeTimes->{
  3.726239546244*^9, {3.726240286729*^9, 3.7262403149449997`*^9}, 
   3.726240356417*^9, 
   3.726243266774*^9},ExpressionUUID->"a0952b81-f71a-4154-a459-310e0146adfd"]
}, Open  ]],

Cell[BoxData["1"], "Input",
 CellChangeTimes->{
  3.726239864301*^9},ExpressionUUID->"d5ebeb36-8d64-455f-b42f-644d2e3aee9e"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Profil 2", "Section",
 CellChangeTimes->{{3.726232366929*^9, 3.726232384227*^9}, 
   3.7262407036289997`*^9},ExpressionUUID->"279f9e42-36f7-4bc8-a404-\
5f4c172cd657"],

Cell[CellGroupData[{

Cell["lecture", "Subsection",
 CellChangeTimes->{{3.726232366929*^9, 3.726232384227*^9}, {3.726232447131*^9,
   3.726232449347*^9}},ExpressionUUID->"aeb9dc0a-c365-4106-9acc-884b7708610e"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"profil", "=", 
  RowBox[{"ToExpression", "@", 
   RowBox[{"ReadList", "[", 
    RowBox[{"\"\<profil_2.txt\>\"", ",", "Word", ",", 
     RowBox[{"RecordLists", "\[Rule]", "True"}], ",", 
     RowBox[{"WordSeparators", "\[Rule]", "\"\<,\>\""}]}], 
    "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{"ListLinePlot", "[", 
  RowBox[{"profil", ",", 
   RowBox[{"AspectRatio", "\[Rule]", "1"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"n", "=", 
  RowBox[{"Length", "[", "profil", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"profilInterp", "=", 
  RowBox[{"Interpolation", "[", 
   RowBox[{"profil", ",", 
    RowBox[{"InterpolationOrder", "\[Rule]", "1"}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"zmin", "=", 
  RowBox[{"Min", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"#", "[", 
      RowBox[{"[", "2", "]"}], "]"}], "&"}], "/@", "profil"}], 
   "]"}]}]}], "Input",
 CellChangeTimes->{{3.7262252160959997`*^9, 3.7262252218710003`*^9}, {
   3.726225308633*^9, 3.72622531775*^9}, {3.7262259504639997`*^9, 
   3.726225965406*^9}, {3.726232362781*^9, 3.726232363865*^9}, {
   3.726232403023*^9, 3.726232429034*^9}, 
   3.726240709807*^9},ExpressionUUID->"a00d45dd-99e7-449d-ae05-7082d6009a9d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.`", ",", "1152.76`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5.88`", ",", "1149.16`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"11.44`", ",", "1146.06`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"16.69`", ",", "1141.36`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"19.44`", ",", "1138.96`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"22.38`", ",", "1136.36`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"23.75`", ",", "1135.76`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"25.31`", ",", "1135.56`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"30.5`", ",", "1135.56`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"34.56`", ",", "1136.56`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"38.56`", ",", "1137.26`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"43.62`", ",", "1141.36`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"47.19`", ",", "1142.96`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"50.`", ",", "1143.06`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"53.81`", ",", "1142.76`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"56.38`", ",", "1143.26`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"58.56`", ",", "1144.06`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"61.56`", ",", "1144.96`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"64.62`", ",", "1145.56`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"67.5`", ",", "1145.96`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"70.31`", ",", "1146.26`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"73.56`", ",", "1146.56`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"76.75`", ",", "1146.86`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"80.31`", ",", "1147.46`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"83.56`", ",", "1147.76`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"89.69`", ",", "1148.26`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"94.12`", ",", "1148.56`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"97.56`", ",", "1148.66`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"104.31`", ",", "1149.06`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"112.`", ",", "1149.46`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"116.06`", ",", "1149.86`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"122.62`", ",", "1150.16`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"126.81`", ",", "1150.06`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"131.44`", ",", "1149.86`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"132.38`", ",", "1149.56`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"133.88`", ",", "1150.36`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"135.69`", ",", "1150.36`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"139.69`", ",", "1150.66`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"144.25`", ",", "1150.86`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"148.88`", ",", "1150.96`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"153.5`", ",", "1151.06`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"158.06`", ",", "1151.66`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"163.25`", ",", "1151.76`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"167.75`", ",", "1152.16`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"176.44`", ",", "1153.36`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"184.75`", ",", "1154.56`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"191.25`", ",", "1155.46`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"199.25`", ",", "1156.66`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"210.56`", ",", "1157.96`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"217.5`", ",", "1158.76`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"226.88`", ",", "1159.86`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"233.19`", ",", "1160.26`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"235.38`", ",", "1159.56`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"239.19`", ",", "1159.56`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"243.12`", ",", "1159.46`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"246.5`", ",", "1159.36`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"250.56`", ",", "1159.36`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"251.56`", ",", "1159.16`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"257.38`", ",", "1162.46`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"262.56`", ",", "1162.66`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"267.31`", ",", "1162.76`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"272.75`", ",", "1162.36`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"274.5`", ",", "1161.06`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"276.81`", ",", "1162.86`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"278.81`", ",", "1163.36`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"281.31`", ",", "1163.96`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"283.56`", ",", "1164.16`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"285.88`", ",", "1164.66`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"288.56`", ",", "1164.86`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"290.62`", ",", "1165.06`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"292.81`", ",", "1165.36`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"295.`", ",", "1165.66`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"297.`", ",", "1165.86`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"298.44`", ",", "1166.06`"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.726225222749*^9, {3.726225313972*^9, 3.726225318549*^9}, 
   3.726225966208*^9, {3.7262323876540003`*^9, 3.726232430127*^9}, 
   3.726232721483*^9, 3.726232768483*^9, 3.72623296151*^9, 3.726233207597*^9, 
   3.7262332696619997`*^9, 3.726235891734*^9, 3.7262407101029997`*^9, 
   3.726243285415*^9},ExpressionUUID->"52d61124-8a6d-4155-b977-81e5ef7ac420"],

Cell[BoxData[
 GraphicsBox[{{}, {{{}, {}, {
      {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
       0.016666666666666666`], AbsoluteThickness[1.6], LineBox[CompressedData["
1:eJxdkztIW2EcxS+VgoS2g0otWBWhqFFKQ7U+BuUTEav4SpQqJVpNfIQ2Jvdm
cHBykS6CvbcdHNwsuBVBBwdpVSgODnYpGXygCL5CEcVnFfXenPNFNBA+fvf8
zzn/L5dkeIKurgeKolSbX+uUn/CYWmKLM8RgxDmdNpgstBJbeOxIFxv9ST8q
NzKFzRrY0fF8wiGsQ/1LVvPEd9MeXuR8RwH0OV1Ew2cLRTT/ly6G54+z3fXF
yPtJfaA0xm+jAWXgecnl8P+mf6ki1m8uG3GOVKJ/mXlKFfwr9G9Xw7/MfR01
4FWZX4v5dfJCHfI2yVkN0LeYv94AfVvH+dWJvF2y14X5Pc47GrFvhHpiE85/
5M0m+Pd14bYu6H8HPmD/52bkHcr8FtxDcuJ76Efy/m48P6Ye14r+U+aNt8F/
Rn3yA/wmmy+7PynQHpuP7jPUDv2EPEP9nPMn97ivA/n/uU+8B/oF/aMe9F7I
38eL/EtduKwXOueF/4q6rxO/xzX5rBO6YqDvSTfyHxrQn/Ugz0be6UHfY8k+
+BMM9Dk/Qk+m7viEvhQD+7r9yE9nX2Yv9Azq/l70pVHfumW8rwDOVOb/CSAv
VfYH77IWxH7PmfdUhd9uCLtV6FOh55CnVOyTy/xHGvLs5GwN+7zgfA31XLKf
/JL8TUPfK/K0xv8N91kjv6YeH4I/j/vbQ+jLl33U33AfNQR/AfkL9UID9xin
v8gQNxdX3xw=
        "]]}}}}, {}, {}, {{}, {}}, {{}, {}}},
  AspectRatio->1,
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 1134.035},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->{941., Automatic},
  Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 298.44}, {1135.56, 1166.06}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.726225222749*^9, {3.726225313972*^9, 3.726225318549*^9}, 
   3.726225966208*^9, {3.7262323876540003`*^9, 3.726232430127*^9}, 
   3.726232721483*^9, 3.726232768483*^9, 3.72623296151*^9, 3.726233207597*^9, 
   3.7262332696619997`*^9, 3.726235891734*^9, 3.7262407101029997`*^9, 
   3.726243285451*^9},ExpressionUUID->"7386207c-e542-41f8-8cfc-052f4833ced5"],

Cell[BoxData["74"], "Output",
 CellChangeTimes->{
  3.726225222749*^9, {3.726225313972*^9, 3.726225318549*^9}, 
   3.726225966208*^9, {3.7262323876540003`*^9, 3.726232430127*^9}, 
   3.726232721483*^9, 3.726232768483*^9, 3.72623296151*^9, 3.726233207597*^9, 
   3.7262332696619997`*^9, 3.726235891734*^9, 3.7262407101029997`*^9, 
   3.726243285457*^9},ExpressionUUID->"c19471b4-56e2-41c2-a466-91fbaca5d01a"],

Cell[BoxData[
 TagBox[
  TemplateBox[{RowBox[{
      StyleBox[
       TagBox["InterpolatingFunction", "SummaryHead"], 
       "NonInterpretableSummary"], 
      StyleBox["[", "NonInterpretableSummary"], 
      DynamicModuleBox[{Typeset`open$$ = False}, 
       PanelBox[
        PaneSelectorBox[{False -> GridBox[{{
              PaneBox[
               ButtonBox[
                DynamicBox[
                 FEPrivate`FrontEndResource[
                 "FEBitmaps", "SquarePlusIconMedium"]], 
                ButtonFunction :> (Typeset`open$$ = True), Appearance -> None,
                 Evaluator -> Automatic, Method -> "Preemptive"], 
               Alignment -> {Center, Center}, ImageSize -> 
               Dynamic[{
                 Automatic, 3.5 CurrentValue["FontCapHeight"]/
                  AbsoluteCurrentValue[Magnification]}]], 
              GraphicsBox[{{{{}, {}, 
                  TagBox[{
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    LineBox[CompressedData["
1:eJwlkntM03cUxYs8LY+BjSA6WSkOoU6Q1wQFPBWpA1ZSEEREhJaC8igtTAaI
MDVRURT7/Y49nLiNdYKjIG/UbGNQHm6wDXShaGBdcI6MEUCE8dbsZ/bHzc0n
Oeck9+Q6ShWRyWtYLJY/M6+2p3OBWLxzMJDX/6U/25DCWNfcN5LDQWjtDw7c
BYLrl5Q86f4tMBaWrTpNECTuSro8ynXDO/b9pkHDBCuPGhNynnqhl30xJqCX
4MAOxZK/ox8Esut20W0EHf2PUy8ZBYI9pFYGMHy0e49cdEuAPzdzW7u0BANl
OrtFwT40K/XViX0EouKu2r9uC7GubpsDfUSgWjvQ6S0OgfPxG/+wRwj0tz27
e7rCkCAai5My7Ch87LvyVjiSzks6k54QfNQS/vGPMjGUh7r8uscIuIdHjFvK
IzDZYnrQbpygtDvP5+FUJHovNKismHvmXXd+3r4rCtzce2etpwhk3IpTYmU0
jBVupGOaoOV3+0027QeRdlq9NXmGwHx7oPt7SzH4LsgrLvs5QXBQlqGJKBYZ
M3emTs8S5Ef2WKd9dhiD1UXK2jmCxtmeDxUP4rAwlBdS/y/Br3E63U1ePLzd
NW4XmH6fRZOrhfFHwedxSuWLBBYhmWecaQIM6ozCQxk+b1Brf1qZCPaVXyZi
GH1xVV7t9xYSPBtuNalaIlitD6vgtEpQIp6+9WKZYLK1ziPyiBRLG0wmqlcI
Rs+Nn5IsSOFV7+xnu0qw/y7f5eIXSSiS5lhzXhLUNQlKz/jLkKoOzphmuEwz
rpLqZFhfcMRvH4tiwuTabFxhMipNuU4zayiCtznYONunwP2+5ie1MYV1U3Wp
mTYFs1bXPOrNKPSGlve/TTiGoMl3hQXmFK4RrPKY5WOYD+Svd7eiGDNYGTD/
6jhOvql9LcqGorKgr10VmArWluGAJxyKoUNqa7e/U9FWL3890pbinKfFi6bS
NBStsxXc2UDx9mDo12x+Ohx42r1zGylih1Wa/IfpMCm8Ope+meKD6hr5PUUG
VG6VBz59g4L3fuzPo2vlMOzYyn7AZfw3LUt4DfL//9GBQnTjEyNvUSaEgsG8
ccavW3TRx89nIuCVgOERcViUslwBoz3l4iom7/ndCu03m5SYkFjqnrpSuBc4
llQplHi512mkhk8x6WjRYNmmhK02N/sPhmUnl01YnCzwc9sGnVwoNkZ4aFJS
snDZVdJoup0iwuK3Gp/mLGh26weKd1AI8vP0KrNsCFlLHZleFI29xfKomGzs
XlBf6fOh6Ozn+bKrsnGi4YQywJfiP9vTrls=
                    "]]}, 
                   Annotation[#, 
                    "Charting`Private`Tag$37413#1"]& ]}}, {}, {}}, {
               DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
                AxesOrigin -> {0, 1135.56}, 
                FrameTicks -> {{{}, {}}, {{}, {}}}, GridLines -> {None, None},
                 DisplayFunction -> Identity, PlotRangePadding -> {{
                   Scaled[0.1], 
                   Scaled[0.1]}, {
                   Scaled[0.1], 
                   Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                All, DisplayFunction -> Identity, AspectRatio -> 1, 
                Axes -> {False, False}, AxesLabel -> {None, None}, 
                AxesOrigin -> {0, 1135.56}, DisplayFunction :> Identity, 
                Frame -> {{True, True}, {True, True}}, 
                FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                Directive[
                  Opacity[0.5], 
                  Thickness[Tiny], 
                  RGBColor[0.368417, 0.506779, 0.709798]], 
                FrameTicks -> {{None, None}, {None, None}}, 
                GridLines -> {None, None}, GridLinesStyle -> Directive[
                  GrayLevel[0.5, 0.4]], ImageSize -> 
                Dynamic[{
                  Automatic, 3.5 CurrentValue["FontCapHeight"]/
                   AbsoluteCurrentValue[Magnification]}], 
                Method -> {
                 "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
                  AbsolutePointSize[6], "ScalingFunctions" -> None, 
                  "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                    (Identity[#]& )[
                    Part[#, 1]], 
                    (Identity[#]& )[
                    Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                    (Identity[#]& )[
                    Part[#, 1]], 
                    (Identity[#]& )[
                    Part[#, 2]]}& )}}, 
                PlotRange -> {{0., 298.44}, {1135.56, 1166.0599992974576`}}, 
                PlotRangeClipping -> True, PlotRangePadding -> {{
                   Scaled[0.1], 
                   Scaled[0.1]}, {
                   Scaled[0.1], 
                   Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
              GridBox[{{
                 RowBox[{
                   TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"0.`", ",", "298.44`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["\"scalar\"", "SummaryItem"]}]}}, 
               GridBoxAlignment -> {
                "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, AutoDelete -> 
               False, GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
               GridBoxSpacings -> {
                "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
               BaseStyle -> {
                ShowStringCharacters -> False, NumberMarks -> False, 
                 PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
            GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> False, 
            GridBoxItemSize -> {
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
            BaselinePosition -> {1, 1}], True -> GridBox[{{
              PaneBox[
               ButtonBox[
                DynamicBox[
                 FEPrivate`FrontEndResource[
                 "FEBitmaps", "SquareMinusIconMedium"]], 
                ButtonFunction :> (Typeset`open$$ = False), Appearance -> 
                None, Evaluator -> Automatic, Method -> "Preemptive"], 
               Alignment -> {Center, Center}, ImageSize -> 
               Dynamic[{
                 Automatic, 3.5 CurrentValue["FontCapHeight"]/
                  AbsoluteCurrentValue[Magnification]}]], 
              GraphicsBox[{{{{}, {}, 
                  TagBox[{
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    LineBox[CompressedData["
1:eJwlkntM03cUxYs8LY+BjSA6WSkOoU6Q1wQFPBWpA1ZSEEREhJaC8igtTAaI
MDVRURT7/Y49nLiNdYKjIG/UbGNQHm6wDXShaGBdcI6MEUCE8dbsZ/bHzc0n
Oeck9+Q6ShWRyWtYLJY/M6+2p3OBWLxzMJDX/6U/25DCWNfcN5LDQWjtDw7c
BYLrl5Q86f4tMBaWrTpNECTuSro8ynXDO/b9pkHDBCuPGhNynnqhl30xJqCX
4MAOxZK/ox8Esut20W0EHf2PUy8ZBYI9pFYGMHy0e49cdEuAPzdzW7u0BANl
OrtFwT40K/XViX0EouKu2r9uC7GubpsDfUSgWjvQ6S0OgfPxG/+wRwj0tz27
e7rCkCAai5My7Ch87LvyVjiSzks6k54QfNQS/vGPMjGUh7r8uscIuIdHjFvK
IzDZYnrQbpygtDvP5+FUJHovNKismHvmXXd+3r4rCtzce2etpwhk3IpTYmU0
jBVupGOaoOV3+0027QeRdlq9NXmGwHx7oPt7SzH4LsgrLvs5QXBQlqGJKBYZ
M3emTs8S5Ef2WKd9dhiD1UXK2jmCxtmeDxUP4rAwlBdS/y/Br3E63U1ePLzd
NW4XmH6fRZOrhfFHwedxSuWLBBYhmWecaQIM6ozCQxk+b1Brf1qZCPaVXyZi
GH1xVV7t9xYSPBtuNalaIlitD6vgtEpQIp6+9WKZYLK1ziPyiBRLG0wmqlcI
Rs+Nn5IsSOFV7+xnu0qw/y7f5eIXSSiS5lhzXhLUNQlKz/jLkKoOzphmuEwz
rpLqZFhfcMRvH4tiwuTabFxhMipNuU4zayiCtznYONunwP2+5ie1MYV1U3Wp
mTYFs1bXPOrNKPSGlve/TTiGoMl3hQXmFK4RrPKY5WOYD+Svd7eiGDNYGTD/
6jhOvql9LcqGorKgr10VmArWluGAJxyKoUNqa7e/U9FWL3890pbinKfFi6bS
NBStsxXc2UDx9mDo12x+Ohx42r1zGylih1Wa/IfpMCm8Ope+meKD6hr5PUUG
VG6VBz59g4L3fuzPo2vlMOzYyn7AZfw3LUt4DfL//9GBQnTjEyNvUSaEgsG8
ccavW3TRx89nIuCVgOERcViUslwBoz3l4iom7/ndCu03m5SYkFjqnrpSuBc4
llQplHi512mkhk8x6WjRYNmmhK02N/sPhmUnl01YnCzwc9sGnVwoNkZ4aFJS
snDZVdJoup0iwuK3Gp/mLGh26weKd1AI8vP0KrNsCFlLHZleFI29xfKomGzs
XlBf6fOh6Ozn+bKrsnGi4YQywJfiP9vTrls=
                    "]]}, 
                   Annotation[#, 
                    "Charting`Private`Tag$37413#1"]& ]}}, {}, {}}, {
               DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
                AxesOrigin -> {0, 1135.56}, 
                FrameTicks -> {{{}, {}}, {{}, {}}}, GridLines -> {None, None},
                 DisplayFunction -> Identity, PlotRangePadding -> {{
                   Scaled[0.1], 
                   Scaled[0.1]}, {
                   Scaled[0.1], 
                   Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                All, DisplayFunction -> Identity, AspectRatio -> 1, 
                Axes -> {False, False}, AxesLabel -> {None, None}, 
                AxesOrigin -> {0, 1135.56}, DisplayFunction :> Identity, 
                Frame -> {{True, True}, {True, True}}, 
                FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                Directive[
                  Opacity[0.5], 
                  Thickness[Tiny], 
                  RGBColor[0.368417, 0.506779, 0.709798]], 
                FrameTicks -> {{None, None}, {None, None}}, 
                GridLines -> {None, None}, GridLinesStyle -> Directive[
                  GrayLevel[0.5, 0.4]], ImageSize -> 
                Dynamic[{
                  Automatic, 3.5 CurrentValue["FontCapHeight"]/
                   AbsoluteCurrentValue[Magnification]}], 
                Method -> {
                 "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
                  AbsolutePointSize[6], "ScalingFunctions" -> None, 
                  "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                    (Identity[#]& )[
                    Part[#, 1]], 
                    (Identity[#]& )[
                    Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                    (Identity[#]& )[
                    Part[#, 1]], 
                    (Identity[#]& )[
                    Part[#, 2]]}& )}}, 
                PlotRange -> {{0., 298.44}, {1135.56, 1166.0599992974576`}}, 
                PlotRangeClipping -> True, PlotRangePadding -> {{
                   Scaled[0.1], 
                   Scaled[0.1]}, {
                   Scaled[0.1], 
                   Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
              GridBox[{{
                 RowBox[{
                   TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"0.`", ",", "298.44`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["\"scalar\"", "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Order: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["1", "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Method: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["\"Hermite\"", "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Periodic: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["False", "SummaryItem"]}]}}, 
               GridBoxAlignment -> {
                "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, AutoDelete -> 
               False, GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
               GridBoxSpacings -> {
                "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
               BaseStyle -> {
                ShowStringCharacters -> False, NumberMarks -> False, 
                 PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
            GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> False, 
            GridBoxItemSize -> {
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
            BaselinePosition -> {1, 1}]}, 
         Dynamic[Typeset`open$$], ImageSize -> Automatic], BaselinePosition -> 
        Baseline], DynamicModuleValues :> {}], 
      StyleBox["]", "NonInterpretableSummary"]}]},
   "CopyTag",
   DisplayFunction->(#& ),
   InterpretationFunction->("InterpolatingFunction[{{0., 298.44}}, <>]"& )],
  False,
  Editable->False,
  SelectWithContents->True,
  Selectable->False]], "Output",
 CellChangeTimes->{
  3.726225222749*^9, {3.726225313972*^9, 3.726225318549*^9}, 
   3.726225966208*^9, {3.7262323876540003`*^9, 3.726232430127*^9}, 
   3.726232721483*^9, 3.726232768483*^9, 3.72623296151*^9, 3.726233207597*^9, 
   3.7262332696619997`*^9, 3.726235891734*^9, 3.7262407101029997`*^9, 
   3.726243285462*^9},ExpressionUUID->"134773c5-38de-4877-9884-930281b6e858"],

Cell[BoxData["1135.56`"], "Output",
 CellChangeTimes->{
  3.726225222749*^9, {3.726225313972*^9, 3.726225318549*^9}, 
   3.726225966208*^9, {3.7262323876540003`*^9, 3.726232430127*^9}, 
   3.726232721483*^9, 3.726232768483*^9, 3.72623296151*^9, 3.726233207597*^9, 
   3.7262332696619997`*^9, 3.726235891734*^9, 3.7262407101029997`*^9, 
   3.726243285469*^9},ExpressionUUID->"c09014b8-04d1-41d9-b051-2757e24ec3ea"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["test", "Subsection",
 CellChangeTimes->{{3.726232366929*^9, 3.726232384227*^9}, {3.726232447131*^9,
   3.726232462184*^9}},ExpressionUUID->"461b54fc-2f58-4359-9555-24edfe83f161"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"profilInterp", "[", "x", "]"}], "\[Equal]", "1223"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "100"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7262254266029997`*^9, 3.726225465616*^9}, 
   3.726232970962*^9},ExpressionUUID->"88867d53-d63b-41ce-a666-cf3b44f9535d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", "\[Rule]", "146.30999999999798`"}], "}"}]], "Output",
 CellChangeTimes->{{3.726225455278*^9, 3.7262254659440002`*^9}, 
   3.726232971256*^9, 3.726233213766*^9, 
   3.72623327438*^9},ExpressionUUID->"a982fd6b-200d-4226-a334-001d9dcce091"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"alt", "=", "1224"}], "\[IndentingNewLine]", 
 RowBox[{" ", 
  RowBox[{
   RowBox[{"ival", "=", 
    RowBox[{"{", "}"}]}], ";"}]}], "\[IndentingNewLine]", 
 RowBox[{"xval", "=", 
  RowBox[{"{", "}"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Do", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"profil", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "2"}], "]"}], "]"}], "\[LessEqual]", "alt", "<=", 
        RowBox[{"profil", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"i", "+", "1"}], ",", "2"}], "]"}], "]"}]}], "||", 
       RowBox[{
        RowBox[{"profil", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "2"}], "]"}], "]"}], "\[GreaterEqual]", " ", 
        "alt", "\[GreaterEqual]", 
        RowBox[{"profil", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"i", "+", "1"}], ",", "2"}], "]"}], "]"}]}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"AppendTo", "[", 
        RowBox[{"ival", ",", "i"}], "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"interp", "=", 
        RowBox[{"Interpolation", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"profil", "[", 
             RowBox[{"[", "i", "  ", "]"}], "]"}], ",", 
            RowBox[{"profil", "[", 
             RowBox[{"[", 
              RowBox[{"i", "+", "1"}], " ", "]"}], "]"}]}], "}"}], ",", 
          RowBox[{"InterpolationOrder", "\[Rule]", "1"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"xc", "=", 
        RowBox[{"x", "/.", 
         RowBox[{
          RowBox[{"FindRoot", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"interp", "[", "x", "]"}], "\[Equal]", "alt"}], ",", 
            RowBox[{"{", 
             RowBox[{"x", ",", 
              RowBox[{"profil", "[", 
               RowBox[{"[", 
                RowBox[{
                 RowBox[{"i", "+", "1"}], ",", "1"}], "]"}], "]"}]}], "}"}]}],
            "]"}], "[", 
          RowBox[{"[", "1", "]"}], "]"}]}]}], ";", 
       RowBox[{"Print", "[", 
        RowBox[{"\"\<i =\>\"", ",", "i", ",", "\"\< x = \>\"", ",", "xc"}], 
        "]"}], ";", 
       RowBox[{"AppendTo", "[", 
        RowBox[{"xval", ",", "xc"}], "]"}], ";"}]}], "\[IndentingNewLine]", 
     "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", 
      RowBox[{"n", "-", "1"}]}], "}"}]}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.7262258536730003`*^9, 3.726225974487*^9}, {
   3.726226108792*^9, 3.726226133618*^9}, {3.726226317785*^9, 
   3.7262264099820004`*^9}, {3.726226449434*^9, 3.72622647455*^9}, {
   3.726226514075*^9, 3.726226570517*^9}, {3.726227020848*^9, 
   3.726227075016*^9}, {3.726227423367*^9, 3.726227427098*^9}, 
   3.7262329678929996`*^9, 
   3.726233299344*^9},ExpressionUUID->"1db5b740-4907-401a-9067-abb44fafe421"],

Cell[BoxData["1224"], "Output",
 CellChangeTimes->{
  3.7262258573529997`*^9, 3.726225974858*^9, 3.726226134086*^9, 
   3.7262264111689997`*^9, {3.7262264709849997`*^9, 3.7262264752460003`*^9}, 
   3.726226519617*^9, {3.726226556707*^9, 3.726226571341*^9}, {
   3.7262270628599997`*^9, 3.726227075238*^9}, 3.726232968212*^9, 
   3.726233213925*^9, {3.7262332761470003`*^9, 
   3.726233300748*^9}},ExpressionUUID->"2fe81979-eee6-4763-bf91-4ae0e78e40eb"],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 CellChangeTimes->{
  3.7262258573529997`*^9, 3.726225974858*^9, 3.726226134086*^9, 
   3.7262264111689997`*^9, {3.7262264709849997`*^9, 3.7262264752460003`*^9}, 
   3.726226519617*^9, {3.726226556707*^9, 3.726226571341*^9}, {
   3.7262270628599997`*^9, 3.726227075238*^9}, 3.726232968212*^9, 
   3.726233213925*^9, {3.7262332761470003`*^9, 
   3.726233300751*^9}},ExpressionUUID->"e415249e-0116-4933-aa55-c1ac9e682691"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "106.03249999999842`"}],
  SequenceForm["i =", 10, " x = ", 106.03249999999842`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232968219*^9, 3.726233213933*^9, {3.7262332761540003`*^9, 
   3.7262333007530003`*^9}},ExpressionUUID->"0b422650-4019-4aa3-a65d-\
25f9636bb2e5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "28", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", "191.88`"}],
  SequenceForm["i =", 28, " x = ", 191.88],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232968219*^9, 3.726233213933*^9, {3.7262332761540003`*^9, 
   3.7262333007539997`*^9}},ExpressionUUID->"b05feb85-3dc5-4e4f-a4df-\
90e04574f6f8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "29", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", "191.88`"}],
  SequenceForm["i =", 29, " x = ", 191.88],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232968219*^9, 3.726233213933*^9, {3.7262332761540003`*^9, 
   3.726233300759*^9}},ExpressionUUID->"4d44e329-b412-48c8-9566-f94ca3dd3822"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.726226008226*^9, 3.7262260121280003`*^9}, {
  3.7262260723859997`*^9, 3.726226090521*^9}, {3.726227012104*^9, 
  3.726227018509*^9}},ExpressionUUID->"ff38554e-8d8f-4406-ae9e-5279f73d3fe4"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"170.38`", ",", "1221.7`"}], "}"}]], "Output",
 CellChangeTimes->{
  3.726226017889*^9, {3.7262260727609997`*^9, 
   3.726226090895*^9}},ExpressionUUID->"566aab53-3609-4bf7-8a2e-e86ee8bd3612"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"{", 
   RowBox[{"il", ",", "ir"}], "}"}], "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"First", "@", "ival"}], ",", 
    RowBox[{"Last", "@", "ival"}]}], "}"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"{", 
   RowBox[{"xl", ",", "xr"}], "}"}], "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"First", "@", "xval"}], ",", 
    RowBox[{"Last", "@", "xval"}]}], "}"}]}]}], "Input",
 CellChangeTimes->{{3.726227096816*^9, 3.726227114612*^9}, {
  3.7262329959960003`*^9, 
  3.72623301877*^9}},ExpressionUUID->"002385d2-1d45-4086-9407-6939f59141a4"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"10", ",", "29"}], "}"}]], "Output",
 CellChangeTimes->{
  3.726227114851*^9, 3.7262330197679996`*^9, 3.726233216243*^9, {
   3.726233281072*^9, 
   3.726233302632*^9}},ExpressionUUID->"757617f9-178b-4cf8-b442-fb2661fd1e3c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"106.03249999999842`", ",", "191.88`"}], "}"}]], "Output",
 CellChangeTimes->{
  3.726227114851*^9, 3.7262330197679996`*^9, 3.726233216243*^9, {
   3.726233281072*^9, 
   3.7262333026359997`*^9}},ExpressionUUID->"a52f89de-f2e2-49af-8aa3-\
1bc7d4e8756f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{
   RowBox[{"alt", " ", "-", 
    RowBox[{"profilInterp", "[", "x", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "xl", ",", "xr"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7262264846289997`*^9, 3.726226486635*^9}, {
  3.726227089087*^9, 3.726227149316*^9}, {3.726227313462*^9, 
  3.7262273437720003`*^9}},ExpressionUUID->"4d60253a-067c-40dc-a747-\
0e9a5be51eeb"],

Cell[BoxData["93.80812500000039`"], "Output",
 CellChangeTimes->{
  3.7262264869230003`*^9, {3.7262271299820004`*^9, 3.72622715016*^9}, {
   3.726227314823*^9, 3.72622734446*^9}, 3.7262330246099997`*^9, 
   3.726233217365*^9, {3.726233284427*^9, 
   3.726233303733*^9}},ExpressionUUID->"42e3598a-5a46-45a6-80f1-91836cfdc477"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"long", "=", 
  RowBox[{
   RowBox[{"Sqrt", "[", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"profil", "[", 
        RowBox[{"[", 
         RowBox[{"il", " ", "+", "1"}], " ", "]"}], "]"}], "-", 
       RowBox[{"{", 
        RowBox[{"xl", ",", "alt"}], "}"}]}], ")"}], ".", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"profil", "[", 
        RowBox[{"[", 
         RowBox[{"il", "+", "1"}], "  ", "]"}], "]"}], "-", " ", 
       RowBox[{"{", 
        RowBox[{"xl", ",", "alt"}], "}"}]}], ")"}]}], "]"}], "+", 
   RowBox[{"Sqrt", "[", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"profil", "[", 
        RowBox[{"[", "ir", "  ", "]"}], "]"}], "-", 
       RowBox[{"{", 
        RowBox[{"xr", ",", "alt"}], "}"}]}], ")"}], ".", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"profil", "[", 
        RowBox[{"[", "ir", "  ", "]"}], "]"}], "-", " ", 
       RowBox[{"{", 
        RowBox[{"xr", ",", "alt"}], "}"}]}], ")"}]}], 
    "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{"long", "+=", 
    RowBox[{"Sqrt", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"profil", "[", 
         RowBox[{"[", "i", "  ", "]"}], "]"}], "-", 
        RowBox[{"profil", "[", 
         RowBox[{"[", 
          RowBox[{"i", "+", "1"}], " ", "]"}], "]"}]}], ")"}], ".", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"profil", "[", 
         RowBox[{"[", "i", "  ", "]"}], "]"}], "-", 
        RowBox[{"profil", "[", 
         RowBox[{"[", 
          RowBox[{"i", "+", "1"}], " ", "]"}], "]"}]}], ")"}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", 
     RowBox[{"il", "+", "1"}], ",", 
     RowBox[{"ir", "-", "1"}]}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.726227405042*^9, 3.72622753533*^9}, {3.726230013764*^9, 
   3.72623004948*^9}, {3.726230121551*^9, 3.726230163789*^9}, 
   3.726230250789*^9, {3.726230292102*^9, 3.7262302936070004`*^9}, {
   3.726231386196*^9, 3.726231407833*^9}, {3.726231510461*^9, 
   3.726231515076*^9}},ExpressionUUID->"66e2a058-e38e-4374-a3ae-1e1b6b3077a5"],

Cell[BoxData["8.35288909599704`"], "Output",
 CellChangeTimes->{{3.726227502731*^9, 3.72622751404*^9}, 
   3.7262300505439997`*^9, 3.7262301643120003`*^9, 3.726230299375*^9, {
   3.726231402686*^9, 3.726231408664*^9}, 3.7262315157*^9, 
   3.7262330274890003`*^9, 3.7262332177609997`*^9, 
   3.726233304427*^9},ExpressionUUID->"f461f075-318a-4477-8488-552631ee3443"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["long"], "Input",
 CellChangeTimes->{{3.726227504414*^9, 
  3.726227506013*^9}},ExpressionUUID->"bdee0e86-f26f-498b-a546-5938f9e84a06"],

Cell[BoxData["43.7534872311104`"], "Output",
 CellChangeTimes->{{3.7262275064630003`*^9, 3.726227517608*^9}, 
   3.726230226168*^9, 3.72623030192*^9, 3.726231412692*^9, 3.726231517759*^9, 
   3.726233029825*^9, 
   3.726233218606*^9},ExpressionUUID->"ce93430f-34a6-4fca-af5b-d63f9de7b2f5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"profilInterp", "[", "x", "]"}], "-", "alt"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "xl", ",", "xr"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.726230927082*^9, 
  3.72623095363*^9}},ExpressionUUID->"d3e6a4cb-8789-4f38-97a0-1026b55b8c8a"],

Cell[BoxData[
 GraphicsBox[{{{{}, {}, 
     TagBox[{{
        {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
         Opacity[1.], LineBox[CompressedData["
1:eJxF2nk4FUwXAPDrEpebrSQhVJaSCm+kFOpFUiRtQpElKknZW2ULLZYWSkmU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          "]]}}},
      Annotation[#, "Charting`Private`Tag$3252#1"]& ]}}, {}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{106.03249999999842`, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{106.03249999999842`, 191.88}, {-3.499486454708631, 0.}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.726230943987*^9, 3.726230954277*^9}, 
   3.7262330320889997`*^9, 3.7262332194960003`*^9, 
   3.7262333061610003`*^9},ExpressionUUID->"a5375edd-bed5-434f-9baf-\
26c1bd500ddc"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcLength", "[", 
  RowBox[{"Line", "[", 
   RowBox[{"Join", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"xl", ",", "alt"}], "}"}], "}"}], ",", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"profil", "[", 
        RowBox[{"[", "i", "]"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", 
         RowBox[{"il", "+", "1"}], ",", "ir"}], "}"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"xr", ",", "alt"}], "}"}], "}"}]}], "]"}], "]"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.726231119546*^9, 3.726231184574*^9}, {3.726231351102*^9,
   3.726231360666*^9}},ExpressionUUID->"2abddc81-2937-4ccf-a46d-33d1d3cd24bf"],

Cell[BoxData["87.39576390177173`"], "Output",
 CellChangeTimes->{
  3.726231185449*^9, {3.7262313517019997`*^9, 3.726231361546*^9}, 
   3.726233041178*^9, 
   3.726233318613*^9},ExpressionUUID->"05f332b4-a477-43f3-b291-cfe3dcea37d8"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"set", "=", 
    RowBox[{"Join", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"xl", ",", "alt"}], "}"}], "}"}], ",", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"profil", "[", 
         RowBox[{"[", "i", "]"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", 
          RowBox[{"il", "+", "1"}], ",", "ir"}], "}"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"xr", ",", "alt"}], "}"}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{" "}]}], "Input",
 CellChangeTimes->{{3.726231312764*^9, 3.7262313401540003`*^9}, {
   3.726231469883*^9, 3.726231486217*^9}, {3.726232056657*^9, 
   3.726232132025*^9}, 
   3.7262332233929996`*^9},ExpressionUUID->"8123cc0e-430a-4fd6-a384-\
b004389060f5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Rh", "=", 
   RowBox[{"ArcLength", "@", 
    RowBox[{"Line", "[", "set", "]"}]}]}], "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{
  3.726233231824*^9},ExpressionUUID->"aa4cc3a1-4ea9-4ad0-9f7e-5b6abd292f12"],

Cell[BoxData["87.39576390177173`"], "Output",
 CellChangeTimes->{3.726233232759*^9, 
  3.726233320042*^9},ExpressionUUID->"ae80d3b3-bba6-4bb8-adc5-fa8e7043a5ad"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"S", "=", 
  RowBox[{"Area", "@", " ", 
   RowBox[{"Polygon", "[", "set", "]"}]}]}]], "Input",
 CellChangeTimes->{{3.726231875073*^9, 3.726231890429*^9}, {3.7262319287*^9, 
   3.726231947594*^9}, {3.7262320226219997`*^9, 3.726232061264*^9}, 
   3.7262332347720003`*^9},ExpressionUUID->"339b821a-71d3-4daa-9cbe-\
d7233b106b4e"],

Cell[BoxData["93.80812500002503`"], "Output",
 CellChangeTimes->{
  3.7262318915030003`*^9, {3.726231930817*^9, 3.726231948278*^9}, {
   3.726232027523*^9, 3.726232031013*^9}, 
   3.726233321311*^9},ExpressionUUID->"465835f2-c9c9-4a30-a854-d289830aca8a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"pente", "=", 
  RowBox[{"2", "/", "66."}]}], "\[IndentingNewLine]", 
 RowBox[{"K", "=", "30"}], "\[IndentingNewLine]", 
 RowBox[{"Q", "=", 
  RowBox[{"S", " ", 
   RowBox[{"Rh", "^", 
    RowBox[{"(", 
     RowBox[{"2", "/", "3"}], ")"}]}], " ", 
   RowBox[{"Sqrt", "[", "pente", "]"}], " ", "K"}]}]}], "Input",
 CellChangeTimes->{{3.726231714743*^9, 3.726231727738*^9}, {
  3.7262321378970003`*^9, 3.726232154474*^9}, {3.726232297094*^9, 
  3.726232315158*^9}},ExpressionUUID->"299b43c6-f382-4575-9a10-f542872d3ca1"],

Cell[BoxData["0.030303030303030304`"], "Output",
 CellChangeTimes->{
  3.726232155381*^9, {3.726232302566*^9, 3.726232316356*^9}, 
   3.726233323672*^9},ExpressionUUID->"a23a4171-f2bb-4a93-9b0f-7245c4f9f78d"],

Cell[BoxData["30"], "Output",
 CellChangeTimes->{
  3.726232155381*^9, {3.726232302566*^9, 3.726232316356*^9}, 
   3.726233323674*^9},ExpressionUUID->"04b967d5-c591-4ad7-9e98-66cb9642851b"],

Cell[BoxData["9647.874869994726`"], "Output",
 CellChangeTimes->{
  3.726232155381*^9, {3.726232302566*^9, 3.726232316356*^9}, 
   3.726233323678*^9},ExpressionUUID->"e1747589-7460-4ae0-ae7b-54bac374fced"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["calcul", "Subsection",
 CellChangeTimes->{{3.726232366929*^9, 3.726232384227*^9}, {3.726232447131*^9,
   3.726232470816*^9}},ExpressionUUID->"c13c0dcc-3ff7-4246-9abc-455d6c2117f2"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"pente", "=", 
  RowBox[{"2", "/", "38."}]}], "\[IndentingNewLine]", 
 RowBox[{"K", "=", "25"}], "\[IndentingNewLine]", 
 RowBox[{"sol", "=", 
  RowBox[{"{", "}"}]}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"ival", "=", 
     RowBox[{"{", "}"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"xval", "=", 
     RowBox[{"{", "}"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"Do", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"profil", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "2"}], "]"}], "]"}], "\[LessEqual]", "alt", "<=", 
          RowBox[{"profil", "[", 
           RowBox[{"[", 
            RowBox[{
             RowBox[{"i", "+", "1"}], ",", "2"}], "]"}], "]"}]}], "||", 
         RowBox[{
          RowBox[{"profil", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "2"}], "]"}], "]"}], "\[GreaterEqual]", " ", 
          "alt", "\[GreaterEqual]", 
          RowBox[{"profil", "[", 
           RowBox[{"[", 
            RowBox[{
             RowBox[{"i", "+", "1"}], ",", "2"}], "]"}], "]"}]}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"AppendTo", "[", 
          RowBox[{"ival", ",", "i"}], "]"}], ";", "\[IndentingNewLine]", 
         RowBox[{"interp", "=", 
          RowBox[{"Interpolation", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"profil", "[", 
               RowBox[{"[", "i", "  ", "]"}], "]"}], ",", 
              RowBox[{"profil", "[", 
               RowBox[{"[", 
                RowBox[{"i", "+", "1"}], " ", "]"}], "]"}]}], "}"}], ",", 
            RowBox[{"InterpolationOrder", "\[Rule]", "1"}]}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"xc", "=", 
          RowBox[{"x", "/.", 
           RowBox[{
            RowBox[{"FindRoot", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"interp", "[", "x", "]"}], "\[Equal]", "alt"}], ",", 
              RowBox[{"{", 
               RowBox[{"x", ",", 
                RowBox[{"profil", "[", 
                 RowBox[{"[", 
                  RowBox[{
                   RowBox[{"i", "+", "1"}], ",", "1"}], "]"}], "]"}]}], 
               "}"}]}], "]"}], "[", 
            RowBox[{"[", "1", "]"}], "]"}]}]}], ";", 
         RowBox[{"Print", "[", 
          RowBox[{"\"\<i =\>\"", ",", "i", ",", "\"\< x = \>\"", ",", "xc"}], 
          "]"}], ";", 
         RowBox[{"AppendTo", "[", 
          RowBox[{"xval", ",", "xc"}], "]"}], ";"}]}], "\[IndentingNewLine]", 
       "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", 
        RowBox[{"n", "-", "1"}]}], "}"}]}], "]"}], ";", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"il", ",", "ir"}], "}"}], "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"First", "@", "ival"}], ",", 
       RowBox[{"Last", "@", "ival"}]}], "}"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"xl", ",", "xr"}], "}"}], "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"First", "@", "xval"}], ",", 
       RowBox[{"Last", "@", "xval"}]}], "}"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"set", "=", 
     RowBox[{"Join", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"xl", ",", "alt"}], "}"}], "}"}], ",", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"profil", "[", 
          RowBox[{"[", "i", "]"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", 
           RowBox[{"il", "+", "1"}], ",", "ir"}], "}"}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"xr", ",", "alt"}], "}"}], "}"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"\[Chi]", "=", 
     RowBox[{"ArcLength", "@", 
      RowBox[{"Line", "[", "set", "]"}]}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"S", "=", 
     RowBox[{"NIntegrate", "[", 
      RowBox[{
       RowBox[{"alt", " ", "-", 
        RowBox[{"profilInterp", "[", "x", "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "xl", ",", "xr"}], "}"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"Rh", "=", 
     RowBox[{"S", "/", "\[Chi]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"Q", "=", 
     RowBox[{"S", " ", 
      RowBox[{"Rh", "^", 
       RowBox[{"(", 
        RowBox[{"2", "/", "3"}], ")"}]}], " ", 
      RowBox[{"Sqrt", "[", "pente", "]"}], " ", "K"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"AppendTo", "[", 
     RowBox[{"sol", ",", 
      RowBox[{"{", 
       RowBox[{"alt", ",", 
        RowBox[{"alt", "-", "zmin"}], ",", "Q", ",", "S", ",", "Rh"}], 
       "}"}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"alt", ",", 
     RowBox[{"zmin", "+", "0.2"}], ",", 
     RowBox[{"zmin", "+", "4"}], ",", "0.05"}], "}"}]}], 
  "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.7262258536730003`*^9, 3.726225974487*^9}, {
   3.726226108792*^9, 3.726226133618*^9}, {3.726226317785*^9, 
   3.7262264099820004`*^9}, {3.726226449434*^9, 3.72622647455*^9}, {
   3.726226514075*^9, 3.726226570517*^9}, {3.726227020848*^9, 
   3.726227075016*^9}, {3.726227423367*^9, 3.726227427098*^9}, {
   3.726232510858*^9, 3.726232631461*^9}, {3.726232669826*^9, 
   3.726232693715*^9}, {3.726233371703*^9, 3.7262334043640003`*^9}, 
   3.726233638984*^9, {3.726235938874*^9, 3.726235945443*^9}, {
   3.7262390861689997`*^9, 3.72623913842*^9}, 3.7262391871289997`*^9, {
   3.726240714218*^9, 
   3.726240715432*^9}},ExpressionUUID->"386f447e-a4eb-444d-9942-96113c920e71"],

Cell[BoxData["0.05263157894736842`"], "Output",
 CellChangeTimes->{
  3.7262258573529997`*^9, 3.726225974858*^9, 3.726226134086*^9, 
   3.7262264111689997`*^9, {3.7262264709849997`*^9, 3.7262264752460003`*^9}, 
   3.726226519617*^9, {3.726226556707*^9, 3.726226571341*^9}, {
   3.7262270628599997`*^9, 3.726227075238*^9}, 3.7262326354440002`*^9, 
   3.726232694592*^9, 3.726232735284*^9, {3.726233379144*^9, 
   3.7262334054709997`*^9}, 3.726233639807*^9, {3.7262359223310003`*^9, 
   3.7262359457139997`*^9}, {3.72623911376*^9, 3.726239138712*^9}, 
   3.726239187417*^9, 3.726240715784*^9, 
   3.7262432893310003`*^9},ExpressionUUID->"7966bd81-6b65-4490-a7c7-\
3f0cdefd906d"],

Cell[BoxData["25"], "Output",
 CellChangeTimes->{
  3.7262258573529997`*^9, 3.726225974858*^9, 3.726226134086*^9, 
   3.7262264111689997`*^9, {3.7262264709849997`*^9, 3.7262264752460003`*^9}, 
   3.726226519617*^9, {3.726226556707*^9, 3.726226571341*^9}, {
   3.7262270628599997`*^9, 3.726227075238*^9}, 3.7262326354440002`*^9, 
   3.726232694592*^9, 3.726232735284*^9, {3.726233379144*^9, 
   3.7262334054709997`*^9}, 3.726233639807*^9, {3.7262359223310003`*^9, 
   3.7262359457139997`*^9}, {3.72623911376*^9, 3.726239138712*^9}, 
   3.726239187417*^9, 3.726240715784*^9, 
   3.726243289333*^9},ExpressionUUID->"69b0d7a0-f3b9-4cae-ac53-5a47709473b3"],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 CellChangeTimes->{
  3.7262258573529997`*^9, 3.726225974858*^9, 3.726226134086*^9, 
   3.7262264111689997`*^9, {3.7262264709849997`*^9, 3.7262264752460003`*^9}, 
   3.726226519617*^9, {3.726226556707*^9, 3.726226571341*^9}, {
   3.7262270628599997`*^9, 3.726227075238*^9}, 3.7262326354440002`*^9, 
   3.726232694592*^9, 3.726232735284*^9, {3.726233379144*^9, 
   3.7262334054709997`*^9}, 3.726233639807*^9, {3.7262359223310003`*^9, 
   3.7262359457139997`*^9}, {3.72623911376*^9, 3.726239138712*^9}, 
   3.726239187417*^9, 3.726240715784*^9, 
   3.726243289335*^9},ExpressionUUID->"fa1a4291-b2f4-4372-afea-b1d42974032c"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", "23.75`"}],
  SequenceForm["i =", 6, " x = ", 23.75],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.7262432893380003`*^9},ExpressionUUID->"7e70a0b0-ce95-44ab-beb2-\
db92be6f50a0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", "23.75`"}],
  SequenceForm["i =", 7, " x = ", 23.75],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726243289341*^9},ExpressionUUID->"3957ed25-ffe3-4375-ba04-4c157e6e9606"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "31.312000000000186`"}],
  SequenceForm["i =", 9, " x = ", 31.312000000000186`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726243289344*^9},ExpressionUUID->"32c056cb-d074-4083-b708-5bd2276154b3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "23.63583333333342`"}],
  SequenceForm["i =", 6, " x = ", 23.63583333333342],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726243289347*^9},ExpressionUUID->"eabc845b-d63c-44e1-9af4-a3090fadc6e3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", "31.515`"}],
  SequenceForm["i =", 9, " x = ", 31.515],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726243289349*^9},ExpressionUUID->"69411be4-719f-4afb-bf33-652bcc3d36b8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "23.52166666666684`"}],
  SequenceForm["i =", 6, " x = ", 23.52166666666684],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726243289352*^9},ExpressionUUID->"8cb52de7-bad6-4c5f-83ae-d0fd567b5311"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "31.717999999999815`"}],
  SequenceForm["i =", 9, " x = ", 31.717999999999815`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726243289355*^9},ExpressionUUID->"0faaa7bf-b104-404d-a628-1a7d4e5b8c66"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "23.40749999999974`"}],
  SequenceForm["i =", 6, " x = ", 23.40749999999974],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.7262432893599997`*^9},ExpressionUUID->"e053eca7-1af4-46d1-97f6-\
6e5a61d328ec"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "31.921000000000554`"}],
  SequenceForm["i =", 9, " x = ", 31.921000000000554`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726243289363*^9},ExpressionUUID->"d1c563f8-f388-46fe-b31d-105110d4a9b7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "23.29333333333316`"}],
  SequenceForm["i =", 6, " x = ", 23.29333333333316],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726243289366*^9},ExpressionUUID->"27b52f89-9121-4095-a5a5-320ecf09545e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "32.12400000000037`"}],
  SequenceForm["i =", 9, " x = ", 32.12400000000037],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.72624328937*^9},ExpressionUUID->"196f6b5b-7e28-4db2-9fa6-477498bb8455"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "23.17916666666658`"}],
  SequenceForm["i =", 6, " x = ", 23.17916666666658],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726243289373*^9},ExpressionUUID->"e9052a94-1541-4b99-92e2-468d923f86c3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "32.32700000000018`"}],
  SequenceForm["i =", 9, " x = ", 32.32700000000018],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.7262432893780003`*^9},ExpressionUUID->"cd28d3cb-3776-463a-b6da-\
a39b9a7f9db8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "23.064999999999998`"}],
  SequenceForm["i =", 6, " x = ", 23.064999999999998`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726243289381*^9},ExpressionUUID->"64c7e24a-ba99-4a8e-8c48-e2c4578e448b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", "32.53`"}],
  SequenceForm["i =", 9, " x = ", 32.53],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726243289384*^9},ExpressionUUID->"409fe526-2464-4379-94e1-9edbc313f275"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "22.95083333333342`"}],
  SequenceForm["i =", 6, " x = ", 22.95083333333342],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726243289388*^9},ExpressionUUID->"a51578e7-7fd1-4016-9098-7d07041e0f4a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "32.73299999999982`"}],
  SequenceForm["i =", 9, " x = ", 32.73299999999982],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726243289391*^9},ExpressionUUID->"55e69cf7-0f19-407e-a7bb-0194ac71db1a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "22.83666666666632`"}],
  SequenceForm["i =", 6, " x = ", 22.83666666666632],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726243289394*^9},ExpressionUUID->"5553b166-535d-4c8f-b2db-5e89dd60662b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "32.936000000000554`"}],
  SequenceForm["i =", 9, " x = ", 32.936000000000554`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.7262432893970003`*^9},ExpressionUUID->"a6a2f6b2-9595-4ca5-bfc4-\
364761c65714"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "22.72249999999974`"}],
  SequenceForm["i =", 6, " x = ", 22.72249999999974],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.7262432894*^9},ExpressionUUID->"f20829e2-d135-4063-a230-fe84563861aa"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "33.13900000000037`"}],
  SequenceForm["i =", 9, " x = ", 33.13900000000037],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726243289403*^9},ExpressionUUID->"e30dc80c-3598-4d5f-9247-836f6ce9050d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "22.60833333333316`"}],
  SequenceForm["i =", 6, " x = ", 22.60833333333316],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726243289407*^9},ExpressionUUID->"0b79dec7-bdfe-4e03-bd55-638c9610c44b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "33.34200000000018`"}],
  SequenceForm["i =", 9, " x = ", 33.34200000000018],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.72624328941*^9},ExpressionUUID->"ce4f8ad8-7819-44f0-ac02-acbf7e630527"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "22.49416666666658`"}],
  SequenceForm["i =", 6, " x = ", 22.49416666666658],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726243289413*^9},ExpressionUUID->"38c7caf8-d274-46a3-80b2-d6483151c860"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", "33.545`"}],
  SequenceForm["i =", 9, " x = ", 33.545],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726243289415*^9},ExpressionUUID->"8c3af315-42c4-486b-9799-763cc66a1350"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", "22.38`"}],
  SequenceForm["i =", 5, " x = ", 22.38],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.72624328942*^9},ExpressionUUID->"9945bd91-6d04-4380-a9fa-da63a01ada22"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", "22.38`"}],
  SequenceForm["i =", 6, " x = ", 22.38],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.7262432894230003`*^9},ExpressionUUID->"9c82a7f2-378f-4729-8d48-\
ea9669e7bfba"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "33.74799999999982`"}],
  SequenceForm["i =", 9, " x = ", 33.74799999999982],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726243289426*^9},ExpressionUUID->"5273224f-9cf9-42ba-8a76-95585eed8258"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "22.323461538461334`"}],
  SequenceForm["i =", 5, " x = ", 22.323461538461334`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726243289429*^9},ExpressionUUID->"a2d68817-8579-460e-8b86-fbac99794797"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "33.951000000000555`"}],
  SequenceForm["i =", 9, " x = ", 33.951000000000555`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726243289433*^9},ExpressionUUID->"8862f6da-5f12-4f28-a234-e164d1a8f07d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "22.26692307692293`"}],
  SequenceForm["i =", 5, " x = ", 22.26692307692293],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726243289436*^9},ExpressionUUID->"203c1bf3-e500-4ba5-acfb-58e640c2d19a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "34.15400000000037`"}],
  SequenceForm["i =", 9, " x = ", 34.15400000000037],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726243289439*^9},ExpressionUUID->"f2811712-9d6d-441a-8c47-fbc60e343606"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "22.21038461538452`"}],
  SequenceForm["i =", 5, " x = ", 22.21038461538452],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726243289441*^9},ExpressionUUID->"10331848-ce3c-4fab-b4f7-f1f7e35e20b5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "34.357000000000184`"}],
  SequenceForm["i =", 9, " x = ", 34.357000000000184`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.7262432894440002`*^9},ExpressionUUID->"9c6cefbf-9e4f-46f6-b538-\
7c36aaf42187"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "22.153846153846114`"}],
  SequenceForm["i =", 5, " x = ", 22.153846153846114`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726243289446*^9},ExpressionUUID->"5cb0d5c8-b4ac-4749-9a6d-793d6eee2db4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", "34.56`"}],
  SequenceForm["i =", 9, " x = ", 34.56],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726243289449*^9},ExpressionUUID->"039e56c1-d849-42b1-8ccc-cedeb6803104"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", "34.56`"}],
  SequenceForm["i =", 10, " x = ", 34.56],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.7262432894519997`*^9},ExpressionUUID->"ee203c13-b011-4662-8d24-\
a86f32ee1c33"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "22.097307692307705`"}],
  SequenceForm["i =", 5, " x = ", 22.097307692307705`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726243289455*^9},ExpressionUUID->"f1c917b5-e752-42cc-826d-2a86b0fbcbdf"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "34.84571428571401`"}],
  SequenceForm["i =", 10, " x = ", 34.84571428571401],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726243289458*^9},ExpressionUUID->"8c519e27-3d0d-4321-8659-d4de6c924bf9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "22.040769230769044`"}],
  SequenceForm["i =", 5, " x = ", 22.040769230769044`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726243289461*^9},ExpressionUUID->"c0e1d960-f0a2-40d4-b6c3-f2d076a9a20c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "35.13142857142932`"}],
  SequenceForm["i =", 10, " x = ", 35.13142857142932],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.7262432894639997`*^9},ExpressionUUID->"ff32ebe1-cd75-4f95-a1c3-\
7f750d3b319a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "21.984230769230635`"}],
  SequenceForm["i =", 5, " x = ", 21.984230769230635`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726243289467*^9},ExpressionUUID->"599f9757-41b5-4ca2-a56f-0f768fcda972"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "35.417142857143325`"}],
  SequenceForm["i =", 10, " x = ", 35.417142857143325`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.7262432894700003`*^9},ExpressionUUID->"ad8d2b06-56e7-46c8-997d-\
d510c4b5f3c3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "21.92769230769223`"}],
  SequenceForm["i =", 5, " x = ", 21.92769230769223],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726243289473*^9},ExpressionUUID->"0f893ba7-2bda-4a25-b3d9-c9de6a3463d3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "35.70285714285733`"}],
  SequenceForm["i =", 10, " x = ", 35.70285714285733],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726243289476*^9},ExpressionUUID->"6afe5683-16e4-48c6-b98f-a233f3afdca8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "21.87115384615382`"}],
  SequenceForm["i =", 5, " x = ", 21.87115384615382],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726243289479*^9},ExpressionUUID->"3a74b514-3473-4fa2-988e-f879d1a7700b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "35.98857142857134`"}],
  SequenceForm["i =", 10, " x = ", 35.98857142857134],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.7262432894820004`*^9},ExpressionUUID->"c1acba08-bec9-4835-af45-\
e2d297062bd3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "21.814615384615415`"}],
  SequenceForm["i =", 5, " x = ", 21.814615384615415`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.7262432894849997`*^9},ExpressionUUID->"e11adea6-ee64-4629-bd01-\
39684cf07414"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "36.27428571428535`"}],
  SequenceForm["i =", 10, " x = ", 36.27428571428535],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726243289487*^9},ExpressionUUID->"13f2497e-27fa-4a56-8b7c-451f714c6975"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "21.75807692307675`"}],
  SequenceForm["i =", 5, " x = ", 21.75807692307675],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.72624328949*^9},ExpressionUUID->"94928620-0157-4eb8-a0cf-a4c94df968c1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "36.56000000000065`"}],
  SequenceForm["i =", 10, " x = ", 36.56000000000065],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726243289493*^9},ExpressionUUID->"83ff3b05-d5f7-4050-948b-e0e6162c4dc9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "21.70153846153834`"}],
  SequenceForm["i =", 5, " x = ", 21.70153846153834],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.7262432894960003`*^9},ExpressionUUID->"c5297c35-7edc-4afa-865f-\
283eaf1e6cb6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "36.84571428571466`"}],
  SequenceForm["i =", 10, " x = ", 36.84571428571466],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726243289499*^9},ExpressionUUID->"f80c8787-d8c0-4a02-a98d-f226b8d569ca"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "21.644999999999936`"}],
  SequenceForm["i =", 5, " x = ", 21.644999999999936`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726243289502*^9},ExpressionUUID->"d842748d-8b0a-404f-8902-20f5f18dffe8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "37.131428571428664`"}],
  SequenceForm["i =", 10, " x = ", 37.131428571428664`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726243289505*^9},ExpressionUUID->"3cd62b0c-a7e7-45f8-8dba-85f2f3c216dc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "21.588461538461527`"}],
  SequenceForm["i =", 5, " x = ", 21.588461538461527`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726243289508*^9},ExpressionUUID->"616ab4f2-57d5-4faa-817e-161987106e4a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "37.41714285714267`"}],
  SequenceForm["i =", 10, " x = ", 37.41714285714267],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.7262432895109997`*^9},ExpressionUUID->"c1097cdd-3f7c-4bf9-b492-\
424869d236fc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "21.53192307692312`"}],
  SequenceForm["i =", 5, " x = ", 21.53192307692312],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726243289514*^9},ExpressionUUID->"1f3bbad1-5ece-46dd-bbd8-1c6b0b212319"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "37.70285714285668`"}],
  SequenceForm["i =", 10, " x = ", 37.70285714285668],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.7262432895179996`*^9},ExpressionUUID->"763c3824-5abb-492e-aea8-\
7ec7b0bb3643"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "21.475384615384456`"}],
  SequenceForm["i =", 5, " x = ", 21.475384615384456`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.72624328952*^9},ExpressionUUID->"db7cf3c8-7e78-4fef-88bc-19101a110017"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "37.98857142857199`"}],
  SequenceForm["i =", 10, " x = ", 37.98857142857199],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726243289524*^9},ExpressionUUID->"02d08ff1-97e7-4ed3-9eda-10cb9f92d1e7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "21.41884615384605`"}],
  SequenceForm["i =", 5, " x = ", 21.41884615384605],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726243289535*^9},ExpressionUUID->"9f8289c8-5482-4331-b838-6891fa8e117a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "38.274285714285995`"}],
  SequenceForm["i =", 10, " x = ", 38.274285714285995`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726243289539*^9},ExpressionUUID->"1df0c521-991e-4969-9511-7262a050a078"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "21.362307692307642`"}],
  SequenceForm["i =", 5, " x = ", 21.362307692307642`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726243289543*^9},ExpressionUUID->"7308556b-87aa-48bc-b769-2fbf81d30858"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", "38.56`"}],
  SequenceForm["i =", 10, " x = ", 38.56],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726243289546*^9},ExpressionUUID->"70d0b25c-6307-4768-8286-3bef2a45985d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", "38.56`"}],
  SequenceForm["i =", 11, " x = ", 38.56],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726243289549*^9},ExpressionUUID->"a0192068-b40a-4622-b644-357a381a8c30"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "21.305769230769236`"}],
  SequenceForm["i =", 5, " x = ", 21.305769230769236`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726243289552*^9},ExpressionUUID->"ccc9f49b-8e5f-405a-a270-128c3783b08b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "38.62170731707312`"}],
  SequenceForm["i =", 11, " x = ", 38.62170731707312],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726243289554*^9},ExpressionUUID->"b1d4664a-0139-44d5-92a0-1e35df96e08c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "21.249230769230827`"}],
  SequenceForm["i =", 5, " x = ", 21.249230769230827`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726243289559*^9},ExpressionUUID->"3498c95d-4ff5-484b-95b5-81ce7b1855b6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "38.68341463414623`"}],
  SequenceForm["i =", 11, " x = ", 38.68341463414623],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.7262432895620003`*^9},ExpressionUUID->"9d87d812-83bf-4b6f-8e15-\
9a5d00d9b745"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "21.192692307692163`"}],
  SequenceForm["i =", 5, " x = ", 21.192692307692163`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726243289565*^9},ExpressionUUID->"41737097-2af4-4fae-9847-194253694a93"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "38.74512195121963`"}],
  SequenceForm["i =", 11, " x = ", 38.74512195121963],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726243289568*^9},ExpressionUUID->"ad4c4789-0d3c-4558-b757-021984720fe7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "21.136153846153757`"}],
  SequenceForm["i =", 5, " x = ", 21.136153846153757`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726243289571*^9},ExpressionUUID->"501ed911-ece1-4978-880e-06bffb9f7044"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "38.806829268292745`"}],
  SequenceForm["i =", 11, " x = ", 38.806829268292745`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726243289574*^9},ExpressionUUID->"ef4f202c-367b-4d7d-82a9-a281599d5b00"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "21.07961538461535`"}],
  SequenceForm["i =", 5, " x = ", 21.07961538461535],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.7262432895810003`*^9},ExpressionUUID->"90a17c8d-dfb2-49ba-b65c-\
0ea7385945c4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "38.86853658536586`"}],
  SequenceForm["i =", 11, " x = ", 38.86853658536586],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726243289584*^9},ExpressionUUID->"e765f350-1964-42b6-af3c-3a7da6df4008"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "21.023076923076943`"}],
  SequenceForm["i =", 5, " x = ", 21.023076923076943`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726243289593*^9},ExpressionUUID->"67f87460-a6e0-4dfa-938d-b55c5fc42be9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "38.93024390243898`"}],
  SequenceForm["i =", 11, " x = ", 38.93024390243898],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.7262432895959997`*^9},ExpressionUUID->"e886d994-e48d-443b-be7d-\
9d69ab7259d0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "20.966538461538537`"}],
  SequenceForm["i =", 5, " x = ", 20.966538461538537`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726243289599*^9},ExpressionUUID->"80440aa0-c8b9-46d9-90a1-2590229a1d22"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "38.991951219512096`"}],
  SequenceForm["i =", 11, " x = ", 38.991951219512096`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726243289601*^9},ExpressionUUID->"6a0984ad-7e1f-4c67-91fe-e695b4138986"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "20.909999999999872`"}],
  SequenceForm["i =", 5, " x = ", 20.909999999999872`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726243289604*^9},ExpressionUUID->"737bf4d0-dc84-4f5f-a542-7ac73d1e5fa3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "39.05365853658549`"}],
  SequenceForm["i =", 11, " x = ", 39.05365853658549],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726243289608*^9},ExpressionUUID->"f8df4138-ae45-4d99-b8d9-2d3ee7796d4c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "20.853461538461463`"}],
  SequenceForm["i =", 5, " x = ", 20.853461538461463`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726243289616*^9},ExpressionUUID->"e4780eda-9703-44c9-ae10-8bf586238417"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "39.11536585365861`"}],
  SequenceForm["i =", 11, " x = ", 39.11536585365861],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726243289619*^9},ExpressionUUID->"a94fb1ad-8363-44db-9e12-571652a6f0be"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "20.796923076923058`"}],
  SequenceForm["i =", 5, " x = ", 20.796923076923058`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726243289623*^9},ExpressionUUID->"c79fc6b7-059a-4b35-a2be-039f34826ce5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "39.177073170731724`"}],
  SequenceForm["i =", 11, " x = ", 39.177073170731724`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726243289626*^9},ExpressionUUID->"b245e199-ba46-43c3-8f12-96d15b345b97"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "20.74038461538465`"}],
  SequenceForm["i =", 5, " x = ", 20.74038461538465],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726243289634*^9},ExpressionUUID->"49018379-3909-4be7-9ed1-c7fefc428657"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "39.23878048780484`"}],
  SequenceForm["i =", 11, " x = ", 39.23878048780484],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726243289637*^9},ExpressionUUID->"f4f0a59d-f168-4eae-97ba-915eb4478770"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "20.683846153846243`"}],
  SequenceForm["i =", 5, " x = ", 20.683846153846243`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.7262432896400003`*^9},ExpressionUUID->"5208ddbd-0c6e-4e4c-b996-\
690c8fbc59a3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "39.30048780487795`"}],
  SequenceForm["i =", 11, " x = ", 39.30048780487795],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.7262432896429996`*^9},ExpressionUUID->"71d407e8-76b7-4a17-9f5f-\
a192d9f5f64e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "20.62730769230758`"}],
  SequenceForm["i =", 5, " x = ", 20.62730769230758],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.72624328965*^9},ExpressionUUID->"3e197d00-6906-44ed-b9c2-65a811403192"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "39.36219512195135`"}],
  SequenceForm["i =", 11, " x = ", 39.36219512195135],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.7262432896540003`*^9},ExpressionUUID->"4cc24e19-c52d-4ee0-8624-\
80360404bfab"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "20.570769230769173`"}],
  SequenceForm["i =", 5, " x = ", 20.570769230769173`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726243289659*^9},ExpressionUUID->"1506fb18-da7d-4982-a35c-e3045ffab0df"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "39.42390243902447`"}],
  SequenceForm["i =", 11, " x = ", 39.42390243902447],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.7262432896619997`*^9},ExpressionUUID->"c262f7e4-47b0-40a6-8c8e-\
b546ad5934bb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "20.514230769230764`"}],
  SequenceForm["i =", 5, " x = ", 20.514230769230764`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726243289665*^9},ExpressionUUID->"e4804b21-72d2-4697-ae6c-6dc312f9db5c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "39.48560975609758`"}],
  SequenceForm["i =", 11, " x = ", 39.48560975609758],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726243289667*^9},ExpressionUUID->"1e47c38a-c305-4c3e-9dcd-d275d3a91d9e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "20.45769230769236`"}],
  SequenceForm["i =", 5, " x = ", 20.45769230769236],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726243289675*^9},ExpressionUUID->"eeccf8c1-7e26-4097-9eac-0c4dd2430fec"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "39.547317073170696`"}],
  SequenceForm["i =", 11, " x = ", 39.547317073170696`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726243289678*^9},ExpressionUUID->"2361fb9d-ce10-41c0-afa9-1dc269926a73"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "20.40115384615395`"}],
  SequenceForm["i =", 5, " x = ", 20.40115384615395],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.7262432896809998`*^9},ExpressionUUID->"c240ce1f-353a-4394-85d1-\
28dba8d8f2c6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "39.60902439024382`"}],
  SequenceForm["i =", 11, " x = ", 39.60902439024382],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726243289684*^9},ExpressionUUID->"b04a1b42-3703-4f0b-b007-64f7dd0c9078"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "20.344615384615288`"}],
  SequenceForm["i =", 5, " x = ", 20.344615384615288`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726243289691*^9},ExpressionUUID->"8f4c6866-a53f-4714-869b-183d5752259f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "39.67073170731721`"}],
  SequenceForm["i =", 11, " x = ", 39.67073170731721],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.7262432896949997`*^9},ExpressionUUID->"9650fbbd-25da-423b-b7cc-\
a267cd5bbfe4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "20.28807692307688`"}],
  SequenceForm["i =", 5, " x = ", 20.28807692307688],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726243289699*^9},ExpressionUUID->"a631a585-ca95-49a1-acef-b97161c71219"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "39.732439024390324`"}],
  SequenceForm["i =", 11, " x = ", 39.732439024390324`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726243289701*^9},ExpressionUUID->"8ea7c8e5-245c-4a2d-bc72-75cc0eef5665"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "20.23153846153847`"}],
  SequenceForm["i =", 5, " x = ", 20.23153846153847],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.72624328971*^9},ExpressionUUID->"2f0334a1-0755-4ce8-a645-8497e4d3182b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "39.794146341463446`"}],
  SequenceForm["i =", 11, " x = ", 39.794146341463446`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.7262432897130003`*^9},ExpressionUUID->"4d91485d-d59e-412f-8a58-\
e191fb83c996"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "20.175000000000065`"}],
  SequenceForm["i =", 5, " x = ", 20.175000000000065`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726243289716*^9},ExpressionUUID->"a8a53515-c32c-4fff-9a28-274ecbfd20fa"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "39.85585365853656`"}],
  SequenceForm["i =", 11, " x = ", 39.85585365853656],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726243289719*^9},ExpressionUUID->"0a503e47-fd89-4c57-8f89-98decaffc698"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "20.11846153846166`"}],
  SequenceForm["i =", 5, " x = ", 20.11846153846166],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726243289727*^9},ExpressionUUID->"4319003e-e9c6-4ad1-928e-b081322427b5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "39.917560975609675`"}],
  SequenceForm["i =", 11, " x = ", 39.917560975609675`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.72624328973*^9},ExpressionUUID->"3f60d120-617d-437d-9e7c-b2048a966912"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "20.061923076922994`"}],
  SequenceForm["i =", 5, " x = ", 20.061923076922994`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726243289733*^9},ExpressionUUID->"a6d66e9b-3eb5-4b14-8c0b-e478ff299dd0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "39.979268292683074`"}],
  SequenceForm["i =", 11, " x = ", 39.979268292683074`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.7262432897349997`*^9},ExpressionUUID->"df18b454-d36e-4c0f-9a35-\
81510dbb7d02"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "20.005384615384585`"}],
  SequenceForm["i =", 5, " x = ", 20.005384615384585`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726243289743*^9},ExpressionUUID->"50c44609-0db5-4a5d-afd9-9eb6478b0f67"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "40.04097560975619`"}],
  SequenceForm["i =", 11, " x = ", 40.04097560975619],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.7262432897469997`*^9},ExpressionUUID->"bc0189d9-ed40-40a6-b88a-\
cbc30bac5263"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "19.94884615384618`"}],
  SequenceForm["i =", 5, " x = ", 19.94884615384618],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.72624328975*^9},ExpressionUUID->"6594588a-4508-4e90-b5a3-7330e5007a3d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "40.1026829268293`"}],
  SequenceForm["i =", 11, " x = ", 40.1026829268293],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.7262432897539997`*^9},ExpressionUUID->"5e2f1db5-e38c-4a3a-a75b-\
b3870102ec25"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "19.89230769230777`"}],
  SequenceForm["i =", 5, " x = ", 19.89230769230777],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726243289758*^9},ExpressionUUID->"afabe2a7-8884-4546-9084-4ef0d9599fa1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "40.16439024390242`"}],
  SequenceForm["i =", 11, " x = ", 40.16439024390242],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726243289762*^9},ExpressionUUID->"ca152093-3f35-448f-8fff-ce23deb8a78d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "19.835769230769365`"}],
  SequenceForm["i =", 5, " x = ", 19.835769230769365`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.72624328977*^9},ExpressionUUID->"278955a6-fb9f-47d6-bd20-268e699100e9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "40.22609756097553`"}],
  SequenceForm["i =", 11, " x = ", 40.22609756097553],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726243289774*^9},ExpressionUUID->"2c361779-d63d-4482-ae11-5b85a786dc96"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "19.7792307692307`"}],
  SequenceForm["i =", 5, " x = ", 19.7792307692307],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726243289778*^9},ExpressionUUID->"38f356c7-889a-4bc8-b92e-5f1ef9625fd8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "40.28780487804893`"}],
  SequenceForm["i =", 11, " x = ", 40.28780487804893],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.7262432897799997`*^9},ExpressionUUID->"e71a7cf7-2dca-4ce9-917d-\
4960c72c4c88"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "19.722692307692295`"}],
  SequenceForm["i =", 5, " x = ", 19.722692307692295`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726243289783*^9},ExpressionUUID->"11868a2b-f426-46e8-ab08-a131df87b236"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "40.349512195122045`"}],
  SequenceForm["i =", 11, " x = ", 40.349512195122045`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.7262432897860003`*^9},ExpressionUUID->"acba3fb3-77de-4cf1-beaa-\
1d2b7ec539b4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "19.666153846153886`"}],
  SequenceForm["i =", 5, " x = ", 19.666153846153886`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726243289795*^9},ExpressionUUID->"fec3424f-3fe8-4b16-a91a-784632db370f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "40.41121951219516`"}],
  SequenceForm["i =", 11, " x = ", 40.41121951219516],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.7262432897980003`*^9},ExpressionUUID->"4b6b53f2-8e6c-4282-9e7b-\
c2ca08760b59"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "19.60961538461548`"}],
  SequenceForm["i =", 5, " x = ", 19.60961538461548],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726243289801*^9},ExpressionUUID->"a656a688-ad5e-4b11-aee2-aa020ee76ba1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "40.47292682926828`"}],
  SequenceForm["i =", 11, " x = ", 40.47292682926828],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726243289804*^9},ExpressionUUID->"84051864-9e6e-42b4-9846-f969a920cc9b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "19.55307692307707`"}],
  SequenceForm["i =", 5, " x = ", 19.55307692307707],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.7262432898129997`*^9},ExpressionUUID->"54caa227-f2b3-4e2f-be84-\
5f2688351154"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "40.534634146341396`"}],
  SequenceForm["i =", 11, " x = ", 40.534634146341396`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726243289816*^9},ExpressionUUID->"73809a2d-5e13-4b87-9582-c5518248e437"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "19.496538461538407`"}],
  SequenceForm["i =", 5, " x = ", 19.496538461538407`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.7262432898190002`*^9},ExpressionUUID->"6a0b7c01-9f4a-4aba-b35b-\
045e97bfaed6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "40.59634146341479`"}],
  SequenceForm["i =", 11, " x = ", 40.59634146341479],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726243289822*^9},ExpressionUUID->"5517ab89-f904-476f-9e7d-56c1e510097c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", "19.44`"}],
  SequenceForm["i =", 4, " x = ", 19.44],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726243289826*^9},ExpressionUUID->"7b286be8-4ade-4789-91b8-0ce484b1474d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", "19.44`"}],
  SequenceForm["i =", 5, " x = ", 19.44],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726243289829*^9},ExpressionUUID->"8e337637-185d-4f80-9218-5a465fb56c7b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "40.65804878048791`"}],
  SequenceForm["i =", 11, " x = ", 40.65804878048791],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726243289832*^9},ExpressionUUID->"96f0ef50-e599-4c43-ae17-9407fe5475a2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "19.382708333333383`"}],
  SequenceForm["i =", 4, " x = ", 19.382708333333383`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726243289835*^9},ExpressionUUID->"481f12e3-6a4c-459b-b166-225ea98f4f39"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "40.719756097561024`"}],
  SequenceForm["i =", 11, " x = ", 40.719756097561024`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726243289837*^9},ExpressionUUID->"56f68e98-3020-46bc-aa65-4970c235ab73"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "19.325416666666765`"}],
  SequenceForm["i =", 4, " x = ", 19.325416666666765`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.7262432898459997`*^9},ExpressionUUID->"5c049a88-4868-4acf-b213-\
6fe5e412a188"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "40.78146341463414`"}],
  SequenceForm["i =", 11, " x = ", 40.78146341463414],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726243289849*^9},ExpressionUUID->"fb6bda43-ecf0-40ba-b829-bc8195a78984"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "19.268125000000147`"}],
  SequenceForm["i =", 4, " x = ", 19.268125000000147`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726243289852*^9},ExpressionUUID->"496970da-0619-4c5e-9c64-0db421200edd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "40.843170731707254`"}],
  SequenceForm["i =", 11, " x = ", 40.843170731707254`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726243289855*^9},ExpressionUUID->"ef712abe-81e7-449b-a4ce-385345e740f5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "19.21083333333327`"}],
  SequenceForm["i =", 4, " x = ", 19.21083333333327],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.7262432898640003`*^9},ExpressionUUID->"12e3bb88-65c8-402a-9cf0-\
e44650e51e39"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "40.90487804878065`"}],
  SequenceForm["i =", 11, " x = ", 40.90487804878065],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726243289867*^9},ExpressionUUID->"dbfffc46-f67b-4280-884c-4b51d5e2be4a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "19.15354166666665`"}],
  SequenceForm["i =", 4, " x = ", 19.15354166666665],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726243289876*^9},ExpressionUUID->"405252c9-660a-4682-a725-22e628825d71"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "40.96658536585377`"}],
  SequenceForm["i =", 11, " x = ", 40.96658536585377],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.7262432898789997`*^9},ExpressionUUID->"dcdb7688-4417-4a6f-a1a4-\
fd75b437f2f3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "19.096250000000033`"}],
  SequenceForm["i =", 4, " x = ", 19.096250000000033`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726243289882*^9},ExpressionUUID->"e5c15e75-bdcf-4e3e-b9c3-2bf33a37ee5a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "41.02829268292688`"}],
  SequenceForm["i =", 11, " x = ", 41.02829268292688],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726243289884*^9},ExpressionUUID->"382e239d-6996-434d-8ceb-440952dfa791"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "19.038958333333415`"}],
  SequenceForm["i =", 4, " x = ", 19.038958333333415`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.7262432898929996`*^9},ExpressionUUID->"53c67f82-1066-4837-b36c-\
61c3c45ec7d6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", "41.09`"}],
  SequenceForm["i =", 11, " x = ", 41.09],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726243289896*^9},ExpressionUUID->"350c31e3-a9c5-4582-a6ea-635f4b423836"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "18.981666666666797`"}],
  SequenceForm["i =", 4, " x = ", 18.981666666666797`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726243289899*^9},ExpressionUUID->"d573c41a-c8f0-48fe-9da7-273fe39922cc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "41.15170731707312`"}],
  SequenceForm["i =", 11, " x = ", 41.15170731707312],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726243289902*^9},ExpressionUUID->"5c2b5d0b-014d-4662-aef7-87bec89aa202"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "18.92437499999992`"}],
  SequenceForm["i =", 4, " x = ", 18.92437499999992],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.7262432899110003`*^9},ExpressionUUID->"aaa7dda5-d99a-4614-9147-\
675c25e5598b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "41.21341463414651`"}],
  SequenceForm["i =", 11, " x = ", 41.21341463414651],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726243289914*^9},ExpressionUUID->"22bb3170-8124-43cc-8c16-c0dc25b6ef6d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "18.8670833333333`"}],
  SequenceForm["i =", 4, " x = ", 18.8670833333333],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.7262432899230003`*^9},ExpressionUUID->"8998f737-2fe1-420e-bada-\
941ce3d7cac7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "41.27512195121963`"}],
  SequenceForm["i =", 11, " x = ", 41.27512195121963],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726243289926*^9},ExpressionUUID->"ce543072-8500-4fce-8c02-ac901b4fa378"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "18.809791666666683`"}],
  SequenceForm["i =", 4, " x = ", 18.809791666666683`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726243289929*^9},ExpressionUUID->"2e2720cb-da47-4f43-b67c-b19c3f0e588c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "41.336829268292746`"}],
  SequenceForm["i =", 11, " x = ", 41.336829268292746`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726243289932*^9},ExpressionUUID->"fddad1e5-61f9-479d-a1cf-72502a0963bc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "18.752500000000065`"}],
  SequenceForm["i =", 4, " x = ", 18.752500000000065`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.72624328994*^9},ExpressionUUID->"3440d86e-da6b-4497-93f0-3f9aed8d1557"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "41.39853658536586`"}],
  SequenceForm["i =", 11, " x = ", 41.39853658536586],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726243289943*^9},ExpressionUUID->"4257fd28-9691-44ee-8863-509bfab65854"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"deb1", "=", 
  RowBox[{"ListLinePlot", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"#", "[", 
         RowBox[{"[", "2", "]"}], "]"}], ",", 
        RowBox[{"#", "[", 
         RowBox[{"[", "3", "]"}], "]"}]}], "}"}], "&"}], "/@", "sol"}], ",", 
    RowBox[{"Frame", "\[Rule]", "True"}], ",", 
    RowBox[{"FrameLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<\!\(\*
StyleBox[\"h\",
FontSlant->\"Italic\"]\)\!\(\*
StyleBox[\" \",
FontSlant->\"Italic\"]\)(m)\>\"", ",", "\"\<\!\(\*
StyleBox[\"Q\",
FontSlant->\"Italic\"]\)\!\(\*
StyleBox[\" \",
FontSlant->\"Italic\"]\)(\!\(\*SuperscriptBox[\(m\), \(3\)]\)/s)\>\""}], 
      "}"}]}], ",", 
    RowBox[{"BaseStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"FontFamily", "->", "\"\<Times\>\""}], ",", "14"}], "}"}]}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.726233420135*^9, 3.726233470976*^9}, {3.726233515049*^9,
   3.726233620692*^9}, {3.726239494539*^9, 
  3.726239498554*^9}},ExpressionUUID->"69a1bbca-7b6b-4e92-a36e-f075a5b5df16"],

Cell[BoxData[
 GraphicsBox[{{}, {{{}, {}, {
      {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
       0.016666666666666666`], AbsoluteThickness[1.6], 
       StyleBox[LineBox[CompressedData["
1:eJwtzXFQ02UYB/CXwcaYGyiZDg1sTMWTqdwRAkfc8yiipYKCGEQlJDIXEgN+
MglFJrKheFp/1GXKbWjn9LTCaUbpFGpQITiwdVxooNuU8CxURCUEbb98vnfv
vf98v59HsVGbni9gjKV4H/+zhi+8aYe+i9pXg674IPs/3VAY98YOpUuCLCra
GyesWRVjmmUPRlas9qYHFrWJol7qleOLfS/I9u5X1jbOQtbd6c2fIHuY3mk8
qiTvJtQZFt42dUYgO8j3XfCgpuSHmLdUyOJ43wOfqVUH+sxRtL8Fy3+xP7mz
LBqZhr83AGMh3HPLjMXkDcLv4ZbafYp48u5AU7U6eGb26+TdhdM532Va/wDy
/oap2XN7YlqXkDcECTf6P2n5Nom8+3Cw95o95FIyMr7eeR/C1prPpbSvQFbP
+w9gpfWozj70Ju2HYUmxKvn2wtXIXuPvPQT55WsZoXWp5I1A1ebD1wv0a8kb
gb7hotm29jTyHsFVy4K0WMU68h7Db7pnwim1GeQ9gfNmyfnKp+vJG4WlpsNn
rTszyRsFf7tY6Jr8Nnn/QnnWmjo4k03eGDhiY/9iee+S9xRc1+8aspQbyBuH
6D3TSxun55I3DrncT+Pds98nbwJGbfavBfEbyXsGka0dBbEZeeQ9hyvNYaF5
uk3kMbz6jbO+wpyPjK+rGXZtXmHiutTIHLzPUBFRfmSZSEN7HxSFSDy3kj5A
doi/54PilubU1XsKyBOgNieO45xbyBNgisShWzfnQ/IEaJxaKhuoLCLPF1cu
2qKd06clzxc1W4vmGY8Uk+eHiSk+/1zOLCHPD9svCLs3TCklzw/PHU/qAkcp
eUI8fumkvPAAR54Qfx6q8XenbSVPhGPCfkWDvIw8ESbYZk475i4jT4Q5TT9+
f69RR54/1te+J6jSbyPPHxtyP5elZ5STJ0Zd6KaXNZEfkSdGx8R6rkVYQZ4Y
ncYAU7angrwA9Mz7KmJx63byAjDffciWfmIHeRLMOjUt/PTHleRJsCdRFpNa
sZM8CSY2jAyqNFXkTcKJ0XeUFpWevElYCAsi2yx68qS43TMUbQjfRZ4US+b/
qh4w7yJPisku06PBsGryZGgbts7Yb64mT4buL+PlTsVu8gKx0C2Nu3BsN3mB
yG1b1ZEcWUNeIFovSudzZ2rIC0LfvcFnkxIM5AVhyCv6jqY2A3mTsaz50/6u
NCP+B5nS4QU=
         "]],
        FontFamily->"Times"]}}}}, {}, {}, {{}, {}}, {{}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  BaseStyle->{FontFamily -> "Times", 14},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox[
     "\"\\!\\(\\*\\nStyleBox[\\\"Q\\\",\\nFontSlant->\\\"Italic\\\"]\\)\\!\\(\
\\*\\nStyleBox[\\\" \
\\\",\\nFontSlant->\\\"Italic\\\"]\\)(\\!\\(\\*SuperscriptBox[\\(m\\), \
\\(3\\)]\\)/s)\"", TraditionalForm], None}, {
     FormBox[
     "\"\\!\\(\\*\\nStyleBox[\\\"h\\\",\\nFontSlant->\\\"Italic\\\"]\\)\\!\\(\
\\*\\nStyleBox[\\\" \\\",\\nFontSlant->\\\"Italic\\\"]\\)(m)\"", 
      TraditionalForm], None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 4.}, {0, 714.2264987584045}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.726233465073*^9, 3.726233471862*^9}, 
   3.7262335163380003`*^9, {3.72623355809*^9, 3.726233586823*^9}, {
   3.726233623099*^9, 3.7262336445109997`*^9}, {3.726235927736*^9, 
   3.726235950542*^9}, {3.726239125174*^9, 3.726239144913*^9}, 
   3.7262391952720003`*^9, 3.726239499711*^9, 3.726240720966*^9, 
   3.72624329812*^9},ExpressionUUID->"a378300a-c30d-454d-814d-9fd83b962bba"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"interQ", "=", 
  RowBox[{"Interpolation", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"#", "[", 
        RowBox[{"[", "2", "]"}], "]"}], ",", 
       RowBox[{"#", "[", 
        RowBox[{"[", "3", "]"}], "]"}]}], "}"}], "&"}], "/@", "sol"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"interQ", "[", "h", "]"}], "\[Equal]", "200"}], ",", 
   RowBox[{"{", 
    RowBox[{"h", ",", "3"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.726235960135*^9, 3.726235994193*^9}, 
   3.7262392067139997`*^9, 
   3.726243300824*^9},ExpressionUUID->"6e9b6809-a472-4d9e-a1a7-23a82cdd99fe"],

Cell[BoxData[
 TagBox[
  TemplateBox[{RowBox[{
      StyleBox[
       TagBox["InterpolatingFunction", "SummaryHead"], 
       "NonInterpretableSummary"], 
      StyleBox["[", "NonInterpretableSummary"], 
      DynamicModuleBox[{Typeset`open$$ = False}, 
       PanelBox[
        PaneSelectorBox[{False -> GridBox[{{
              PaneBox[
               ButtonBox[
                DynamicBox[
                 FEPrivate`FrontEndResource[
                 "FEBitmaps", "SquarePlusIconMedium"]], 
                ButtonFunction :> (Typeset`open$$ = True), Appearance -> None,
                 Evaluator -> Automatic, Method -> "Preemptive"], 
               Alignment -> {Center, Center}, ImageSize -> 
               Dynamic[{
                 Automatic, 3.5 CurrentValue["FontCapHeight"]/
                  AbsoluteCurrentValue[Magnification]}]], 
              GraphicsBox[{{{{}, {}, 
                  TagBox[{
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    LineBox[CompressedData["
1:eJwB0QMu/CFib1JlAgAAADwAAAACAAAAZ6DpI5qZyT/KFWvTD80BQEWwNjG8
w9A/hsQzyS5IDUAWA986ChDVPzeRrS1lNhZAqdn38G0T2T+w7MhNtoMeQKqD
KGiqAt0/BJAjUrLlI0A00N/koqPgPxmyYBkzkSlAdaDja3uh4j+mBHxaU3Uv
QBWqGmgDyuQ/V2KZxCRAM0Bsnd3Ed+jmP3XO9iJeCzdApNLY93bi6D/aiEEw
/+E6QDxBB6AlB+s/kHnwE8B1P0C18W0eXwftPyau8PuyCUJA5Ytg/YT97j/1
hBOcbnNEQLovwygtj/A/sywvlTkqR0ByOvI9XY3xP19S5uUwzUlA2uG6DeWg
8j+neuqeZ9hMQB1+yQ1jr/M/o1hdsKECUEBRO/R4pqv0P9pTl5l5k1FANZW4
nkG99T8QIwrpel5TQAoQmS+ivPY/aO4QnxciVUCOJxN7WtH3P/qg1yoxJVdA
7TPT9gjh+D+FGhv1bzlZQD1hr9183vk/MlW+yhVCW0A9KyV/SPH6P+vE8UOs
jV1ALha3i9nx+z/aV8RJAAVgQPr1jshg7fw/SBh8uUdQYUB2cgDAP/79P7I5
+J9Rw2JA4g+OIuT8/j92Ev17wyhkQP+k2h9wCABArGuMcES4ZUB7PJFG6Y8A
QMrG5OOgTGdAb+TVIkUOAUB0V5Klj9BoQLtaZ9xMlwFAzz8+L/CAakB/4YZL
NxcCQKoqaRd3H2xAsWLJ0pyUAkD921uBAMBtQDuyWDeuHANAqzapW1SPb0A9
EnZRopsDQGTXM8IcpXBAl0DgSEIlBEDL7fEN75pxQGl/2PXEpQRA9UcYGt6F
ckCpuPO6wiMFQGOwcp08cXNAQcBbXWysBUDQsleFK3Z0QFHYUbX4KwZAnJFu
LfludUC5vpTqMLYGQBHuXipUgnZAj5/6N+Q9B0CgJt+8dZZ3QN2Q7jp6vAdA
3+2ddTadeECDUC8bvEUIQCWPWSG/v3lAoSD+sODFCEBZ+jxbRdR6QC3r716A
QwlA7EXiyE7oe0ARhC7qy8sJQA6DLPhUGX1AbS37KvpKCkBU+8rpJzt+QCGl
FEnU1ApAgD26V/d6f0BDF1F/KVwLQLzscRRPXYBA3Zkba2HaC0CaaaIz3vSA
QM/qMjRFYwxAcf/oOQucgUA5TNiyC+MMQACdZbq3OoJA+3vKDn5tDUCXcwW8
gumCQCum34Jr9Q1AkU5m5QaYg0DT4IKsO3QOQMTf3R5wPYRA0+lys7f9DkAE
IiNymvOEQEsD8W8Wfg9Asm7zmFughUD6/1r3//8PQPpjr9LPUYZAXt/CbA==

                    "]]}, 
                   Annotation[#, 
                    "Charting`Private`Tag$40394#1"]& ]}}, {}, {}}, {
               DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
                AxesOrigin -> {0, 0}, FrameTicks -> {{{}, {}}, {{}, {}}}, 
                GridLines -> {None, None}, DisplayFunction -> Identity, 
                PlotRangePadding -> {{
                   Scaled[0.1], 
                   Scaled[0.1]}, {
                   Scaled[0.1], 
                   Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                All, DisplayFunction -> Identity, AspectRatio -> 1, 
                Axes -> {False, False}, AxesLabel -> {None, None}, 
                AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
                Frame -> {{True, True}, {True, True}}, 
                FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                Directive[
                  Opacity[0.5], 
                  Thickness[Tiny], 
                  RGBColor[0.368417, 0.506779, 0.709798]], 
                FrameTicks -> {{None, None}, {None, None}}, 
                GridLines -> {None, None}, GridLinesStyle -> Directive[
                  GrayLevel[0.5, 0.4]], ImageSize -> 
                Dynamic[{
                  Automatic, 3.5 CurrentValue["FontCapHeight"]/
                   AbsoluteCurrentValue[Magnification]}], 
                Method -> {
                 "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
                  AbsolutePointSize[6], "ScalingFunctions" -> None, 
                  "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                    (Identity[#]& )[
                    Part[#, 1]], 
                    (Identity[#]& )[
                    Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                    (Identity[#]& )[
                    Part[#, 1]], 
                    (Identity[#]& )[
                    Part[#, 2]]}& )}}, 
                PlotRange -> {{0.20000000000004547`, 4.}, {0., 
                 714.2264760687242}}, PlotRangeClipping -> True, 
                PlotRangePadding -> {{
                   Scaled[0.1], 
                   Scaled[0.1]}, {
                   Scaled[0.1], 
                   Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
              GridBox[{{
                 RowBox[{
                   TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"0.20000000000004547`", ",", "4.`"}], "}"}], 
                    "}"}], "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["\"scalar\"", "SummaryItem"]}]}}, 
               GridBoxAlignment -> {
                "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, AutoDelete -> 
               False, GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
               GridBoxSpacings -> {
                "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
               BaseStyle -> {
                ShowStringCharacters -> False, NumberMarks -> False, 
                 PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
            GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> False, 
            GridBoxItemSize -> {
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
            BaselinePosition -> {1, 1}], True -> GridBox[{{
              PaneBox[
               ButtonBox[
                DynamicBox[
                 FEPrivate`FrontEndResource[
                 "FEBitmaps", "SquareMinusIconMedium"]], 
                ButtonFunction :> (Typeset`open$$ = False), Appearance -> 
                None, Evaluator -> Automatic, Method -> "Preemptive"], 
               Alignment -> {Center, Center}, ImageSize -> 
               Dynamic[{
                 Automatic, 3.5 CurrentValue["FontCapHeight"]/
                  AbsoluteCurrentValue[Magnification]}]], 
              GraphicsBox[{{{{}, {}, 
                  TagBox[{
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    LineBox[CompressedData["
1:eJwB0QMu/CFib1JlAgAAADwAAAACAAAAZ6DpI5qZyT/KFWvTD80BQEWwNjG8
w9A/hsQzyS5IDUAWA986ChDVPzeRrS1lNhZAqdn38G0T2T+w7MhNtoMeQKqD
KGiqAt0/BJAjUrLlI0A00N/koqPgPxmyYBkzkSlAdaDja3uh4j+mBHxaU3Uv
QBWqGmgDyuQ/V2KZxCRAM0Bsnd3Ed+jmP3XO9iJeCzdApNLY93bi6D/aiEEw
/+E6QDxBB6AlB+s/kHnwE8B1P0C18W0eXwftPyau8PuyCUJA5Ytg/YT97j/1
hBOcbnNEQLovwygtj/A/sywvlTkqR0ByOvI9XY3xP19S5uUwzUlA2uG6DeWg
8j+neuqeZ9hMQB1+yQ1jr/M/o1hdsKECUEBRO/R4pqv0P9pTl5l5k1FANZW4
nkG99T8QIwrpel5TQAoQmS+ivPY/aO4QnxciVUCOJxN7WtH3P/qg1yoxJVdA
7TPT9gjh+D+FGhv1bzlZQD1hr9183vk/MlW+yhVCW0A9KyV/SPH6P+vE8UOs
jV1ALha3i9nx+z/aV8RJAAVgQPr1jshg7fw/SBh8uUdQYUB2cgDAP/79P7I5
+J9Rw2JA4g+OIuT8/j92Ev17wyhkQP+k2h9wCABArGuMcES4ZUB7PJFG6Y8A
QMrG5OOgTGdAb+TVIkUOAUB0V5Klj9BoQLtaZ9xMlwFAzz8+L/CAakB/4YZL
NxcCQKoqaRd3H2xAsWLJ0pyUAkD921uBAMBtQDuyWDeuHANAqzapW1SPb0A9
EnZRopsDQGTXM8IcpXBAl0DgSEIlBEDL7fEN75pxQGl/2PXEpQRA9UcYGt6F
ckCpuPO6wiMFQGOwcp08cXNAQcBbXWysBUDQsleFK3Z0QFHYUbX4KwZAnJFu
LfludUC5vpTqMLYGQBHuXipUgnZAj5/6N+Q9B0CgJt+8dZZ3QN2Q7jp6vAdA
3+2ddTadeECDUC8bvEUIQCWPWSG/v3lAoSD+sODFCEBZ+jxbRdR6QC3r716A
QwlA7EXiyE7oe0ARhC7qy8sJQA6DLPhUGX1AbS37KvpKCkBU+8rpJzt+QCGl
FEnU1ApAgD26V/d6f0BDF1F/KVwLQLzscRRPXYBA3Zkba2HaC0CaaaIz3vSA
QM/qMjRFYwxAcf/oOQucgUA5TNiyC+MMQACdZbq3OoJA+3vKDn5tDUCXcwW8
gumCQCum34Jr9Q1AkU5m5QaYg0DT4IKsO3QOQMTf3R5wPYRA0+lys7f9DkAE
IiNymvOEQEsD8W8Wfg9Asm7zmFughUD6/1r3//8PQPpjr9LPUYZAXt/CbA==

                    "]]}, 
                   Annotation[#, 
                    "Charting`Private`Tag$40394#1"]& ]}}, {}, {}}, {
               DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
                AxesOrigin -> {0, 0}, FrameTicks -> {{{}, {}}, {{}, {}}}, 
                GridLines -> {None, None}, DisplayFunction -> Identity, 
                PlotRangePadding -> {{
                   Scaled[0.1], 
                   Scaled[0.1]}, {
                   Scaled[0.1], 
                   Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                All, DisplayFunction -> Identity, AspectRatio -> 1, 
                Axes -> {False, False}, AxesLabel -> {None, None}, 
                AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
                Frame -> {{True, True}, {True, True}}, 
                FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                Directive[
                  Opacity[0.5], 
                  Thickness[Tiny], 
                  RGBColor[0.368417, 0.506779, 0.709798]], 
                FrameTicks -> {{None, None}, {None, None}}, 
                GridLines -> {None, None}, GridLinesStyle -> Directive[
                  GrayLevel[0.5, 0.4]], ImageSize -> 
                Dynamic[{
                  Automatic, 3.5 CurrentValue["FontCapHeight"]/
                   AbsoluteCurrentValue[Magnification]}], 
                Method -> {
                 "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
                  AbsolutePointSize[6], "ScalingFunctions" -> None, 
                  "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                    (Identity[#]& )[
                    Part[#, 1]], 
                    (Identity[#]& )[
                    Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                    (Identity[#]& )[
                    Part[#, 1]], 
                    (Identity[#]& )[
                    Part[#, 2]]}& )}}, 
                PlotRange -> {{0.20000000000004547`, 4.}, {0., 
                 714.2264760687242}}, PlotRangeClipping -> True, 
                PlotRangePadding -> {{
                   Scaled[0.1], 
                   Scaled[0.1]}, {
                   Scaled[0.1], 
                   Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
              GridBox[{{
                 RowBox[{
                   TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"0.20000000000004547`", ",", "4.`"}], "}"}], 
                    "}"}], "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["\"scalar\"", "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Order: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["3", "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Method: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["\"Hermite\"", "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Periodic: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["False", "SummaryItem"]}]}}, 
               GridBoxAlignment -> {
                "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, AutoDelete -> 
               False, GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
               GridBoxSpacings -> {
                "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
               BaseStyle -> {
                ShowStringCharacters -> False, NumberMarks -> False, 
                 PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
            GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> False, 
            GridBoxItemSize -> {
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
            BaselinePosition -> {1, 1}]}, 
         Dynamic[Typeset`open$$], ImageSize -> Automatic], BaselinePosition -> 
        Baseline], DynamicModuleValues :> {}], 
      StyleBox["]", "NonInterpretableSummary"]}]},
   "CopyTag",
   DisplayFunction->(#& ),
   InterpretationFunction->("InterpolatingFunction[{{0.2, 4.}}, <>]"& )],
  False,
  Editable->False,
  SelectWithContents->True,
  Selectable->False]], "Output",
 CellChangeTimes->{3.726235995255*^9, 3.726239207005*^9, 3.726240725686*^9, 
  3.726243301682*^9},ExpressionUUID->"fcf51c2c-89ed-4650-ad4a-5327b26466e1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"h", "\[Rule]", "2.139401539414288`"}], "}"}]], "Output",
 CellChangeTimes->{3.726235995255*^9, 3.726239207005*^9, 3.726240725686*^9, 
  3.726243301691*^9},ExpressionUUID->"5b66c2ff-3532-47cc-ab4d-4ba94b057873"]
}, Open  ]],

Cell[BoxData[" "], "Input",
 CellChangeTimes->{{3.726236029142*^9, 3.72623603277*^9}, 
   3.7262360919820004`*^9},ExpressionUUID->"09090cf8-1793-45b5-8274-\
68fce9d81229"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{
   RowBox[{"alt", "=", 
    RowBox[{"zmin", "+", "2.14"}]}], "\[IndentingNewLine]", " ", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ival", "=", 
     RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"xval", "=", 
     RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Do", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"profil", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "2"}], "]"}], "]"}], "\[LessEqual]", "alt", "<=", 
          RowBox[{"profil", "[", 
           RowBox[{"[", 
            RowBox[{
             RowBox[{"i", "+", "1"}], ",", "2"}], "]"}], "]"}]}], "||", 
         RowBox[{
          RowBox[{"profil", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "2"}], "]"}], "]"}], "\[GreaterEqual]", " ", 
          "alt", "\[GreaterEqual]", 
          RowBox[{"profil", "[", 
           RowBox[{"[", 
            RowBox[{
             RowBox[{"i", "+", "1"}], ",", "2"}], "]"}], "]"}]}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"AppendTo", "[", 
          RowBox[{"ival", ",", "i"}], "]"}], ";", "\[IndentingNewLine]", 
         RowBox[{"interp", "=", 
          RowBox[{"Interpolation", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"profil", "[", 
               RowBox[{"[", "i", "  ", "]"}], "]"}], ",", 
              RowBox[{"profil", "[", 
               RowBox[{"[", 
                RowBox[{"i", "+", "1"}], " ", "]"}], "]"}]}], "}"}], ",", 
            RowBox[{"InterpolationOrder", "\[Rule]", "1"}]}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"xc", "=", 
          RowBox[{"x", "/.", 
           RowBox[{
            RowBox[{"FindRoot", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"interp", "[", "x", "]"}], "\[Equal]", "alt"}], ",", 
              RowBox[{"{", 
               RowBox[{"x", ",", 
                RowBox[{"profil", "[", 
                 RowBox[{"[", 
                  RowBox[{
                   RowBox[{"i", "+", "1"}], ",", "1"}], "]"}], "]"}]}], 
               "}"}]}], "]"}], "[", 
            RowBox[{"[", "1", "]"}], "]"}]}]}], ";", 
         RowBox[{"Print", "[", 
          RowBox[{"\"\<i =\>\"", ",", "i", ",", "\"\< x = \>\"", ",", "xc"}], 
          "]"}], ";", 
         RowBox[{"AppendTo", "[", 
          RowBox[{"xval", ",", "xc"}], "]"}], ";"}]}], "\[IndentingNewLine]", 
       "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", 
        RowBox[{"n", "-", "1"}]}], "}"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"il", ",", "ir"}], "}"}], "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"First", "@", "ival"}], ",", 
       RowBox[{"Last", "@", "ival"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"xl", ",", "xr"}], "}"}], "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"First", "@", "xval"}], ",", 
       RowBox[{"Last", "@", "xval"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"set", "=", 
     RowBox[{"Join", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"xl", ",", "alt"}], "}"}], "}"}], ",", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"profil", "[", 
          RowBox[{"[", "i", "]"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", 
           RowBox[{"il", "+", "1"}], ",", "ir"}], "}"}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"xr", ",", "alt"}], "}"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[Chi]", "=", 
     RowBox[{"ArcLength", "@", 
      RowBox[{"Line", "[", "set", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"S", "=", 
     RowBox[{"NIntegrate", "[", 
      RowBox[{
       RowBox[{"alt", " ", "-", 
        RowBox[{"profilInterp", "[", "x", "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "xl", ",", "xr"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Rh", "=", 
     RowBox[{"S", "/", "\[Chi]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"Q", "=", 
    RowBox[{"S", " ", 
     RowBox[{"Rh", "^", 
      RowBox[{"(", 
       RowBox[{"2", "/", "3"}], ")"}]}], " ", 
     RowBox[{"Sqrt", "[", "pente", "]"}], " ", "K"}]}], "\[IndentingNewLine]",
    " "}]}]], "Input",
 CellChangeTimes->{{3.726236096017*^9, 3.726236139051*^9}, {3.726239212269*^9,
   3.726239247734*^9}, {3.72624078179*^9, 3.726240785001*^9}, {
  3.7262433065629997`*^9, 
  3.726243306816*^9}},ExpressionUUID->"04ef088c-cdc1-424e-87a0-6bde6e11b588"],

Cell[BoxData["1137.7`"], "Output",
 CellChangeTimes->{{3.726236135211*^9, 3.7262361397939997`*^9}, {
   3.726239214106*^9, 3.726239247984*^9}, 3.726240728785*^9, 
   3.7262407858199997`*^9, 
   3.726243307073*^9},ExpressionUUID->"33a9776b-367c-491f-b467-1f72fb166bbc"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "20.864769230769145`"}],
  SequenceForm["i =", 5, " x = ", 20.864769230769145`],
  Editable->False]], "Print",
 CellChangeTimes->{{3.726236135215*^9, 3.726236139803*^9}, {3.726239214113*^9,
    3.726239247988*^9}, 3.72624072879*^9, 3.726240785824*^9, 
   3.7262433070769997`*^9},ExpressionUUID->"41fdb092-5ae6-47ce-bada-\
75ae3afec15c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "39.10302439024398`"}],
  SequenceForm["i =", 11, " x = ", 39.10302439024398],
  Editable->False]], "Print",
 CellChangeTimes->{{3.726236135215*^9, 3.726236139803*^9}, {3.726239214113*^9,
    3.726239247988*^9}, 3.72624072879*^9, 3.726240785824*^9, 
   3.72624330708*^9},ExpressionUUID->"479595ac-6601-41c5-a44e-14e5ec7448c4"]
}, Open  ]],

Cell[BoxData["200.11955241677185`"], "Output",
 CellChangeTimes->{{3.726236135211*^9, 3.7262361397939997`*^9}, {
   3.726239214106*^9, 3.726239247984*^9}, 3.726240728785*^9, 
   3.7262407858199997`*^9, 
   3.726243307084*^9},ExpressionUUID->"b8bb879c-153d-49f8-998e-1d4635e7ea73"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"des1", "=", 
  RowBox[{"Show", "[", 
   RowBox[{
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"profilInterp", "[", "x", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "xl", ",", "xr"}], "}"}]}], "]"}], ",", 
    RowBox[{"Plot", "[", 
     RowBox[{"alt", ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "xl", ",", "xr"}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", "Dashed"}]}], " ", "]"}], " ", ",", 
    RowBox[{"Frame", "\[Rule]", "True"}], ",", 
    RowBox[{"FrameLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<\!\(\*
StyleBox[\"x\",
FontSlant->\"Italic\"]\)\!\(\*
StyleBox[\" \",
FontSlant->\"Italic\"]\)(m)\>\"", ",", "\"\<\!\(\*
StyleBox[\"z\",
FontSlant->\"Italic\"]\)\!\(\*
StyleBox[\" \",
FontSlant->\"Italic\"]\)(m)\>\""}], "}"}]}], ",", 
    RowBox[{"BaseStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"FontFamily", "->", "\"\<Times\>\""}], ",", "14"}], "}"}]}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.7262361432539997`*^9, 3.726236190376*^9}, {
  3.7262389987869997`*^9, 3.726239033442*^9}, {3.7262392680439997`*^9, 
  3.726239281119*^9}, {3.7262394803380003`*^9, 
  3.7262394844560003`*^9}},ExpressionUUID->"eee5f64b-bcea-4a40-8c3a-\
e46947aeb702"],

Cell[BoxData[
 GraphicsBox[{{{{{}, {}, 
      TagBox[{
        {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
         Opacity[1.], LineBox[CompressedData["
1:eJxF2Gk4Vd0XAPBKURINCJmKKLO67rnXcO86jjKWOaWEihQhESLKUEivZKgo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          "]]}},
       Annotation[#, "Charting`Private`Tag$40486#1"]& ]}}, {}, {}}, {{{{}, {}, 
      TagBox[{
        {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
         Opacity[1.], Dashing[{Small, Small}], LineBox[CompressedData["
1:eJxTTMoPSmViYGAwAWIQzRaX3ZV418Th7BkgODbRwT7T38qE2xTOrygxfsVm
ieArWs/bnTgHwX+gH8yu/hPBF6uTKpUKMYPzm2taQg5vQ/DZV1qsuyZkDucf
au2vnF+G4H/Z/SNt2g0E31ZhzbnvxhZw/l4TphV80xH84PJFv/s/I/gJwqGF
9n6WcP6S+FURSzYg+P9veu4q5rGC8yey9PT+yEfwZ3U8aFp9EcHfZVX/6YSO
NZwvOPfA5dn9CH6dro/+zdcIvnJe1Z/T/jZwvh3H7tdvNiL4BRdcQyt4beH8
mx7FBjsLEPzI969aU84i+AHvS/7aatgh7Ju/8NmZLgT/UK2E17FnCL4dj5F8
qZc9nG/wJVYsaA2CL8v66vAZZgdE+GaUmXqbIvgZj9Sf1CUj+P6djxafnIDg
B3bkybw/iODHz5O/dPI9gt/Bs8ihXtEREV8TPd+89Efw1zr/WpFdi+Dv9K2R
O7EOwb+Qp3zx5h0En/nFbJtjfE5w/sde2Z0n7RH8V15HippyEfz/8TZPRecj
+PI9N6fEnUXwfz+pD933C8H/NPX7uR/azoj0Fzul9UUkgh9ged2kpxjBXysi
9US/F8EHADlh3F0=
          "]]}},
       Annotation[#, "Charting`Private`Tag$40527#1"]& ]}}, {}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{20.864769230769145`, 1135.56},
  BaseStyle->{FontFamily -> "Times", 14},
  DisplayFunction->Identity,
  Frame->True,
  FrameLabel->{
    FormBox[
    "\"\\!\\(\\*\\nStyleBox[\\\"x\\\",\\nFontSlant->\\\"Italic\\\"]\\)\\!\\(\\\
*\\nStyleBox[\\\" \\\",\\nFontSlant->\\\"Italic\\\"]\\)(m)\"", 
     TraditionalForm], 
    FormBox[
    "\"\\!\\(\\*\\nStyleBox[\\\"z\\\",\\nFontSlant->\\\"Italic\\\"]\\)\\!\\(\\\
*\\nStyleBox[\\\" \\\",\\nFontSlant->\\\"Italic\\\"]\\)(m)\"", 
     TraditionalForm]},
  FrameTicks->FrontEndValueCache[{{Automatic, 
      Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
      Charting`ScaledFrameTicks[{Identity, Identity}]}}, {{
     Automatic, {{1135.5, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.01, 
        0.}, {
         AbsoluteThickness[0.1]}}, {1136., 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.01, 
        0.}, {
         AbsoluteThickness[0.1]}}, {1136.5, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.01, 
        0.}, {
         AbsoluteThickness[0.1]}}, {1137., 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.01, 
        0.}, {
         AbsoluteThickness[0.1]}}, {1137.5, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.01, 
        0.}, {
         AbsoluteThickness[0.1]}}, {1135., 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {1135.1, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {1135.2, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {1135.3, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {1135.4, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {1135.6, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {1135.7, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {1135.8, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {1135.9, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {1136.1, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {1136.2, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {1136.3, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {1136.4, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {1136.6, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {1136.7, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {1136.8, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {1136.9, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {1137.1, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {1137.2, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {1137.3, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {1137.4, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {1137.6, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {1137.7, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {1137.8, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {1137.9, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {1138., 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}}}, {Automatic, {{22.5, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.01, 
        0.}, {
         AbsoluteThickness[0.1]}}, {25., 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.01, 
        0.}, {
         AbsoluteThickness[0.1]}}, {27.5, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.01, 
        0.}, {
         AbsoluteThickness[0.1]}}, {30., 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.01, 
        0.}, {
         AbsoluteThickness[0.1]}}, {32.5, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.01, 
        0.}, {
         AbsoluteThickness[0.1]}}, {35., 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.01, 
        0.}, {
         AbsoluteThickness[0.1]}}, {37.5, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.01, 
        0.}, {
         AbsoluteThickness[0.1]}}, {20., 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {20.5, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {21., 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {21.5, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {22., 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {23., 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {23.5, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {24., 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {24.5, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {25.5, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {26., 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {26.5, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {27., 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {28., 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {28.5, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {29., 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {29.5, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {30.5, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {31., 
        FormBox[
         InterpretationBox[
          StyleBox[
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {31.5, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {32., 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {33., 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {33.5, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {34., 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {34.5, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {35.5, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {36., 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {36.5, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {37., 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {38., 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {38.5, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {39., 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {39.5, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {40., 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}}}}],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{20.864769230769145`, 39.10302439024398}, {1135.56, 
   1137.6999996984075`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.726239034332*^9, 3.7262392514110003`*^9, 
  3.72623928192*^9, 3.72623948565*^9, 3.726240731222*^9, 3.726240789343*^9, 
  3.726243310277*^9},ExpressionUUID->"6b95f77e-fcf7-456e-92ce-af87c2da877d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"14", "*", 
  RowBox[{
  "1.5", "/", 
   "2"}]}], "\[IndentingNewLine]", "S", "\[IndentingNewLine]", "Rh"}], "Input",
 CellChangeTimes->{{3.726236222825*^9, 
  3.7262362778780003`*^9}},ExpressionUUID->"15495df9-ab67-4ab1-8f47-\
28a94e95c3e3"],

Cell[BoxData["10.5`"], "Output",
 CellChangeTimes->{{3.726236254389*^9, 
  3.726236279014*^9}},ExpressionUUID->"e58e34b4-adcc-47c3-b390-b208860c8faa"],

Cell[BoxData["9.392653846152372`"], "Output",
 CellChangeTimes->{{3.726236254389*^9, 
  3.726236279025*^9}},ExpressionUUID->"e8914f8b-85ee-4ecd-b5d1-b0b226bac0c6"],

Cell[BoxData["15.458828223640888`"], "Output",
 CellChangeTimes->{{3.726236254389*^9, 
  3.7262362790290003`*^9}},ExpressionUUID->"f50337db-216b-4d2e-83f4-\
7c103c927a1f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Export", "[", 
  RowBox[{"\"\<section2.eps\>\"", ",", "des1", ",", "\"\<EPS\>\""}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Export", "[", 
  RowBox[{"\"\<debitance2.eps\>\"", ",", "deb1", ",", "\"\<EPS\>\""}], 
  "]"}], "\[IndentingNewLine]", "pente", "\[IndentingNewLine]", 
 RowBox[{"alt", "-", "zmin"}], "\[IndentingNewLine]", "alt"}], "Input",
 CellChangeTimes->{{3.726239511822*^9, 3.726239544264*^9}, {3.726240284528*^9,
   3.726240313686*^9}, {3.726240349039*^9, 3.7262403552390003`*^9}, {
  3.726240737948*^9, 
  3.726240739928*^9}},ExpressionUUID->"b57e74fd-7b34-4a0d-8b16-ce4038ea3da0"],

Cell[BoxData["\<\"section2.eps\"\>"], "Output",
 CellChangeTimes->{
  3.726239546244*^9, {3.726240286729*^9, 3.7262403149449997`*^9}, 
   3.726240356417*^9, 3.726240740539*^9, 3.7262407930950003`*^9, 
   3.726243315104*^9},ExpressionUUID->"31854186-fe50-4c46-8d53-a51c3b40e585"],

Cell[BoxData["\<\"debitance2.eps\"\>"], "Output",
 CellChangeTimes->{
  3.726239546244*^9, {3.726240286729*^9, 3.7262403149449997`*^9}, 
   3.726240356417*^9, 3.726240740539*^9, 3.7262407930950003`*^9, 
   3.726243315366*^9},ExpressionUUID->"50a2018a-9756-4527-9023-6bcdf81e844e"],

Cell[BoxData["0.05263157894736842`"], "Output",
 CellChangeTimes->{
  3.726239546244*^9, {3.726240286729*^9, 3.7262403149449997`*^9}, 
   3.726240356417*^9, 3.726240740539*^9, 3.7262407930950003`*^9, 
   3.726243315369*^9},ExpressionUUID->"3b32d976-b606-4e69-b641-affe0e27645d"],

Cell[BoxData["2.1400000000001`"], "Output",
 CellChangeTimes->{
  3.726239546244*^9, {3.726240286729*^9, 3.7262403149449997`*^9}, 
   3.726240356417*^9, 3.726240740539*^9, 3.7262407930950003`*^9, 
   3.7262433153710003`*^9},ExpressionUUID->"e333ebd7-5bd8-4bc9-90be-\
1dc228e115c2"],

Cell[BoxData["1137.7`"], "Output",
 CellChangeTimes->{
  3.726239546244*^9, {3.726240286729*^9, 3.7262403149449997`*^9}, 
   3.726240356417*^9, 3.726240740539*^9, 3.7262407930950003`*^9, 
   3.726243315374*^9},ExpressionUUID->"ab19ce09-14c5-4ec9-938f-2962652a5341"]
}, Open  ]],

Cell[BoxData["1"], "Input",
 CellChangeTimes->{
  3.726239864301*^9},ExpressionUUID->"ec3de3c7-084f-461e-8cca-6379144e780d"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Profil 3", "Section",
 CellChangeTimes->{{3.726232366929*^9, 3.726232384227*^9}, 
   3.7262407036289997`*^9, 
   3.726240898671*^9},ExpressionUUID->"f196365d-959a-4010-afb6-86a7424f8a67"],

Cell[CellGroupData[{

Cell["lecture", "Subsection",
 CellChangeTimes->{{3.726232366929*^9, 3.726232384227*^9}, {3.726232447131*^9,
   3.726232449347*^9}},ExpressionUUID->"82f12620-edce-4c35-abb2-1dba30981b9c"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"profil", "=", 
  RowBox[{"ToExpression", "@", 
   RowBox[{"ReadList", "[", 
    RowBox[{"\"\<profil_3.txt\>\"", ",", "Word", ",", 
     RowBox[{"RecordLists", "\[Rule]", "True"}], ",", 
     RowBox[{"WordSeparators", "\[Rule]", "\"\<,\>\""}]}], 
    "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{"ListLinePlot", "[", 
  RowBox[{"profil", ",", 
   RowBox[{"AspectRatio", "\[Rule]", "1"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"n", "=", 
  RowBox[{"Length", "[", "profil", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"profilInterp", "=", 
  RowBox[{"Interpolation", "[", 
   RowBox[{"profil", ",", 
    RowBox[{"InterpolationOrder", "\[Rule]", "1"}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"zmin", "=", 
  RowBox[{"Min", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"#", "[", 
      RowBox[{"[", "2", "]"}], "]"}], "&"}], "/@", "profil"}], 
   "]"}]}]}], "Input",
 CellChangeTimes->{{3.7262252160959997`*^9, 3.7262252218710003`*^9}, {
   3.726225308633*^9, 3.72622531775*^9}, {3.7262259504639997`*^9, 
   3.726225965406*^9}, {3.726232362781*^9, 3.726232363865*^9}, {
   3.726232403023*^9, 3.726232429034*^9}, 3.726240709807*^9, 
   3.7262409059119997`*^9},ExpressionUUID->"1e5cf15b-202f-40ed-98e9-\
2736ff7ed5e6"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.`", ",", "1087.22`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.`", ",", "1086.62`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5.75`", ",", "1086.42`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9.`", ",", "1086.32`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"11.75`", ",", "1085.82`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"14.06`", ",", "1085.52`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"17.25`", ",", "1085.02`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"20.69`", ",", "1084.52`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"23.5`", ",", "1083.52`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"27.12`", ",", "1082.62`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"30.19`", ",", "1081.92`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"32.44`", ",", "1081.92`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"34.19`", ",", "1081.72`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"36.12`", ",", "1081.62`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"37.56`", ",", "1081.52`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"39.62`", ",", "1080.92`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"40.94`", ",", "1080.52`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"42.69`", ",", "1080.32`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"44.31`", ",", "1080.32`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"46.06`", ",", "1079.92`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"47.44`", ",", "1079.72`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"49.19`", ",", "1079.92`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"50.38`", ",", "1080.02`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"52.94`", ",", "1080.02`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"54.44`", ",", "1081.62`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"55.88`", ",", "1082.22`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"57.44`", ",", "1082.52`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"59.44`", ",", "1082.42`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"61.75`", ",", "1082.32`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"63.75`", ",", "1082.22`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"67.06`", ",", "1082.42`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"70.69`", ",", "1082.72`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"74.75`", ",", "1083.02`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"79.62`", ",", "1083.32`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"84.`", ",", "1083.52`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"87.12`", ",", "1083.62`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"91.75`", ",", "1083.72`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"96.5`", ",", "1083.92`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"101.`", ",", "1084.22`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"104.44`", ",", "1085.72`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"106.06`", ",", "1085.82`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"110.19`", ",", "1085.82`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"114.44`", ",", "1085.62`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"114.5`", ",", "1085.62`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"116.12`", ",", "1085.52`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"120.44`", ",", "1085.72`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"125.38`", ",", "1085.92`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"129.31`", ",", "1086.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"132.06`", ",", "1086.52`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"135.38`", ",", "1086.42`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"138.62`", ",", "1086.42`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"140.`", ",", "1086.52`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"143.31`", ",", "1086.72`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"147.44`", ",", "1086.92`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"151.81`", ",", "1087.02`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"155.75`", ",", "1087.22`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"161.06`", ",", "1087.32`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"165.5`", ",", "1087.22`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"170.06`", ",", "1087.22`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"173.`", ",", "1087.22`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"177.19`", ",", "1087.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"180.56`", ",", "1086.92`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"182.44`", ",", "1086.72`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"184.19`", ",", "1086.52`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"185.75`", ",", "1086.22`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"187.12`", ",", "1085.82`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"188.81`", ",", "1085.02`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"190.12`", ",", "1085.22`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"191.69`", ",", "1085.52`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"192.69`", ",", "1085.82`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"194.12`", ",", "1085.92`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"197.31`", ",", "1085.92`"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.726225222749*^9, {3.726225313972*^9, 3.726225318549*^9}, 
   3.726225966208*^9, {3.7262323876540003`*^9, 3.726232430127*^9}, 
   3.726232721483*^9, 3.726232768483*^9, 3.72623296151*^9, 3.726233207597*^9, 
   3.7262332696619997`*^9, 3.726235891734*^9, 3.7262407101029997`*^9, 
   3.726240906193*^9, 
   3.7262433423199997`*^9},ExpressionUUID->"14ac3f15-a0e6-495c-8e7b-\
cf1e866394f2"],

Cell[BoxData[
 GraphicsBox[{{}, {{{}, {}, {
      {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
       0.016666666666666666`], AbsoluteThickness[1.6], LineBox[CompressedData["
1:eJxVkz1IW1EUx4ODSheXoA7FVgc/wMFCwYC0XD8TjZ8RRW1ak6h5Tn5sYheL
uAk+txYcAroIEjJmtkO3Orq1RkFrqjYUTdUq+N79n3PCDYTH757/+Z9z77m3
OjYfminyeDwB5+9++ffRm/RnHmwFKlUuLt8zV6hAZtmbvGOuUS76mVfqwP9s
9WLt91C6qlG56d48xdUr8LWtFt88O9xOvQb/5fxm8BXnt6B+lvRNb1H/zFbp
KkfgUyZXtird/6mtNvZv6sNlbch3WOu+tcGf4wftWD+h/KUOxI+Jxzqxnwzl
13WZXOLH9yfp037U/0H8OSBx9N8N/yOu12OyLyj9an0uCL9f7N8LfZa5D/7n
dH5H/ehPeEDydxYcw6+Dog+7B7A3hHiW9KkQ/C9of2fD8LvkeY/IfHCeI+j3
iuK5UfgxvxyD7g/PfxzxHNV/PgHOU3+rE3J/dHz9nclbYdTj+5QoMObxXu4b
/D+IP+Y5CZ3jF3IXGiLIvyX+FEH+PeVfROS+6/6Go+b9X4mKXuefR1HPYb0+
F4P+P8XvYljn97U0pfi96Xj1NPb7yPOYNuOtM8p4n4kCa9/aOPbD+s241Nfx
73Gzv2JL+td+PgvxW9rvlCXnr/2+WPJ+cZ9If01+eUvOX3/LZyVf69tnzfPf
LfATvjz25w==
        "]]}}}}, {}, {}, {{}, {}}, {{}, {}}},
  AspectRatio->1,
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 1079.3400000000001`},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->{941., Automatic},
  Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 197.31}, {1079.72, 1087.32}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.726225222749*^9, {3.726225313972*^9, 3.726225318549*^9}, 
   3.726225966208*^9, {3.7262323876540003`*^9, 3.726232430127*^9}, 
   3.726232721483*^9, 3.726232768483*^9, 3.72623296151*^9, 3.726233207597*^9, 
   3.7262332696619997`*^9, 3.726235891734*^9, 3.7262407101029997`*^9, 
   3.726240906193*^9, 
   3.726243342352*^9},ExpressionUUID->"3950a5a9-32e8-4d2e-9a56-68370ea24ccb"],

Cell[BoxData["72"], "Output",
 CellChangeTimes->{
  3.726225222749*^9, {3.726225313972*^9, 3.726225318549*^9}, 
   3.726225966208*^9, {3.7262323876540003`*^9, 3.726232430127*^9}, 
   3.726232721483*^9, 3.726232768483*^9, 3.72623296151*^9, 3.726233207597*^9, 
   3.7262332696619997`*^9, 3.726235891734*^9, 3.7262407101029997`*^9, 
   3.726240906193*^9, 
   3.726243342356*^9},ExpressionUUID->"ffb6a285-ebd0-4310-9265-21367a829c10"],

Cell[BoxData[
 TagBox[
  TemplateBox[{RowBox[{
      StyleBox[
       TagBox["InterpolatingFunction", "SummaryHead"], 
       "NonInterpretableSummary"], 
      StyleBox["[", "NonInterpretableSummary"], 
      DynamicModuleBox[{Typeset`open$$ = False}, 
       PanelBox[
        PaneSelectorBox[{False -> GridBox[{{
              PaneBox[
               ButtonBox[
                DynamicBox[
                 FEPrivate`FrontEndResource[
                 "FEBitmaps", "SquarePlusIconMedium"]], 
                ButtonFunction :> (Typeset`open$$ = True), Appearance -> None,
                 Evaluator -> Automatic, Method -> "Preemptive"], 
               Alignment -> {Center, Center}, ImageSize -> 
               Dynamic[{
                 Automatic, 3.5 CurrentValue["FontCapHeight"]/
                  AbsoluteCurrentValue[Magnification]}]], 
              GraphicsBox[{{{{}, {}, 
                  TagBox[{
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    LineBox[CompressedData["
1:eJw90n9Q02UcB3DM6IZpIoGYxZRDz84rJz+lDfNNSzd+jI0FysQGY/uyxeSH
EMUJqYOIGC0eaPM8bUxBSCMJC4MDpUZwiGGjklha0dQDJgQCkkzpx8N51x/P
Pfe653nuPs/78/FPy5Yyj7m5uUXQtbg7ipjb51f0v9wTqBM4FggiE80FTIcH
Gs+ftWY8IEh/fuGnnIG1kDb4exAXgU9EQpBgPADmAQPLNE9wbmVsca1oMxpN
TwgNfxGELvOZjzRvRUXFrpKD9wi8rHyD3h6MzzO17OoZgmLCBK6WbUOwSjkc
M0lwNTTpGWEfF+a5M3bbHYKjlfrh+H+2QyXSuW6MErjckvaKLwJKq1AdSq02
LmtxJL+CLaJguWSEoKu6niOY5QPTuiV7btF6/dqD4s7thOOgd5PAQRBdPLnB
GiWAodlWoBgmeDvv45pBVhR8L4vbXNTVtiDupa+jkXo8eyL/JsGEu7PbUxaL
l7T8KZ2ToPLymiF3nzjs9611GahzGY09/Usx3mvVs2fHCMS9x5pD2iXYN+Tb
fZqeJ1dNl1qOxiNPwbnaTf9TJrwuhUqK/ONdE+3jBPaew7cC+a/B2xZQWT9B
INx6QSt7OgGry2pN6j8JOAO/v5sxnABWa/1nC9S8sB5F/8VEZJW2xubTvNTl
vDBVxW684BlY0kndWpv1fax2D1a9qkoKmSI4NG26zxYkIbr6OdsQNfOiaM0m
bxm8GnOLv7hLkMOxLhyekUE8ePtk5xzBCXaP/amuvY/yuk+wnX9pZ5khGWs7
JA27qJduyX1LkrEP1lWcN07S/jrdW2vE4a/jnamuI+HU9+ra9BZfOb69Ih//
jXodJzpr45gcotMtGQx9/82U7aaxJQWpkaEhLmo+r9ywOSoViYoN8cvpPIXl
59bXN6eit4F9YJSa58Vd17deAeFiQdQP+woVjg8VGOHmIZDOY0xBqcU4p8Cv
eTrZLHVTeeaOu6o0/BE/77Q8JDhV5XdjpD8N+wXdJbPU4hbBjh+DlFhuqRrL
ofO9kitxTz+lRCMvm/uAOuWr9b1GlgrmuklN+N8EVpPtjrZABdaBTbs9qIcr
53/eNqJC4eI40fuGI87Omljmf4uutbGaOhgY1M6AfmozWxKXFJCOvtHH54uo
//2uZ+7Tj9LhWSfwP0Pr8TNeYGaWqKF9P+dYAK3/ijTzh2saNZ7MVXot0Pz0
by61pNjViFgxOCin/bn+gUJTCg2KCkM+aaD5/RLz7KHxs5pH+VD/Bzrs1a0=

                    "]]}, 
                   Annotation[#, 
                    "Charting`Private`Tag$40703#1"]& ]}}, {}, {}}, {
               DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
                AxesOrigin -> {0, 1079.8451874209889`}, 
                FrameTicks -> {{{}, {}}, {{}, {}}}, GridLines -> {None, None},
                 DisplayFunction -> Identity, PlotRangePadding -> {{
                   Scaled[0.1], 
                   Scaled[0.1]}, {
                   Scaled[0.1], 
                   Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                All, DisplayFunction -> Identity, AspectRatio -> 1, 
                Axes -> {False, False}, AxesLabel -> {None, None}, 
                AxesOrigin -> {0, 1079.8451874209889`}, DisplayFunction :> 
                Identity, Frame -> {{True, True}, {True, True}}, 
                FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                Directive[
                  Opacity[0.5], 
                  Thickness[Tiny], 
                  RGBColor[0.368417, 0.506779, 0.709798]], 
                FrameTicks -> {{None, None}, {None, None}}, 
                GridLines -> {None, None}, GridLinesStyle -> Directive[
                  GrayLevel[0.5, 0.4]], ImageSize -> 
                Dynamic[{
                  Automatic, 3.5 CurrentValue["FontCapHeight"]/
                   AbsoluteCurrentValue[Magnification]}], 
                Method -> {
                 "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
                  AbsolutePointSize[6], "ScalingFunctions" -> None, 
                  "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                    (Identity[#]& )[
                    Part[#, 1]], 
                    (Identity[#]& )[
                    Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                    (Identity[#]& )[
                    Part[#, 1]], 
                    (Identity[#]& )[
                    Part[#, 2]]}& )}}, 
                PlotRange -> {{0., 197.31}, {1079.8451874209889`, 
                 1087.3050877845155`}}, PlotRangeClipping -> True, 
                PlotRangePadding -> {{
                   Scaled[0.1], 
                   Scaled[0.1]}, {
                   Scaled[0.1], 
                   Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
              GridBox[{{
                 RowBox[{
                   TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"0.`", ",", "197.31`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["\"scalar\"", "SummaryItem"]}]}}, 
               GridBoxAlignment -> {
                "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, AutoDelete -> 
               False, GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
               GridBoxSpacings -> {
                "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
               BaseStyle -> {
                ShowStringCharacters -> False, NumberMarks -> False, 
                 PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
            GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> False, 
            GridBoxItemSize -> {
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
            BaselinePosition -> {1, 1}], True -> GridBox[{{
              PaneBox[
               ButtonBox[
                DynamicBox[
                 FEPrivate`FrontEndResource[
                 "FEBitmaps", "SquareMinusIconMedium"]], 
                ButtonFunction :> (Typeset`open$$ = False), Appearance -> 
                None, Evaluator -> Automatic, Method -> "Preemptive"], 
               Alignment -> {Center, Center}, ImageSize -> 
               Dynamic[{
                 Automatic, 3.5 CurrentValue["FontCapHeight"]/
                  AbsoluteCurrentValue[Magnification]}]], 
              GraphicsBox[{{{{}, {}, 
                  TagBox[{
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    LineBox[CompressedData["
1:eJw90n9Q02UcB3DM6IZpIoGYxZRDz84rJz+lDfNNSzd+jI0FysQGY/uyxeSH
EMUJqYOIGC0eaPM8bUxBSCMJC4MDpUZwiGGjklha0dQDJgQCkkzpx8N51x/P
Pfe653nuPs/78/FPy5Yyj7m5uUXQtbg7ipjb51f0v9wTqBM4FggiE80FTIcH
Gs+ftWY8IEh/fuGnnIG1kDb4exAXgU9EQpBgPADmAQPLNE9wbmVsca1oMxpN
TwgNfxGELvOZjzRvRUXFrpKD9wi8rHyD3h6MzzO17OoZgmLCBK6WbUOwSjkc
M0lwNTTpGWEfF+a5M3bbHYKjlfrh+H+2QyXSuW6MErjckvaKLwJKq1AdSq02
LmtxJL+CLaJguWSEoKu6niOY5QPTuiV7btF6/dqD4s7thOOgd5PAQRBdPLnB
GiWAodlWoBgmeDvv45pBVhR8L4vbXNTVtiDupa+jkXo8eyL/JsGEu7PbUxaL
l7T8KZ2ToPLymiF3nzjs9611GahzGY09/Usx3mvVs2fHCMS9x5pD2iXYN+Tb
fZqeJ1dNl1qOxiNPwbnaTf9TJrwuhUqK/ONdE+3jBPaew7cC+a/B2xZQWT9B
INx6QSt7OgGry2pN6j8JOAO/v5sxnABWa/1nC9S8sB5F/8VEZJW2xubTvNTl
vDBVxW684BlY0kndWpv1fax2D1a9qkoKmSI4NG26zxYkIbr6OdsQNfOiaM0m
bxm8GnOLv7hLkMOxLhyekUE8ePtk5xzBCXaP/amuvY/yuk+wnX9pZ5khGWs7
JA27qJduyX1LkrEP1lWcN07S/jrdW2vE4a/jnamuI+HU9+ra9BZfOb69Ih//
jXodJzpr45gcotMtGQx9/82U7aaxJQWpkaEhLmo+r9ywOSoViYoN8cvpPIXl
59bXN6eit4F9YJSa58Vd17deAeFiQdQP+woVjg8VGOHmIZDOY0xBqcU4p8Cv
eTrZLHVTeeaOu6o0/BE/77Q8JDhV5XdjpD8N+wXdJbPU4hbBjh+DlFhuqRrL
ofO9kitxTz+lRCMvm/uAOuWr9b1GlgrmuklN+N8EVpPtjrZABdaBTbs9qIcr
53/eNqJC4eI40fuGI87Omljmf4uutbGaOhgY1M6AfmozWxKXFJCOvtHH54uo
//2uZ+7Tj9LhWSfwP0Pr8TNeYGaWqKF9P+dYAK3/ijTzh2saNZ7MVXot0Pz0
by61pNjViFgxOCin/bn+gUJTCg2KCkM+aaD5/RLz7KHxs5pH+VD/Bzrs1a0=

                    "]]}, 
                   Annotation[#, 
                    "Charting`Private`Tag$40703#1"]& ]}}, {}, {}}, {
               DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
                AxesOrigin -> {0, 1079.8451874209889`}, 
                FrameTicks -> {{{}, {}}, {{}, {}}}, GridLines -> {None, None},
                 DisplayFunction -> Identity, PlotRangePadding -> {{
                   Scaled[0.1], 
                   Scaled[0.1]}, {
                   Scaled[0.1], 
                   Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                All, DisplayFunction -> Identity, AspectRatio -> 1, 
                Axes -> {False, False}, AxesLabel -> {None, None}, 
                AxesOrigin -> {0, 1079.8451874209889`}, DisplayFunction :> 
                Identity, Frame -> {{True, True}, {True, True}}, 
                FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                Directive[
                  Opacity[0.5], 
                  Thickness[Tiny], 
                  RGBColor[0.368417, 0.506779, 0.709798]], 
                FrameTicks -> {{None, None}, {None, None}}, 
                GridLines -> {None, None}, GridLinesStyle -> Directive[
                  GrayLevel[0.5, 0.4]], ImageSize -> 
                Dynamic[{
                  Automatic, 3.5 CurrentValue["FontCapHeight"]/
                   AbsoluteCurrentValue[Magnification]}], 
                Method -> {
                 "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
                  AbsolutePointSize[6], "ScalingFunctions" -> None, 
                  "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                    (Identity[#]& )[
                    Part[#, 1]], 
                    (Identity[#]& )[
                    Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                    (Identity[#]& )[
                    Part[#, 1]], 
                    (Identity[#]& )[
                    Part[#, 2]]}& )}}, 
                PlotRange -> {{0., 197.31}, {1079.8451874209889`, 
                 1087.3050877845155`}}, PlotRangeClipping -> True, 
                PlotRangePadding -> {{
                   Scaled[0.1], 
                   Scaled[0.1]}, {
                   Scaled[0.1], 
                   Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
              GridBox[{{
                 RowBox[{
                   TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"0.`", ",", "197.31`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["\"scalar\"", "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Order: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["1", "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Method: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["\"Hermite\"", "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Periodic: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["False", "SummaryItem"]}]}}, 
               GridBoxAlignment -> {
                "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, AutoDelete -> 
               False, GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
               GridBoxSpacings -> {
                "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
               BaseStyle -> {
                ShowStringCharacters -> False, NumberMarks -> False, 
                 PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
            GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> False, 
            GridBoxItemSize -> {
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
            BaselinePosition -> {1, 1}]}, 
         Dynamic[Typeset`open$$], ImageSize -> Automatic], BaselinePosition -> 
        Baseline], DynamicModuleValues :> {}], 
      StyleBox["]", "NonInterpretableSummary"]}]},
   "CopyTag",
   DisplayFunction->(#& ),
   InterpretationFunction->("InterpolatingFunction[{{0., 197.31}}, <>]"& )],
  False,
  Editable->False,
  SelectWithContents->True,
  Selectable->False]], "Output",
 CellChangeTimes->{
  3.726225222749*^9, {3.726225313972*^9, 3.726225318549*^9}, 
   3.726225966208*^9, {3.7262323876540003`*^9, 3.726232430127*^9}, 
   3.726232721483*^9, 3.726232768483*^9, 3.72623296151*^9, 3.726233207597*^9, 
   3.7262332696619997`*^9, 3.726235891734*^9, 3.7262407101029997`*^9, 
   3.726240906193*^9, 
   3.726243342361*^9},ExpressionUUID->"1c9669b5-c2ee-4311-904d-692338bc7eaa"],

Cell[BoxData["1079.72`"], "Output",
 CellChangeTimes->{
  3.726225222749*^9, {3.726225313972*^9, 3.726225318549*^9}, 
   3.726225966208*^9, {3.7262323876540003`*^9, 3.726232430127*^9}, 
   3.726232721483*^9, 3.726232768483*^9, 3.72623296151*^9, 3.726233207597*^9, 
   3.7262332696619997`*^9, 3.726235891734*^9, 3.7262407101029997`*^9, 
   3.726240906193*^9, 
   3.726243342369*^9},ExpressionUUID->"e43681e9-15db-41e2-8ad1-9da042583115"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["test", "Subsection",
 CellChangeTimes->{{3.726232366929*^9, 3.726232384227*^9}, {3.726232447131*^9,
   3.726232462184*^9}},ExpressionUUID->"f6104d4c-e1c3-4aed-ad2d-65c026617555"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"profilInterp", "[", "x", "]"}], "\[Equal]", "1223"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "100"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7262254266029997`*^9, 3.726225465616*^9}, 
   3.726232970962*^9},ExpressionUUID->"0cc82559-2124-4461-be4c-b64172f9d48f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", "\[Rule]", "146.30999999999798`"}], "}"}]], "Output",
 CellChangeTimes->{{3.726225455278*^9, 3.7262254659440002`*^9}, 
   3.726232971256*^9, 3.726233213766*^9, 
   3.72623327438*^9},ExpressionUUID->"c4eb4c2e-597c-4b5f-93bc-1e6f103e8ae6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"alt", "=", "1224"}], "\[IndentingNewLine]", 
 RowBox[{" ", 
  RowBox[{
   RowBox[{"ival", "=", 
    RowBox[{"{", "}"}]}], ";"}]}], "\[IndentingNewLine]", 
 RowBox[{"xval", "=", 
  RowBox[{"{", "}"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Do", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"profil", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "2"}], "]"}], "]"}], "\[LessEqual]", "alt", "<=", 
        RowBox[{"profil", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"i", "+", "1"}], ",", "2"}], "]"}], "]"}]}], "||", 
       RowBox[{
        RowBox[{"profil", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "2"}], "]"}], "]"}], "\[GreaterEqual]", " ", 
        "alt", "\[GreaterEqual]", 
        RowBox[{"profil", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"i", "+", "1"}], ",", "2"}], "]"}], "]"}]}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"AppendTo", "[", 
        RowBox[{"ival", ",", "i"}], "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"interp", "=", 
        RowBox[{"Interpolation", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"profil", "[", 
             RowBox[{"[", "i", "  ", "]"}], "]"}], ",", 
            RowBox[{"profil", "[", 
             RowBox[{"[", 
              RowBox[{"i", "+", "1"}], " ", "]"}], "]"}]}], "}"}], ",", 
          RowBox[{"InterpolationOrder", "\[Rule]", "1"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"xc", "=", 
        RowBox[{"x", "/.", 
         RowBox[{
          RowBox[{"FindRoot", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"interp", "[", "x", "]"}], "\[Equal]", "alt"}], ",", 
            RowBox[{"{", 
             RowBox[{"x", ",", 
              RowBox[{"profil", "[", 
               RowBox[{"[", 
                RowBox[{
                 RowBox[{"i", "+", "1"}], ",", "1"}], "]"}], "]"}]}], "}"}]}],
            "]"}], "[", 
          RowBox[{"[", "1", "]"}], "]"}]}]}], ";", 
       RowBox[{"Print", "[", 
        RowBox[{"\"\<i =\>\"", ",", "i", ",", "\"\< x = \>\"", ",", "xc"}], 
        "]"}], ";", 
       RowBox[{"AppendTo", "[", 
        RowBox[{"xval", ",", "xc"}], "]"}], ";"}]}], "\[IndentingNewLine]", 
     "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", 
      RowBox[{"n", "-", "1"}]}], "}"}]}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.7262258536730003`*^9, 3.726225974487*^9}, {
   3.726226108792*^9, 3.726226133618*^9}, {3.726226317785*^9, 
   3.7262264099820004`*^9}, {3.726226449434*^9, 3.72622647455*^9}, {
   3.726226514075*^9, 3.726226570517*^9}, {3.726227020848*^9, 
   3.726227075016*^9}, {3.726227423367*^9, 3.726227427098*^9}, 
   3.7262329678929996`*^9, 
   3.726233299344*^9},ExpressionUUID->"2697a8b7-a0b0-4fd9-b9b3-9da2759fd5b6"],

Cell[BoxData["1224"], "Output",
 CellChangeTimes->{
  3.7262258573529997`*^9, 3.726225974858*^9, 3.726226134086*^9, 
   3.7262264111689997`*^9, {3.7262264709849997`*^9, 3.7262264752460003`*^9}, 
   3.726226519617*^9, {3.726226556707*^9, 3.726226571341*^9}, {
   3.7262270628599997`*^9, 3.726227075238*^9}, 3.726232968212*^9, 
   3.726233213925*^9, {3.7262332761470003`*^9, 
   3.726233300748*^9}},ExpressionUUID->"3cea6366-23d5-4d02-bc00-4036f1c0232d"],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 CellChangeTimes->{
  3.7262258573529997`*^9, 3.726225974858*^9, 3.726226134086*^9, 
   3.7262264111689997`*^9, {3.7262264709849997`*^9, 3.7262264752460003`*^9}, 
   3.726226519617*^9, {3.726226556707*^9, 3.726226571341*^9}, {
   3.7262270628599997`*^9, 3.726227075238*^9}, 3.726232968212*^9, 
   3.726233213925*^9, {3.7262332761470003`*^9, 
   3.726233300751*^9}},ExpressionUUID->"e43418d0-85e6-4870-8133-d6eb9a6fbf64"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "106.03249999999842`"}],
  SequenceForm["i =", 10, " x = ", 106.03249999999842`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232968219*^9, 3.726233213933*^9, {3.7262332761540003`*^9, 
   3.7262333007530003`*^9}},ExpressionUUID->"37f4b399-f0bc-49d4-879b-\
4d0e6e89a7e5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "28", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", "191.88`"}],
  SequenceForm["i =", 28, " x = ", 191.88],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232968219*^9, 3.726233213933*^9, {3.7262332761540003`*^9, 
   3.7262333007539997`*^9}},ExpressionUUID->"244d212c-8f0c-4803-a78b-\
6014e978f09f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "29", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", "191.88`"}],
  SequenceForm["i =", 29, " x = ", 191.88],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232968219*^9, 3.726233213933*^9, {3.7262332761540003`*^9, 
   3.726233300759*^9}},ExpressionUUID->"6a8c2fc2-1b00-4bdf-b2d0-75564a31cc9f"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.726226008226*^9, 3.7262260121280003`*^9}, {
  3.7262260723859997`*^9, 3.726226090521*^9}, {3.726227012104*^9, 
  3.726227018509*^9}},ExpressionUUID->"d94e9f99-b101-46ee-a97f-87e68ab47414"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"170.38`", ",", "1221.7`"}], "}"}]], "Output",
 CellChangeTimes->{
  3.726226017889*^9, {3.7262260727609997`*^9, 
   3.726226090895*^9}},ExpressionUUID->"1b05cef5-2daa-4121-8673-6d00b78541e4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"{", 
   RowBox[{"il", ",", "ir"}], "}"}], "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"First", "@", "ival"}], ",", 
    RowBox[{"Last", "@", "ival"}]}], "}"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"{", 
   RowBox[{"xl", ",", "xr"}], "}"}], "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"First", "@", "xval"}], ",", 
    RowBox[{"Last", "@", "xval"}]}], "}"}]}]}], "Input",
 CellChangeTimes->{{3.726227096816*^9, 3.726227114612*^9}, {
  3.7262329959960003`*^9, 
  3.72623301877*^9}},ExpressionUUID->"b62b7927-65e8-4f77-8b25-989b2b1ef935"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"10", ",", "29"}], "}"}]], "Output",
 CellChangeTimes->{
  3.726227114851*^9, 3.7262330197679996`*^9, 3.726233216243*^9, {
   3.726233281072*^9, 
   3.726233302632*^9}},ExpressionUUID->"9a700d1c-43bc-48e0-b9fe-3999de5133e1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"106.03249999999842`", ",", "191.88`"}], "}"}]], "Output",
 CellChangeTimes->{
  3.726227114851*^9, 3.7262330197679996`*^9, 3.726233216243*^9, {
   3.726233281072*^9, 
   3.7262333026359997`*^9}},ExpressionUUID->"ed7e56b1-05e9-4cfd-999c-\
67b22a7f5508"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{
   RowBox[{"alt", " ", "-", 
    RowBox[{"profilInterp", "[", "x", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "xl", ",", "xr"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7262264846289997`*^9, 3.726226486635*^9}, {
  3.726227089087*^9, 3.726227149316*^9}, {3.726227313462*^9, 
  3.7262273437720003`*^9}},ExpressionUUID->"23a935fa-53e0-4ddf-9f82-\
9523da809d95"],

Cell[BoxData["93.80812500000039`"], "Output",
 CellChangeTimes->{
  3.7262264869230003`*^9, {3.7262271299820004`*^9, 3.72622715016*^9}, {
   3.726227314823*^9, 3.72622734446*^9}, 3.7262330246099997`*^9, 
   3.726233217365*^9, {3.726233284427*^9, 
   3.726233303733*^9}},ExpressionUUID->"fd154355-35ca-4b0a-bb96-1897656c6b4b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"long", "=", 
  RowBox[{
   RowBox[{"Sqrt", "[", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"profil", "[", 
        RowBox[{"[", 
         RowBox[{"il", " ", "+", "1"}], " ", "]"}], "]"}], "-", 
       RowBox[{"{", 
        RowBox[{"xl", ",", "alt"}], "}"}]}], ")"}], ".", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"profil", "[", 
        RowBox[{"[", 
         RowBox[{"il", "+", "1"}], "  ", "]"}], "]"}], "-", " ", 
       RowBox[{"{", 
        RowBox[{"xl", ",", "alt"}], "}"}]}], ")"}]}], "]"}], "+", 
   RowBox[{"Sqrt", "[", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"profil", "[", 
        RowBox[{"[", "ir", "  ", "]"}], "]"}], "-", 
       RowBox[{"{", 
        RowBox[{"xr", ",", "alt"}], "}"}]}], ")"}], ".", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"profil", "[", 
        RowBox[{"[", "ir", "  ", "]"}], "]"}], "-", " ", 
       RowBox[{"{", 
        RowBox[{"xr", ",", "alt"}], "}"}]}], ")"}]}], 
    "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{"long", "+=", 
    RowBox[{"Sqrt", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"profil", "[", 
         RowBox[{"[", "i", "  ", "]"}], "]"}], "-", 
        RowBox[{"profil", "[", 
         RowBox[{"[", 
          RowBox[{"i", "+", "1"}], " ", "]"}], "]"}]}], ")"}], ".", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"profil", "[", 
         RowBox[{"[", "i", "  ", "]"}], "]"}], "-", 
        RowBox[{"profil", "[", 
         RowBox[{"[", 
          RowBox[{"i", "+", "1"}], " ", "]"}], "]"}]}], ")"}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", 
     RowBox[{"il", "+", "1"}], ",", 
     RowBox[{"ir", "-", "1"}]}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.726227405042*^9, 3.72622753533*^9}, {3.726230013764*^9, 
   3.72623004948*^9}, {3.726230121551*^9, 3.726230163789*^9}, 
   3.726230250789*^9, {3.726230292102*^9, 3.7262302936070004`*^9}, {
   3.726231386196*^9, 3.726231407833*^9}, {3.726231510461*^9, 
   3.726231515076*^9}},ExpressionUUID->"a5cd4006-5e32-4b1e-8c6f-eb9770f767ab"],

Cell[BoxData["8.35288909599704`"], "Output",
 CellChangeTimes->{{3.726227502731*^9, 3.72622751404*^9}, 
   3.7262300505439997`*^9, 3.7262301643120003`*^9, 3.726230299375*^9, {
   3.726231402686*^9, 3.726231408664*^9}, 3.7262315157*^9, 
   3.7262330274890003`*^9, 3.7262332177609997`*^9, 
   3.726233304427*^9},ExpressionUUID->"82526e04-32c2-4034-ba70-a7f1f66f2b7b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["long"], "Input",
 CellChangeTimes->{{3.726227504414*^9, 
  3.726227506013*^9}},ExpressionUUID->"59464701-1ac1-4efa-869a-5b9a185fab07"],

Cell[BoxData["43.7534872311104`"], "Output",
 CellChangeTimes->{{3.7262275064630003`*^9, 3.726227517608*^9}, 
   3.726230226168*^9, 3.72623030192*^9, 3.726231412692*^9, 3.726231517759*^9, 
   3.726233029825*^9, 
   3.726233218606*^9},ExpressionUUID->"683b99c7-bffc-428a-805d-c20d141b93a6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"profilInterp", "[", "x", "]"}], "-", "alt"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "xl", ",", "xr"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.726230927082*^9, 
  3.72623095363*^9}},ExpressionUUID->"e8d38afa-c4f3-44ee-aa30-6406ddfb01e1"],

Cell[BoxData[
 GraphicsBox[{{{{}, {}, 
     TagBox[{{
        {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
         Opacity[1.], LineBox[CompressedData["
1:eJxF2nk4FUwXAPDrEpebrSQhVJaSCm+kFOpFUiRtQpElKknZW2ULLZYWSkmU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          "]]}}},
      Annotation[#, "Charting`Private`Tag$3252#1"]& ]}}, {}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{106.03249999999842`, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{106.03249999999842`, 191.88}, {-3.499486454708631, 0.}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.726230943987*^9, 3.726230954277*^9}, 
   3.7262330320889997`*^9, 3.7262332194960003`*^9, 
   3.7262333061610003`*^9},ExpressionUUID->"9d8f81b1-91d7-47b5-ad6d-\
ae48cf2dd585"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcLength", "[", 
  RowBox[{"Line", "[", 
   RowBox[{"Join", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"xl", ",", "alt"}], "}"}], "}"}], ",", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"profil", "[", 
        RowBox[{"[", "i", "]"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", 
         RowBox[{"il", "+", "1"}], ",", "ir"}], "}"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"xr", ",", "alt"}], "}"}], "}"}]}], "]"}], "]"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.726231119546*^9, 3.726231184574*^9}, {3.726231351102*^9,
   3.726231360666*^9}},ExpressionUUID->"37b2f4eb-de96-4457-ad99-4c5df9d7dd75"],

Cell[BoxData["87.39576390177173`"], "Output",
 CellChangeTimes->{
  3.726231185449*^9, {3.7262313517019997`*^9, 3.726231361546*^9}, 
   3.726233041178*^9, 
   3.726233318613*^9},ExpressionUUID->"e15c1b24-d6ff-4d82-a177-151eb28bbf49"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"set", "=", 
    RowBox[{"Join", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"xl", ",", "alt"}], "}"}], "}"}], ",", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"profil", "[", 
         RowBox[{"[", "i", "]"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", 
          RowBox[{"il", "+", "1"}], ",", "ir"}], "}"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"xr", ",", "alt"}], "}"}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{" "}]}], "Input",
 CellChangeTimes->{{3.726231312764*^9, 3.7262313401540003`*^9}, {
   3.726231469883*^9, 3.726231486217*^9}, {3.726232056657*^9, 
   3.726232132025*^9}, 
   3.7262332233929996`*^9},ExpressionUUID->"4a6d6a7a-a05c-480a-b98c-\
a32c325998ed"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Rh", "=", 
   RowBox[{"ArcLength", "@", 
    RowBox[{"Line", "[", "set", "]"}]}]}], "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{
  3.726233231824*^9},ExpressionUUID->"371629db-246d-47b0-b49b-cfe74aa17443"],

Cell[BoxData["87.39576390177173`"], "Output",
 CellChangeTimes->{3.726233232759*^9, 
  3.726233320042*^9},ExpressionUUID->"41025afe-4ca7-44d4-8a95-7c24f86ea779"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"S", "=", 
  RowBox[{"Area", "@", " ", 
   RowBox[{"Polygon", "[", "set", "]"}]}]}]], "Input",
 CellChangeTimes->{{3.726231875073*^9, 3.726231890429*^9}, {3.7262319287*^9, 
   3.726231947594*^9}, {3.7262320226219997`*^9, 3.726232061264*^9}, 
   3.7262332347720003`*^9},ExpressionUUID->"69ff7d88-24d8-472a-ba75-\
42748f5f5637"],

Cell[BoxData["93.80812500002503`"], "Output",
 CellChangeTimes->{
  3.7262318915030003`*^9, {3.726231930817*^9, 3.726231948278*^9}, {
   3.726232027523*^9, 3.726232031013*^9}, 
   3.726233321311*^9},ExpressionUUID->"7c9a4a7c-e25b-408e-8d56-b36d24934e3d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"pente", "=", 
  RowBox[{"2", "/", "66."}]}], "\[IndentingNewLine]", 
 RowBox[{"K", "=", "30"}], "\[IndentingNewLine]", 
 RowBox[{"Q", "=", 
  RowBox[{"S", " ", 
   RowBox[{"Rh", "^", 
    RowBox[{"(", 
     RowBox[{"2", "/", "3"}], ")"}]}], " ", 
   RowBox[{"Sqrt", "[", "pente", "]"}], " ", "K"}]}]}], "Input",
 CellChangeTimes->{{3.726231714743*^9, 3.726231727738*^9}, {
  3.7262321378970003`*^9, 3.726232154474*^9}, {3.726232297094*^9, 
  3.726232315158*^9}},ExpressionUUID->"25584cfa-87c2-4928-ae6d-431ce6badbad"],

Cell[BoxData["0.030303030303030304`"], "Output",
 CellChangeTimes->{
  3.726232155381*^9, {3.726232302566*^9, 3.726232316356*^9}, 
   3.726233323672*^9},ExpressionUUID->"5ef20d41-7044-437d-8028-ed062333755a"],

Cell[BoxData["30"], "Output",
 CellChangeTimes->{
  3.726232155381*^9, {3.726232302566*^9, 3.726232316356*^9}, 
   3.726233323674*^9},ExpressionUUID->"373705e1-471c-4dfb-81d3-318df25f304b"],

Cell[BoxData["9647.874869994726`"], "Output",
 CellChangeTimes->{
  3.726232155381*^9, {3.726232302566*^9, 3.726232316356*^9}, 
   3.726233323678*^9},ExpressionUUID->"f6362ee5-cd5b-47a9-8be1-90dd296d41f0"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["calcul", "Subsection",
 CellChangeTimes->{{3.726232366929*^9, 3.726232384227*^9}, {3.726232447131*^9,
   3.726232470816*^9}},ExpressionUUID->"c2e562c2-43c7-4704-abbe-814b7d9d1f4e"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"pente", "=", 
  RowBox[{"2", "/", "79."}]}], "\[IndentingNewLine]", 
 RowBox[{"K", "=", "25"}], "\[IndentingNewLine]", 
 RowBox[{"sol", "=", 
  RowBox[{"{", "}"}]}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"ival", "=", 
     RowBox[{"{", "}"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"xval", "=", 
     RowBox[{"{", "}"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"Do", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"profil", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "2"}], "]"}], "]"}], "\[LessEqual]", "alt", "<=", 
          RowBox[{"profil", "[", 
           RowBox[{"[", 
            RowBox[{
             RowBox[{"i", "+", "1"}], ",", "2"}], "]"}], "]"}]}], "||", 
         RowBox[{
          RowBox[{"profil", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "2"}], "]"}], "]"}], "\[GreaterEqual]", " ", 
          "alt", "\[GreaterEqual]", 
          RowBox[{"profil", "[", 
           RowBox[{"[", 
            RowBox[{
             RowBox[{"i", "+", "1"}], ",", "2"}], "]"}], "]"}]}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"AppendTo", "[", 
          RowBox[{"ival", ",", "i"}], "]"}], ";", "\[IndentingNewLine]", 
         RowBox[{"interp", "=", 
          RowBox[{"Interpolation", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"profil", "[", 
               RowBox[{"[", "i", "  ", "]"}], "]"}], ",", 
              RowBox[{"profil", "[", 
               RowBox[{"[", 
                RowBox[{"i", "+", "1"}], " ", "]"}], "]"}]}], "}"}], ",", 
            RowBox[{"InterpolationOrder", "\[Rule]", "1"}]}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"xc", "=", 
          RowBox[{"x", "/.", 
           RowBox[{
            RowBox[{"FindRoot", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"interp", "[", "x", "]"}], "\[Equal]", "alt"}], ",", 
              RowBox[{"{", 
               RowBox[{"x", ",", 
                RowBox[{"profil", "[", 
                 RowBox[{"[", 
                  RowBox[{
                   RowBox[{"i", "+", "1"}], ",", "1"}], "]"}], "]"}]}], 
               "}"}]}], "]"}], "[", 
            RowBox[{"[", "1", "]"}], "]"}]}]}], ";", 
         RowBox[{"Print", "[", 
          RowBox[{"\"\<i =\>\"", ",", "i", ",", "\"\< x = \>\"", ",", "xc"}], 
          "]"}], ";", 
         RowBox[{"AppendTo", "[", 
          RowBox[{"xval", ",", "xc"}], "]"}], ";"}]}], "\[IndentingNewLine]", 
       "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", 
        RowBox[{"n", "-", "1"}]}], "}"}]}], "]"}], ";", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"il", ",", "ir"}], "}"}], "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"First", "@", "ival"}], ",", 
       RowBox[{"Last", "@", "ival"}]}], "}"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"xl", ",", "xr"}], "}"}], "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"First", "@", "xval"}], ",", 
       RowBox[{"Last", "@", "xval"}]}], "}"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"set", "=", 
     RowBox[{"Join", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"xl", ",", "alt"}], "}"}], "}"}], ",", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"profil", "[", 
          RowBox[{"[", "i", "]"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", 
           RowBox[{"il", "+", "1"}], ",", "ir"}], "}"}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"xr", ",", "alt"}], "}"}], "}"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"\[Chi]", "=", 
     RowBox[{"ArcLength", "@", 
      RowBox[{"Line", "[", "set", "]"}]}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"S", "=", 
     RowBox[{"NIntegrate", "[", 
      RowBox[{
       RowBox[{"alt", " ", "-", 
        RowBox[{"profilInterp", "[", "x", "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "xl", ",", "xr"}], "}"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"Rh", "=", 
     RowBox[{"S", "/", "\[Chi]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"Q", "=", 
     RowBox[{"S", " ", 
      RowBox[{"Rh", "^", 
       RowBox[{"(", 
        RowBox[{"2", "/", "3"}], ")"}]}], " ", 
      RowBox[{"Sqrt", "[", "pente", "]"}], " ", "K"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"AppendTo", "[", 
     RowBox[{"sol", ",", 
      RowBox[{"{", 
       RowBox[{"alt", ",", 
        RowBox[{"alt", "-", "zmin"}], ",", "Q", ",", "S", ",", "Rh"}], 
       "}"}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"alt", ",", 
     RowBox[{"zmin", "+", "0.2"}], ",", 
     RowBox[{"zmin", "+", "4"}], ",", "0.05"}], "}"}]}], 
  "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.7262258536730003`*^9, 3.726225974487*^9}, {
   3.726226108792*^9, 3.726226133618*^9}, {3.726226317785*^9, 
   3.7262264099820004`*^9}, {3.726226449434*^9, 3.72622647455*^9}, {
   3.726226514075*^9, 3.726226570517*^9}, {3.726227020848*^9, 
   3.726227075016*^9}, {3.726227423367*^9, 3.726227427098*^9}, {
   3.726232510858*^9, 3.726232631461*^9}, {3.726232669826*^9, 
   3.726232693715*^9}, {3.726233371703*^9, 3.7262334043640003`*^9}, 
   3.726233638984*^9, {3.726235938874*^9, 3.726235945443*^9}, {
   3.7262390861689997`*^9, 3.72623913842*^9}, 3.7262391871289997`*^9, {
   3.726240714218*^9, 3.726240715432*^9}, {3.726241003191*^9, 
   3.726241003391*^9}},ExpressionUUID->"61286c5c-1a1c-4da4-a161-d4b157f7c95e"],

Cell[BoxData["0.02531645569620253`"], "Output",
 CellChangeTimes->{
  3.7262258573529997`*^9, 3.726225974858*^9, 3.726226134086*^9, 
   3.7262264111689997`*^9, {3.7262264709849997`*^9, 3.7262264752460003`*^9}, 
   3.726226519617*^9, {3.726226556707*^9, 3.726226571341*^9}, {
   3.7262270628599997`*^9, 3.726227075238*^9}, 3.7262326354440002`*^9, 
   3.726232694592*^9, 3.726232735284*^9, {3.726233379144*^9, 
   3.7262334054709997`*^9}, 3.726233639807*^9, {3.7262359223310003`*^9, 
   3.7262359457139997`*^9}, {3.72623911376*^9, 3.726239138712*^9}, 
   3.726239187417*^9, 3.726240715784*^9, 3.726240958565*^9, 3.726241008507*^9,
    3.7262433494049997`*^9},ExpressionUUID->"5070f073-6132-4878-bc52-\
63e4c2c0535b"],

Cell[BoxData["25"], "Output",
 CellChangeTimes->{
  3.7262258573529997`*^9, 3.726225974858*^9, 3.726226134086*^9, 
   3.7262264111689997`*^9, {3.7262264709849997`*^9, 3.7262264752460003`*^9}, 
   3.726226519617*^9, {3.726226556707*^9, 3.726226571341*^9}, {
   3.7262270628599997`*^9, 3.726227075238*^9}, 3.7262326354440002`*^9, 
   3.726232694592*^9, 3.726232735284*^9, {3.726233379144*^9, 
   3.7262334054709997`*^9}, 3.726233639807*^9, {3.7262359223310003`*^9, 
   3.7262359457139997`*^9}, {3.72623911376*^9, 3.726239138712*^9}, 
   3.726239187417*^9, 3.726240715784*^9, 3.726240958565*^9, 3.726241008507*^9,
    3.726243349409*^9},ExpressionUUID->"6ba6541b-59df-4149-8c69-0556514735b3"],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 CellChangeTimes->{
  3.7262258573529997`*^9, 3.726225974858*^9, 3.726226134086*^9, 
   3.7262264111689997`*^9, {3.7262264709849997`*^9, 3.7262264752460003`*^9}, 
   3.726226519617*^9, {3.726226556707*^9, 3.726226571341*^9}, {
   3.7262270628599997`*^9, 3.726227075238*^9}, 3.7262326354440002`*^9, 
   3.726232694592*^9, 3.726232735284*^9, {3.726233379144*^9, 
   3.7262334054709997`*^9}, 3.726233639807*^9, {3.7262359223310003`*^9, 
   3.7262359457139997`*^9}, {3.72623911376*^9, 3.726239138712*^9}, 
   3.726239187417*^9, 3.726240715784*^9, 3.726240958565*^9, 3.726241008507*^9,
    3.7262433494110003`*^9},ExpressionUUID->"7d0a6871-044f-4189-ba19-\
d03ca12d3c21"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "19", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", "46.06`"}],
  SequenceForm["i =", 19, " x = ", 46.06],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243349414*^9},ExpressionUUID->"4ef3cc94-fac0-4e49-b6d4-f94bac64132f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "20", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", "46.06`"}],
  SequenceForm["i =", 20, " x = ", 46.06],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243349418*^9},ExpressionUUID->"10c5306f-9c42-47a8-8ebd-deaefe503212"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "21", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", "49.19`"}],
  SequenceForm["i =", 21, " x = ", 49.19],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243349421*^9},ExpressionUUID->"94153938-cd86-4b6f-a86a-dd020155761b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "22", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", "49.19`"}],
  SequenceForm["i =", 22, " x = ", 49.19],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243349426*^9},ExpressionUUID->"ff7fb4f9-3ba7-4c5f-ae4e-b7aff016ffd4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "19", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "45.84125000000013`"}],
  SequenceForm["i =", 19, " x = ", 45.84125000000013],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243349429*^9},ExpressionUUID->"31222220-26b3-4aa5-9dd5-81bb5e08557d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "22", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", "49.785`"}],
  SequenceForm["i =", 22, " x = ", 49.785],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243349434*^9},ExpressionUUID->"9f3ce56c-67f5-484e-8875-d0377bc6c4b1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "19", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "45.62250000000025`"}],
  SequenceForm["i =", 19, " x = ", 45.62250000000025],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.7262433494370003`*^9},ExpressionUUID->"d851dd4b-20f2-4bf4-8142-\
d97b87facc57"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "22", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", "50.38`"}],
  SequenceForm["i =", 22, " x = ", 50.38],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243349439*^9},ExpressionUUID->"5bb1a893-1a16-4fc9-bb00-24006880e5bb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "23", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", "52.94`"}],
  SequenceForm["i =", 23, " x = ", 52.94],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.7262433494440002`*^9},ExpressionUUID->"06405bb4-8328-44a1-b236-\
3a1992f19bf2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "24", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", "52.94`"}],
  SequenceForm["i =", 24, " x = ", 52.94],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243349447*^9},ExpressionUUID->"6e925a09-c5c0-4426-b966-7d5bfcc95591"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "19", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "45.40374999999938`"}],
  SequenceForm["i =", 19, " x = ", 45.40374999999938],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243349451*^9},ExpressionUUID->"2730dad1-4347-4873-bf5f-001f9825e363"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "24", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "52.98687500000017`"}],
  SequenceForm["i =", 24, " x = ", 52.98687500000017],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243349454*^9},ExpressionUUID->"a501e131-0e92-49a1-85c7-740df747e3d7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "19", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "45.184999999999505`"}],
  SequenceForm["i =", 19, " x = ", 45.184999999999505`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243349457*^9},ExpressionUUID->"bbe109e0-28c0-40c6-a9a4-f85320533c16"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "24", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "53.03375000000013`"}],
  SequenceForm["i =", 24, " x = ", 53.03375000000013],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.72624334946*^9},ExpressionUUID->"7fb84d07-5cb1-49f7-b35c-c3bb76a99dbe"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "19", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "44.96624999999963`"}],
  SequenceForm["i =", 19, " x = ", 44.96624999999963],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.7262433494639997`*^9},ExpressionUUID->"55fca520-fb8e-443e-bcb6-\
19ebe4a490e2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "24", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "53.08062500000009`"}],
  SequenceForm["i =", 24, " x = ", 53.08062500000009],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243349467*^9},ExpressionUUID->"fdd207b1-8e39-4611-b559-b022a704c8e3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "19", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "44.747499999999754`"}],
  SequenceForm["i =", 19, " x = ", 44.747499999999754`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.7262433494700003`*^9},ExpressionUUID->"9fa6705c-2b8a-4659-bcb2-\
d3a762c6622b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "24", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "53.127500000000055`"}],
  SequenceForm["i =", 24, " x = ", 53.127500000000055`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243349473*^9},ExpressionUUID->"f7859a48-cdd0-42a8-be70-806fb9220598"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "19", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "44.528749999999874`"}],
  SequenceForm["i =", 19, " x = ", 44.528749999999874`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243349476*^9},ExpressionUUID->"158b9b51-728e-4957-bfda-9fae66194faa"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "24", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "53.17437500000001`"}],
  SequenceForm["i =", 24, " x = ", 53.17437500000001],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.72624334948*^9},ExpressionUUID->"bc374138-19d2-400e-aac8-64ab93e625b0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "17", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "42.68999999999801`"}],
  SequenceForm["i =", 17, " x = ", 42.68999999999801],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243349483*^9},ExpressionUUID->"698184af-672c-41b3-a2a0-db15200a6e2a"]
}, Open  ]],

Cell[BoxData[
 TemplateBox[{
  "FindRoot","jsing",
   "\"Encountered a singular Jacobian at the point \
\\!\\(\\*RowBox[{\\\"{\\\", \\\"x\\\", \\\"}\\\"}]\\) = \
\\!\\(\\*RowBox[{\\\"{\\\", \\\"44.31`\\\", \\\"}\\\"}]\\). Try perturbing \
the initial point(s).\"",2,365,23,21554243663432278208,"Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.7262409586400003`*^9, 3.726241008568*^9, 
  3.726243349486*^9},ExpressionUUID->"6564d9e4-ca66-48ff-a193-b3d55526ad3c"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "18", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", "44.31`"}],
  SequenceForm["i =", 18, " x = ", 44.31],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243349507*^9},ExpressionUUID->"56b4a4cc-f6c2-4d97-b50e-6fc207c4cfde"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "19", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "44.30999999999901`"}],
  SequenceForm["i =", 19, " x = ", 44.30999999999901],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243349509*^9},ExpressionUUID->"34d8c45f-c624-4789-9607-f5b1aa7b3512"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "24", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "53.22125000000018`"}],
  SequenceForm["i =", 24, " x = ", 53.22125000000018],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243349513*^9},ExpressionUUID->"5f1e8806-bbef-4004-b47a-39e36581c08a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "17", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "42.252499999998506`"}],
  SequenceForm["i =", 17, " x = ", 42.252499999998506`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243349516*^9},ExpressionUUID->"ed05a905-d75b-46fc-870c-71840850dd88"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "24", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "53.26812500000015`"}],
  SequenceForm["i =", 24, " x = ", 53.26812500000015],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243349519*^9},ExpressionUUID->"e429fea8-cb42-4417-9d8d-115fcb086e63"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "17", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "41.814999999999`"}],
  SequenceForm["i =", 17, " x = ", 41.814999999999],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.7262433495220003`*^9},ExpressionUUID->"bdfbe2ec-6b67-489f-ac08-\
9cd99e9d0ed7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "24", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "53.315000000000104`"}],
  SequenceForm["i =", 24, " x = ", 53.315000000000104`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243349525*^9},ExpressionUUID->"055e2763-8ff7-4f87-934b-2440a5e6f124"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "17", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "41.3774999999995`"}],
  SequenceForm["i =", 17, " x = ", 41.3774999999995],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243349528*^9},ExpressionUUID->"b7424328-f8bf-48dd-a36c-7df8baba94cc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "24", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "53.36187500000006`"}],
  SequenceForm["i =", 24, " x = ", 53.36187500000006],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.7262433495299997`*^9},ExpressionUUID->"aa163fbe-4765-4953-a837-\
e6f305708327"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "16", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", "40.94`"}],
  SequenceForm["i =", 16, " x = ", 40.94],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243349533*^9},ExpressionUUID->"b7d217ec-fdef-4d70-a9c4-81273f49df33"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "17", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", "40.94`"}],
  SequenceForm["i =", 17, " x = ", 40.94],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.7262433495360003`*^9},ExpressionUUID->"f971cdf7-f877-4632-b102-\
dc1e25bc91cf"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "24", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "53.408750000000026`"}],
  SequenceForm["i =", 24, " x = ", 53.408750000000026`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243349538*^9},ExpressionUUID->"7698213a-8bce-42eb-93a0-2aeb09609c10"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "16", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "40.77499999999944`"}],
  SequenceForm["i =", 16, " x = ", 40.77499999999944],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243349541*^9},ExpressionUUID->"dbccdf79-2b2d-4d5d-926b-390896d923cb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "24", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "53.4556250000002`"}],
  SequenceForm["i =", 24, " x = ", 53.4556250000002],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243349545*^9},ExpressionUUID->"c9dc72a6-6070-4d4f-83e1-fdff88e73b01"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "16", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "40.60999999999962`"}],
  SequenceForm["i =", 16, " x = ", 40.60999999999962],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.7262433495480003`*^9},ExpressionUUID->"fb5df9cd-113a-47bb-ab9a-\
e2eee7dfab67"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "24", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "53.502500000000154`"}],
  SequenceForm["i =", 24, " x = ", 53.502500000000154`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.72624334955*^9},ExpressionUUID->"d9279982-1574-4ab1-b05d-ed5ccfc174c0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "16", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "40.44499999999981`"}],
  SequenceForm["i =", 16, " x = ", 40.44499999999981],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243349553*^9},ExpressionUUID->"0a6dd24b-c848-4ffc-84bf-2ae29bc02e82"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "24", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "53.54937500000012`"}],
  SequenceForm["i =", 24, " x = ", 53.54937500000012],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.7262433495559998`*^9},ExpressionUUID->"cc1ddb19-12a2-4435-b30c-\
6535527d81a7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "16", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", "40.28`"}],
  SequenceForm["i =", 16, " x = ", 40.28],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243349559*^9},ExpressionUUID->"6e53e050-4349-49f5-9f83-993ca5967948"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "24", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "53.596250000000076`"}],
  SequenceForm["i =", 24, " x = ", 53.596250000000076`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.7262433495620003`*^9},ExpressionUUID->"33d20801-a015-45bb-a725-\
79e3468fcb18"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "16", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "40.11500000000019`"}],
  SequenceForm["i =", 16, " x = ", 40.11500000000019],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243349565*^9},ExpressionUUID->"b7d4107f-7ce1-4d76-9f62-2a2c9ae27394"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "24", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "53.64312500000004`"}],
  SequenceForm["i =", 24, " x = ", 53.64312500000004],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243349568*^9},ExpressionUUID->"ff866057-d8ee-4bc6-b386-f154a3bfc366"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "16", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "39.94999999999962`"}],
  SequenceForm["i =", 16, " x = ", 39.94999999999962],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.7262433495699997`*^9},ExpressionUUID->"a98f3a92-b2d0-469c-938b-\
8609f5d1752d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "24", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "53.69000000000021`"}],
  SequenceForm["i =", 24, " x = ", 53.69000000000021],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243349572*^9},ExpressionUUID->"e8d9167c-922b-4bbb-b689-247a58b8e516"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "16", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "39.78499999999981`"}],
  SequenceForm["i =", 16, " x = ", 39.78499999999981],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243349575*^9},ExpressionUUID->"ec38d006-0c16-4f8d-b66e-b70a86b2513d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "24", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "53.73687500000017`"}],
  SequenceForm["i =", 24, " x = ", 53.73687500000017],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243349578*^9},ExpressionUUID->"7aec5c4e-c78d-4602-813b-7b14f11ef585"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "15", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", "39.62`"}],
  SequenceForm["i =", 15, " x = ", 39.62],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.7262433495810003`*^9},ExpressionUUID->"37c4a83e-9584-44a1-95cf-\
e731bb4818a7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "16", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", "39.62`"}],
  SequenceForm["i =", 16, " x = ", 39.62],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243349584*^9},ExpressionUUID->"f75574f8-25c8-4786-8140-143c08c5640e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "24", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "53.78375000000013`"}],
  SequenceForm["i =", 24, " x = ", 53.78375000000013],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243349586*^9},ExpressionUUID->"58246a64-31a0-4595-aafe-d94a9a05223c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "15", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "39.44833333333346`"}],
  SequenceForm["i =", 15, " x = ", 39.44833333333346],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.7262433495889997`*^9},ExpressionUUID->"f65166ed-101a-4b3f-8562-\
0382d15dbcdc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "24", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "53.83062500000009`"}],
  SequenceForm["i =", 24, " x = ", 53.83062500000009],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243349592*^9},ExpressionUUID->"01198f50-9fa9-4edc-ac96-25a61f3c868a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "15", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "39.27666666666693`"}],
  SequenceForm["i =", 15, " x = ", 39.27666666666693],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.7262433495950003`*^9},ExpressionUUID->"678ee2e6-5f52-4929-96f3-\
e340f3f321f5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "24", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "53.877500000000055`"}],
  SequenceForm["i =", 24, " x = ", 53.877500000000055`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243349597*^9},ExpressionUUID->"62246a86-39ab-4bea-80de-39b61743f795"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "15", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "39.104999999999606`"}],
  SequenceForm["i =", 15, " x = ", 39.104999999999606`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243349609*^9},ExpressionUUID->"063a3c63-1077-4e0f-8b11-47ba09650611"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "24", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "53.924375000000225`"}],
  SequenceForm["i =", 24, " x = ", 53.924375000000225`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243349612*^9},ExpressionUUID->"d38f08e4-aa53-4551-bde0-d8e2a939835d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "15", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "38.933333333333074`"}],
  SequenceForm["i =", 15, " x = ", 38.933333333333074`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243349615*^9},ExpressionUUID->"2dc1a960-7b54-4243-8af1-8a85f002854c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "24", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "53.97125000000018`"}],
  SequenceForm["i =", 24, " x = ", 53.97125000000018],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243349618*^9},ExpressionUUID->"44c761f7-fc15-4f6b-bb28-5fca51a4ac84"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "15", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "38.761666666666535`"}],
  SequenceForm["i =", 15, " x = ", 38.761666666666535`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243349627*^9},ExpressionUUID->"1c0cdcfb-c0e8-426f-970e-af11a7848b30"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "24", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "54.01812500000015`"}],
  SequenceForm["i =", 24, " x = ", 54.01812500000015],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.72624334963*^9},ExpressionUUID->"f23544ed-7ad5-44d6-a84b-461f8e4fdcce"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "15", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", "38.59`"}],
  SequenceForm["i =", 15, " x = ", 38.59],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243349639*^9},ExpressionUUID->"9895e10d-f1fa-4d5f-a767-26adef1ddbd8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "24", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "54.065000000000104`"}],
  SequenceForm["i =", 24, " x = ", 54.065000000000104`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243349644*^9},ExpressionUUID->"a336154a-89df-411c-9f18-dddc0052bdcd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "15", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "38.418333333333464`"}],
  SequenceForm["i =", 15, " x = ", 38.418333333333464`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243349646*^9},ExpressionUUID->"5f775c82-c706-4629-859e-5252f9306b79"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "24", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "54.11187500000006`"}],
  SequenceForm["i =", 24, " x = ", 54.11187500000006],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.72624334965*^9},ExpressionUUID->"53deef15-4cc1-41dc-9354-d508e8efe8a4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "15", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "38.246666666666144`"}],
  SequenceForm["i =", 15, " x = ", 38.246666666666144`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243349658*^9},ExpressionUUID->"a33bf67b-0b33-4a6e-9ace-97ad069986f4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "24", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "54.15875000000024`"}],
  SequenceForm["i =", 24, " x = ", 54.15875000000024],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.7262433496610003`*^9},ExpressionUUID->"b3c2963d-8f16-44f8-846d-\
cd3a802ec433"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "15", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "38.07499999999961`"}],
  SequenceForm["i =", 15, " x = ", 38.07499999999961],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.7262433496689997`*^9},ExpressionUUID->"739eefb4-3b93-4dcb-a65c-\
6ef1dc15a3c6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "24", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "54.2056250000002`"}],
  SequenceForm["i =", 24, " x = ", 54.2056250000002],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.7262433496730003`*^9},ExpressionUUID->"3f50da8d-48f3-4b34-b595-\
e3ce552f563d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "15", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "37.90333333333307`"}],
  SequenceForm["i =", 15, " x = ", 37.90333333333307],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243349682*^9},ExpressionUUID->"71ed9598-8da2-4a69-85ba-21bad50acd60"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "24", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "54.252500000000154`"}],
  SequenceForm["i =", 24, " x = ", 54.252500000000154`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243349686*^9},ExpressionUUID->"73bbc633-7740-4fef-818d-898e3cecd4a9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "15", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "37.73166666666654`"}],
  SequenceForm["i =", 15, " x = ", 37.73166666666654],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243349693*^9},ExpressionUUID->"61babe4e-e11c-4549-baeb-d8d4e72a7497"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "24", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "54.29937500000012`"}],
  SequenceForm["i =", 24, " x = ", 54.29937500000012],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243349697*^9},ExpressionUUID->"f2b6b9e6-c86d-4993-973a-a2581d792bff"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "14", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", "37.56`"}],
  SequenceForm["i =", 14, " x = ", 37.56],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.7262433497*^9},ExpressionUUID->"13485142-8e64-48b3-8208-c9026289ab37"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "15", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", "37.56`"}],
  SequenceForm["i =", 15, " x = ", 37.56],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.7262433497019997`*^9},ExpressionUUID->"bac46f25-ad74-44c3-a0a6-\
6fad453ee30f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "24", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "54.346250000000076`"}],
  SequenceForm["i =", 24, " x = ", 54.346250000000076`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243349705*^9},ExpressionUUID->"932ed9ed-e89a-444d-8782-f6c929e08b6b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "14", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "36.83999999999673`"}],
  SequenceForm["i =", 14, " x = ", 36.83999999999673],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.7262433497130003`*^9},ExpressionUUID->"f4b74073-eda4-492c-b072-\
3374fdbb83e6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "24", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "54.39312500000025`"}],
  SequenceForm["i =", 24, " x = ", 54.39312500000025],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243349716*^9},ExpressionUUID->"52384efe-a504-44dc-a75d-6a57d09959f4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "13", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "36.119999999995606`"}],
  SequenceForm["i =", 13, " x = ", 36.119999999995606`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243349724*^9},ExpressionUUID->"a2b0cee0-edc5-4d77-b3a3-15212e7d0562"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "14", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "36.11999999999672`"}],
  SequenceForm["i =", 14, " x = ", 36.11999999999672],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.7262433497279997`*^9},ExpressionUUID->"7326246c-d165-476d-a124-\
e847a0aaf965"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "24", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "54.44000000000021`"}],
  SequenceForm["i =", 24, " x = ", 54.44000000000021],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243349731*^9},ExpressionUUID->"a69eb5cd-2459-4bf6-8256-5e7fdc3697e3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "25", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "54.440000000000545`"}],
  SequenceForm["i =", 25, " x = ", 54.440000000000545`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243349734*^9},ExpressionUUID->"f9ab012f-b531-48eb-abfa-a5f2beb8ec5d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "13", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "35.154999999997806`"}],
  SequenceForm["i =", 13, " x = ", 35.154999999997806`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243349736*^9},ExpressionUUID->"e4de613f-fe4b-4661-b790-ddc35ffbc2d0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "25", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "54.56000000000041`"}],
  SequenceForm["i =", 25, " x = ", 54.56000000000041],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.7262433497390003`*^9},ExpressionUUID->"7400ace2-6076-4395-b093-\
7f44b1924eb3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "12", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", "34.19`"}],
  SequenceForm["i =", 12, " x = ", 34.19],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243349748*^9},ExpressionUUID->"3ed188b8-a5fc-4ec3-ae9d-b928ace0ea33"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "13", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", "34.19`"}],
  SequenceForm["i =", 13, " x = ", 34.19],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243349752*^9},ExpressionUUID->"864e0553-6fc0-42ca-b44d-37ae2948bc15"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "25", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "54.68000000000027`"}],
  SequenceForm["i =", 25, " x = ", 54.68000000000027],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.7262433497539997`*^9},ExpressionUUID->"5c716283-2d7c-43f4-a844-\
5d41ffee53bb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "12", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "33.752500000000495`"}],
  SequenceForm["i =", 12, " x = ", 33.752500000000495`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243349763*^9},ExpressionUUID->"4f12df34-2907-4cab-a347-2009ccab9440"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "25", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "54.80000000000013`"}],
  SequenceForm["i =", 25, " x = ", 54.80000000000013],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243349766*^9},ExpressionUUID->"41881ec1-3228-4377-965a-c2384528d3bd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "12", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "33.314999999999`"}],
  SequenceForm["i =", 12, " x = ", 33.314999999999],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243349774*^9},ExpressionUUID->"efee77b3-73b3-421e-bb90-95d1adfd04de"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "25", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "54.92000000000054`"}],
  SequenceForm["i =", 25, " x = ", 54.92000000000054],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243349778*^9},ExpressionUUID->"a8e53d71-a998-4186-af6d-85079ffef00d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "12", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "32.8774999999995`"}],
  SequenceForm["i =", 12, " x = ", 32.8774999999995],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.7262433497869997`*^9},ExpressionUUID->"4ef25594-9e4b-4e03-9e0c-\
2920377d65a0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "25", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "55.04000000000041`"}],
  SequenceForm["i =", 25, " x = ", 55.04000000000041],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243349791*^9},ExpressionUUID->"88022871-9295-4209-9770-c6a267327e39"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", "30.19`"}],
  SequenceForm["i =", 10, " x = ", 30.19],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243349803*^9},ExpressionUUID->"8a48ec47-d019-458a-84ab-627aa02b2203"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", "32.44`"}],
  SequenceForm["i =", 11, " x = ", 32.44],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243349808*^9},ExpressionUUID->"901a6fed-5247-4e59-86c9-33d0498dd7fa"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "12", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", "32.44`"}],
  SequenceForm["i =", 12, " x = ", 32.44],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.7262433498129997`*^9},ExpressionUUID->"f57076ca-5b18-4640-a77c-\
8a7362cec700"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "25", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "55.160000000000274`"}],
  SequenceForm["i =", 25, " x = ", 55.160000000000274`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243349817*^9},ExpressionUUID->"2ad651f3-1efd-432b-b1fe-0ae7f28c95ab"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "29.97071428571443`"}],
  SequenceForm["i =", 10, " x = ", 29.97071428571443],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243349821*^9},ExpressionUUID->"61a5b515-ede6-4181-986a-d1b8b1ad161e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "25", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "55.280000000000136`"}],
  SequenceForm["i =", 25, " x = ", 55.280000000000136`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243349826*^9},ExpressionUUID->"64adbc3f-ed65-48ab-8714-0ab40dac4939"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "29.751428571428857`"}],
  SequenceForm["i =", 10, " x = ", 29.751428571428857`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.72624334983*^9},ExpressionUUID->"ee26e3a8-e78d-461d-84fd-309aa5abdddd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "25", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", "55.4`"}],
  SequenceForm["i =", 25, " x = ", 55.4],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243349834*^9},ExpressionUUID->"994e10e9-4df2-402c-824d-aa1c218be165"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "29.53214285714229`"}],
  SequenceForm["i =", 10, " x = ", 29.53214285714229],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.7262433498459997`*^9},ExpressionUUID->"7484298b-278f-4476-9e5e-\
a7add02390a1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "25", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "55.52000000000041`"}],
  SequenceForm["i =", 25, " x = ", 55.52000000000041],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.72624334985*^9},ExpressionUUID->"5bc0c098-46b0-485f-a62b-d1818c6660c8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "29.312857142856718`"}],
  SequenceForm["i =", 10, " x = ", 29.312857142856718`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243349873*^9},ExpressionUUID->"58cbcaba-3939-4956-81a3-d308744bba32"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "25", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "55.64000000000028`"}],
  SequenceForm["i =", 25, " x = ", 55.64000000000028],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.7262433498789997`*^9},ExpressionUUID->"c1042573-2f3c-46f7-849b-\
3ec9503ee950"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "29.093571428571146`"}],
  SequenceForm["i =", 10, " x = ", 29.093571428571146`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243349883*^9},ExpressionUUID->"7c7fda59-7682-4fc1-aa43-9313f50bd44b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "25", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "55.76000000000014`"}],
  SequenceForm["i =", 25, " x = ", 55.76000000000014],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243349887*^9},ExpressionUUID->"2e843d37-7b6c-449a-ae90-32c60f2667f3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "28.874285714285573`"}],
  SequenceForm["i =", 10, " x = ", 28.874285714285573`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243349892*^9},ExpressionUUID->"b7be8ba5-b8bf-4458-a2e6-3d0b0e65fbad"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "25", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", "55.88`"}],
  SequenceForm["i =", 25, " x = ", 55.88],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243349896*^9},ExpressionUUID->"8fe799fc-353f-4523-a96a-76b3c21f16af"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "26", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", "55.88`"}],
  SequenceForm["i =", 26, " x = ", 55.88],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243349901*^9},ExpressionUUID->"45f8e061-2b9a-4b1c-9140-02b6afb649d4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "29", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", "63.75`"}],
  SequenceForm["i =", 29, " x = ", 63.75],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.7262433499040003`*^9},ExpressionUUID->"1d4350a5-344a-4c6c-b5b2-\
5197f043833b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "30", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", "63.75`"}],
  SequenceForm["i =", 30, " x = ", 63.75],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243349908*^9},ExpressionUUID->"71f2e748-d4cd-4c08-ba75-a25ee045316a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", "28.655`"}],
  SequenceForm["i =", 10, " x = ", 28.655],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.7262433499119997`*^9},ExpressionUUID->"533be7b5-0ab2-4806-b59f-\
3e928c33d923"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "26", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "56.1399999999998`"}],
  SequenceForm["i =", 26, " x = ", 56.1399999999998],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243349916*^9},ExpressionUUID->"4d17baff-ff8d-4e00-872d-a69b84fba23d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "29", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", "62.75`"}],
  SequenceForm["i =", 29, " x = ", 62.75],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243349921*^9},ExpressionUUID->"708e3ee4-061d-4da3-8b2f-3f57c4929073"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "30", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "64.57749999999906`"}],
  SequenceForm["i =", 30, " x = ", 64.57749999999906],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243349925*^9},ExpressionUUID->"0fe0034e-ab65-402b-aa76-1708e8a7a0c8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "28.43571428571343`"}],
  SequenceForm["i =", 10, " x = ", 28.43571428571343],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243349929*^9},ExpressionUUID->"5db20e52-2276-4ea0-a14b-09a1e22d27e8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "26", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "56.40000000000079`"}],
  SequenceForm["i =", 26, " x = ", 56.40000000000079],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243349933*^9},ExpressionUUID->"4f88203e-6c03-4f2c-ac0d-fd00308586a5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "28", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "61.74999999999475`"}],
  SequenceForm["i =", 28, " x = ", 61.74999999999475],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.7262433499379997`*^9},ExpressionUUID->"a7ac5e04-6934-466d-a61e-\
390d860c99dd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "29", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "61.74999999999545`"}],
  SequenceForm["i =", 29, " x = ", 61.74999999999545],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243349942*^9},ExpressionUUID->"2469538c-34e9-414d-847c-c9ae44d13873"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "30", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "65.40500000000188`"}],
  SequenceForm["i =", 30, " x = ", 65.40500000000188],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243349947*^9},ExpressionUUID->"7623ae6c-dc74-43b2-bac7-42d6087d9fd3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "28.216428571427862`"}],
  SequenceForm["i =", 10, " x = ", 28.216428571427862`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.72624334995*^9},ExpressionUUID->"a41ef339-138b-4d03-b09c-95d518364e90"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "26", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "56.66000000000059`"}],
  SequenceForm["i =", 26, " x = ", 56.66000000000059],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243349954*^9},ExpressionUUID->"486c3fd2-db91-4c83-b28b-b2f774dc2985"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "28", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "60.59499999999737`"}],
  SequenceForm["i =", 28, " x = ", 60.59499999999737],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243349959*^9},ExpressionUUID->"4720d172-c794-4f25-9579-04871ccc5944"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "30", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "66.23250000000094`"}],
  SequenceForm["i =", 30, " x = ", 66.23250000000094],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.7262433499630003`*^9},ExpressionUUID->"3d247be1-3996-4ce0-b7c5-\
d24b328a2d5e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "27.99714285714229`"}],
  SequenceForm["i =", 10, " x = ", 27.99714285714229],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243349967*^9},ExpressionUUID->"3c141325-a240-41b2-892c-9f81229cc4c1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "26", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "56.92000000000039`"}],
  SequenceForm["i =", 26, " x = ", 56.92000000000039],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.7262433499709997`*^9},ExpressionUUID->"c3d6fa68-ca61-43a3-8cf0-\
273e5fa26442"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "27", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", "59.44`"}],
  SequenceForm["i =", 27, " x = ", 59.44],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243349975*^9},ExpressionUUID->"48622f8e-6bf5-4b81-a37d-a5c5892ff19c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "28", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", "59.44`"}],
  SequenceForm["i =", 28, " x = ", 59.44],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243349981*^9},ExpressionUUID->"06ff39ac-6b08-4024-8388-c2cce7a0e714"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "30", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", "67.06`"}],
  SequenceForm["i =", 30, " x = ", 67.06],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243349984*^9},ExpressionUUID->"a093ccb0-ded7-45a5-a11a-51bad3908472"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "31", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", "67.06`"}],
  SequenceForm["i =", 31, " x = ", 67.06],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243349988*^9},ExpressionUUID->"f191eac6-b146-452b-b293-654d18e9955d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "27.777857142856718`"}],
  SequenceForm["i =", 10, " x = ", 27.777857142856718`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243349993*^9},ExpressionUUID->"7ce4d1d7-1fa4-4a96-958d-e54ba8158186"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "26", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "57.1800000000002`"}],
  SequenceForm["i =", 26, " x = ", 57.1800000000002],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.7262433499969997`*^9},ExpressionUUID->"8b5c42c4-b156-4527-84ef-\
6b4fa89c60d5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "27", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", "58.44`"}],
  SequenceForm["i =", 27, " x = ", 58.44],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243350001*^9},ExpressionUUID->"18abacdc-24ff-4581-863f-e146b8c744ee"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "31", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "67.66499999999954`"}],
  SequenceForm["i =", 31, " x = ", 67.66499999999954],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243350005*^9},ExpressionUUID->"06f47b70-b8a5-4417-a684-3e64fc594e20"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "27.558571428571145`"}],
  SequenceForm["i =", 10, " x = ", 27.558571428571145`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243350009*^9},ExpressionUUID->"a6d72743-2e9b-429b-b735-38efc8860ef1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "26", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", "57.44`"}],
  SequenceForm["i =", 26, " x = ", 57.44],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243350013*^9},ExpressionUUID->"49642489-be72-4517-871a-646a0fef90a4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "27", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", "57.44`"}],
  SequenceForm["i =", 27, " x = ", 57.44],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243350017*^9},ExpressionUUID->"42cebfec-3840-4282-9d16-7b400758cbd1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "31", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "68.26999999999909`"}],
  SequenceForm["i =", 31, " x = ", 68.26999999999909],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243350021*^9},ExpressionUUID->"383ff25e-c102-47a9-9ea2-1872728f0ecc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "27.339285714284575`"}],
  SequenceForm["i =", 10, " x = ", 27.339285714284575`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243350027*^9},ExpressionUUID->"4ca949d0-99b1-4cc2-b009-019bc3a5f4ea"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "31", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "68.87500000000138`"}],
  SequenceForm["i =", 31, " x = ", 68.87500000000138],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243350031*^9},ExpressionUUID->"913232c2-7161-4fdb-baaa-6aef413d5694"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "27.119999999999088`"}],
  SequenceForm["i =", 9, " x = ", 27.119999999999088`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.7262433500550003`*^9},ExpressionUUID->"fe664c02-98fc-4c84-afde-\
fd05854d1c3d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "27.119999999999003`"}],
  SequenceForm["i =", 10, " x = ", 27.119999999999003`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.72624335006*^9},ExpressionUUID->"15fe2638-20fe-4061-87ed-aebd3dea6d15"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "31", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "69.48000000000091`"}],
  SequenceForm["i =", 31, " x = ", 69.48000000000091],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243350064*^9},ExpressionUUID->"efab85ce-fce9-46ae-9971-825055847328"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "26.91888888888818`"}],
  SequenceForm["i =", 9, " x = ", 26.91888888888818],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243350068*^9},ExpressionUUID->"742f1711-580f-4bdd-874a-a0f1707e09ea"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "31", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "70.08500000000046`"}],
  SequenceForm["i =", 31, " x = ", 70.08500000000046],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243350072*^9},ExpressionUUID->"3318ff81-614b-4295-ae34-c545c1fbdfdd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "26.717777777777272`"}],
  SequenceForm["i =", 9, " x = ", 26.717777777777272`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.7262433500950003`*^9},ExpressionUUID->"4a2204b3-2e2a-4ea3-b2f5-\
f5d284eb2f6d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "31", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", "70.69`"}],
  SequenceForm["i =", 31, " x = ", 70.69],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243350099*^9},ExpressionUUID->"f5a93855-bde2-4871-a4de-7c0d09ac79b2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "32", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", "70.69`"}],
  SequenceForm["i =", 32, " x = ", 70.69],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.7262433501029997`*^9},ExpressionUUID->"888babe2-819f-453f-a767-\
0398d3e2f575"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "26.516666666666364`"}],
  SequenceForm["i =", 9, " x = ", 26.516666666666364`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243350108*^9},ExpressionUUID->"a3550de1-bc96-4e9b-905c-8801df34f3d8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "32", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "71.36666666666615`"}],
  SequenceForm["i =", 32, " x = ", 71.36666666666615],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243350112*^9},ExpressionUUID->"d21cf935-cef5-457c-b476-1c732c6f2e5c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "26.31555555555454`"}],
  SequenceForm["i =", 9, " x = ", 26.31555555555454],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243350135*^9},ExpressionUUID->"6979a6b0-2d05-4a9b-8e84-9ec31483474e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "32", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "72.04333333333538`"}],
  SequenceForm["i =", 32, " x = ", 72.04333333333538],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.7262433501400003`*^9},ExpressionUUID->"3c3df96d-4ca7-4afb-90f4-\
e4c53bb1921c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "26.11444444444363`"}],
  SequenceForm["i =", 9, " x = ", 26.11444444444363],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.72624335015*^9},ExpressionUUID->"ca0abc45-5534-4d3c-b0dc-75bb63623ad6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "32", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "72.72000000000153`"}],
  SequenceForm["i =", 32, " x = ", 72.72000000000153],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.7262433501540003`*^9},ExpressionUUID->"c95ef814-a788-4e56-b87d-\
6a77432002c0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "25.913333333332723`"}],
  SequenceForm["i =", 9, " x = ", 25.913333333332723`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243350177*^9},ExpressionUUID->"ba5c4404-69e2-4048-835d-9eaf9b12759e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "32", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "73.3966666666677`"}],
  SequenceForm["i =", 32, " x = ", 73.3966666666677],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.7262433501809998`*^9},ExpressionUUID->"93706bde-8f4a-48ab-9d47-\
a920203a3292"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "25.712222222221815`"}],
  SequenceForm["i =", 9, " x = ", 25.712222222221815`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.72624335019*^9},ExpressionUUID->"3446cfcf-42aa-49ac-925f-fde4c9aa94e0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "32", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "74.07333333333385`"}],
  SequenceForm["i =", 32, " x = ", 74.07333333333385],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.7262433501949997`*^9},ExpressionUUID->"41da9a7b-1f82-4a97-9d5a-\
c9ba145a5f88"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "25.511111111110907`"}],
  SequenceForm["i =", 9, " x = ", 25.511111111110907`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243350217*^9},ExpressionUUID->"6e4498a5-5eb9-40ee-8159-0b44a7afaabf"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "32", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", "74.75`"}],
  SequenceForm["i =", 32, " x = ", 74.75],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243350222*^9},ExpressionUUID->"bd450133-98f8-4a3b-ac43-b1cad322af48"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "33", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", "74.75`"}],
  SequenceForm["i =", 33, " x = ", 74.75],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243350226*^9},ExpressionUUID->"f726465a-2a8b-4dee-8809-a1354ad87d8f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "25.309999999999086`"}],
  SequenceForm["i =", 9, " x = ", 25.309999999999086`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.72624335023*^9},ExpressionUUID->"dfbbb4d1-c088-4396-af94-0f63816acaaf"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "33", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "75.56166666666974`"}],
  SequenceForm["i =", 33, " x = ", 75.56166666666974],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243350234*^9},ExpressionUUID->"7e8f95be-d493-48a2-986a-f87d4a4082fd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "25.108888888888178`"}],
  SequenceForm["i =", 9, " x = ", 25.108888888888178`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243350256*^9},ExpressionUUID->"59bc8426-a89d-41d1-84da-698a83e809bc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "33", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "76.3733333333358`"}],
  SequenceForm["i =", 33, " x = ", 76.3733333333358],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243350262*^9},ExpressionUUID->"0c4a20b3-681c-4480-acb3-351c57b53438"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "24.90777777777727`"}],
  SequenceForm["i =", 9, " x = ", 24.90777777777727],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243350271*^9},ExpressionUUID->"9b347917-cba0-4e58-8bf5-e4b3133b9390"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "33", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "77.18500000000185`"}],
  SequenceForm["i =", 33, " x = ", 77.18500000000185],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243350276*^9},ExpressionUUID->"78688c24-3f19-4785-bc3b-d86b2be265aa"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "24.70666666666636`"}],
  SequenceForm["i =", 9, " x = ", 24.70666666666636],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243350299*^9},ExpressionUUID->"e075da0f-95eb-45c0-a1a2-941d343bf275"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "33", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "77.9966666666679`"}],
  SequenceForm["i =", 33, " x = ", 77.9966666666679],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243350303*^9},ExpressionUUID->"41d1918d-e02c-49af-b2ed-b4712b0ed4b4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "24.505555555555453`"}],
  SequenceForm["i =", 9, " x = ", 24.505555555555453`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243350314*^9},ExpressionUUID->"f26d65ef-4f0e-4d68-8e7e-d46ca285540c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "33", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "78.80833333333395`"}],
  SequenceForm["i =", 33, " x = ", 78.80833333333395],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243350318*^9},ExpressionUUID->"47e3d17c-7a92-4819-919a-0dc40a22ea72"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "24.304444444443632`"}],
  SequenceForm["i =", 9, " x = ", 24.304444444443632`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243350341*^9},ExpressionUUID->"e8e9c103-fc94-49e2-a7b5-f88f0db59aef"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "33", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "79.6200000000037`"}],
  SequenceForm["i =", 33, " x = ", 79.6200000000037],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243350347*^9},ExpressionUUID->"69af2a60-43bc-4e9b-9bea-938c396f7397"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "34", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "79.62000000000498`"}],
  SequenceForm["i =", 34, " x = ", 79.62000000000498],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.72624335035*^9},ExpressionUUID->"50ebc4e7-5a1f-4a3a-a693-f50b3116b36f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "24.103333333332724`"}],
  SequenceForm["i =", 9, " x = ", 24.103333333332724`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243350361*^9},ExpressionUUID->"5af9c3b9-e482-4fe9-89d2-8845f775cd15"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "34", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "80.71500000000374`"}],
  SequenceForm["i =", 34, " x = ", 80.71500000000374],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.7262433503640003`*^9},ExpressionUUID->"c07079a5-33a5-4030-bafa-\
c2b61ed86295"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "23.902222222221816`"}],
  SequenceForm["i =", 9, " x = ", 23.902222222221816`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243350387*^9},ExpressionUUID->"057fb6ac-7eb5-4bb0-828b-7f0b036fe786"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "34", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "81.81000000000249`"}],
  SequenceForm["i =", 34, " x = ", 81.81000000000249],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243350392*^9},ExpressionUUID->"472e95f8-ff19-461c-bb21-7c1fef2f4f12"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "23.701111111110908`"}],
  SequenceForm["i =", 9, " x = ", 23.701111111110908`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243350402*^9},ExpressionUUID->"a9169c04-3a8d-4536-87be-707993b5e617"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "34", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "82.90500000000125`"}],
  SequenceForm["i =", 34, " x = ", 82.90500000000125],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243350406*^9},ExpressionUUID->"787ca894-e067-4d04-aae4-ffb30790d131"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", "23.5`"}],
  SequenceForm["i =", 8, " x = ", 23.5],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243350428*^9},ExpressionUUID->"bca9e592-2e91-4224-85ce-ba43cf9d8d5b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", "23.5`"}],
  SequenceForm["i =", 9, " x = ", 23.5],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243350433*^9},ExpressionUUID->"df1c7778-82ab-49b9-9919-964b5f072b20"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "34", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", "84.`"}],
  SequenceForm["i =", 34, " x = ", 84.],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.7262433504370003`*^9},ExpressionUUID->"e666a379-c4d6-4ede-827f-\
e05127b8ab87"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "35", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", "84.`"}],
  SequenceForm["i =", 35, " x = ", 84.],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243350441*^9},ExpressionUUID->"b20bcff8-e3ec-4156-b3e1-a38da70699ce"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "23.35949999999949`"}],
  SequenceForm["i =", 8, " x = ", 23.35949999999949],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.72624335045*^9},ExpressionUUID->"a3a91b2e-fa4a-41f2-9a89-371b1e6da611"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "35", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "85.5600000000071`"}],
  SequenceForm["i =", 35, " x = ", 85.5600000000071],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243350454*^9},ExpressionUUID->"6e18d45b-5b9f-4f41-84eb-d226e5d38809"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "23.218999999999618`"}],
  SequenceForm["i =", 8, " x = ", 23.218999999999618`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.7262433504779997`*^9},ExpressionUUID->"cae9eb76-a805-4fb4-9eff-\
10cb7b606668"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "35", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "87.1200000000071`"}],
  SequenceForm["i =", 35, " x = ", 87.1200000000071],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.7262433504820004`*^9},ExpressionUUID->"5a6d6bce-e0c9-4502-a6cd-\
ad7474c82d0e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "36", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "87.12000000001053`"}],
  SequenceForm["i =", 36, " x = ", 87.12000000001053],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243350486*^9},ExpressionUUID->"c63ff663-4b1b-4344-b548-f4afc26184b7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "23.078499999999746`"}],
  SequenceForm["i =", 8, " x = ", 23.078499999999746`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.7262433504960003`*^9},ExpressionUUID->"7a667823-8d9f-4121-bb66-\
fed3b481f9a4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "36", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "89.43500000000526`"}],
  SequenceForm["i =", 36, " x = ", 89.43500000000526],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.7262433505*^9},ExpressionUUID->"f25caca6-a096-4f07-b32e-37a277b6fd27"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "22.93799999999987`"}],
  SequenceForm["i =", 8, " x = ", 22.93799999999987],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.7262433505220003`*^9},ExpressionUUID->"93b0f046-ef22-4f35-acea-\
54cb56f3bd1c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "36", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", "91.75`"}],
  SequenceForm["i =", 36, " x = ", 91.75],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243350527*^9},ExpressionUUID->"e9c70a05-bb47-4328-a522-343c4a8d05d6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "37", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", "91.75`"}],
  SequenceForm["i =", 37, " x = ", 91.75],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, 
   3.726240958579*^9, 3.726241008516*^9, 
   3.726243350531*^9},ExpressionUUID->"758b4b11-8cb6-4e57-91ee-88797b1419c8"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"deb1", "=", 
  RowBox[{"ListLinePlot", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"#", "[", 
         RowBox[{"[", "2", "]"}], "]"}], ",", 
        RowBox[{"#", "[", 
         RowBox[{"[", "3", "]"}], "]"}]}], "}"}], "&"}], "/@", "sol"}], ",", 
    RowBox[{"Frame", "\[Rule]", "True"}], ",", 
    RowBox[{"FrameLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<\!\(\*
StyleBox[\"h\",
FontSlant->\"Italic\"]\)\!\(\*
StyleBox[\" \",
FontSlant->\"Italic\"]\)(m)\>\"", ",", "\"\<\!\(\*
StyleBox[\"Q\",
FontSlant->\"Italic\"]\)\!\(\*
StyleBox[\" \",
FontSlant->\"Italic\"]\)(\!\(\*SuperscriptBox[\(m\), \(3\)]\)/s)\>\""}], 
      "}"}]}], ",", 
    RowBox[{"BaseStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"FontFamily", "->", "\"\<Times\>\""}], ",", "14"}], "}"}]}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.726233420135*^9, 3.726233470976*^9}, {3.726233515049*^9,
   3.726233620692*^9}, {3.726239494539*^9, 
  3.726239498554*^9}},ExpressionUUID->"7f96f39f-2d0a-4848-bd01-ede947ff0ae0"],

Cell[BoxData[
 GraphicsBox[{{}, {{{}, {}, {
      {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
       0.016666666666666666`], AbsoluteThickness[1.6], 
       StyleBox[LineBox[CompressedData["
1:eJwtzX9Q03UYB/APPzbGGFuOmF1qCZl0x3HggT9A2PN4AgccpInyI364iazZ
bs1ZJOGQoZc5VHTVdeIhRwERh3hlaH94t0Kva4UwEYE8iGOCtYnYEFCBOdo3
nvfd5z7/vN+vJ2yfblepL2Msy/u4nzXWefM7RBpPyHulfcD+z23oGOG3Hx8d
BRYT600/mJl1yefBfWAHVd4MwgVNgUz59RNY3t+D9a7UxaCtHmC3b3kzAqul
5unzQj4ue2Mg0JoPXBOKkZ3n+nbYVNxgvVgTgmwL54/DqvqNbUqBDJf3E9AQ
0Jaut61Cpubu/Q0XF+aU2jVh5DkgXdP5asK368hzQmjRKxny42+RNwmWKa1b
IYoi7xGcLN81L5uNIe8xODpGFjtqYslzgbx7xZgufRMyrn7LBeqU7Ldd0fHI
6jl/Gv6xdTmHkhJp/wTiJ1X/jh0CZHHcvRkY5NVvf/+9beTNgsZx2WKI2E7e
LLxWJ2pxLCSTNweth+MlrfZU8p6C489Z6dXhNPKewY5Ka3KIM4O852BYHM78
NTCLvOfw089HTvUl7SBvHh40JZc23thJ3gLc6ba5xa53yFuEDc1fzidEZJPn
hplfKpsj1bvJc4MntzXIeWUPeS/g+826sw11OeR5ID43XML7PJe8JYguuDKj
VuSRx9DSc+5cVVo+Mq6uYqjdOfSV9vK7yHo5n2GYaqAz8Y1C2vug0rSHF9Va
hOwCd88Ht24JnhgsLSLPF3+oz6x25ewlzxdXZG0w29oV5PliaHZO7/yPSvL8
8GRtiW3p5j7y/HCNornn4XAJef6YYorq0d9RkOePT48OnLoxpSTPHxPLZ9JT
ZCXk8VAS0dOZkLmfPB6utshDx8+WksdHP/2ZN/PnVOTxsaD/5jditZo8Pqps
3cYYxwHyAvD1thMVk2Ua8gLQ2ldRlxGiJU+Acaf780yWD8gTYJlVWHN380Hy
BHgpP8bZtFJPXiCuMzU++8OjJy8Q0eC4rpw6RJ4Qm3XZMuP4h+QJUXNsqCvJ
/hF5Qhx1uPsK/yojLwg3Nv2W1mL/mLwgbPdMR8Y+PkyeCFuKywvC/T4hT4Td
V9vNtWsryBNh8PX8ki9Sj5AXjJ+tvzZgKjaQF4z3ogvzdhsryROjz95P26SX
jpInRvXYUP+EvYo8Mcq1wi5zlZE8CcYZXJK8l6vJk2D4tijbXG01eS+h+UXV
dzrpMfwPy1zufA==
         "]],
        FontFamily->"Times"]}}}}, {}, {}, {{}, {}}, {{}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  BaseStyle->{FontFamily -> "Times", 14},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox[
     "\"\\!\\(\\*\\nStyleBox[\\\"Q\\\",\\nFontSlant->\\\"Italic\\\"]\\)\\!\\(\
\\*\\nStyleBox[\\\" \
\\\",\\nFontSlant->\\\"Italic\\\"]\\)(\\!\\(\\*SuperscriptBox[\\(m\\), \
\\(3\\)]\\)/s)\"", TraditionalForm], None}, {
     FormBox[
     "\"\\!\\(\\*\\nStyleBox[\\\"h\\\",\\nFontSlant->\\\"Italic\\\"]\\)\\!\\(\
\\*\\nStyleBox[\\\" \\\",\\nFontSlant->\\\"Italic\\\"]\\)(m)\"", 
      TraditionalForm], None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 4.}, {0, 578.3045206069238}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.726233465073*^9, 3.726233471862*^9}, 
   3.7262335163380003`*^9, {3.72623355809*^9, 3.726233586823*^9}, {
   3.726233623099*^9, 3.7262336445109997`*^9}, {3.726235927736*^9, 
   3.726235950542*^9}, {3.726239125174*^9, 3.726239144913*^9}, 
   3.7262391952720003`*^9, 3.726239499711*^9, 3.726240720966*^9, 
   3.726240965466*^9, 3.726241016757*^9, 
   3.726243355395*^9},ExpressionUUID->"687f7159-f03f-49c4-8edd-9197045911bd"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"interQ", "=", 
  RowBox[{"Interpolation", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"#", "[", 
        RowBox[{"[", "2", "]"}], "]"}], ",", 
       RowBox[{"#", "[", 
        RowBox[{"[", "3", "]"}], "]"}]}], "}"}], "&"}], "/@", "sol"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"interQ", "[", "h", "]"}], "\[Equal]", "200"}], ",", 
   RowBox[{"{", 
    RowBox[{"h", ",", "3"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.726235960135*^9, 3.726235994193*^9}, 
   3.7262392067139997`*^9, 
   3.726243358224*^9},ExpressionUUID->"309d85da-bfe9-4778-8406-94135cfae473"],

Cell[BoxData[
 TagBox[
  TemplateBox[{RowBox[{
      StyleBox[
       TagBox["InterpolatingFunction", "SummaryHead"], 
       "NonInterpretableSummary"], 
      StyleBox["[", "NonInterpretableSummary"], 
      DynamicModuleBox[{Typeset`open$$ = False}, 
       PanelBox[
        PaneSelectorBox[{False -> GridBox[{{
              PaneBox[
               ButtonBox[
                DynamicBox[
                 FEPrivate`FrontEndResource[
                 "FEBitmaps", "SquarePlusIconMedium"]], 
                ButtonFunction :> (Typeset`open$$ = True), Appearance -> None,
                 Evaluator -> Automatic, Method -> "Preemptive"], 
               Alignment -> {Center, Center}, ImageSize -> 
               Dynamic[{
                 Automatic, 3.5 CurrentValue["FontCapHeight"]/
                  AbsoluteCurrentValue[Magnification]}]], 
              GraphicsBox[{{{{}, {}, 
                  TagBox[{
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    LineBox[CompressedData["
1:eJwB0QMu/CFib1JlAgAAADwAAAACAAAAZ6DpI5qZyT9D1kK70BLRP0WwNjG8
w9A/LtXpYynF3z8WA986ChDVPwYdGtILa+w/qdn38G0T2T+YDzoZESz8P6qD
KGiqAt0/VFCCWeqIBkA00N/koqPgPw6A8OI66BBAdaDja3uh4j9U/rdGjgsV
QBWqGmgDyuQ/svlrlg7EG0Bsnd3Ed+jmP+lbpBqwMyJApNLY93bi6D/qADxo
A7kmQDxBB6AlB+s/xyrA6fGJLEC18W0eXwftP/p8QWdbUDFA5Ytg/YT97j8Q
4fnlTYk0QLovwygtj/A/dthC1VxMOEByOvI9XY3xP3ODyNcGDjxA2uG6DeWg
8j/Nn8iqUjJAQB1+yQ1jr/M/4N2WyOB0QkBRO/R4pqv0P9+ctFHwrURANZW4
nkG99T949/2vXjhHQAoQmS+ivPY/0IuDqpC2SUCOJxN7WtH3P/eLyZ8BjExA
7TPT9gjh+D9X1lurmXZPQD1hr9183vk/5OECuO4mUUA9KyV/SPH6P4uF2BkD
wlJALha3i9nx+z+zX45XrlFUQPr1jshg7fw/+4cpGkLbVUB2cgDAP/79P8Sy
3awxFVdA4g+OIuT8/j/v49ws9SlYQP+k2h9wCABAtQtknr9iWUB7PJFG6Y8A
QIbTu0rAQ1tAb+TVIkUOAUBjMv6UCDddQLtaZ9xMlwFAj5c+z+5kXUB/4YZL
NxcCQPYV+0vOyV9AsWLJ0pyUAkBPkpJrDiJhQDuyWDeuHANAoHIxOICHYkA9
EnZRopsDQIBJzNXBz2NAl0DgSEIlBEA+N2ie4fVgQGl/2PXEpQRAMag3SK6j
YkCpuPO6wiMFQEEJouCfHGRAQcBbXWysBUCB1fswq89lQFHYUbX4KwZAr2pk
oeaSZ0C5vpTqMLYGQK36S5Q2kmlAj5/6N+Q9B0D4kRPxYKBrQN2Q7jp6vAdA
gposiKejbUCDUC8bvEUIQIDbpCFV5G9AoSD+sODFCEBg9ye+RwhxQC3r716A
QwlAEJVWTkYkckARhC7qy8sJQNBBbCgVZXNAbS37KvpKCkCb5kOtEJ10QCGl
FEnU1ApAXMzepnnxdUBDF1F/KVwLQNPHBP4STHdA3Zkba2HaC0As4XUCapx4
QM/qMjRFYwxA5PXb6LQXekA5TNiyC+MMQJsB00/Eg3tA+3vKDn5tDUDUGEng
SgJ9QCum34Jr9Q1A5fyNdqOMfkDT4IKsO3QOQMMVFR6GBIBA0+lys7f9DkBF
IEfK28eAQEsD8W8Wfg9AQXdnyJlugUD6/1r3//8PQBqfCpxvEoJAe6bH5A==

                    "]]}, 
                   Annotation[#, 
                    "Charting`Private`Tag$44412#1"]& ]}}, {}, {}}, {
               DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
                AxesOrigin -> {0, 0}, FrameTicks -> {{{}, {}}, {{}, {}}}, 
                GridLines -> {None, None}, DisplayFunction -> Identity, 
                PlotRangePadding -> {{
                   Scaled[0.1], 
                   Scaled[0.1]}, {
                   Scaled[0.1], 
                   Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                All, DisplayFunction -> Identity, AspectRatio -> 1, 
                Axes -> {False, False}, AxesLabel -> {None, None}, 
                AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
                Frame -> {{True, True}, {True, True}}, 
                FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                Directive[
                  Opacity[0.5], 
                  Thickness[Tiny], 
                  RGBColor[0.368417, 0.506779, 0.709798]], 
                FrameTicks -> {{None, None}, {None, None}}, 
                GridLines -> {None, None}, GridLinesStyle -> Directive[
                  GrayLevel[0.5, 0.4]], ImageSize -> 
                Dynamic[{
                  Automatic, 3.5 CurrentValue["FontCapHeight"]/
                   AbsoluteCurrentValue[Magnification]}], 
                Method -> {
                 "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
                  AbsolutePointSize[6], "ScalingFunctions" -> None, 
                  "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                    (Identity[#]& )[
                    Part[#, 1]], 
                    (Identity[#]& )[
                    Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                    (Identity[#]& )[
                    Part[#, 1]], 
                    (Identity[#]& )[
                    Part[#, 2]]}& )}}, 
                PlotRange -> {{0.20000000000004547`, 4.}, {0., 
                 578.304496844273}}, PlotRangeClipping -> True, 
                PlotRangePadding -> {{
                   Scaled[0.1], 
                   Scaled[0.1]}, {
                   Scaled[0.1], 
                   Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
              GridBox[{{
                 RowBox[{
                   TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"0.20000000000004547`", ",", "4.`"}], "}"}], 
                    "}"}], "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["\"scalar\"", "SummaryItem"]}]}}, 
               GridBoxAlignment -> {
                "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, AutoDelete -> 
               False, GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
               GridBoxSpacings -> {
                "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
               BaseStyle -> {
                ShowStringCharacters -> False, NumberMarks -> False, 
                 PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
            GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> False, 
            GridBoxItemSize -> {
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
            BaselinePosition -> {1, 1}], True -> GridBox[{{
              PaneBox[
               ButtonBox[
                DynamicBox[
                 FEPrivate`FrontEndResource[
                 "FEBitmaps", "SquareMinusIconMedium"]], 
                ButtonFunction :> (Typeset`open$$ = False), Appearance -> 
                None, Evaluator -> Automatic, Method -> "Preemptive"], 
               Alignment -> {Center, Center}, ImageSize -> 
               Dynamic[{
                 Automatic, 3.5 CurrentValue["FontCapHeight"]/
                  AbsoluteCurrentValue[Magnification]}]], 
              GraphicsBox[{{{{}, {}, 
                  TagBox[{
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    LineBox[CompressedData["
1:eJwB0QMu/CFib1JlAgAAADwAAAACAAAAZ6DpI5qZyT9D1kK70BLRP0WwNjG8
w9A/LtXpYynF3z8WA986ChDVPwYdGtILa+w/qdn38G0T2T+YDzoZESz8P6qD
KGiqAt0/VFCCWeqIBkA00N/koqPgPw6A8OI66BBAdaDja3uh4j9U/rdGjgsV
QBWqGmgDyuQ/svlrlg7EG0Bsnd3Ed+jmP+lbpBqwMyJApNLY93bi6D/qADxo
A7kmQDxBB6AlB+s/xyrA6fGJLEC18W0eXwftP/p8QWdbUDFA5Ytg/YT97j8Q
4fnlTYk0QLovwygtj/A/dthC1VxMOEByOvI9XY3xP3ODyNcGDjxA2uG6DeWg
8j/Nn8iqUjJAQB1+yQ1jr/M/4N2WyOB0QkBRO/R4pqv0P9+ctFHwrURANZW4
nkG99T949/2vXjhHQAoQmS+ivPY/0IuDqpC2SUCOJxN7WtH3P/eLyZ8BjExA
7TPT9gjh+D9X1lurmXZPQD1hr9183vk/5OECuO4mUUA9KyV/SPH6P4uF2BkD
wlJALha3i9nx+z+zX45XrlFUQPr1jshg7fw/+4cpGkLbVUB2cgDAP/79P8Sy
3awxFVdA4g+OIuT8/j/v49ws9SlYQP+k2h9wCABAtQtknr9iWUB7PJFG6Y8A
QIbTu0rAQ1tAb+TVIkUOAUBjMv6UCDddQLtaZ9xMlwFAj5c+z+5kXUB/4YZL
NxcCQPYV+0vOyV9AsWLJ0pyUAkBPkpJrDiJhQDuyWDeuHANAoHIxOICHYkA9
EnZRopsDQIBJzNXBz2NAl0DgSEIlBEA+N2ie4fVgQGl/2PXEpQRAMag3SK6j
YkCpuPO6wiMFQEEJouCfHGRAQcBbXWysBUCB1fswq89lQFHYUbX4KwZAr2pk
oeaSZ0C5vpTqMLYGQK36S5Q2kmlAj5/6N+Q9B0D4kRPxYKBrQN2Q7jp6vAdA
gposiKejbUCDUC8bvEUIQIDbpCFV5G9AoSD+sODFCEBg9ye+RwhxQC3r716A
QwlAEJVWTkYkckARhC7qy8sJQNBBbCgVZXNAbS37KvpKCkCb5kOtEJ10QCGl
FEnU1ApAXMzepnnxdUBDF1F/KVwLQNPHBP4STHdA3Zkba2HaC0As4XUCapx4
QM/qMjRFYwxA5PXb6LQXekA5TNiyC+MMQJsB00/Eg3tA+3vKDn5tDUDUGEng
SgJ9QCum34Jr9Q1A5fyNdqOMfkDT4IKsO3QOQMMVFR6GBIBA0+lys7f9DkBF
IEfK28eAQEsD8W8Wfg9AQXdnyJlugUD6/1r3//8PQBqfCpxvEoJAe6bH5A==

                    "]]}, 
                   Annotation[#, 
                    "Charting`Private`Tag$44412#1"]& ]}}, {}, {}}, {
               DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
                AxesOrigin -> {0, 0}, FrameTicks -> {{{}, {}}, {{}, {}}}, 
                GridLines -> {None, None}, DisplayFunction -> Identity, 
                PlotRangePadding -> {{
                   Scaled[0.1], 
                   Scaled[0.1]}, {
                   Scaled[0.1], 
                   Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                All, DisplayFunction -> Identity, AspectRatio -> 1, 
                Axes -> {False, False}, AxesLabel -> {None, None}, 
                AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
                Frame -> {{True, True}, {True, True}}, 
                FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                Directive[
                  Opacity[0.5], 
                  Thickness[Tiny], 
                  RGBColor[0.368417, 0.506779, 0.709798]], 
                FrameTicks -> {{None, None}, {None, None}}, 
                GridLines -> {None, None}, GridLinesStyle -> Directive[
                  GrayLevel[0.5, 0.4]], ImageSize -> 
                Dynamic[{
                  Automatic, 3.5 CurrentValue["FontCapHeight"]/
                   AbsoluteCurrentValue[Magnification]}], 
                Method -> {
                 "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
                  AbsolutePointSize[6], "ScalingFunctions" -> None, 
                  "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                    (Identity[#]& )[
                    Part[#, 1]], 
                    (Identity[#]& )[
                    Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                    (Identity[#]& )[
                    Part[#, 1]], 
                    (Identity[#]& )[
                    Part[#, 2]]}& )}}, 
                PlotRange -> {{0.20000000000004547`, 4.}, {0., 
                 578.304496844273}}, PlotRangeClipping -> True, 
                PlotRangePadding -> {{
                   Scaled[0.1], 
                   Scaled[0.1]}, {
                   Scaled[0.1], 
                   Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
              GridBox[{{
                 RowBox[{
                   TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"0.20000000000004547`", ",", "4.`"}], "}"}], 
                    "}"}], "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["\"scalar\"", "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Order: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["3", "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Method: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["\"Hermite\"", "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Periodic: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["False", "SummaryItem"]}]}}, 
               GridBoxAlignment -> {
                "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, AutoDelete -> 
               False, GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
               GridBoxSpacings -> {
                "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
               BaseStyle -> {
                ShowStringCharacters -> False, NumberMarks -> False, 
                 PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
            GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> False, 
            GridBoxItemSize -> {
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
            BaselinePosition -> {1, 1}]}, 
         Dynamic[Typeset`open$$], ImageSize -> Automatic], BaselinePosition -> 
        Baseline], DynamicModuleValues :> {}], 
      StyleBox["]", "NonInterpretableSummary"]}]},
   "CopyTag",
   DisplayFunction->(#& ),
   InterpretationFunction->("InterpolatingFunction[{{0.2, 4.}}, <>]"& )],
  False,
  Editable->False,
  SelectWithContents->True,
  Selectable->False]], "Output",
 CellChangeTimes->{3.726235995255*^9, 3.726239207005*^9, 3.726240725686*^9, 
  3.7262409695559998`*^9, 3.7262410185030003`*^9, 
  3.7262433589370003`*^9},ExpressionUUID->"ecac65bf-9950-4cf2-a2f1-\
42589b649e2f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"h", "\[Rule]", "2.8199883087700885`"}], "}"}]], "Output",
 CellChangeTimes->{3.726235995255*^9, 3.726239207005*^9, 3.726240725686*^9, 
  3.7262409695559998`*^9, 3.7262410185030003`*^9, 
  3.7262433589449997`*^9},ExpressionUUID->"68809b79-0ef5-4316-96a2-\
a2b32b2321ee"]
}, Open  ]],

Cell[BoxData[" "], "Input",
 CellChangeTimes->{{3.726236029142*^9, 3.72623603277*^9}, 
   3.7262360919820004`*^9},ExpressionUUID->"e7e5a273-8561-4939-9f1b-\
58b94f98d3d8"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{
   RowBox[{"alt", "=", 
    RowBox[{"zmin", "+", "2.82"}]}], "\[IndentingNewLine]", " ", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ival", "=", 
     RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"xval", "=", 
     RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Do", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"profil", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "2"}], "]"}], "]"}], "\[LessEqual]", "alt", "<=", 
          RowBox[{"profil", "[", 
           RowBox[{"[", 
            RowBox[{
             RowBox[{"i", "+", "1"}], ",", "2"}], "]"}], "]"}]}], "||", 
         RowBox[{
          RowBox[{"profil", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "2"}], "]"}], "]"}], "\[GreaterEqual]", " ", 
          "alt", "\[GreaterEqual]", 
          RowBox[{"profil", "[", 
           RowBox[{"[", 
            RowBox[{
             RowBox[{"i", "+", "1"}], ",", "2"}], "]"}], "]"}]}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"AppendTo", "[", 
          RowBox[{"ival", ",", "i"}], "]"}], ";", "\[IndentingNewLine]", 
         RowBox[{"interp", "=", 
          RowBox[{"Interpolation", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"profil", "[", 
               RowBox[{"[", "i", "  ", "]"}], "]"}], ",", 
              RowBox[{"profil", "[", 
               RowBox[{"[", 
                RowBox[{"i", "+", "1"}], " ", "]"}], "]"}]}], "}"}], ",", 
            RowBox[{"InterpolationOrder", "\[Rule]", "1"}]}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"xc", "=", 
          RowBox[{"x", "/.", 
           RowBox[{
            RowBox[{"FindRoot", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"interp", "[", "x", "]"}], "\[Equal]", "alt"}], ",", 
              RowBox[{"{", 
               RowBox[{"x", ",", 
                RowBox[{"profil", "[", 
                 RowBox[{"[", 
                  RowBox[{
                   RowBox[{"i", "+", "1"}], ",", "1"}], "]"}], "]"}]}], 
               "}"}]}], "]"}], "[", 
            RowBox[{"[", "1", "]"}], "]"}]}]}], ";", 
         RowBox[{"Print", "[", 
          RowBox[{"\"\<i =\>\"", ",", "i", ",", "\"\< x = \>\"", ",", "xc"}], 
          "]"}], ";", 
         RowBox[{"AppendTo", "[", 
          RowBox[{"xval", ",", "xc"}], "]"}], ";"}]}], "\[IndentingNewLine]", 
       "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", 
        RowBox[{"n", "-", "1"}]}], "}"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"il", ",", "ir"}], "}"}], "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"First", "@", "ival"}], ",", 
       RowBox[{"Last", "@", "ival"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"xl", ",", "xr"}], "}"}], "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"First", "@", "xval"}], ",", 
       RowBox[{"Last", "@", "xval"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"set", "=", 
     RowBox[{"Join", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"xl", ",", "alt"}], "}"}], "}"}], ",", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"profil", "[", 
          RowBox[{"[", "i", "]"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", 
           RowBox[{"il", "+", "1"}], ",", "ir"}], "}"}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"xr", ",", "alt"}], "}"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[Chi]", "=", 
     RowBox[{"ArcLength", "@", 
      RowBox[{"Line", "[", "set", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"S", "=", 
     RowBox[{"NIntegrate", "[", 
      RowBox[{
       RowBox[{"alt", " ", "-", 
        RowBox[{"profilInterp", "[", "x", "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "xl", ",", "xr"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Rh", "=", 
     RowBox[{"S", "/", "\[Chi]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"Q", "=", 
    RowBox[{"S", " ", 
     RowBox[{"Rh", "^", 
      RowBox[{"(", 
       RowBox[{"2", "/", "3"}], ")"}]}], " ", 
     RowBox[{"Sqrt", "[", "pente", "]"}], " ", "K"}]}], "\[IndentingNewLine]",
    " "}]}]], "Input",
 CellChangeTimes->{{3.726236096017*^9, 3.726236139051*^9}, {3.726239212269*^9,
   3.726239247734*^9}, {3.72624078179*^9, 3.726240785001*^9}, {
  3.726240973641*^9, 3.726240973863*^9}, {3.726241021763*^9, 
  3.726241027323*^9}, {3.726243365612*^9, 
  3.726243366226*^9}},ExpressionUUID->"b6ddd11d-ff73-4d46-9bb5-6020e6cf9be5"],

Cell[BoxData["1082.54`"], "Output",
 CellChangeTimes->{{3.726236135211*^9, 3.7262361397939997`*^9}, {
   3.726239214106*^9, 3.726239247984*^9}, 3.726240728785*^9, 
   3.7262407858199997`*^9, 3.72624097419*^9, {3.7262410228640003`*^9, 
   3.726241027612*^9}, 
   3.726243366506*^9},ExpressionUUID->"761b8d3b-8ff8-443e-a695-c0e2010042fa"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "27.470857142856914`"}],
  SequenceForm["i =", 10, " x = ", 27.470857142856914`],
  Editable->False]], "Print",
 CellChangeTimes->{{3.726236135215*^9, 3.726236139803*^9}, {3.726239214113*^9,
    3.726239247988*^9}, 3.72624072879*^9, 3.726240785824*^9, 
   3.726240974196*^9, {3.72624102287*^9, 3.726241027616*^9}, 
   3.7262433665109997`*^9},ExpressionUUID->"ba97fb18-3999-4a4c-9ba2-\
328e24d9f09f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "31", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "68.5119999999989`"}],
  SequenceForm["i =", 31, " x = ", 68.5119999999989],
  Editable->False]], "Print",
 CellChangeTimes->{{3.726236135215*^9, 3.726236139803*^9}, {3.726239214113*^9,
    3.726239247988*^9}, 3.72624072879*^9, 3.726240785824*^9, 
   3.726240974196*^9, {3.72624102287*^9, 3.726241027616*^9}, 
   3.726243366514*^9},ExpressionUUID->"d4c636a5-26b3-4da4-80e2-03b90734000a"]
}, Open  ]],

Cell[BoxData["200.0027963217887`"], "Output",
 CellChangeTimes->{{3.726236135211*^9, 3.7262361397939997`*^9}, {
   3.726239214106*^9, 3.726239247984*^9}, 3.726240728785*^9, 
   3.7262407858199997`*^9, 3.72624097419*^9, {3.7262410228640003`*^9, 
   3.726241027612*^9}, 
   3.726243366552*^9},ExpressionUUID->"4bd2d6f6-4051-4287-95d3-50ab9ed98726"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"des1", "=", 
  RowBox[{"Show", "[", 
   RowBox[{
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"profilInterp", "[", "x", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "xl", ",", "xr"}], "}"}]}], "]"}], ",", 
    RowBox[{"Plot", "[", 
     RowBox[{"alt", ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "xl", ",", "xr"}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", "Dashed"}]}], " ", "]"}], " ", ",", 
    RowBox[{"Frame", "\[Rule]", "True"}], ",", 
    RowBox[{"FrameLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<\!\(\*
StyleBox[\"x\",
FontSlant->\"Italic\"]\)\!\(\*
StyleBox[\" \",
FontSlant->\"Italic\"]\)(m)\>\"", ",", "\"\<\!\(\*
StyleBox[\"z\",
FontSlant->\"Italic\"]\)\!\(\*
StyleBox[\" \",
FontSlant->\"Italic\"]\)(m)\>\""}], "}"}]}], ",", 
    RowBox[{"BaseStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"FontFamily", "->", "\"\<Times\>\""}], ",", "14"}], "}"}]}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.7262361432539997`*^9, 3.726236190376*^9}, {
  3.7262389987869997`*^9, 3.726239033442*^9}, {3.7262392680439997`*^9, 
  3.726239281119*^9}, {3.7262394803380003`*^9, 
  3.7262394844560003`*^9}},ExpressionUUID->"b396f632-028e-49f5-a44f-\
1dec403a2c91"],

Cell[BoxData[
 GraphicsBox[{{{{{}, {}, 
      TagBox[{
        {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
         Opacity[1.], LineBox[CompressedData["
1:eJxF2nc8Vf//AHBZpbJHKbJKqGRFEV73uot7c68VLSEkLamMIuFTRhGlaBll
JTKSkqyiUkJklYxEZmQVkd/r/P74+ofH83HueZ/3eb1f73He5yg4Hbd04ebi
4jqFf4j/TJ5lyuE+BuBU8mRSZSAKEr/5i7w6awDC/2z5lNET5aMzf88ZQJHh
jIQSOv58U+3RCwYgUWykI4senUvytbhqAK+L3niKom/82fphZaYBqBa2jkz3
R8G3YddTaR0GMPJ4rv8d+kzLy5cVtO3g94DafgQt7BC1wU7ZEJIuxk0k9kXB
veDELbdVDWGX1PzMXbRuWo5x+0ZDEEl1WXQbbf+zzspZ2xACKrWErqMz/UT9
PMAQ9vF+WB+GNr15tTp0tyGsClq05wQ6uD7maGGkIVz1dy8noaWmkr1now3B
TPDjGyN0hvSTQOPrhrDorl6NAbreofF65W1D8HjB+2ULWn5EsuRjuiGY/42f
UEUXL4sVGnhpCEt9G9aLoX9Tbmav+m0Iwae2R377EQUyvrZ2O2YMYT782v0O
NDlLctH5OUM4mzTwrA19WfKqZQ+PEZyqietuQsv3hk9mixiBi8rk1vdo6irT
+G/iRtBlxDJ/i3Y3X0yXXGEE+2zuH6hE5xcEx52RNYKdQRaRpejWARIpS94I
6uPS779A/1vDNdChZATm2fPPCtGMED8DqpoR0Nuyuh+jjxbpf/feZASvxnin
c9BXR/5cztAwAkbXGYlH6KdKT7d81V5wm+3pdmG9BSuX/dp82nDBHirHAj+b
LJh32nVtCmfBcVX73xzft+C+ZSZWt6IWvM1cuaPi1YIFM3/vfa1l/D93CVR9
fpO0YPmo8w4xjQvevEzmZA4v/M8lQ2Ex90UXbF7z+8mNNQuWKn1EE1m34PZs
l+awDQsmq5QnvFZfcGqijBuP1oJb9ppVJ2kveKm0jwZsWfD2xpSYdt0FH4tu
+OO3FaCKtGY4C83ne1PISB/APfeiZSb6jsP+tfMGAMsVRp5moKs2D7IDjQHM
ucqC0tBra7jTLtAAGkocVyahPy/Vsom0Bmg3SDGJQdP+i8pN8AAY27Lx1hm0
nPcO95fpADJq+nQ6kQ+u7uyzGQDzl+TyqcT97gzR0ckE6BrmVaAQ19ct/5eS
DZCWWzsD6FVTOtfCCgC0t7k80ifidVrmBacCwJQRJamOFjo5KNjRAeDt2tst
gf7ptGQ8tgtg99v3HHH0B8t1LZxuAEO13GJRIt+19t972QvA8/NsrBARr7F6
3dRhgMjToswlaP4Tz/cf/QuQ8t/2vL+9UdDr0ExRngMI7VWQm0FXciZUO/4B
HGYsvvwH/Z+G+gSHmwQay+tdJtHco0mhOgIkeHHtoPQI+ltHydHhpSRImGRd
HEaX136xTF1OgkBbrfFB9PlsSdmVIiSgr56r7kPvT9Di/ihKAjX/b9t+oI2u
sH+EiZNAsONNag96TcCRarIkCUYhS/w7eu5YWO5fKRI03Lt6/hs6rrFt4sZK
Ely3FdnQhdbarrFVaxUJWq7Hnu9EV98LPvthNQlWfVrT1IF2FWgucZMlwV6x
1A2EuTzUuHnlSBDP2RTYjr7V5E9NkCdBZ2R+01d0zf211Y1KJHBZ9iqwDZ3Q
UtqbrUEC77nZTc1oEnlqtbMZCW53eVysRl+QPHCx2p8E3x7Y6T0l4pVmfjY8
gASF7ufOFaCDtul7MAJJEL0hufIJEY99orsr/iMBZI1Y5aP9Uko3vbhEgrs5
Fz1y0ae2yDQ+vEkCu6f5Dx6inWwalS49IUFNhYhMItrxR9lK06ckSLmgeyAB
7eCbKbi4kAT+tL0Z8Wj7u8G/g16QYOPbtK130bt7NN+feUWCsPdGNrfQFqcj
Pd0/koBSfyQyBg3X6eWmwyR43vGWKww9c/eQxMBPEjz7p2sdin6ceulg+CgJ
CmRT0kLQys9qBd+PkyB3T6D5RfTyL7a7WTMkSG/edicY/brbN2voL9ZvKm0k
CB0wdJsrYo4E9yWlTAiPzXWkfuAiQ4LVWP95dKu827j5YjJcr83QO4e+qhpO
G1lChms/V17yR7O0Mm9eWUqGaMGQdj80v0HN0OblZLiycVKTcJnJqHGdIBku
Mw9cOIs+wxK75iFMhu+M0cYzaG0bnV4RUTK8Skv56YtOdfW5bCFBhvMuIvI+
aM/M0HXWCmTw2lvU44He+CTDZ0KRDNZFHv+Oo3uKq9/HrCWD9irlFYTtakU8
G9eT4VdzFOMo2ngsrmSnOhkOW7k+PETEY+sD210GZHA0Ez3hhE55VRVmb0MG
1taDs1bo9E/kzKmdZPjo+kCacEZPUU2kHRl2Xh/UtUQ/WvxIvHQPGRzGjp/g
oJ8xr96VcyLDyUyfXhb6XcPu3M5jZLgpH15HRf/sHmxxCiVDz5KsZD306ITz
35kwMrjrjZTrEvHma5e9dokMIy6aHVvQv9fXOb2KJMOfl0+kdYj+cCR/SOk6
GZb5l0RqoMUm/Lh6ksig9avWRxUtwTel6H+fDAVyYjdU0FJSx6mSKWQwMLd+
vB69eqtjODWdDNSHLcPr0Gv9qBKpj8hg59LlpEjkS0SJrlEOGb5eUzqvgFaN
19vVlIvxeelyVx6tXqYaz/8E4yc30LwGrccrpHKwiAznWsdYq9HxIDerUEyG
wdqfO1cR7e+vUddWQgbb1wMO0uijhaTk2DIyVLzodV+J/jRp6WP5kgyaj7+d
WoE20HJmCVaQ4e6D9nNS6HvHTsu/rSTD0sTPoZJogYcXJ4LekMH7RtNVCbTH
j9i3hlVksFENbRZBNys9uPPnHRnaOvNqlxPjlcNzj8fVZDgQ9/XNEqK9W9tW
qtaRwXOx9jMuon3fKRySaCZDZM/XuNEeXG8t1jasbSGD5N0l0UNoLxOKaPhn
rI+1dlgfmvLCtXD+Kxkevgr17UR3ZT0UGPxOhjdJ2rvr0Kuit2SUj5FhkX3Y
6hx04AfaOb8JMoRK5otnovsE7Cz1psgg/KF9WTq6IOjMTOY0GWS368wmoC1P
lZrFcZmA/qqOtivoS7amg8eETOBkk078cfSs7L6NMmom0GPeKb8ZfbjXtMQt
2gQuDJ4+ZvQd1wehpALHRRSYe/G0Tqcb1yfHfA5J81Dgu96bVA10pk22zEde
ClTnNfltRJspyQbDEgrcTp9UWYu+WPKHLSdMAf0Y7UBxNNdkdn+bDAV8Dmdr
jn3D9a7jGlm7rRSYkE67mo1+xbCpE9anQFtMgdtD9NXNl4PfGFDglfBrozS0
5tx0v64xBa7x9QzEo4/FNRZI0iiYr4omkei+msucBisKeLyNHz+CfvrkFc8l
GwrYmjyqckNfvDNTQLalgHFJcYIzep27m2zebgoI5bcx96Kd+CgDUY4UyEpY
lcwkrjd05i7jAAWur1I7Q0dzNeRyuFwo4H99G8cEHZ8o9/S4GwVYl+xm9dFf
DP4Gmx+nwKDXDWs1tPNNt+t9HhSwLzrrqYz+OdWYGuRJgbp5hyhFtI+1yTOZ
UxQwodAerUFz5+VUFZymQEHohupV6MvCa75wvCmg8kFkQAotdfTS0IAPBbJv
zv0URye++zP33xkKcBuK+Yih1VRcheX8KGDTqbxIFJ1/oUG+0J8C6cEG4cJo
o27QsgqgwIwyR1wIbRm/2iYkiAKJR33XLUP7Sny8NRKK9Z95b8pH1MfTKDMs
nAKG8Z31PER9ah8WK12mQBRpcg83cf3wi522VyiwJXTNsfmuKHjLtV257DoF
zkueuDqNXjGcmht1jwJSGlJfhtGJZhKv1JIpcKhBzXkIrZYe+KkihQJFXsbD
A2ijA3t//0mngGOx2/wPtGurqKFjNgUyzYqUvqGfVPq91XxBAZKLw5EmtFW8
ZUd9IwWO3MqYK0GT19vdu9JMAcVh/oPFaI2cfS6sVgq0GB+oK0ILvXQbrGyj
AKVn9f1nRH17zv1+1k0BGY0IRh5x/U0PhRN+YT5XHr+WglZ5wQOHBamw6ZeO
6mXifqgCPCrCVOg2ib4ajuavEXr9XYQKN28M/w1Fd3dIs+wlqMC3PbXmAjqe
R8POYjUVvl5ccSoALc7c66GnSoUImZkSTzT3J0ftCTUqmBzfqXICPbr34FTO
RipMl+dFH0fXHPP0U9OggsvBw85H0KFXQ0Nl9ahgmNcm4Ir+15qfyEOlwjC9
1HoXOq11tPwejQpW6tqttmhO68ZuEoMKzyXS9u1E329JXneeSYWQrkhXKzSr
pZMmt4MKP99wD1qgp5pl3ErMqWDzyOs4B81ojsmYtaCC4ll7nx3osaa697et
qBDmWD/LRN9uWj6sb0OFUTot0AxNaWIIfd5JhZ3qz/lM0T8b/9vsa0cFYnlO
R0Pj7ImnexZ87dOp/En7Bbd/tC75eXjBKrU6b3/4LLikauJL69UFW1Xkj7zP
XPAKZX0z/p4FfwkpTQZZ2v8c+lOy/7H8gnVtjmxav3bBEaGxtZ3rFvy96OWJ
W+sXbDAyLG6tSoOV5KMZFPRVRekCwQ002GzZHkRC99tQ7N5spAHNib3HiLjf
sOMz59VpsM+zTNsAPTxSaTShSYPLV+991yHiW+z55vNWGvTVu9JU0Amjdw/F
6NOAq7t5zTqiPZSqlplvp8GKccZvBXRyuByn3JgGVPEN6avR87bVLWk0Gtyz
GhEQRheMrRs4ZU2DPZ+8P0x24vitbHFZfScNPL/3pYyhnXf5qffZ0iBsYte5
EbRoWb3nnj00eCqxfXM/+khEwF+SEw0kbLii29BKKq3LhT1o8KEx1PoVOmrf
5c0PLuEDUvPNL1Hoe4t/bqZG0OCZkP5ABPpxLlujK5IGmrTPf8LRTXzimtJX
aaD4ZJXUBbTMo5taYXE04L12m+OLTv+XuuVQCg2qzO9WOqLLEsoNVEtpYPk6
MVsLXW+qtL2yjAbv5qBkM7p7/L/tji9pYLKlq3ojmp/BMLxZSQOdZIUBZTRr
tMZIoJoGUkH31q5Gt0Abqb+FBl8Mk2/yoEe6pugPxmjg/CQt+FMHji9PR6cP
TtDgPrPZ8iO67fLAQ+UpGnzr4lesQb/VaxdOnqaBo5Br2Ru0kWBLudNfGiQm
X79SgX7y7eNJhTkadOhX2pej70VUNsdz0WHfwbVzz9ErD5SG7eOmw505q+qn
6MithQYyvHRouxZ8Ox/NK/R4+DMfHVarPXbPRZ/tzky4uZgOu8u+bXuEHnuW
amEnQIfnembKmWi3yESeFcvo0NjjKJ+Btt4WczBGiA7LyNESqeh3QpHSViJ0
UB5NF0pGw/eQ96JidCDFly25h9505ezmK5J08J4Zmb2L5u9x+h0mQ4fuPPOe
6+hnUZohAWp0eKG0vOACWt11wzajjXRo/qiUE4xONlg3OLuJDmMBBhmB6Oje
lewzmnRQaXOP90e7b+dacXorHWJiqi6eRsv01aS60+hwlC/E1gUdaHzktY0T
HWR/LJqmoPMu3WmaOkCHT3mnJE3Q35qre2Nd6BB+7ocmCU3x2LT4sxsdfkt+
cDdEL0n6Sbc/ToePlLi2Lego7hNVrn50uHBPvUwZXW6e1Lr4HB22H0tqW0vE
79bH/vQArO82iWlFIl7aWksHg+iw/+O0phzRPs7jZsfD6LCNq/L+CnRC5elq
7xt0GN63J2QJuk40tW1lHB2SVWvu86O57JuGCm9i+0xCGS/aaUpXcPYOHd5c
Vp7mQiuv/7Pj/H06JBX9cp9ujwLbkyr2Cil0sAtxDvmNDi21O/YylQ5CVs33
J9EDtoWRvBl0ODvwou0X+lHomdrQHDrYSIeaD6A7PmV0qObRYXnPjHsfWkTh
y8i7x3R4mXM0pBdNOrqM68gTOvj6dd7/jvYsNBARfEqHzQyrsm/o+3xH5B89
o4Nz/t/bXehPFnc02M+xfWxY0t1ovvhqGC2iQ8XUnRvE+boDs5zoYjqMxw6L
E+Uf1N3kqFVKB6VtRtE/0HFB+040lNHB6nOkUD96ZlVJtGQFHfJkNASG0MXM
gPqb7+hwIsnzH3E/uon8eVrVGG8O7dQ4OmciIvr9BzrsmJcemEAn373Dmauj
g9q+8kYiPuEjhTUOzXT4tlIka46I37WJd+u/4/WisvYIYHx/fT706skcHXQD
+p7JdxDrN+v8jxoM+LvX/iSb6E8DJ6kRWgy4sHdgiQWRT4euNTF0GCCy1wtX
CjgfH6r/U6rHAOU9kVU2RPsf4hg+MmKAxa4Sub3o5W6s1+EsBqTbrKl2I/LH
hdJi4saAnebta4OIfOg5cGj+EAO6drg/J/pDtkvwzPPDDDiyY4pN9JcjLi9l
tI4zIJAldDYU3esMjvJeDMgyM/oYiW49sH1gNpgBvPR4/9tEf+vec/bZBQZE
0tTEif5448DZ5adCGCBNK0iPR1seeK4+GM6AzdSahiR0tdPWk63RDNht8k81
HV3mqDP7JIEBo99OLX+M3mUXPmiVxADfY0WKxPgyZt75+dc9BvDMLNr2BL12
++XCTakMWCF6xYUYj0KlvnulZDLAyPhBSRHa4v21XzGFDIi4/dWDGN++6Yz3
nmxggJo1rbGRGJ82mDaJNjLgccflwSa0hGJCZXYTAwwPNyxqQdOEmcmDrRjP
IAf1z+iH/fccD3QywCfnTEg7+lS8ZZvlMAPeLM/e9gPNtyTvo+ZiUzhQuSL+
D5pbLdFzbIkpvFPMfT9N9DdWpPjjpaagcd5segY9e8XdRkfIFOb0/a3n0BMr
lFp1JU0hNufbUm4c38e2iZ75LYXHBf22EuP96J75Vc9WmoLzYUlXXvRQwpe9
22RMQVOZUc5PzCfrYzoNlEzh/e0s72XoTtOgwNm1eHyalrIc3X7YQ7FYGcvf
2VkviP6czXI2UsPyRMXVRYj55aM+3/wGPP9Y5h5RYr4bV0kt3YTnV1PDxNCf
JFfQz282hTjVjgJxYj7T4+sDTVPAxcQZCfS70uLDJlsXXE73GqEaLzjhoN0/
9p4F+4foC+72XjCnrkPS7dGCFaUvrPHqWbDZtunh2pVm//OJXUeLVVkLvvdi
WYnk7gXXy2WULHJbsLvFdMnvYwvmDmaUDp9esBt7r/FD7wXXrPYodfM1g6f9
W17LonX6go2Vz5qByca6BGK+vpUfW9rtZwa1x9x9DdBcgQ+Nk86ZwZ5cXisz
tOuO0lL782bwYzx+4y60Vm9vaWuwGcz7NHR4oePyZoxjL5jBpaKjhcR64t85
oTLrEDNY8W/xtRginit0y2rDzWBz8HZaHtrJ9EJZZbQZ2EekZA6jr2Yqlecm
mEFJkrevM66Xxj0dXoYVmYH/u9Xilvg8I1GQkahabAbD860j+9E60xPnqkrM
YN+WuOqjaK+AMAOBl2ZgmChxMQz951JefuhbM5g7LThdhv6XzJsW0ojlKcy3
b8bnXYHm9EsXRtA+3zIE8XlabdX4oXW/sPysxJDVaLN9hozKMSy/295ZFX25
+yMv3xSWb/5FlooWGp3x/28Wy1f6FOWHlhDY4REswIRztZVeg2g5g1/WgUpo
5QfkKnx+D714lVt6HRO2tAW3NqHHPmrn5CgzYTDa3uM7usLNa1mnKhN2zYnH
z6PV81cUem9ggvDjnzqCvVEQO//MVXgTE167Vb0n9lvcb/wtN9Jggs6nc9PE
/tGnrjvHmzSZMBC2K8oEbbjJSPaYNhOSjHXWWxD7az4d7/i2MMFuUqjEHi1S
cd7nri4ThB72Wx8h9ueEFZW3bGVCpUPFILEf1737VUP1NiZ8rd9RF0Ds96U6
BzobMKGFZCB3AV3wi2/z7HYmNOSoHAtHyxumtV0zYkKtnFTxFXRYKCN8AzDh
XSTP8uvovXKXenabMKH8SPsDYn900Q6RO4WmTHikEtND7Ley0lcJeO9kQlji
/F5iP7hgvKhAyI4JF4SHHxL7zXLG+5xTdzHh/LnPM/3E/lljQmnjXiZ4730S
N0HEh2edl84BJjivPPxJ4AeOj/abu38dZ4JxVBNTB+0jSSk+EsaEyYAs/TDi
fcFlf5n1l5i47oG5SLQEz9OzXZeZIDhfX0q8T8gdVdXfGcUE5XN/KInogffC
T41jmbDTz4T9FL0n6EuOWAoTCnxaD/SgjUY8k5+VMcHrBF8E8X5tuWsmz8mX
TODWjGPT0Z/bepw2VTAhclRNbAfa+52dwr03TEg9zom1Q+ekGMVfqmFC09Hb
ScfRCnuXxtm3MUHPXbOAeP83Wm/ye2U7E16pVvjcR5eY+u9s6GACu3+nwQP0
br1RCUY3Ew66+ZXlo1UeqZ7i7mHC+Hrh4OfoqbUHGl70MiHgRxK1DH1VrCla
c4AJsa5v3r1HO4QJ/xocZIKS8u6Ij2h1LlNO6jATsnuG2M3oWa+gbIcRJhik
BIh9Rb8fLhJa/YsJ8adWzHehbzlPHm0cY4LbxIO072i3L+ofrkwwQfvUds4P
NG9V0iXeP0x4e9IxaQgdUSBqmjTNBI+gfTIjxPvI5EB+o79MkI7eFfuLqH+A
Y6D3Pya4P7KImEIztyh4D/CyYHk/yZerH+uflOhUJ8oCjr2ihQRa7kzCtjsb
WNDC6Obajk4/KPx76yYWBNp2nDVCa9gE5Deqs0DV9csUoMka+zcLa7HgTHDD
EBXt2rtmXdBWFsiUvGphozMt40XcqCxw1E7OOYDW33D3h/Z+FvTLujhcQqtQ
UnaOO7DAXq1cJBItuS+rMs+JBQ26suVR6NHI4vuariwoZjcq3ECnjX3dv/ko
C64GUrsT0RLP17SonWWBQc861wI0d4MyfcCPBTm/AqUK0SOD6gUPzrFg3b+v
r4vQ72SNY1SCWCC84sb6cnRg4H6OchgLvjP4+9+jfzIS3yrEsiAis/dwF7rN
MV2vK44F3IVkme/oqjM5qYm3WOBdGV/di07OLPtPLh7vr33npiH0HpEukE1h
wRaRNz+n0AzV/uy2VBY8lFFKIN5f65J/rbmTzgJ51QD2LFrs1KK5VZksWErW
y1k0gPNFhMCRz1ksCDC/5sCLHk4R/XIzmwUTu0dEFqPfNisUrnzMgvaTaSeW
owtGVVVa8llgfZ5HURidLKAVG1vAgqrL++uJ9+dXFfX5bZ+xoDOuyUcCHWBA
Pi31nAXHnb5WiqOPWJt9byxiwfyG72KEdx+1tLpezIIrkwP7xdC6CU6aEuUs
XLf/mRZBr33mntjwkgWGlvM0wqIfPYWvVbDgw2r+GOL6Q9zBw6JvWTD0SFxd
CH3f9f4D4VoWbGhUd1qGZk11eeXWscBuRLhoKfE9wAV5ilU9Cy4I/BInTEm5
236jkQUdho8rl6B7u2PF17Rhe6fqqfKjVRwv+2/sZ8GMN4xyoTP3nLYw5dkB
VasszxHxfsKhTwfp7YCDDqdvEe03wcpaM3B3B9S6uyY/I/JTcU3G3HJzaAh9
/v/5FZS68VX6KXMQ+p33mfh+4CMPjczVYw6+f6aziHzecVIhlmnFBunFLVek
0a9tHyr+sGbDr9ptgyvRRtu3PArayYaquNs0whp8ppWFu9jgq7Z/Topo31iP
8fUObGjZ0etO9K+m56Vs3qNsuBEzQRVGO3DbLym+yMZ1pugsL7ql98c1u1A2
DA542hK2eH9CbiKMDa8ef8rjIfpbzAXdDRFsOEmNO8SNXqec5XzzGhvq3eSa
57F/D5jOlp1OZEN09qa8GfTJ6Fu+6s/ZIGRo5jaK5iS9KBgqYkOS0/snxHih
nts+nlHMBp1QFg/hvjrFY+vL2bCnwTx+mPg+QuShk/xbNqQfsvo0gDaQ/5DQ
XsUGgyufFAiv1Bhpu/OeDTX5Nsf70Q1sbVvpWjZMztsu7UMzrhQxxZrYQL6x
F3rQyglfQ+ua2dBY9DWCGN94sucrI1vZ4NZl/6Ub3VmiwLPjCxv+8neqEC6p
MYFlX9lwZaOj1zf07XYX/6p2NihafntFjJc+P0Oeh3RivGdNwwjv/PfgN/Ub
G+i7/zkQv9cWqtbh/c4GqWd5W4nyRNb8PPGyhw3fJQ+KENf/uUkk+/wPNuSd
XN1HOH2HtercABvYm/+L7UWviWiTnfrFhrBUmyni/mbv/NudP84GO96lNcT9
t2bKx3lOskHZqSRlEB1T7Sw28gfbS3a9DRE/geXD/H3zbJiL+fOYiP+Zyn+/
h/g54BF8+8RvtAtFuKtdggO2Dl1DRHvnhRSpZ0tyIKGHXMCH/vfuoF+AFAd+
uCcH8KNvWJStkF/JAe/TB8WWEPlof8LccTUHYsOH9ZahlX0biroVONCcPx0k
iu7Nir3Rp84BOwEx6TVE/q+QZ40x0Hlkqh763LjovfmzHHhwjZLohk6q26Lx
1Y8D4/WnvQ6hK7J2lTz354ChWBrLHS3glvT5dAAH6qIEpg+jY9o0xIeCOPA7
osbiODqjkv1fSxgHaKF2PF5EvsdGuObGcqDb74hrMHr6VO5EZBwHNr64u/0/
tIxlY9CRmxzw+lsjdgHtuFw2Yf1tDiw9o1l6ET10PrP5bjwHNL2nVoQT47v7
e0Z4CgcCTpyvIvrv5u0CGw485oCMa8zGeHSONaNPM58DndWeE4Q1joakcD3h
wH1tixcJhOP55OMLOKC2SIiVRJiLW7K1kAN6d0IOJxPnryTVpz3nwF9uV+0U
4rjm+SteRRwoOUT5+/92+icgUcwBqt6iS2mEK2b+mZdxwLL+TEYGcX7bthey
5RyQ2rbL8yFxfNLHdwjdmqCnn0kcF3ymW/SSA3f5pbiziOPKv8fDXnHA4ehE
FeEcI91cuwoOPK8YLH1EHLc9fWx9JQfKo5gfs9GaoeN9Fa85UKuybCIXrcUa
qtf/wIHFYQIBz4n8cd4QJVDDASGbQ1HEfKfl776jBS2pUJX0gvCjvjen6zig
VBhaUYLWFul5kdPAAeP+xUtfoXU+fU1V/oz5Zcp/nZgPt+ytPSP2A/NPgOdh
G3oqnWIyjXab3NT2FV0wWbiss48D/Z12gh3orVeS72QNcGDw6aPjxPir/9K3
hPGTAyMuu3WI+dJIZS13wCTmS3lu8QiaNuETNshjAYvPONRx43jOT/ppUc9r
AaEulxYR89+biAOrCvksQMCiQIsPzVhv/vDiYgtYprL8OjEfmu1W+qCwzAKE
m57uIuZDdtkHETsxC1ihJdwtiRYRNGk1EreAOFl9iRXoul3PktZJWIC0gAt1
Jdpy/J7WuKQFrO58nrYKba3sYx0pbQFyka5H5NASJ4dlTq+ygETf6Lvy6MZS
p549qy1AweVFjQJ6564dXqqyFqC0XUxzLVoq9aWRyBoLSF5v6LQO3Tymt/g3
ep242zXi+7c446zar3IWkPrvasV6tN1lxbgKeQtYP1D8/9/L/R9G5vp/
          "]]}},
       Annotation[#, "Charting`Private`Tag$44526#1"]& ]}}, {}, {}}, {{{{}, {}, 
      TagBox[{
        {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
         Opacity[1.], Dashing[{Small, Small}], LineBox[CompressedData["
1:eJxTTMoPSmViYGAwAWIQ7c3MrdZVYe0Q03/oq8arCQ6P3qaVLL+P4FfdOHTo
iJsNnM+fMEE7Qs0Wzv/uMnO91HcE39JP7f6Rw3Zw/kPOk7eOL7SH8/MmXv5R
Y+EA58uX+2YdWoHg/83r3PhbzBHObxVNbjtTi+A7THU/6PkWwV96+GRnXKgT
nG/OwqeRvhvB/yMbqyOj5QznZz/z3JcxEcHn7XDclsjoAufftv7d7JeP4AfP
C7p/6SqC/+/mlgXMrq4I+SNb3p9eg+Dfbt+/xEHWDc6fENujv7IbwX//8Jv7
yk8IfqN9zrHQJHc4f693/aWZpxB81ayQLRcNPOD8A4kmf7bOR/BZOTZdNGT3
hPNr2614o8oRfCXJVrmypwh+YWTuXk0fLzj/c1HCoc7dCL689ceQRmVvOL9C
1GVvTieCz3JyYTfLDwTfSnvuc+N4Hzh/cdrilfznEfytAe4/m8x94fwvPmvl
Xs1F8NOU5Fb95fGD85uW6RxeUYLgX2R2c2J4iuD7FitO9w72h/OLJ86q1NuF
4Ke68D+8JxKAMF9cweeTB4Jf91lw0f9qBF/fhlM7eTOCbxpzvkroOYLv9qWi
8zVzIJwf0aM044gCgg8AUMmfrw==
          "]]}},
       Annotation[#, "Charting`Private`Tag$44567#1"]& ]}}, {}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{27.470857142856914`, 1079.7203215912677`},
  BaseStyle->{FontFamily -> "Times", 14},
  DisplayFunction->Identity,
  Frame->True,
  FrameLabel->{
    FormBox[
    "\"\\!\\(\\*\\nStyleBox[\\\"x\\\",\\nFontSlant->\\\"Italic\\\"]\\)\\!\\(\\\
*\\nStyleBox[\\\" \\\",\\nFontSlant->\\\"Italic\\\"]\\)(m)\"", 
     TraditionalForm], 
    FormBox[
    "\"\\!\\(\\*\\nStyleBox[\\\"z\\\",\\nFontSlant->\\\"Italic\\\"]\\)\\!\\(\\\
*\\nStyleBox[\\\" \\\",\\nFontSlant->\\\"Italic\\\"]\\)(m)\"", 
     TraditionalForm]},
  FrameTicks->FrontEndValueCache[{{Automatic, 
      Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
      Charting`ScaledFrameTicks[{Identity, Identity}]}}, {{Automatic, {{1080., 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.01, 
        0.}, {
         AbsoluteThickness[0.1]}}, {1080.5, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.01, 
        0.}, {
         AbsoluteThickness[0.1]}}, {1081., 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.01, 
        0.}, {
         AbsoluteThickness[0.1]}}, {1081.5, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.01, 
        0.}, {
         AbsoluteThickness[0.1]}}, {1082., 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.01, 
        0.}, {
         AbsoluteThickness[0.1]}}, {1082.5, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.01, 
        0.}, {
         AbsoluteThickness[0.1]}}, {1079.5, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {1079.6, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {1079.7, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {1079.8, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {1079.9, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {1080.1, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {1080.2, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {1080.3, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {1080.4, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {1080.6, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {1080.7, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {1080.8, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {1080.9, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {1081.1, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {1081.2, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {1081.3, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {1081.4, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {1081.6, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {1081.7, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {1081.8, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {1081.9, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {1082.1, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {1082.2, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {1082.3, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {1082.4, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {1082.6, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {1082.7, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {1082.8, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {1082.9, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {1083., 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}}}, {Automatic, {{30., 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.01, 
        0.}, {
         AbsoluteThickness[0.1]}}, {40., 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.01, 
        0.}, {
         AbsoluteThickness[0.1]}}, {50., 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.01, 
        0.}, {
         AbsoluteThickness[0.1]}}, {60., 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.01, 
        0.}, {
         AbsoluteThickness[0.1]}}, {20., 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {22., 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {24., 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {26., 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {28., 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {32., 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {34., 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {36., 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {38., 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {42., 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {44., 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {46., 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {48., 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {52., 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {54., 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {56., 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {58., 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {62., 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {64., 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {66., 
        FormBox[
         InterpretationBox[
          StyleBox[
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {68., 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {70., 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}}}}],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{27.470857142856914`, 68.5119999999989}, {1079.7203215912677`, 
   1082.539999930779}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.726239034332*^9, 3.7262392514110003`*^9, 
  3.72623928192*^9, 3.72623948565*^9, 3.726240731222*^9, 3.726240789343*^9, 
  3.726240977799*^9, 3.72624103087*^9, 
  3.7262433694440002`*^9},ExpressionUUID->"012fcaf5-82b6-4864-8fee-\
ebd677f3c94a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"14", "*", 
  RowBox[{
  "1.5", "/", 
   "2"}]}], "\[IndentingNewLine]", "S", "\[IndentingNewLine]", "Rh"}], "Input",
 CellChangeTimes->{{3.726236222825*^9, 
  3.7262362778780003`*^9}},ExpressionUUID->"6ac7f522-f204-4256-9da5-\
eba0f670df9f"],

Cell[BoxData["10.5`"], "Output",
 CellChangeTimes->{{3.726236254389*^9, 
  3.726236279014*^9}},ExpressionUUID->"f7e8cf0d-54df-4db6-a941-5c9693d90e0a"],

Cell[BoxData["9.392653846152372`"], "Output",
 CellChangeTimes->{{3.726236254389*^9, 
  3.726236279025*^9}},ExpressionUUID->"97671657-e8b6-45c4-b28f-417cd300fed0"],

Cell[BoxData["15.458828223640888`"], "Output",
 CellChangeTimes->{{3.726236254389*^9, 
  3.7262362790290003`*^9}},ExpressionUUID->"f10e3993-0812-408f-8a50-\
671275f32dcb"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Export", "[", 
  RowBox[{"\"\<section3.eps\>\"", ",", "des1", ",", "\"\<EPS\>\""}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Export", "[", 
  RowBox[{"\"\<debitance3.eps\>\"", ",", "deb1", ",", "\"\<EPS\>\""}], 
  "]"}], "\[IndentingNewLine]", "pente", "\[IndentingNewLine]", 
 RowBox[{"alt", "-", "zmin"}], "\[IndentingNewLine]", "alt"}], "Input",
 CellChangeTimes->{{3.726239511822*^9, 3.726239544264*^9}, {3.726240284528*^9,
   3.726240313686*^9}, {3.726240349039*^9, 3.7262403552390003`*^9}, {
  3.726240737948*^9, 3.726240739928*^9}, {3.726240988543*^9, 
  3.726240990638*^9}},ExpressionUUID->"0bbae9a2-d92b-42b0-9a66-d905e1d60bc7"],

Cell[BoxData["\<\"section3.eps\"\>"], "Output",
 CellChangeTimes->{
  3.726239546244*^9, {3.726240286729*^9, 3.7262403149449997`*^9}, 
   3.726240356417*^9, 3.726240740539*^9, 3.7262407930950003`*^9, 
   3.726240991236*^9, 3.726241040024*^9, 
   3.726243372102*^9},ExpressionUUID->"fe72a6f9-a596-49e3-a1d7-4052206fd02c"],

Cell[BoxData["\<\"debitance3.eps\"\>"], "Output",
 CellChangeTimes->{
  3.726239546244*^9, {3.726240286729*^9, 3.7262403149449997`*^9}, 
   3.726240356417*^9, 3.726240740539*^9, 3.7262407930950003`*^9, 
   3.726240991236*^9, 3.726241040024*^9, 
   3.7262433723529997`*^9},ExpressionUUID->"28b9594c-1f63-4b6d-b344-\
014927674116"],

Cell[BoxData["0.02531645569620253`"], "Output",
 CellChangeTimes->{
  3.726239546244*^9, {3.726240286729*^9, 3.7262403149449997`*^9}, 
   3.726240356417*^9, 3.726240740539*^9, 3.7262407930950003`*^9, 
   3.726240991236*^9, 3.726241040024*^9, 
   3.726243372356*^9},ExpressionUUID->"4e4cb3fd-51ab-4aeb-8861-7131905ac161"],

Cell[BoxData["2.8199999999999363`"], "Output",
 CellChangeTimes->{
  3.726239546244*^9, {3.726240286729*^9, 3.7262403149449997`*^9}, 
   3.726240356417*^9, 3.726240740539*^9, 3.7262407930950003`*^9, 
   3.726240991236*^9, 3.726241040024*^9, 
   3.726243372358*^9},ExpressionUUID->"2b79ebef-4816-414e-b0bc-5e9f539ac167"],

Cell[BoxData["1082.54`"], "Output",
 CellChangeTimes->{
  3.726239546244*^9, {3.726240286729*^9, 3.7262403149449997`*^9}, 
   3.726240356417*^9, 3.726240740539*^9, 3.7262407930950003`*^9, 
   3.726240991236*^9, 3.726241040024*^9, 
   3.726243372361*^9},ExpressionUUID->"7d26be2c-158c-46e7-b20c-09d753f37c4e"]
}, Open  ]],

Cell[BoxData["1"], "Input",
 CellChangeTimes->{
  3.726239864301*^9},ExpressionUUID->"004d646f-6925-458e-b3b2-4d14a67980af"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Profil 4", "Section",
 CellChangeTimes->{{3.726232366929*^9, 3.726232384227*^9}, 
   3.7262407036289997`*^9, 
   3.726240901414*^9},ExpressionUUID->"2369fb01-6b9f-4af6-bbd0-31ae68706165"],

Cell[CellGroupData[{

Cell["lecture", "Subsection",
 CellChangeTimes->{{3.726232366929*^9, 3.726232384227*^9}, {3.726232447131*^9,
   3.726232449347*^9}},ExpressionUUID->"0b3981ad-bf70-4fcf-ac62-004bdaeef8a2"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"profil", "=", 
  RowBox[{"ToExpression", "@", 
   RowBox[{"ReadList", "[", 
    RowBox[{"\"\<profil_4.txt\>\"", ",", "Word", ",", 
     RowBox[{"RecordLists", "\[Rule]", "True"}], ",", 
     RowBox[{"WordSeparators", "\[Rule]", "\"\<,\>\""}]}], 
    "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{"ListLinePlot", "[", 
  RowBox[{"profil", ",", 
   RowBox[{"AspectRatio", "\[Rule]", "1"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"n", "=", 
  RowBox[{"Length", "[", "profil", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"profilInterp", "=", 
  RowBox[{"Interpolation", "[", 
   RowBox[{"profil", ",", 
    RowBox[{"InterpolationOrder", "\[Rule]", "1"}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"zmin", "=", 
  RowBox[{"Min", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"#", "[", 
      RowBox[{"[", "2", "]"}], "]"}], "&"}], "/@", "profil"}], 
   "]"}]}]}], "Input",
 CellChangeTimes->{{3.7262252160959997`*^9, 3.7262252218710003`*^9}, {
   3.726225308633*^9, 3.72622531775*^9}, {3.7262259504639997`*^9, 
   3.726225965406*^9}, {3.726232362781*^9, 3.726232363865*^9}, {
   3.726232403023*^9, 3.726232429034*^9}, 3.726240709807*^9, 
   3.726241095024*^9},ExpressionUUID->"31d17775-7bb3-450f-ac3e-11c1473876a8"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.`", ",", "1067.47`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.56`", ",", "1067.47`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.12`", ",", "1067.47`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.62`", ",", "1067.37`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6.19`", ",", "1067.37`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9.25`", ",", "1067.17`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"11.06`", ",", "1067.17`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"13.56`", ",", "1067.07`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"17.06`", ",", "1066.67`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"18.88`", ",", "1066.57`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"20.94`", ",", "1066.37`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"22.94`", ",", "1066.17`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"24.75`", ",", "1065.97`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"26.31`", ",", "1065.77`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"32.`", ",", "1065.17`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"33.56`", ",", "1065.07`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"35.75`", ",", "1064.87`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"39.5`", ",", "1064.67`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"41.88`", ",", "1064.67`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"45.`", ",", "1064.47`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"46.31`", ",", "1064.37`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"46.5`", ",", "1064.27`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"48.56`", ",", "1059.47`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"48.94`", ",", "1058.67`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"51.81`", ",", "1058.57`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"53.88`", ",", "1060.47`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"57.62`", ",", "1061.27`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"60.06`", ",", "1063.57`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"63.69`", ",", "1063.67`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"63.81`", ",", "1063.67`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"66.5`", ",", "1063.67`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"69.38`", ",", "1063.47`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"72.25`", ",", "1063.57`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"75.12`", ",", "1063.57`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"78.44`", ",", "1063.47`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"81.81`", ",", "1063.47`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"85.19`", ",", "1063.47`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"88.44`", ",", "1063.67`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"91.56`", ",", "1063.57`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"95.44`", ",", "1063.67`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"99.44`", ",", "1063.77`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"103.06`", ",", "1063.77`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"104.81`", ",", "1064.77`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"106.12`", ",", "1065.57`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"107.75`", ",", "1066.57`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"109.44`", ",", "1067.27`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"111.12`", ",", "1068.37`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"112.69`", ",", "1069.27`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"114.75`", ",", "1069.97`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"117.62`", ",", "1070.27`"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.726225222749*^9, {3.726225313972*^9, 3.726225318549*^9}, 
   3.726225966208*^9, {3.7262323876540003`*^9, 3.726232430127*^9}, 
   3.726232721483*^9, 3.726232768483*^9, 3.72623296151*^9, 3.726233207597*^9, 
   3.7262332696619997`*^9, 3.726235891734*^9, 3.7262407101029997`*^9, 
   3.726241095408*^9, {3.726243406558*^9, 
   3.7262434192139997`*^9}},ExpressionUUID->"5cb6bb26-0556-4fe4-acc9-\
9ad212a6e1a9"],

Cell[BoxData[
 GraphicsBox[{{}, {{{}, {}, {
      {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
       0.016666666666666666`], AbsoluteThickness[1.6], LineBox[CompressedData["
1:eJxTTMoPSmViYGAwAmIQDQPVIuvcH66d4PBNI6b/0Ncf9qh8DgcYH0xXCTmA
KSD/8FeQAgk4H2xYg5KDx8MqkXVrJjjIt74O3CGnhsbXdgBx3YF8oOEaMfyG
EPlVEyDiD40gNJBfaMt1ffEHE4j5K2F8M4j6FVD7DlhA3LUcap6/lQNIuchy
qDyDA0T9kgkQ+rgDxPwlUPkHjhDzF8PMc4aoWwSzzwXOh/jPDWLfQqh56u4Q
/Quh8g7uEPth8u4eEPW9Exx2yAEDoMIDIt4FlX/uCXFPF8w+L4j6iVD/nPeB
mDcVqp7dD6J+HtS8G/4Q8Xkw8xB8sHsWBMD5YPURgRDz50LlBYLg5kHCB8EH
xb7GnGC4+iUFQAcWh8D5YHmfUFS+TBjcPrD6x2Go5t0Jh8tD+BEQ/82Hqj8c
ico3joLwF0Pd1x4FMW8Z1P0fouDpBWxeTDRE/VqYf6Ih8bMRKq8TA5HfCtW/
IQbi/u1Q9emxEPmdExwAmhtX2g==
        "]]}}}}, {}, {}, {{}, {}}, {{}, {}}},
  AspectRatio->1,
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 1057.9850000000001`},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->{941., Automatic},
  Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 117.62}, {1058.57, 1070.27}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.726225222749*^9, {3.726225313972*^9, 3.726225318549*^9}, 
   3.726225966208*^9, {3.7262323876540003`*^9, 3.726232430127*^9}, 
   3.726232721483*^9, 3.726232768483*^9, 3.72623296151*^9, 3.726233207597*^9, 
   3.7262332696619997`*^9, 3.726235891734*^9, 3.7262407101029997`*^9, 
   3.726241095408*^9, {3.726243406558*^9, 
   3.7262434192469997`*^9}},ExpressionUUID->"efee83b1-f5d0-4eed-abfe-\
f4402356f083"],

Cell[BoxData["50"], "Output",
 CellChangeTimes->{
  3.726225222749*^9, {3.726225313972*^9, 3.726225318549*^9}, 
   3.726225966208*^9, {3.7262323876540003`*^9, 3.726232430127*^9}, 
   3.726232721483*^9, 3.726232768483*^9, 3.72623296151*^9, 3.726233207597*^9, 
   3.7262332696619997`*^9, 3.726235891734*^9, 3.7262407101029997`*^9, 
   3.726241095408*^9, {3.726243406558*^9, 
   3.726243419251*^9}},ExpressionUUID->"13f684c7-fe54-4bbc-ac04-1521aa5c2252"],

Cell[BoxData[
 TagBox[
  TemplateBox[{RowBox[{
      StyleBox[
       TagBox["InterpolatingFunction", "SummaryHead"], 
       "NonInterpretableSummary"], 
      StyleBox["[", "NonInterpretableSummary"], 
      DynamicModuleBox[{Typeset`open$$ = False}, 
       PanelBox[
        PaneSelectorBox[{False -> GridBox[{{
              PaneBox[
               ButtonBox[
                DynamicBox[
                 FEPrivate`FrontEndResource[
                 "FEBitmaps", "SquarePlusIconMedium"]], 
                ButtonFunction :> (Typeset`open$$ = True), Appearance -> None,
                 Evaluator -> Automatic, Method -> "Preemptive"], 
               Alignment -> {Center, Center}, ImageSize -> 
               Dynamic[{
                 Automatic, 3.5 CurrentValue["FontCapHeight"]/
                  AbsoluteCurrentValue[Magnification]}]], 
              GraphicsBox[{{{{}, {}, 
                  TagBox[{
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    LineBox[CompressedData["
1:eJxF039QE2QYB/BJCadSy9wpKCKggGBIBEO5KL8hOJCpA8evDezggNmAxokE
TXBcgpoWvoByIhQ/lhSYHIKnLPBCUE9Gjl+JIxo6fkwYJ4zgQDJX7/KiP957
73PPPc897933tY+ThCaYMRgMX3pMd3nvUJ+DovXDY6w6jvYqgTeXJfnpqnHX
fz4kF963eM6E7Hxh5mVqs99/STnz8zqYylLqU1HXPVnRm0AKvY5aUldwXy8e
Vm1GoFbKqvuRgF/Y0eBZ44wnh7Lz8qkdfO4eturfhtEKxp2N1F9aj7Ucn3ZH
aYndU7crBKPMbvV2rQdu695YkNUSFLTf3zQ+64nXbOIsNDUEriuZN2NG2GgL
sFdaU5MU0UZWxw7kyarE+38gOLFMyGOpfZDfGVQd8j1B3Nayvu7293HLOTc2
o5pAJcvc/Ej9Adx8rfKLLxOYzyX62Y7uQlGY3SPFdwQXsnvUb+mAxuR5qQd1
ivWtz25OfYT3XH8tOSonaD7e5dsy5gc3F5XXKmpelvtEwszuV++tIgg+bfXS
/bk/nqVWsWupW2K2+kQ+C8CK9bqsd6jTOvOEjgt78LhoLPdiJUGl2cpq3jQH
ywKaM3nnCdiB6yLLhgOhFVxLI2cImE5HDF/pg7DvN8e2aOqPH8zWDz7ZCy/W
SHxKAcG8ZXtE12QwvtiuX3uuiGBWsCFxZIaLexLJoFUxQeKRS2Vhun3ITb+x
k/sNgZ2DSJE8vR/8gt5W6bd0/1KBUas78Gp/6rSCpIfNybwlx1V220YZeDDX
6B7wqS3XBmU5JoVgS9PZe5N03kD4ONffEIIVHu++ZNN67F+XPAqTQ2Fq51Db
uLy9N1UXCkMbZ3An9Z/29Q8rxAchT73gtEj7i2Sx6QzdQfybN2pejc/phiT+
kiHoV81N/e9JyUmXxE/CsLxWsdpIrQiJWXCZCoO7Wq7MofP9LnIGbMThaByq
X3+S2pgwP1U+Eg72i3ClaR/N350Z6aIIDOfUz2VTZxivs6TDEXiTyS+tp2Z3
3NnSI4rE3WOCmTFqpw0lh5v0kTDFnVVO0NuT06qKj1pyJf/c2R0TUehlCr3F
FQTbfK+Ju+IFULY2LfxB86OeXmxR6AXoNyw+XUPz3ORqsdvrUyEyBsiJHvpf
+EpnjWZciBeN8f5XGgjWeEv0AynRuC14XPX5DYKvzZWrluujkTVhFuLXRDB0
wNayThQDeXCflKUg+AfHQtAl
                    "]]}, 
                   Annotation[#, 
                    "Charting`Private`Tag$44834#1"]& ]}}, {}, {}}, {
               DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
                AxesOrigin -> {0, 1058.5905843653193`}, 
                FrameTicks -> {{{}, {}}, {{}, {}}}, GridLines -> {None, None},
                 DisplayFunction -> Identity, PlotRangePadding -> {{
                   Scaled[0.1], 
                   Scaled[0.1]}, {
                   Scaled[0.1], 
                   Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                All, DisplayFunction -> Identity, AspectRatio -> 1, 
                Axes -> {False, False}, AxesLabel -> {None, None}, 
                AxesOrigin -> {0, 1058.5905843653193`}, DisplayFunction :> 
                Identity, Frame -> {{True, True}, {True, True}}, 
                FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                Directive[
                  Opacity[0.5], 
                  Thickness[Tiny], 
                  RGBColor[0.368417, 0.506779, 0.709798]], 
                FrameTicks -> {{None, None}, {None, None}}, 
                GridLines -> {None, None}, GridLinesStyle -> Directive[
                  GrayLevel[0.5, 0.4]], ImageSize -> 
                Dynamic[{
                  Automatic, 3.5 CurrentValue["FontCapHeight"]/
                   AbsoluteCurrentValue[Magnification]}], 
                Method -> {
                 "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
                  AbsolutePointSize[6], "ScalingFunctions" -> None, 
                  "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                    (Identity[#]& )[
                    Part[#, 1]], 
                    (Identity[#]& )[
                    Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                    (Identity[#]& )[
                    Part[#, 1]], 
                    (Identity[#]& )[
                    Part[#, 2]]}& )}}, 
                PlotRange -> {{0., 117.62}, {1058.5905843653193`, 
                 1070.269999791614}}, PlotRangeClipping -> True, 
                PlotRangePadding -> {{
                   Scaled[0.1], 
                   Scaled[0.1]}, {
                   Scaled[0.1], 
                   Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
              GridBox[{{
                 RowBox[{
                   TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"0.`", ",", "117.62`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["\"scalar\"", "SummaryItem"]}]}}, 
               GridBoxAlignment -> {
                "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, AutoDelete -> 
               False, GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
               GridBoxSpacings -> {
                "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
               BaseStyle -> {
                ShowStringCharacters -> False, NumberMarks -> False, 
                 PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
            GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> False, 
            GridBoxItemSize -> {
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
            BaselinePosition -> {1, 1}], True -> GridBox[{{
              PaneBox[
               ButtonBox[
                DynamicBox[
                 FEPrivate`FrontEndResource[
                 "FEBitmaps", "SquareMinusIconMedium"]], 
                ButtonFunction :> (Typeset`open$$ = False), Appearance -> 
                None, Evaluator -> Automatic, Method -> "Preemptive"], 
               Alignment -> {Center, Center}, ImageSize -> 
               Dynamic[{
                 Automatic, 3.5 CurrentValue["FontCapHeight"]/
                  AbsoluteCurrentValue[Magnification]}]], 
              GraphicsBox[{{{{}, {}, 
                  TagBox[{
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    LineBox[CompressedData["
1:eJxF039QE2QYB/BJCadSy9wpKCKggGBIBEO5KL8hOJCpA8evDezggNmAxokE
TXBcgpoWvoByIhQ/lhSYHIKnLPBCUE9Gjl+JIxo6fkwYJ4zgQDJX7/KiP957
73PPPc897933tY+ThCaYMRgMX3pMd3nvUJ+DovXDY6w6jvYqgTeXJfnpqnHX
fz4kF963eM6E7Hxh5mVqs99/STnz8zqYylLqU1HXPVnRm0AKvY5aUldwXy8e
Vm1GoFbKqvuRgF/Y0eBZ44wnh7Lz8qkdfO4eturfhtEKxp2N1F9aj7Ucn3ZH
aYndU7crBKPMbvV2rQdu695YkNUSFLTf3zQ+64nXbOIsNDUEriuZN2NG2GgL
sFdaU5MU0UZWxw7kyarE+38gOLFMyGOpfZDfGVQd8j1B3Nayvu7293HLOTc2
o5pAJcvc/Ej9Adx8rfKLLxOYzyX62Y7uQlGY3SPFdwQXsnvUb+mAxuR5qQd1
ivWtz25OfYT3XH8tOSonaD7e5dsy5gc3F5XXKmpelvtEwszuV++tIgg+bfXS
/bk/nqVWsWupW2K2+kQ+C8CK9bqsd6jTOvOEjgt78LhoLPdiJUGl2cpq3jQH
ywKaM3nnCdiB6yLLhgOhFVxLI2cImE5HDF/pg7DvN8e2aOqPH8zWDz7ZCy/W
SHxKAcG8ZXtE12QwvtiuX3uuiGBWsCFxZIaLexLJoFUxQeKRS2Vhun3ITb+x
k/sNgZ2DSJE8vR/8gt5W6bd0/1KBUas78Gp/6rSCpIfNybwlx1V220YZeDDX
6B7wqS3XBmU5JoVgS9PZe5N03kD4ONffEIIVHu++ZNN67F+XPAqTQ2Fq51Db
uLy9N1UXCkMbZ3An9Z/29Q8rxAchT73gtEj7i2Sx6QzdQfybN2pejc/phiT+
kiHoV81N/e9JyUmXxE/CsLxWsdpIrQiJWXCZCoO7Wq7MofP9LnIGbMThaByq
X3+S2pgwP1U+Eg72i3ClaR/N350Z6aIIDOfUz2VTZxivs6TDEXiTyS+tp2Z3
3NnSI4rE3WOCmTFqpw0lh5v0kTDFnVVO0NuT06qKj1pyJf/c2R0TUehlCr3F
FQTbfK+Ju+IFULY2LfxB86OeXmxR6AXoNyw+XUPz3ORqsdvrUyEyBsiJHvpf
+EpnjWZciBeN8f5XGgjWeEv0AynRuC14XPX5DYKvzZWrluujkTVhFuLXRDB0
wNayThQDeXCflKUg+AfHQtAl
                    "]]}, 
                   Annotation[#, 
                    "Charting`Private`Tag$44834#1"]& ]}}, {}, {}}, {
               DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
                AxesOrigin -> {0, 1058.5905843653193`}, 
                FrameTicks -> {{{}, {}}, {{}, {}}}, GridLines -> {None, None},
                 DisplayFunction -> Identity, PlotRangePadding -> {{
                   Scaled[0.1], 
                   Scaled[0.1]}, {
                   Scaled[0.1], 
                   Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                All, DisplayFunction -> Identity, AspectRatio -> 1, 
                Axes -> {False, False}, AxesLabel -> {None, None}, 
                AxesOrigin -> {0, 1058.5905843653193`}, DisplayFunction :> 
                Identity, Frame -> {{True, True}, {True, True}}, 
                FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                Directive[
                  Opacity[0.5], 
                  Thickness[Tiny], 
                  RGBColor[0.368417, 0.506779, 0.709798]], 
                FrameTicks -> {{None, None}, {None, None}}, 
                GridLines -> {None, None}, GridLinesStyle -> Directive[
                  GrayLevel[0.5, 0.4]], ImageSize -> 
                Dynamic[{
                  Automatic, 3.5 CurrentValue["FontCapHeight"]/
                   AbsoluteCurrentValue[Magnification]}], 
                Method -> {
                 "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
                  AbsolutePointSize[6], "ScalingFunctions" -> None, 
                  "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                    (Identity[#]& )[
                    Part[#, 1]], 
                    (Identity[#]& )[
                    Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                    (Identity[#]& )[
                    Part[#, 1]], 
                    (Identity[#]& )[
                    Part[#, 2]]}& )}}, 
                PlotRange -> {{0., 117.62}, {1058.5905843653193`, 
                 1070.269999791614}}, PlotRangeClipping -> True, 
                PlotRangePadding -> {{
                   Scaled[0.1], 
                   Scaled[0.1]}, {
                   Scaled[0.1], 
                   Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
              GridBox[{{
                 RowBox[{
                   TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"0.`", ",", "117.62`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["\"scalar\"", "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Order: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["1", "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Method: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["\"Hermite\"", "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Periodic: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["False", "SummaryItem"]}]}}, 
               GridBoxAlignment -> {
                "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, AutoDelete -> 
               False, GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
               GridBoxSpacings -> {
                "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
               BaseStyle -> {
                ShowStringCharacters -> False, NumberMarks -> False, 
                 PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
            GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> False, 
            GridBoxItemSize -> {
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
            BaselinePosition -> {1, 1}]}, 
         Dynamic[Typeset`open$$], ImageSize -> Automatic], BaselinePosition -> 
        Baseline], DynamicModuleValues :> {}], 
      StyleBox["]", "NonInterpretableSummary"]}]},
   "CopyTag",
   DisplayFunction->(#& ),
   InterpretationFunction->("InterpolatingFunction[{{0., 117.62}}, <>]"& )],
  False,
  Editable->False,
  SelectWithContents->True,
  Selectable->False]], "Output",
 CellChangeTimes->{
  3.726225222749*^9, {3.726225313972*^9, 3.726225318549*^9}, 
   3.726225966208*^9, {3.7262323876540003`*^9, 3.726232430127*^9}, 
   3.726232721483*^9, 3.726232768483*^9, 3.72623296151*^9, 3.726233207597*^9, 
   3.7262332696619997`*^9, 3.726235891734*^9, 3.7262407101029997`*^9, 
   3.726241095408*^9, {3.726243406558*^9, 
   3.726243419259*^9}},ExpressionUUID->"fc8c1cd8-0ff1-4545-8849-57e0f09def4d"],

Cell[BoxData["1058.57`"], "Output",
 CellChangeTimes->{
  3.726225222749*^9, {3.726225313972*^9, 3.726225318549*^9}, 
   3.726225966208*^9, {3.7262323876540003`*^9, 3.726232430127*^9}, 
   3.726232721483*^9, 3.726232768483*^9, 3.72623296151*^9, 3.726233207597*^9, 
   3.7262332696619997`*^9, 3.726235891734*^9, 3.7262407101029997`*^9, 
   3.726241095408*^9, {3.726243406558*^9, 
   3.726243419266*^9}},ExpressionUUID->"db84537b-07af-4639-a3b8-e4df091a9488"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["test", "Subsection",
 CellChangeTimes->{{3.726232366929*^9, 3.726232384227*^9}, {3.726232447131*^9,
   3.726232462184*^9}},ExpressionUUID->"db6457d8-a3ae-4cea-9deb-0ef6868cad1f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"profilInterp", "[", "x", "]"}], "\[Equal]", "1223"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "100"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7262254266029997`*^9, 3.726225465616*^9}, 
   3.726232970962*^9},ExpressionUUID->"06f3cb09-181e-4691-9c32-e8331d395152"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", "\[Rule]", "146.30999999999798`"}], "}"}]], "Output",
 CellChangeTimes->{{3.726225455278*^9, 3.7262254659440002`*^9}, 
   3.726232971256*^9, 3.726233213766*^9, 
   3.72623327438*^9},ExpressionUUID->"d66422b8-ce49-4fa5-986c-a34583e4eb15"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"alt", "=", "1224"}], "\[IndentingNewLine]", 
 RowBox[{" ", 
  RowBox[{
   RowBox[{"ival", "=", 
    RowBox[{"{", "}"}]}], ";"}]}], "\[IndentingNewLine]", 
 RowBox[{"xval", "=", 
  RowBox[{"{", "}"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Do", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"profil", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "2"}], "]"}], "]"}], "\[LessEqual]", "alt", "<=", 
        RowBox[{"profil", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"i", "+", "1"}], ",", "2"}], "]"}], "]"}]}], "||", 
       RowBox[{
        RowBox[{"profil", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "2"}], "]"}], "]"}], "\[GreaterEqual]", " ", 
        "alt", "\[GreaterEqual]", 
        RowBox[{"profil", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"i", "+", "1"}], ",", "2"}], "]"}], "]"}]}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"AppendTo", "[", 
        RowBox[{"ival", ",", "i"}], "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"interp", "=", 
        RowBox[{"Interpolation", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"profil", "[", 
             RowBox[{"[", "i", "  ", "]"}], "]"}], ",", 
            RowBox[{"profil", "[", 
             RowBox[{"[", 
              RowBox[{"i", "+", "1"}], " ", "]"}], "]"}]}], "}"}], ",", 
          RowBox[{"InterpolationOrder", "\[Rule]", "1"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"xc", "=", 
        RowBox[{"x", "/.", 
         RowBox[{
          RowBox[{"FindRoot", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"interp", "[", "x", "]"}], "\[Equal]", "alt"}], ",", 
            RowBox[{"{", 
             RowBox[{"x", ",", 
              RowBox[{"profil", "[", 
               RowBox[{"[", 
                RowBox[{
                 RowBox[{"i", "+", "1"}], ",", "1"}], "]"}], "]"}]}], "}"}]}],
            "]"}], "[", 
          RowBox[{"[", "1", "]"}], "]"}]}]}], ";", 
       RowBox[{"Print", "[", 
        RowBox[{"\"\<i =\>\"", ",", "i", ",", "\"\< x = \>\"", ",", "xc"}], 
        "]"}], ";", 
       RowBox[{"AppendTo", "[", 
        RowBox[{"xval", ",", "xc"}], "]"}], ";"}]}], "\[IndentingNewLine]", 
     "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", 
      RowBox[{"n", "-", "1"}]}], "}"}]}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.7262258536730003`*^9, 3.726225974487*^9}, {
   3.726226108792*^9, 3.726226133618*^9}, {3.726226317785*^9, 
   3.7262264099820004`*^9}, {3.726226449434*^9, 3.72622647455*^9}, {
   3.726226514075*^9, 3.726226570517*^9}, {3.726227020848*^9, 
   3.726227075016*^9}, {3.726227423367*^9, 3.726227427098*^9}, 
   3.7262329678929996`*^9, 
   3.726233299344*^9},ExpressionUUID->"37f899e8-5494-41da-b313-fc13178c554b"],

Cell[BoxData["1224"], "Output",
 CellChangeTimes->{
  3.7262258573529997`*^9, 3.726225974858*^9, 3.726226134086*^9, 
   3.7262264111689997`*^9, {3.7262264709849997`*^9, 3.7262264752460003`*^9}, 
   3.726226519617*^9, {3.726226556707*^9, 3.726226571341*^9}, {
   3.7262270628599997`*^9, 3.726227075238*^9}, 3.726232968212*^9, 
   3.726233213925*^9, {3.7262332761470003`*^9, 
   3.726233300748*^9}},ExpressionUUID->"a796b718-9a6e-46a9-8fdb-0691a4fab646"],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 CellChangeTimes->{
  3.7262258573529997`*^9, 3.726225974858*^9, 3.726226134086*^9, 
   3.7262264111689997`*^9, {3.7262264709849997`*^9, 3.7262264752460003`*^9}, 
   3.726226519617*^9, {3.726226556707*^9, 3.726226571341*^9}, {
   3.7262270628599997`*^9, 3.726227075238*^9}, 3.726232968212*^9, 
   3.726233213925*^9, {3.7262332761470003`*^9, 
   3.726233300751*^9}},ExpressionUUID->"061f3b6b-81e5-422a-b3ab-c3fd6c6135ea"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "106.03249999999842`"}],
  SequenceForm["i =", 10, " x = ", 106.03249999999842`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232968219*^9, 3.726233213933*^9, {3.7262332761540003`*^9, 
   3.7262333007530003`*^9}},ExpressionUUID->"566250f9-9ecb-41ba-9b8b-\
99ead1eb7914"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "28", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", "191.88`"}],
  SequenceForm["i =", 28, " x = ", 191.88],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232968219*^9, 3.726233213933*^9, {3.7262332761540003`*^9, 
   3.7262333007539997`*^9}},ExpressionUUID->"a83d043e-0ffd-474a-8406-\
dd2aa395b287"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "29", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", "191.88`"}],
  SequenceForm["i =", 29, " x = ", 191.88],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232968219*^9, 3.726233213933*^9, {3.7262332761540003`*^9, 
   3.726233300759*^9}},ExpressionUUID->"2c2ea217-22ed-4959-9d43-9eb7cf8a095d"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.726226008226*^9, 3.7262260121280003`*^9}, {
  3.7262260723859997`*^9, 3.726226090521*^9}, {3.726227012104*^9, 
  3.726227018509*^9}},ExpressionUUID->"94b8a777-fe6b-43b2-9c43-dd4774a4bddb"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"170.38`", ",", "1221.7`"}], "}"}]], "Output",
 CellChangeTimes->{
  3.726226017889*^9, {3.7262260727609997`*^9, 
   3.726226090895*^9}},ExpressionUUID->"6908cbe4-b954-4b02-87b3-4baeeb5332ea"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"{", 
   RowBox[{"il", ",", "ir"}], "}"}], "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"First", "@", "ival"}], ",", 
    RowBox[{"Last", "@", "ival"}]}], "}"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"{", 
   RowBox[{"xl", ",", "xr"}], "}"}], "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"First", "@", "xval"}], ",", 
    RowBox[{"Last", "@", "xval"}]}], "}"}]}]}], "Input",
 CellChangeTimes->{{3.726227096816*^9, 3.726227114612*^9}, {
  3.7262329959960003`*^9, 
  3.72623301877*^9}},ExpressionUUID->"1bf513be-99fd-4512-8cbc-85e100f10be5"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"10", ",", "29"}], "}"}]], "Output",
 CellChangeTimes->{
  3.726227114851*^9, 3.7262330197679996`*^9, 3.726233216243*^9, {
   3.726233281072*^9, 
   3.726233302632*^9}},ExpressionUUID->"9a9e122e-ae6b-43d8-bee0-d10a834b6274"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"106.03249999999842`", ",", "191.88`"}], "}"}]], "Output",
 CellChangeTimes->{
  3.726227114851*^9, 3.7262330197679996`*^9, 3.726233216243*^9, {
   3.726233281072*^9, 
   3.7262333026359997`*^9}},ExpressionUUID->"75494de3-fb11-4fc7-99cf-\
622dc8d06269"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{
   RowBox[{"alt", " ", "-", 
    RowBox[{"profilInterp", "[", "x", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "xl", ",", "xr"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7262264846289997`*^9, 3.726226486635*^9}, {
  3.726227089087*^9, 3.726227149316*^9}, {3.726227313462*^9, 
  3.7262273437720003`*^9}},ExpressionUUID->"494920a9-3880-417b-ad4e-\
62a4abd3413a"],

Cell[BoxData["93.80812500000039`"], "Output",
 CellChangeTimes->{
  3.7262264869230003`*^9, {3.7262271299820004`*^9, 3.72622715016*^9}, {
   3.726227314823*^9, 3.72622734446*^9}, 3.7262330246099997`*^9, 
   3.726233217365*^9, {3.726233284427*^9, 
   3.726233303733*^9}},ExpressionUUID->"fb331302-7d9f-4986-a921-88a26a8d97e0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"long", "=", 
  RowBox[{
   RowBox[{"Sqrt", "[", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"profil", "[", 
        RowBox[{"[", 
         RowBox[{"il", " ", "+", "1"}], " ", "]"}], "]"}], "-", 
       RowBox[{"{", 
        RowBox[{"xl", ",", "alt"}], "}"}]}], ")"}], ".", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"profil", "[", 
        RowBox[{"[", 
         RowBox[{"il", "+", "1"}], "  ", "]"}], "]"}], "-", " ", 
       RowBox[{"{", 
        RowBox[{"xl", ",", "alt"}], "}"}]}], ")"}]}], "]"}], "+", 
   RowBox[{"Sqrt", "[", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"profil", "[", 
        RowBox[{"[", "ir", "  ", "]"}], "]"}], "-", 
       RowBox[{"{", 
        RowBox[{"xr", ",", "alt"}], "}"}]}], ")"}], ".", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"profil", "[", 
        RowBox[{"[", "ir", "  ", "]"}], "]"}], "-", " ", 
       RowBox[{"{", 
        RowBox[{"xr", ",", "alt"}], "}"}]}], ")"}]}], 
    "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{"long", "+=", 
    RowBox[{"Sqrt", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"profil", "[", 
         RowBox[{"[", "i", "  ", "]"}], "]"}], "-", 
        RowBox[{"profil", "[", 
         RowBox[{"[", 
          RowBox[{"i", "+", "1"}], " ", "]"}], "]"}]}], ")"}], ".", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"profil", "[", 
         RowBox[{"[", "i", "  ", "]"}], "]"}], "-", 
        RowBox[{"profil", "[", 
         RowBox[{"[", 
          RowBox[{"i", "+", "1"}], " ", "]"}], "]"}]}], ")"}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", 
     RowBox[{"il", "+", "1"}], ",", 
     RowBox[{"ir", "-", "1"}]}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.726227405042*^9, 3.72622753533*^9}, {3.726230013764*^9, 
   3.72623004948*^9}, {3.726230121551*^9, 3.726230163789*^9}, 
   3.726230250789*^9, {3.726230292102*^9, 3.7262302936070004`*^9}, {
   3.726231386196*^9, 3.726231407833*^9}, {3.726231510461*^9, 
   3.726231515076*^9}},ExpressionUUID->"6114d7b3-5b0e-4a86-a6e6-1f76fa34a760"],

Cell[BoxData["8.35288909599704`"], "Output",
 CellChangeTimes->{{3.726227502731*^9, 3.72622751404*^9}, 
   3.7262300505439997`*^9, 3.7262301643120003`*^9, 3.726230299375*^9, {
   3.726231402686*^9, 3.726231408664*^9}, 3.7262315157*^9, 
   3.7262330274890003`*^9, 3.7262332177609997`*^9, 
   3.726233304427*^9},ExpressionUUID->"f90fbb6a-d8ad-46d4-8ce2-fc85eee6ecc5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["long"], "Input",
 CellChangeTimes->{{3.726227504414*^9, 
  3.726227506013*^9}},ExpressionUUID->"60bac60b-0a0b-4353-a17d-89c72e1a641e"],

Cell[BoxData["43.7534872311104`"], "Output",
 CellChangeTimes->{{3.7262275064630003`*^9, 3.726227517608*^9}, 
   3.726230226168*^9, 3.72623030192*^9, 3.726231412692*^9, 3.726231517759*^9, 
   3.726233029825*^9, 
   3.726233218606*^9},ExpressionUUID->"ef5a98d3-f7f3-4287-870d-ea1f771d1659"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"profilInterp", "[", "x", "]"}], "-", "alt"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "xl", ",", "xr"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.726230927082*^9, 
  3.72623095363*^9}},ExpressionUUID->"8a99209b-65c6-4491-b423-448862362b01"],

Cell[BoxData[
 GraphicsBox[{{{{}, {}, 
     TagBox[{{
        {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
         Opacity[1.], LineBox[CompressedData["
1:eJxF2nk4FUwXAPDrEpebrSQhVJaSCm+kFOpFUiRtQpElKknZW2ULLZYWSkmU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          "]]}}},
      Annotation[#, "Charting`Private`Tag$3252#1"]& ]}}, {}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{106.03249999999842`, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{106.03249999999842`, 191.88}, {-3.499486454708631, 0.}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.726230943987*^9, 3.726230954277*^9}, 
   3.7262330320889997`*^9, 3.7262332194960003`*^9, 
   3.7262333061610003`*^9},ExpressionUUID->"6c41774e-5222-4a97-96f0-\
e8f50f707917"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcLength", "[", 
  RowBox[{"Line", "[", 
   RowBox[{"Join", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"xl", ",", "alt"}], "}"}], "}"}], ",", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"profil", "[", 
        RowBox[{"[", "i", "]"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", 
         RowBox[{"il", "+", "1"}], ",", "ir"}], "}"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"xr", ",", "alt"}], "}"}], "}"}]}], "]"}], "]"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.726231119546*^9, 3.726231184574*^9}, {3.726231351102*^9,
   3.726231360666*^9}},ExpressionUUID->"a1736759-90cc-4927-9af6-c6d9b51f4c44"],

Cell[BoxData["87.39576390177173`"], "Output",
 CellChangeTimes->{
  3.726231185449*^9, {3.7262313517019997`*^9, 3.726231361546*^9}, 
   3.726233041178*^9, 
   3.726233318613*^9},ExpressionUUID->"09871ce3-7f97-4866-ba90-90ecd9708f73"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"set", "=", 
    RowBox[{"Join", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"xl", ",", "alt"}], "}"}], "}"}], ",", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"profil", "[", 
         RowBox[{"[", "i", "]"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", 
          RowBox[{"il", "+", "1"}], ",", "ir"}], "}"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"xr", ",", "alt"}], "}"}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{" "}]}], "Input",
 CellChangeTimes->{{3.726231312764*^9, 3.7262313401540003`*^9}, {
   3.726231469883*^9, 3.726231486217*^9}, {3.726232056657*^9, 
   3.726232132025*^9}, 
   3.7262332233929996`*^9},ExpressionUUID->"aa567f1e-72c4-4acd-8c6f-\
ab0abad1c84e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Rh", "=", 
   RowBox[{"ArcLength", "@", 
    RowBox[{"Line", "[", "set", "]"}]}]}], "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{
  3.726233231824*^9},ExpressionUUID->"f68bdcc5-0d26-4e73-b762-32fa0e9fd1d0"],

Cell[BoxData["87.39576390177173`"], "Output",
 CellChangeTimes->{3.726233232759*^9, 
  3.726233320042*^9},ExpressionUUID->"be55711d-f4c1-46d0-bb24-42a7f3aee949"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"S", "=", 
  RowBox[{"Area", "@", " ", 
   RowBox[{"Polygon", "[", "set", "]"}]}]}]], "Input",
 CellChangeTimes->{{3.726231875073*^9, 3.726231890429*^9}, {3.7262319287*^9, 
   3.726231947594*^9}, {3.7262320226219997`*^9, 3.726232061264*^9}, 
   3.7262332347720003`*^9},ExpressionUUID->"371009d0-155f-42d4-8df7-\
b4f8d0255e05"],

Cell[BoxData["93.80812500002503`"], "Output",
 CellChangeTimes->{
  3.7262318915030003`*^9, {3.726231930817*^9, 3.726231948278*^9}, {
   3.726232027523*^9, 3.726232031013*^9}, 
   3.726233321311*^9},ExpressionUUID->"b9ca9d35-e6fa-40cb-a4d5-42fda384d39d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"pente", "=", 
  RowBox[{"2", "/", "66."}]}], "\[IndentingNewLine]", 
 RowBox[{"K", "=", "30"}], "\[IndentingNewLine]", 
 RowBox[{"Q", "=", 
  RowBox[{"S", " ", 
   RowBox[{"Rh", "^", 
    RowBox[{"(", 
     RowBox[{"2", "/", "3"}], ")"}]}], " ", 
   RowBox[{"Sqrt", "[", "pente", "]"}], " ", "K"}]}]}], "Input",
 CellChangeTimes->{{3.726231714743*^9, 3.726231727738*^9}, {
  3.7262321378970003`*^9, 3.726232154474*^9}, {3.726232297094*^9, 
  3.726232315158*^9}},ExpressionUUID->"10e0d577-f7c5-4e1a-bcf3-0a76d537a566"],

Cell[BoxData["0.030303030303030304`"], "Output",
 CellChangeTimes->{
  3.726232155381*^9, {3.726232302566*^9, 3.726232316356*^9}, 
   3.726233323672*^9},ExpressionUUID->"00144a13-e41e-4c11-99a2-158d87b7bf87"],

Cell[BoxData["30"], "Output",
 CellChangeTimes->{
  3.726232155381*^9, {3.726232302566*^9, 3.726232316356*^9}, 
   3.726233323674*^9},ExpressionUUID->"376b38d0-3a04-4f71-8c04-c405f5fa65eb"],

Cell[BoxData["9647.874869994726`"], "Output",
 CellChangeTimes->{
  3.726232155381*^9, {3.726232302566*^9, 3.726232316356*^9}, 
   3.726233323678*^9},ExpressionUUID->"da25e079-cffd-4eaa-a32b-fbafc683a470"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["calcul", "Subsection",
 CellChangeTimes->{{3.726232366929*^9, 3.726232384227*^9}, {3.726232447131*^9,
   3.726232470816*^9}},ExpressionUUID->"e762fe04-d31f-4c7b-92d4-4fed37804c38"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"pente", "=", 
  RowBox[{"20", "/", "410."}]}], "\[IndentingNewLine]", 
 RowBox[{"K", "=", "25"}], "\[IndentingNewLine]", 
 RowBox[{"sol", "=", 
  RowBox[{"{", "}"}]}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"ival", "=", 
     RowBox[{"{", "}"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"xval", "=", 
     RowBox[{"{", "}"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"Do", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"profil", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "2"}], "]"}], "]"}], "\[LessEqual]", "alt", "<=", 
          RowBox[{"profil", "[", 
           RowBox[{"[", 
            RowBox[{
             RowBox[{"i", "+", "1"}], ",", "2"}], "]"}], "]"}]}], "||", 
         RowBox[{
          RowBox[{"profil", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "2"}], "]"}], "]"}], "\[GreaterEqual]", " ", 
          "alt", "\[GreaterEqual]", 
          RowBox[{"profil", "[", 
           RowBox[{"[", 
            RowBox[{
             RowBox[{"i", "+", "1"}], ",", "2"}], "]"}], "]"}]}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"AppendTo", "[", 
          RowBox[{"ival", ",", "i"}], "]"}], ";", "\[IndentingNewLine]", 
         RowBox[{"interp", "=", 
          RowBox[{"Interpolation", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"profil", "[", 
               RowBox[{"[", "i", "  ", "]"}], "]"}], ",", 
              RowBox[{"profil", "[", 
               RowBox[{"[", 
                RowBox[{"i", "+", "1"}], " ", "]"}], "]"}]}], "}"}], ",", 
            RowBox[{"InterpolationOrder", "\[Rule]", "1"}]}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"xc", "=", 
          RowBox[{"x", "/.", 
           RowBox[{
            RowBox[{"FindRoot", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"interp", "[", "x", "]"}], "\[Equal]", "alt"}], ",", 
              RowBox[{"{", 
               RowBox[{"x", ",", 
                RowBox[{"profil", "[", 
                 RowBox[{"[", 
                  RowBox[{
                   RowBox[{"i", "+", "1"}], ",", "1"}], "]"}], "]"}]}], 
               "}"}]}], "]"}], "[", 
            RowBox[{"[", "1", "]"}], "]"}]}]}], ";", 
         RowBox[{"Print", "[", 
          RowBox[{"\"\<i =\>\"", ",", "i", ",", "\"\< x = \>\"", ",", "xc"}], 
          "]"}], ";", 
         RowBox[{"AppendTo", "[", 
          RowBox[{"xval", ",", "xc"}], "]"}], ";"}]}], "\[IndentingNewLine]", 
       "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", 
        RowBox[{"n", "-", "1"}]}], "}"}]}], "]"}], ";", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"il", ",", "ir"}], "}"}], "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"First", "@", "ival"}], ",", 
       RowBox[{"Last", "@", "ival"}]}], "}"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"xl", ",", "xr"}], "}"}], "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"First", "@", "xval"}], ",", 
       RowBox[{"Last", "@", "xval"}]}], "}"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"set", "=", 
     RowBox[{"Join", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"xl", ",", "alt"}], "}"}], "}"}], ",", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"profil", "[", 
          RowBox[{"[", "i", "]"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", 
           RowBox[{"il", "+", "1"}], ",", "ir"}], "}"}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"xr", ",", "alt"}], "}"}], "}"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"\[Chi]", "=", 
     RowBox[{"ArcLength", "@", 
      RowBox[{"Line", "[", "set", "]"}]}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"S", "=", 
     RowBox[{"NIntegrate", "[", 
      RowBox[{
       RowBox[{"alt", " ", "-", 
        RowBox[{"profilInterp", "[", "x", "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "xl", ",", "xr"}], "}"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"Rh", "=", 
     RowBox[{"S", "/", "\[Chi]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"Q", "=", 
     RowBox[{"S", " ", 
      RowBox[{"Rh", "^", 
       RowBox[{"(", 
        RowBox[{"2", "/", "3"}], ")"}]}], " ", 
      RowBox[{"Sqrt", "[", "pente", "]"}], " ", "K"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"AppendTo", "[", 
     RowBox[{"sol", ",", 
      RowBox[{"{", 
       RowBox[{"alt", ",", 
        RowBox[{"alt", "-", "zmin"}], ",", "Q", ",", "S", ",", "Rh"}], 
       "}"}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"alt", ",", 
     RowBox[{"zmin", "+", "0.2"}], ",", 
     RowBox[{"zmin", "+", "5"}], ",", "0.05"}], "}"}]}], 
  "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.7262258536730003`*^9, 3.726225974487*^9}, {
   3.726226108792*^9, 3.726226133618*^9}, {3.726226317785*^9, 
   3.7262264099820004`*^9}, {3.726226449434*^9, 3.72622647455*^9}, {
   3.726226514075*^9, 3.726226570517*^9}, {3.726227020848*^9, 
   3.726227075016*^9}, {3.726227423367*^9, 3.726227427098*^9}, {
   3.726232510858*^9, 3.726232631461*^9}, {3.726232669826*^9, 
   3.726232693715*^9}, {3.726233371703*^9, 3.7262334043640003`*^9}, 
   3.726233638984*^9, {3.726235938874*^9, 3.726235945443*^9}, {
   3.7262390861689997`*^9, 3.72623913842*^9}, 3.7262391871289997`*^9, {
   3.726240714218*^9, 3.726240715432*^9}, {3.726241099689*^9, 
   3.726241126535*^9}},ExpressionUUID->"3fdde85b-8e19-4349-9e79-2f7b42866753"],

Cell[BoxData["0.04878048780487805`"], "Output",
 CellChangeTimes->{
  3.7262258573529997`*^9, 3.726225974858*^9, 3.726226134086*^9, 
   3.7262264111689997`*^9, {3.7262264709849997`*^9, 3.7262264752460003`*^9}, 
   3.726226519617*^9, {3.726226556707*^9, 3.726226571341*^9}, {
   3.7262270628599997`*^9, 3.726227075238*^9}, 3.7262326354440002`*^9, 
   3.726232694592*^9, 3.726232735284*^9, {3.726233379144*^9, 
   3.7262334054709997`*^9}, 3.726233639807*^9, {3.7262359223310003`*^9, 
   3.7262359457139997`*^9}, {3.72623911376*^9, 3.726239138712*^9}, 
   3.726239187417*^9, 3.726240715784*^9, {3.726241102454*^9, 
   3.7262411268190002`*^9}, 
   3.726243421067*^9},ExpressionUUID->"a8ed31a2-6e00-4492-8fde-c2da02f7ab6d"],

Cell[BoxData["25"], "Output",
 CellChangeTimes->{
  3.7262258573529997`*^9, 3.726225974858*^9, 3.726226134086*^9, 
   3.7262264111689997`*^9, {3.7262264709849997`*^9, 3.7262264752460003`*^9}, 
   3.726226519617*^9, {3.726226556707*^9, 3.726226571341*^9}, {
   3.7262270628599997`*^9, 3.726227075238*^9}, 3.7262326354440002`*^9, 
   3.726232694592*^9, 3.726232735284*^9, {3.726233379144*^9, 
   3.7262334054709997`*^9}, 3.726233639807*^9, {3.7262359223310003`*^9, 
   3.7262359457139997`*^9}, {3.72623911376*^9, 3.726239138712*^9}, 
   3.726239187417*^9, 3.726240715784*^9, {3.726241102454*^9, 
   3.7262411268190002`*^9}, 
   3.726243421072*^9},ExpressionUUID->"e7c339b9-2793-4547-9324-a1c161ce9690"],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 CellChangeTimes->{
  3.7262258573529997`*^9, 3.726225974858*^9, 3.726226134086*^9, 
   3.7262264111689997`*^9, {3.7262264709849997`*^9, 3.7262264752460003`*^9}, 
   3.726226519617*^9, {3.726226556707*^9, 3.726226571341*^9}, {
   3.7262270628599997`*^9, 3.726227075238*^9}, 3.7262326354440002`*^9, 
   3.726232694592*^9, 3.726232735284*^9, {3.726233379144*^9, 
   3.7262334054709997`*^9}, 3.726233639807*^9, {3.7262359223310003`*^9, 
   3.7262359457139997`*^9}, {3.72623911376*^9, 3.726239138712*^9}, 
   3.726239187417*^9, 3.726240715784*^9, {3.726241102454*^9, 
   3.7262411268190002`*^9}, 
   3.726243421075*^9},ExpressionUUID->"4db73b6f-7070-469b-9092-798a7af61a9d"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "23", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "48.89250000000004`"}],
  SequenceForm["i =", 23, " x = ", 48.89250000000004],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, {
   3.726241102466*^9, 3.726241126828*^9}, 
   3.7262434210769997`*^9},ExpressionUUID->"aeb8c181-6c8e-419e-9a98-\
649c9e6cabee"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "25", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "52.02789473684215`"}],
  SequenceForm["i =", 25, " x = ", 52.02789473684215],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, {
   3.726241102466*^9, 3.726241126828*^9}, 
   3.7262434210810003`*^9},ExpressionUUID->"0777074f-1c83-4ce0-ab08-\
8b7c5d71fef1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "23", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "48.86875000000006`"}],
  SequenceForm["i =", 23, " x = ", 48.86875000000006],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, {
   3.726241102466*^9, 3.726241126828*^9}, 
   3.726243421084*^9},ExpressionUUID->"3314840c-0e43-45b2-982e-5ba892cb9e3f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "25", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "52.08236842105262`"}],
  SequenceForm["i =", 25, " x = ", 52.08236842105262],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, {
   3.726241102466*^9, 3.726241126828*^9}, 
   3.7262434210889997`*^9},ExpressionUUID->"571d49c4-f484-4b0d-a96b-\
44aab9645e0d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "23", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "48.84500000000008`"}],
  SequenceForm["i =", 23, " x = ", 48.84500000000008],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, {
   3.726241102466*^9, 3.726241126828*^9}, 
   3.726243421092*^9},ExpressionUUID->"8400a30f-5796-454d-9746-b77490330ccf"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "25", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "52.13684210526309`"}],
  SequenceForm["i =", 25, " x = ", 52.13684210526309],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, {
   3.726241102466*^9, 3.726241126828*^9}, 
   3.7262434210950003`*^9},ExpressionUUID->"a3d0e20d-f2f5-4517-9f67-\
f4464f7c2377"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "23", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "48.82124999999999`"}],
  SequenceForm["i =", 23, " x = ", 48.82124999999999],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, {
   3.726241102466*^9, 3.726241126828*^9}, 
   3.7262434211*^9},ExpressionUUID->"a45e5940-989b-4a28-8714-2bed92a8dcc3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "25", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "52.19131578947382`"}],
  SequenceForm["i =", 25, " x = ", 52.19131578947382],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, {
   3.726241102466*^9, 3.726241126828*^9}, 
   3.7262434211029997`*^9},ExpressionUUID->"91b1a97c-2e2f-4f05-84e8-\
15b18a621e97"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "23", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "48.797500000000014`"}],
  SequenceForm["i =", 23, " x = ", 48.797500000000014`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, {
   3.726241102466*^9, 3.726241126828*^9}, 
   3.726243421106*^9},ExpressionUUID->"e40d873a-644c-491b-89e0-9450d735a7e3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "25", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "52.24578947368429`"}],
  SequenceForm["i =", 25, " x = ", 52.24578947368429],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, {
   3.726241102466*^9, 3.726241126828*^9}, 
   3.726243421109*^9},ExpressionUUID->"56984e29-3fa6-4d39-b856-e07ebc6335ea"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "23", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "48.773750000000035`"}],
  SequenceForm["i =", 23, " x = ", 48.773750000000035`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, {
   3.726241102466*^9, 3.726241126828*^9}, 
   3.726243421112*^9},ExpressionUUID->"b988b1ff-1a2a-4c0f-9117-e51898ce0c03"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "25", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "52.30026315789477`"}],
  SequenceForm["i =", 25, " x = ", 52.30026315789477],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, {
   3.726241102466*^9, 3.726241126828*^9}, 
   3.726243421115*^9},ExpressionUUID->"47962ad5-8301-4f19-93ce-efc9cd6f98e2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "23", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "48.75000000000006`"}],
  SequenceForm["i =", 23, " x = ", 48.75000000000006],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, {
   3.726241102466*^9, 3.726241126828*^9}, 
   3.726243421118*^9},ExpressionUUID->"62a07bdc-7158-4223-9b85-a9671476befe"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "25", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "52.35473684210524`"}],
  SequenceForm["i =", 25, " x = ", 52.35473684210524],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, {
   3.726241102466*^9, 3.726241126828*^9}, 
   3.7262434211210003`*^9},ExpressionUUID->"b83f7644-bd32-4ffa-b90a-\
7fb229cb9f61"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "23", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "48.72625000000007`"}],
  SequenceForm["i =", 23, " x = ", 48.72625000000007],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, {
   3.726241102466*^9, 3.726241126828*^9}, 
   3.726243421125*^9},ExpressionUUID->"82f2ae19-4a05-4977-abea-acac48a85b00"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "25", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "52.40921052631571`"}],
  SequenceForm["i =", 25, " x = ", 52.40921052631571],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, {
   3.726241102466*^9, 3.726241126828*^9}, 
   3.7262434211280003`*^9},ExpressionUUID->"ec6eb34e-1fea-414b-bdba-\
b3bedcb19114"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "23", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "48.702499999999986`"}],
  SequenceForm["i =", 23, " x = ", 48.702499999999986`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, {
   3.726241102466*^9, 3.726241126828*^9}, 
   3.726243421131*^9},ExpressionUUID->"29bfc84c-2a4d-4e86-a08e-ed2070c2b9e1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "25", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "52.46368421052644`"}],
  SequenceForm["i =", 25, " x = ", 52.46368421052644],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, {
   3.726241102466*^9, 3.726241126828*^9}, 
   3.726243421134*^9},ExpressionUUID->"17e37795-1762-4f7d-82e6-fea822cd5308"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "23", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "48.67875000000001`"}],
  SequenceForm["i =", 23, " x = ", 48.67875000000001],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, {
   3.726241102466*^9, 3.726241126828*^9}, 
   3.726243421138*^9},ExpressionUUID->"dc12b751-8bdc-47e3-bb00-aaa0f919a463"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "25", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "52.51815789473691`"}],
  SequenceForm["i =", 25, " x = ", 52.51815789473691],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, {
   3.726241102466*^9, 3.726241126828*^9}, 
   3.726243421141*^9},ExpressionUUID->"19ea1bf8-1a3c-4407-afa9-c23fc49ad730"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "23", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "48.65500000000003`"}],
  SequenceForm["i =", 23, " x = ", 48.65500000000003],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, {
   3.726241102466*^9, 3.726241126828*^9}, 
   3.726243421144*^9},ExpressionUUID->"8c99b53d-c65b-444e-aa39-4309779cedf3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "25", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "52.57263157894739`"}],
  SequenceForm["i =", 25, " x = ", 52.57263157894739],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, {
   3.726241102466*^9, 3.726241126828*^9}, 
   3.7262434211470003`*^9},ExpressionUUID->"ef4aff5d-c737-474f-9874-\
8d4c55282ee6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "23", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "48.63125000000005`"}],
  SequenceForm["i =", 23, " x = ", 48.63125000000005],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, {
   3.726241102466*^9, 3.726241126828*^9}, 
   3.72624342115*^9},ExpressionUUID->"e59d5cfc-9169-4e39-8c1c-cdd7e1996d1e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "25", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "52.62710526315786`"}],
  SequenceForm["i =", 25, " x = ", 52.62710526315786],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, {
   3.726241102466*^9, 3.726241126828*^9}, 
   3.726243421153*^9},ExpressionUUID->"dcffdd29-7d79-4fc2-adb8-e32c86e4a7b3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "23", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "48.60750000000007`"}],
  SequenceForm["i =", 23, " x = ", 48.60750000000007],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, {
   3.726241102466*^9, 3.726241126828*^9}, 
   3.726243421156*^9},ExpressionUUID->"060180ba-2646-4caf-85f4-a33e019e4961"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "25", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "52.68157894736833`"}],
  SequenceForm["i =", 25, " x = ", 52.68157894736833],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, {
   3.726241102466*^9, 3.726241126828*^9}, 
   3.72624342116*^9},ExpressionUUID->"854f8df7-e54c-48f6-b124-2654e8856442"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "23", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "48.58374999999998`"}],
  SequenceForm["i =", 23, " x = ", 48.58374999999998],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, {
   3.726241102466*^9, 3.726241126828*^9}, 
   3.726243421163*^9},ExpressionUUID->"1f0d2353-4030-4597-9946-a13b5ce1026d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "25", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "52.73605263157906`"}],
  SequenceForm["i =", 25, " x = ", 52.73605263157906],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, {
   3.726241102466*^9, 3.726241126828*^9}, 
   3.726243421165*^9},ExpressionUUID->"7e57899a-34c3-4ce5-8adf-dc5638a0bbae"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "22", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", "48.56`"}],
  SequenceForm["i =", 22, " x = ", 48.56],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, {
   3.726241102466*^9, 3.726241126828*^9}, 
   3.726243421168*^9},ExpressionUUID->"e1466f15-c02d-47bc-8813-80c28615abfc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "23", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", "48.56`"}],
  SequenceForm["i =", 23, " x = ", 48.56],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, {
   3.726241102466*^9, 3.726241126828*^9}, 
   3.726243421171*^9},ExpressionUUID->"35ccb963-d987-40fd-ab09-b1aeabe94aad"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "25", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "52.79052631578953`"}],
  SequenceForm["i =", 25, " x = ", 52.79052631578953],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, {
   3.726241102466*^9, 3.726241126828*^9}, 
   3.726243421174*^9},ExpressionUUID->"2134ec7b-848b-4d0c-aac7-56eccd790be7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "22", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "48.53854166666669`"}],
  SequenceForm["i =", 22, " x = ", 48.53854166666669],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, {
   3.726241102466*^9, 3.726241126828*^9}, 
   3.726243421176*^9},ExpressionUUID->"870d2301-d86e-49ab-aa5f-9d09968222c5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "25", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", "52.845`"}],
  SequenceForm["i =", 25, " x = ", 52.845],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, {
   3.726241102466*^9, 3.726241126828*^9}, 
   3.726243421179*^9},ExpressionUUID->"91a074f6-5f2a-43b7-93ca-24086eb14837"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "22", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "48.517083333333375`"}],
  SequenceForm["i =", 22, " x = ", 48.517083333333375`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, {
   3.726241102466*^9, 3.726241126828*^9}, 
   3.726243421182*^9},ExpressionUUID->"c904a5bf-6a93-44b9-8a99-9bd9832fcf85"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "25", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "52.89947368421048`"}],
  SequenceForm["i =", 25, " x = ", 52.89947368421048],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, {
   3.726241102466*^9, 3.726241126828*^9}, 
   3.726243421185*^9},ExpressionUUID->"c40ee5ec-0846-4271-b229-326a2d24117e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "22", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "48.49562500000006`"}],
  SequenceForm["i =", 22, " x = ", 48.49562500000006],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, {
   3.726241102466*^9, 3.726241126828*^9}, 
   3.7262434211879997`*^9},ExpressionUUID->"b16e2fa9-de6b-4e0d-b489-\
17075eee85d7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "25", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "52.95394736842095`"}],
  SequenceForm["i =", 25, " x = ", 52.95394736842095],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, {
   3.726241102466*^9, 3.726241126828*^9}, 
   3.72624342119*^9},ExpressionUUID->"747735ad-e9e2-4a59-bbe2-ffc809faea89"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "22", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "48.47416666666665`"}],
  SequenceForm["i =", 22, " x = ", 48.47416666666665],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, {
   3.726241102466*^9, 3.726241126828*^9}, 
   3.726243421193*^9},ExpressionUUID->"8f86d9fa-b832-4e9e-b9b6-33777146d59f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "25", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "53.008421052631675`"}],
  SequenceForm["i =", 25, " x = ", 53.008421052631675`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, {
   3.726241102466*^9, 3.726241126828*^9}, 
   3.726243421196*^9},ExpressionUUID->"66c0a464-75c7-42a6-9466-cff929c8b0d7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "22", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "48.452708333333334`"}],
  SequenceForm["i =", 22, " x = ", 48.452708333333334`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, {
   3.726241102466*^9, 3.726241126828*^9}, 
   3.726243421199*^9},ExpressionUUID->"51a032e2-da14-4c70-925c-3e78b5d1fc18"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "25", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "53.062894736842146`"}],
  SequenceForm["i =", 25, " x = ", 53.062894736842146`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, {
   3.726241102466*^9, 3.726241126828*^9}, 
   3.726243421201*^9},ExpressionUUID->"c40b3ea1-2b64-4c88-ab6c-1027e5232930"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "22", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "48.43125000000002`"}],
  SequenceForm["i =", 22, " x = ", 48.43125000000002],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, {
   3.726241102466*^9, 3.726241126828*^9}, 
   3.726243421205*^9},ExpressionUUID->"c59e167e-2874-4d4c-a854-88fa6b186b41"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "25", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "53.11736842105262`"}],
  SequenceForm["i =", 25, " x = ", 53.11736842105262],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, {
   3.726241102466*^9, 3.726241126828*^9}, 
   3.726243421208*^9},ExpressionUUID->"8a3ab6c9-f6a0-4359-9226-b4c3026594e9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "22", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "48.409791666666706`"}],
  SequenceForm["i =", 22, " x = ", 48.409791666666706`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, {
   3.726241102466*^9, 3.726241126828*^9}, 
   3.726243421211*^9},ExpressionUUID->"bcc29f52-dd5b-46ac-8b31-8cb98646ca1b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "25", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "53.171842105263096`"}],
  SequenceForm["i =", 25, " x = ", 53.171842105263096`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, {
   3.726241102466*^9, 3.726241126828*^9}, 
   3.7262434212139997`*^9},ExpressionUUID->"840426d5-f3a9-4c61-8e0e-\
74b4915933fa"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "22", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "48.38833333333339`"}],
  SequenceForm["i =", 22, " x = ", 48.38833333333339],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, {
   3.726241102466*^9, 3.726241126828*^9}, 
   3.726243421217*^9},ExpressionUUID->"c42f9405-5b23-4e6c-9caf-ff16c38205cb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "25", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "53.22631578947357`"}],
  SequenceForm["i =", 25, " x = ", 53.22631578947357],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, {
   3.726241102466*^9, 3.726241126828*^9}, 
   3.726243421219*^9},ExpressionUUID->"6961588d-4887-45b2-938e-aba99ee7f698"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "22", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "48.36687499999998`"}],
  SequenceForm["i =", 22, " x = ", 48.36687499999998],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, {
   3.726241102466*^9, 3.726241126828*^9}, 
   3.726243421222*^9},ExpressionUUID->"12dc3499-e88b-4416-babe-99afdb11bc7a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "25", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "53.280789473684294`"}],
  SequenceForm["i =", 25, " x = ", 53.280789473684294`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, {
   3.726241102466*^9, 3.726241126828*^9}, 
   3.726243421225*^9},ExpressionUUID->"2853d341-82dd-42be-96a1-9547812e0eeb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "22", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "48.345416666666665`"}],
  SequenceForm["i =", 22, " x = ", 48.345416666666665`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, {
   3.726241102466*^9, 3.726241126828*^9}, 
   3.7262434212279997`*^9},ExpressionUUID->"5ca59a98-01e2-4e9f-a2ea-\
b40b06101074"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "25", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "53.335263157894765`"}],
  SequenceForm["i =", 25, " x = ", 53.335263157894765`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, {
   3.726241102466*^9, 3.726241126828*^9}, 
   3.726243421231*^9},ExpressionUUID->"4e71b202-e9ec-4b5c-bf07-06b6b4ce1ead"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "22", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "48.32395833333335`"}],
  SequenceForm["i =", 22, " x = ", 48.32395833333335],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, {
   3.726241102466*^9, 3.726241126828*^9}, 
   3.726243421233*^9},ExpressionUUID->"8e6acec0-4172-444e-bac0-c1f1ee73cf5f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "25", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "53.389736842105236`"}],
  SequenceForm["i =", 25, " x = ", 53.389736842105236`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, {
   3.726241102466*^9, 3.726241126828*^9}, 
   3.726243421236*^9},ExpressionUUID->"fd15ae92-7a79-4e0b-830c-a1b9489c81e5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "22", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "48.30250000000004`"}],
  SequenceForm["i =", 22, " x = ", 48.30250000000004],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, {
   3.726241102466*^9, 3.726241126828*^9}, 
   3.72624342124*^9},ExpressionUUID->"f65594b2-65d0-4ab5-9848-e96bf6624198"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "25", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "53.444210526315715`"}],
  SequenceForm["i =", 25, " x = ", 53.444210526315715`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, {
   3.726241102466*^9, 3.726241126828*^9}, 
   3.726243421243*^9},ExpressionUUID->"2ec9ac07-55b7-4ee2-a01c-fb47a174072c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "22", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "48.281041666666724`"}],
  SequenceForm["i =", 22, " x = ", 48.281041666666724`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, {
   3.726241102466*^9, 3.726241126828*^9}, 
   3.726243421245*^9},ExpressionUUID->"2482d1ec-a660-429e-97c6-cd069d64c3fb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "25", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "53.498684210526186`"}],
  SequenceForm["i =", 25, " x = ", 53.498684210526186`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, {
   3.726241102466*^9, 3.726241126828*^9}, 
   3.726243421248*^9},ExpressionUUID->"ae879b1d-c8c5-4ff7-a06a-b2166f12c650"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "22", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "48.25958333333331`"}],
  SequenceForm["i =", 22, " x = ", 48.25958333333331],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, {
   3.726241102466*^9, 3.726241126828*^9}, 
   3.726243421251*^9},ExpressionUUID->"c37375f8-5ba9-4c14-a3ca-438b5467e03c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "25", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "53.55315789473691`"}],
  SequenceForm["i =", 25, " x = ", 53.55315789473691],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, {
   3.726241102466*^9, 3.726241126828*^9}, 
   3.7262434212539997`*^9},ExpressionUUID->"3c98ea65-cb51-4a2f-8a2a-\
278a03a4c1e4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "22", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", "48.238125`"}],
  SequenceForm["i =", 22, " x = ", 48.238125],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, {
   3.726241102466*^9, 3.726241126828*^9}, 
   3.726243421258*^9},ExpressionUUID->"c8b3c405-6ca8-467b-814f-6ddda9b48cc3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "25", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "53.607631578947384`"}],
  SequenceForm["i =", 25, " x = ", 53.607631578947384`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, {
   3.726241102466*^9, 3.726241126828*^9}, 
   3.7262434212609997`*^9},ExpressionUUID->"64882bc8-3aff-4442-aa5b-\
4646ce877c3d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "22", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "48.21666666666668`"}],
  SequenceForm["i =", 22, " x = ", 48.21666666666668],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, {
   3.726241102466*^9, 3.726241126828*^9}, 
   3.726243421264*^9},ExpressionUUID->"1a1904ce-8f7a-4b43-988d-2b88d5b6a955"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "25", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "53.662105263157855`"}],
  SequenceForm["i =", 25, " x = ", 53.662105263157855`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, {
   3.726241102466*^9, 3.726241126828*^9}, 
   3.726243421266*^9},ExpressionUUID->"11e78e3b-89c6-4789-9e2b-9cd597242f97"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "22", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "48.19520833333337`"}],
  SequenceForm["i =", 22, " x = ", 48.19520833333337],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, {
   3.726241102466*^9, 3.726241126828*^9}, 
   3.726243421269*^9},ExpressionUUID->"dc211b57-ae41-4c43-889e-be6d062ee81e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "25", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "53.71657894736833`"}],
  SequenceForm["i =", 25, " x = ", 53.71657894736833],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, {
   3.726241102466*^9, 3.726241126828*^9}, 
   3.7262434212720003`*^9},ExpressionUUID->"3d1e3054-bae7-4f4b-ba7c-\
ab278a481724"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "22", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "48.173750000000055`"}],
  SequenceForm["i =", 22, " x = ", 48.173750000000055`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, {
   3.726241102466*^9, 3.726241126828*^9}, 
   3.726243421275*^9},ExpressionUUID->"99fb180e-c2b6-4837-9d47-a5aa2789a149"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "25", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "53.771052631578804`"}],
  SequenceForm["i =", 25, " x = ", 53.771052631578804`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, {
   3.726241102466*^9, 3.726241126828*^9}, 
   3.726243421277*^9},ExpressionUUID->"22ff832b-f04c-4acf-9cad-83eecaf717b6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "22", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "48.15229166666664`"}],
  SequenceForm["i =", 22, " x = ", 48.15229166666664],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, {
   3.726241102466*^9, 3.726241126828*^9}, 
   3.7262434212799997`*^9},ExpressionUUID->"6245a613-54fb-4969-9802-\
d43e74966b1f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "25", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "53.82552631578953`"}],
  SequenceForm["i =", 25, " x = ", 53.82552631578953],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, {
   3.726241102466*^9, 3.726241126828*^9}, 
   3.726243421283*^9},ExpressionUUID->"b6b0476e-9bce-4a5f-8ed7-0eee95220906"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "22", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "48.13083333333333`"}],
  SequenceForm["i =", 22, " x = ", 48.13083333333333],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, {
   3.726241102466*^9, 3.726241126828*^9}, 
   3.7262434212860003`*^9},ExpressionUUID->"4b53d6cc-8b9e-4ed3-ba23-\
02b72a10b0a9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "25", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", "53.88`"}],
  SequenceForm["i =", 25, " x = ", 53.88],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, {
   3.726241102466*^9, 3.726241126828*^9}, 
   3.726243421289*^9},ExpressionUUID->"75cd270a-611e-42ca-b114-89f6898de81b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "26", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", "53.88`"}],
  SequenceForm["i =", 26, " x = ", 53.88],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, {
   3.726241102466*^9, 3.726241126828*^9}, 
   3.726243421291*^9},ExpressionUUID->"b9acbfeb-7299-4743-a9ef-2df2886207d6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "22", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "48.109375000000014`"}],
  SequenceForm["i =", 22, " x = ", 48.109375000000014`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, {
   3.726241102466*^9, 3.726241126828*^9}, 
   3.7262434212939997`*^9},ExpressionUUID->"7490344e-9386-4ed7-8936-\
0648cba8a585"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "26", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "54.113749999999804`"}],
  SequenceForm["i =", 26, " x = ", 54.113749999999804`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, {
   3.726241102466*^9, 3.726241126828*^9}, 
   3.726243421296*^9},ExpressionUUID->"b2f3af2f-3dfa-47f1-b6a8-330cc8c78fee"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "22", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "48.0879166666667`"}],
  SequenceForm["i =", 22, " x = ", 48.0879166666667],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, {
   3.726241102466*^9, 3.726241126828*^9}, 
   3.7262434213*^9},ExpressionUUID->"319a90d2-523b-4532-9ff7-6365dac18063"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "26", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "54.347499999999606`"}],
  SequenceForm["i =", 26, " x = ", 54.347499999999606`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, {
   3.726241102466*^9, 3.726241126828*^9}, 
   3.726243421303*^9},ExpressionUUID->"d6a38c82-0c94-47d8-9394-eb07dede6813"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "22", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "48.06645833333339`"}],
  SequenceForm["i =", 22, " x = ", 48.06645833333339],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, {
   3.726241102466*^9, 3.726241126828*^9}, 
   3.7262434213059998`*^9},ExpressionUUID->"a99fef3c-a62f-4309-b632-\
7ce9005de4fa"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "26", 
   "\[InvisibleSpace]", "\<\" x = \"\>", "\[InvisibleSpace]", 
   "54.5812499999994`"}],
  SequenceForm["i =", 26, " x = ", 54.5812499999994],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.726225974861*^9, 3.72622613409*^9, 3.726226411262*^9, {3.72622647109*^9, 
   3.7262264753450003`*^9}, 3.726226519671*^9, {3.726226556744*^9, 
   3.726226571343*^9}, {3.7262270628710003`*^9, 3.726227075242*^9}, 
   3.726232635454*^9, 3.726232694601*^9, 3.726232735291*^9, {
   3.726233379151*^9, 3.726233405481*^9}, 3.7262336398129997`*^9, {
   3.7262359223380003`*^9, 3.7262359457279997`*^9}, {3.7262391137679996`*^9, 
   3.726239138723*^9}, 3.726239187424*^9, 3.726240715793*^9, {
   3.726241102466*^9, 3.726241126828*^9}, 
   3.726243421308*^9},ExpressionUUID->"5ec0c47f-9f2f-40f7-bc30-66346317db0b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i =\"\>", "\[InvisibleSpace]", "22", 
   "\[InvisibleSpace]