function [x_interp, z_interp, h, S, chi, Q] = debit(x, z, n_interp, K, i)

% figure
% plot(x, z, 'LineWidth', 2.5, 'Color', 'k')
% xlabel('x [m]')
% ylabel('z [m]')
% title('cross section')
% axis([0 200 0 25])

%%  %%  interpolation des donnes

% calcul des nouvelles abscisses interpoles  intervalle spcifi

xmin = min(x); xmax = max(x);
x_interp = linspace(xmin, xmax, n_interp);
x_interp = x_interp';
z_interp = interp1(x, z, x_interp, 'linear');

% figure
% plot(x, z, 'k-', 'LineWidth', 2.5)
% hold on
% plot(x_interp, z_interp, 'bo', 'LineWidth', 1.5, 'MarkerSize', 6)
% xlabel('x [m]')
% ylabel('z [m]')
% title('section en travers')
% axis([0 200 0 25])

%%  section en travers

z_inf = min(z_interp);
z_sup = max(z_interp);

N = length(z_interp);
alt = linspace(z_inf, z_sup, N);

S = zeros(length(z_interp), 1);
for j = 1 : length(alt)

integ = alt(j) - z_interp;
for i = 1 : length(integ)
    if(integ(i) < 0)
        integ(i) = 0;
    end
end

S(j) = trapz(x_interp, integ);

end

% figure
% plot(alt -alt(1), S, 'k-', 'LineWidth', 2)
% hold on
% plot(alt - alt(1), (alt - alt(1))*100, 'b-', 'LineWidth', 2)
% xlabel('h [m]', 'FontSize', 26)
% ylabel('S [m^2]', 'FontSize', 26)
% title('surface mouille')
% axis([0 200 0 25])

%%  perimtre mouill

%   section en travers 1
chi = zeros(length(z_interp), 1);
for j = 1 : length(alt)
% calculer la fonction profil en travers
integ = alt(j) - z_interp;
for i = 1 : length(integ)
    if(integ(i) < 0)
        integ(i) = 0;
    end
end
% calculer la longeur d'arc de la section en travers
ind_pos = find(abs(diff(integ)) > 0);
ind_neg = find(abs(diff(integ)) == 0);
d_ind = abs(diff(integ));
tot = sum(d_ind(ind_pos)) ;


if(isempty(find(abs(integ(ind_neg)) > 0)))
    tot = tot;
else
    ind = find(abs(integ(ind_neg)) > 0);
    tot = tot + length(ind);
end
chi(j) = tot;
end

% figure
% plot(alt - alt(1), chi, 'k-', 'LineWidth', 2)
% hold on
% plot(alt - alt(1), 100 + 2*(alt - alt(1)), 'b-', 'LineWidth', 2)
% xlabel('h [m]', 'FontSize', 26)
% ylabel('\chi [m^2]', 'FontSize', 26)
% title('primtre mouill')

%%  dbitance
% K = 25;
% i = 0.03;
R_h = S./chi;
Q = K.*S.*R_h.^(2/3).*sqrt(i);
h = alt - alt(1);
h = h';

L = 100;
S_an = h*L;
chi_an = 2*h + L;
chi_an(1) = 0;
R_han = S_an./chi_an;
Q_an = K.*S_an.*R_han.^(2/3).*sqrt(i);

% figure
% plot(h, Q, 'k-', 'LineWidth', 2)
% hold on
% plot(h, Q_an, 'b-', 'LineWidth', 2)
% xlabel('h [m]', 'FontSize', 26)
% ylabel('Q [m^3/s]', 'FontSize', 26)
% title('dbitance')
