%   chargement des diffrents profils

set(groot,'defaulttextinterpreter', 'latex');
fontSize = 32;
set(groot,'DefaultAxesFontSize', fontSize);
set(groot,'defaultAxesFontName', 'CMU Serif');
set(groot,'defaultLineLineWidth', 2.5)
disp('figure plotting parameters set to default')

A = load('profil_1.txt');
X = cell(4,1);
Z = cell(4,1);
X{1} = A(:,1);
Z{1} = A(:,2);
A = load('profil_2.txt');
X{2} = A(:,1);
Z{2} = A(:,2);
A = load('profil_3.txt');
X{3} = A(:,1);
Z{3} = A(:,2);
A = load('profil_4.txt');
X{4} = A(:,1);
Z{4} = A(:,2);

n_interp = 1000;    % nombre de points d'interpolations des donnes topographiques
Qprojet = 200;      % dbit de pointe estim avec IBER

%%  calculs et 
for j = 1:4
K = 25;
i = [0.03 0.052 0.025 0.049 0.03];
x = X{j};
z = Z{j};
%   calcul des sections en travers et des primtres mouills
[x_interp, z_interp, h, S, chi, Q] = debit(x, z, n_interp, K, i(j));

%   calcul de la dbitance
QQ = K.*S.*(S./chi/2).^(2/3)*sqrt(i(j));
QQ(1) = 0;
ind = (find(QQ > Qprojet-10 & QQ < Qprojet+10));
l = length(ind);
ind = min([round(mean(ind(1:round(l/2)))) round(mean(ind(round(l/2):end)))]);
h_proj = h(ind);
Q_proj = Qprojet;
hmin = 0;
hmax = 5;
Qmin = 0;
Qmax = 600;

%   dessin de la dbitance
figure
plot(h, QQ, 'k-', 'LineWidth', 2.5)
hold on
plot([0 10], [Q_proj Q_proj], 'r-.')
hold on
plot([h_proj h_proj], [Qmin Qmax], 'b:')
xlabel('$h$ [m]')
ylabel('$Q$ [m$^3$/s]')
title(['dbitance profil ' num2str(j)])
text(0.5, Q_proj+30, ['$Q_{projet} = $ ' num2str(Q_proj) ' m$^3$/s'], 'Color', 'r', 'FontSize', fontSize)
text(h_proj+0.1, 500, ['$h =$ ' num2str(h_proj) ' m'], 'Color', 'b', 'FontSize', fontSize)
axis([hmin hmax Qmin Qmax])

%   calcul du niveau de l'eau
ind_mininterp = find(z_interp == min(z_interp));
water_height = min(z_interp) + h_proj;
ind = find(z_interp>water_height-0.2 & z_interp<water_height+0.2);
if(length(ind) == 1)
    disp('deux intersections non trouves')
else
    indmin = ind(1);
    indmax = ind(end);
    xmin = x_interp(indmin);
    xmax = x_interp(indmax);
    zmin = min(z_interp);
    zmax = water_height;
end

%   dessin du niveau de l'eau
figure
plot(x_interp, z_interp, 'k-')
hold on
plot([xmin xmax], [min(z_interp)+h_proj min(z_interp)+h_proj], 'b-.')
xlabel('$x$ [m]')
ylabel('$z$ [m]')
title(['profondeur d eau profil ' num2str(j)])
axis([xmin-1 xmax+1 zmin-.5 zmax+.5])

end

