%% Clear
clc;
close all;
clear all;
fileName=1;
folder=1;

%% Choosing the files to treat
uiwait(warndlg({'choose the file to load'}));
[fileName folder] = uigetfile('*.txt', 'Select file(s)', 'MultiSelect', 'on');
addpath(folder,strcat(folder,'Picking'));
cd(folder);
if iscell(fileName)
    nbfiles = length(fileName);
elseif fileName ~= 0
    nbfiles = 1;
    fileName=cellstr(fileName);
else
    nbfiles = 0;
end
%% Loop on the chosen files
N= nbfiles;
%% Init
Data=cell(N,4);

Fs = [];
Fs = input('Enter the sampling frequency in [Hz]!...:')

for i =1:N
    %% Initializing
    
    Picks=zeros();
    traces=[1 1 1];
    traces=load(fileName{i});
    time=[1:1:size(traces,1)]./Fs;
    
    trigger=traces(:,1);
    Pwave=traces(:,2);
    Swave=traces(:,3);
    
    vname=@(x) inputname(1);
    
    
    Pstr=vname(Pwave);
    Sstr=vname(Swave);
    
    
    
    %% Picking
    
    Title=strcat('Picking...',fileName,'...Zoom in --> Check Box --> Select the pick point');
      
if iscell(fileName)
    Title=strcat('Picking...',fileName{i},'...Zoom in --> Check Box --> Select the pick point');
elseif fileName ~= 0
    Title=strcat('Picking...',fileName,'...Zoom in --> Check Box --> Select the pick point');
end
    
    mainfig=figure(i);

    set(gca,'visible','off');
    
    tabgroup = uitabgroup(mainfig, 'Position', [.05 .1 .9 .83]);
    
    for k= 1:3
        
        if k==1
            WFM=trigger;
            WFMstr=vname(trigger);
        elseif k==2
            WFM=Pwave;
            WFMstr=vname(Pwave);
        elseif k==3
            WFM=Swave;
            WFMstr=vname(Swave);
        end
        
        tab(k)=uitab(tabgroup,'Title', sprintf(WFMstr));
        a=axes('parent',tab(k));
        plot(time,WFM);
        xlabel('time (s)')
        ylabel('Voltage (V)')
        title(Title, 'Interpreter', 'none');
        tabgroup.SelectedTab=tab(k);
        ord=ylim;
        button=uicontrol('Style','checkbox','String','DoneZooming','Units','normalized','Position',[0.8 0.8 0.15 0.15],'Visible','on');
        while true
            drawnow()
            dragzoom(a);
            stop_state = get(button,'Value');
            if stop_state==get(button,'Max')
                break
            end
        end
        
        [x y] = ginput(1);
        Picks(k,1)=x;
        Picks(k,2)=y;
        hold on
        plot(Picks(k,1),Picks(k,2),'r*');
        hold off
        zoom out
        zoom out
    end
    
    TimesV=Picks;
    
    Data{i,1}={fileName};
    Data{i,2}=traces;
    Data{i,3}=Picks';
    
    display('Congratulations, your waves are picked.')
    display('The variable Data contains: {i,1}the name of the file you treated;')
    display('{i,2} the traces [trigger Pwave Swave];')
    display('and {i,3} the picked times with their corresponding voltages [[trigger];[Pwave];[Swave]].')
    display('You will now treat another file')
    
    Data{i,1}{1}
    Data{i,2};
    format long
    disp(Data{i,3}(1,:))
    format short

    display('The variable Data{i,4} contains: [trigger time ; P_wave time ; S_wave time)] ')
    Data{i,4}=[Data{i,3}(1,1) Data{i,3}(1,2) Data{i,3}(1,3)];
    Data{i,4}
   
    clearvars -except Data fileName Fs
    
end

