--[[
----------------------------------------------------------------------
Frontend for the Students
----------------------------------------------------------------------
Original Author: Michel Lopez / IPESE
--]]
local osmose = require 'osmose'
local my_obj = "TotalCost"
local frontend = osmose.Project ('methanol', my_obj)
frontend.operationalCosts = 'operating_data.csv'

frontend:load (
    { Methanol= 'ET.Methanol' },
    { coolingtower= 'ET.coolingtower' },
    { furnace= 'ET.furnace' },
    { market= 'ET.market' },
    { refrigerator= 'ET.refrigerator' },
    { steamnetwork_ss= 'ET.steamnetwork_ss' }
)

frontend.options.mathProg = {
    language = 'ampl', solver_name = 'gurobi', options = {'display_1col 10000','display_eps 0.0001','presolve_eps 1e-4','omit_zero_rows 1', 'omit_zero_cols 1'}
}

frontend.options.graph.format = 'svg'
frontend.options.graph.icc = {'model','unit','utility'}
frontend.options.graph.carnot = {'model','utilities'}
frontend.options.graph.spaghetti = true
frontend.options.graph.rungnuplot = false

frontend.options.storejson = true

frontend:scenario(1):time(1)
frontend:solve()
