local osmose = require 'osmose'
local et = osmose.Model 'steamnetwork_ss'
et.superstructure = {'steamnetwork_sowe'}

et.values = {}
et.inputs = {}

et:addSteamNetwork  {

  base = 'sowe', -- (mandatory) Defines the base of calculation (may not be compatible with the legacy versions of the superstructure)
  database = 'coolprop', -- (mandatory) Defines by default the use of coolprop instead of refprop
  pressures = { -- [bar] Pressure levels defined for the rankine cycle in decreasing order
    30,3,1,0.04,
  },
  temperatures = { -- [C] Temperature level, only if pressure is not defined (Optional)
    1,1,1,1,
  },
  isturbine = { -- [-] Activate turbine at the respective level, for last level is zero
    1,0,0,0,
  },
  issteam = { -- [-] Activate steam generation at the respective level
    1,0,0,0,
  },
  superheatdT = { -- [K] Superheating temperature difference
    200,2,2,2,
  },

  subcooldT = -1.1, -- [K] Subcooling temperature difference in the condenser, must be <= 0
  DT = { -- (optional) [K] Minimum temperature difference contribution (dtmin/2), which depends on the fluid state.
    gas = 15, -- [K] Minimum temperature difference contribution related to the gas phase stream
    liquid = 5, -- [K] Minimum temperature difference contribution related to the liquid phase stream
    phasechange = 2, -- [K] Minimum temperature difference contribution related to the phasechange stream
    global = 10, -- [K] Minimum temperature difference contribution for the global scope
  },
  htc = { -- (optional) Heat transfer coefficients for each fluid state. It follows the relation $DT=112.14/htc^{0.4913}$
    gas = 0.06, -- [kW/m2K] Heat transfer coefficient related to the gas phase stream
    liquid = 0.56, -- [kW/m2K] Heat transfer coefficient related to the liquid phase stream
    condensing = 1.6, -- [kW/m2K] Heat transfer coefficient related to the condensing stream
    vaporising = 3.6, -- [kW/m2K] Heat transfer coefficient related to the vaporasing stream
  },

  fmin = { -- (optional)  Minimum load factors of the units of the superstructure provided in kW
    header = 0, -- 
    drawoff = 0, -- 
    turbine_drawoff = 0, -- 
    turbine_ext = 0, -- 
    pump = 0, -- 
  },
  fmax = { -- (optional)  Maximum load factors of the units of the superstructure provided in kW
    header = 100000, -- 
    drawoff = 100000, -- 
    turbine_drawoff = 100000, -- 
    turbine_ext = 100000, -- 
    pump = 100000, -- 
  },

  inv1 = { -- (optional) [CHF/yr] Fixed annualized investment cost of the units of the superstructure
    turbine = 150, -- 
    pump = 50, -- 
  },
  inv2 = { -- (optional) [CHF/yr/kW] Variable annualized investment cost of the units of the superstructure
    turbine = 120, -- 
    pump = 8, -- 
  },

  eff_backpr_turb = 0.90, -- 
  eff_cond_turb = 0.95, -- 
  eff_pump = 0.80, -- 
  fluid = 'water', -- Fluid selected from the fluid list -- working fluid of the cycle (default = 'water')

  layerofelec = 'ELEC', -- Layer of electricity
  layerofheat = 'DefaultHeatCascade', -- Layer of heat
  layerstype = { -- (mandatory) Define the layer type. It can be used as shown by default
    electricity = 'ResourceBalance',
    pressure = 'ResourceBalanceQuality',
    drawoff = 'ResourceBalance',
    condensate = 'ResourceBalance',
    makeup = 'ResourceBalance',
  },
  -- optional -- automatically defined P01, P02, etc, can be user defined, If the table of pressures consists of numbers rather than strings it is recommended to use this key.
  layerofpressure = { -- [-] Layer of pressure
    'p1','p2','p3','p4',
  },
  -- (mandatory) layers of drawoff in case the user has some units that consume steam as "mass" rather than "heat".
  layerofdrawoff = { -- [-] Layer of draw off for steam straction
    'droffp1','droffp2','droffp3','droffp4',
  },

  options = {
    add_ext_turbine = 0 -- 0 or 1 (default 0) -- add extraction turbines (1) or not (0)--(optional)
  }
}

return et
