local osmose = require 'osmose'
local et = osmose.Model 'refrigerator'

et:addLayers { ELEC = {type= 'ResourceBalance', unit = 'kW'} }

et:addUnit("Refrigerator", {type = 'Utility', Cost1 = 'Refrigerator_cost1', Cost2 = 'Refrigerator_cost2', Cinv1 = 'Refrigerator_cinv1', Cinv2 = 'Refrigerator_cinv2', Impact1 = 'Refrigerator_imp1', Impact2 = 'Refrigerator_imp2', Fmin = 'Refrigerator_fmin', Fmax = 'Refrigerator_fmax'})

et["Refrigerator"]:addStreams({
  ELEC = rs{'ELEC', 'in', 'Refrigerator_ELEC_Flow'},
  evaporation = qt{tin = 'Refrigerator_evaporation_Tin', hin = 'Refrigerator_evaporation_Hin', tout = 'Refrigerator_evaporation_Tout', hout = 'Refrigerator_evaporation_Hout', dtmin = 'Refrigerator_evaporation_dTmin', alpha = 'Refrigerator_evaporation_alpha'},
  condensation = qt{tin = 'Refrigerator_condensation_Tin', hin = 'Refrigerator_condensation_Hin', tout = 'Refrigerator_condensation_Tout', hout = 'Refrigerator_condensation_Hout', dtmin = 'Refrigerator_condensation_dTmin', alpha = 'Refrigerator_condensation_alpha'},
})


et.inputs = {
Refrigerator_cost1 = {default = 0 },
Refrigerator_cost2 = {default = 0 },
Refrigerator_cinv1 = {default = 0 },
Refrigerator_cinv2 = {default = 125590.17081620239 },
Refrigerator_imp1 = {default = 0 },
Refrigerator_imp2 = {default = 0 },
Refrigerator_fmin = {default = 0 },
Refrigerator_fmax = {default = 10 },
Refrigerator_ELEC_Flow = {default = 1079.1366906474818 },
Refrigerator_evaporation_Tin = {default = 5 },
Refrigerator_evaporation_Tout = {default = 5 },
Refrigerator_evaporation_Hin = {default = 0 },
Refrigerator_evaporation_Hout = {default = 5000 },
Refrigerator_evaporation_dTmin = {default = 2 },
Refrigerator_evaporation_alpha = {default = 1 },
Refrigerator_condensation_Tin = {default = 35 },
Refrigerator_condensation_Tout = {default = 35 },
Refrigerator_condensation_Hin = {default = 6079.136690647481 },
Refrigerator_condensation_Hout = {default = 0 },
Refrigerator_condensation_dTmin = {default = 2 },
Refrigerator_condensation_alpha = {default = 1 },
}
et.outputs = {
}

return et
