local osmose = require 'osmose'
local et = osmose.Model 'market'

et:addLayers { NATGAS = {type= 'ResourceBalance', unit = 'kW'} }
et:addLayers { ELEC = {type= 'ResourceBalance', unit = 'kW'} }
et:addLayers { WATER = {type= 'ResourceBalance', unit = 'kg/h'} }

et:addUnit("ElecSell", {type = 'Utility', Cost1 = 'ElecSell_cost1', Cost2 = 'ElecSell_cost2', Cinv1 = 'ElecSell_cinv1', Cinv2 = 'ElecSell_cinv2', Impact1 = 'ElecSell_imp1', Impact2 = 'ElecSell_imp2', Fmin = 'ElecSell_fmin', Fmax = 'ElecSell_fmax'})

et["ElecSell"]:addStreams({
  ELEC = rs{'ELEC', 'out', 'ElecSell_ELEC_Flow'},
})
et:addUnit("NatgasSell", {type = 'Utility', Cost1 = 'NatgasSell_cost1', Cost2 = 'NatgasSell_cost2', Cinv1 = 'NatgasSell_cinv1', Cinv2 = 'NatgasSell_cinv2', Impact1 = 'NatgasSell_imp1', Impact2 = 'NatgasSell_imp2', Fmin = 'NatgasSell_fmin', Fmax = 'NatgasSell_fmax'})

et["NatgasSell"]:addStreams({
  NATGAS = rs{'NATGAS', 'out', 'NatgasSell_NATGAS_Flow'},
})
et:addUnit("WaterSell", {type = 'Utility', Cost1 = 'WaterSell_cost1', Cost2 = 'WaterSell_cost2', Cinv1 = 'WaterSell_cinv1', Cinv2 = 'WaterSell_cinv2', Impact1 = 'WaterSell_imp1', Impact2 = 'WaterSell_imp2', Fmin = 'WaterSell_fmin', Fmax = 'WaterSell_fmax'})

et["WaterSell"]:addStreams({
  WATER = rs{'WATER', 'out', 'WaterSell_WATER_Flow'},
})


et.inputs = {
ElecSell_cost1 = {default = 0 },
ElecSell_cost2 = {default = 250.0 },
ElecSell_cinv1 = {default = 0 },
ElecSell_cinv2 = {default = 0 },
ElecSell_imp1 = {default = 0 },
ElecSell_imp2 = {default = 0 },
ElecSell_fmin = {default = 0 },
ElecSell_fmax = {default = 100000 },
ElecSell_ELEC_Flow = {default = 1000 },
NatgasSell_cost1 = {default = 0 },
NatgasSell_cost2 = {default = 119.0 },
NatgasSell_cinv1 = {default = 0 },
NatgasSell_cinv2 = {default = 0 },
NatgasSell_imp1 = {default = 0 },
NatgasSell_imp2 = {default = 0 },
NatgasSell_fmin = {default = 0 },
NatgasSell_fmax = {default = 1000 },
NatgasSell_NATGAS_Flow = {default = 1000 },
WaterSell_cost1 = {default = 0 },
WaterSell_cost2 = {default = 2.5 },
WaterSell_cinv1 = {default = 0 },
WaterSell_cinv2 = {default = 0 },
WaterSell_imp1 = {default = 0 },
WaterSell_imp2 = {default = 0 },
WaterSell_fmin = {default = 0 },
WaterSell_fmax = {default = 10000 },
WaterSell_WATER_Flow = {default = 1000 },
}
et.outputs = {
}

return et
