local osmose = require 'osmose'
local et = osmose.Model 'furnace'

et:addLayers { NATGAS = {type= 'ResourceBalance', unit = 'kW'} }

et:addUnit("Furnace", {type = 'Utility', Cost1 = 'Furnace_cost1', Cost2 = 'Furnace_cost2', Cinv1 = 'Furnace_cinv1', Cinv2 = 'Furnace_cinv2', Impact1 = 'Furnace_imp1', Impact2 = 'Furnace_imp2', Fmin = 'Furnace_fmin', Fmax = 'Furnace_fmax'})

et["Furnace"]:addStreams({
  NATGAS = rs{'NATGAS', 'in', 'Furnace_NATGAS_Flow'},
  radiation = qt{tin = 'Furnace_radiation_Tin', hin = 'Furnace_radiation_Hin', tout = 'Furnace_radiation_Tout', hout = 'Furnace_radiation_Hout', dtmin = 'Furnace_radiation_dTmin', alpha = 'Furnace_radiation_alpha'},
  convection = qt{tin = 'Furnace_convection_Tin', hin = 'Furnace_convection_Hin', tout = 'Furnace_convection_Tout', hout = 'Furnace_convection_Hout', dtmin = 'Furnace_convection_dTmin', alpha = 'Furnace_convection_alpha'},
  preheating = qt{tin = 'Furnace_preheating_Tin', hin = 'Furnace_preheating_Hin', tout = 'Furnace_preheating_Tout', hout = 'Furnace_preheating_Hout', dtmin = 'Furnace_preheating_dTmin', alpha = 'Furnace_preheating_alpha'},
})


et.inputs = {
Furnace_cost1 = {default = 0 },
Furnace_cost2 = {default = 0 },
Furnace_cinv1 = {default = 0 },
Furnace_cinv2 = {default = 13772.807687141723 },
Furnace_imp1 = {default = 0 },
Furnace_imp2 = {default = 0 },
Furnace_fmin = {default = 0 },
Furnace_fmax = {default = 100 },
Furnace_NATGAS_Flow = {default = 1030.9278350515465 },
Furnace_radiation_Tin = {default = 1050 },
Furnace_radiation_Tout = {default = 1050 },
Furnace_radiation_Hin = {default = 480.26584125000005 },
Furnace_radiation_Hout = {default = 0 },
Furnace_radiation_dTmin = {default = 2 },
Furnace_radiation_alpha = {default = 1 },
Furnace_convection_Tin = {default = 1050 },
Furnace_convection_Tout = {default = 100 },
Furnace_convection_Hin = {default = 482.04866749999997 },
Furnace_convection_Hout = {default = 0 },
Furnace_convection_dTmin = {default = 8 },
Furnace_convection_alpha = {default = 1 },
Furnace_preheating_Tin = {default = 25 },
Furnace_preheating_Tout = {default = 26 },
Furnace_preheating_Hin = {default = 0 },
Furnace_preheating_Hout = {default = 0.37098249999999994 },
Furnace_preheating_dTmin = {default = 8 },
Furnace_preheating_alpha = {default = 1 },
}
et.outputs = {
}

return et
