local osmose = require 'osmose'
local et = osmose.Model 'coolingtower'

et:addLayers { ELEC = {type= 'ResourceBalance', unit = 'kW'} }
et:addLayers { WATER = {type= 'ResourceBalance', unit = 'kg/h'} }

et:addUnit("CoolTower", {type = 'Utility', Cost1 = 'CoolTower_cost1', Cost2 = 'CoolTower_cost2', Cinv1 = 'CoolTower_cinv1', Cinv2 = 'CoolTower_cinv2', Impact1 = 'CoolTower_imp1', Impact2 = 'CoolTower_imp2', Fmin = 'CoolTower_fmin', Fmax = 'CoolTower_fmax'})

et["CoolTower"]:addStreams({
  ELEC = rs{'ELEC', 'in', 'CoolTower_ELEC_Flow'},
  WATER = rs{'WATER', 'in', 'CoolTower_WATER_Flow'},
  cooltowerheat = qt{tin = 'CoolTower_cooltowerheat_Tin', hin = 'CoolTower_cooltowerheat_Hin', tout = 'CoolTower_cooltowerheat_Tout', hout = 'CoolTower_cooltowerheat_Hout', dtmin = 'CoolTower_cooltowerheat_dTmin', alpha = 'CoolTower_cooltowerheat_alpha'},
})


et.inputs = {
CoolTower_cost1 = {default = 0 },
CoolTower_cost2 = {default = 0 },
CoolTower_cinv1 = {default = 0 },
CoolTower_cinv2 = {default = 11411.988413145207 },
CoolTower_imp1 = {default = 0 },
CoolTower_imp2 = {default = 0 },
CoolTower_fmin = {default = 0 },
CoolTower_fmax = {default = 100000 },
CoolTower_ELEC_Flow = {default = 21.0 },
CoolTower_WATER_Flow = {default = 731.751592356688 },
CoolTower_cooltowerheat_Tin = {default = 15 },
CoolTower_cooltowerheat_Tout = {default = 30 },
CoolTower_cooltowerheat_Hin = {default = 0 },
CoolTower_cooltowerheat_Hout = {default = 1000 },
CoolTower_cooltowerheat_dTmin = {default = 5 },
CoolTower_cooltowerheat_alpha = {default = 1 },
}
et.outputs = {
}

return et
