local osmose = require 'osmose'
local et = osmose.Model 'Methanol'

et:addLayers { ELEC = {type= 'ResourceBalance', unit = 'kW'} }

et:addUnit("Methanol", {type = 'Process', Cost1 = 'Methanol_cost1', Cost2 = 'Methanol_cost2', Cinv1 = 'Methanol_cinv1', Cinv2 = 'Methanol_cinv2', Impact1 = 'Methanol_imp1', Impact2 = 'Methanol_imp2', Fmin = 'Methanol_fmin', Fmax = 'Methanol_fmax'})

et["Methanol"]:addStreams({
  ELEC = rs{'ELEC', 'in', 'Methanol_ELEC_Flow'},
  heater_1 = qt{tin = 'Methanol_heater_1_Tin', hin = 'Methanol_heater_1_Hin', tout = 'Methanol_heater_1_Tout', hout = 'Methanol_heater_1_Hout', dtmin = 'Methanol_heater_1_dTmin', alpha = 'Methanol_heater_1_alpha'},
  heater_3 = qt{tin = 'Methanol_heater_3_Tin', hin = 'Methanol_heater_3_Hin', tout = 'Methanol_heater_3_Tout', hout = 'Methanol_heater_3_Hout', dtmin = 'Methanol_heater_3_dTmin', alpha = 'Methanol_heater_3_alpha'},
  heater_4 = qt{tin = 'Methanol_heater_4_Tin', hin = 'Methanol_heater_4_Hin', tout = 'Methanol_heater_4_Tout', hout = 'Methanol_heater_4_Hout', dtmin = 'Methanol_heater_4_dTmin', alpha = 'Methanol_heater_4_alpha'},
  heater_5 = qt{tin = 'Methanol_heater_5_Tin', hin = 'Methanol_heater_5_Hin', tout = 'Methanol_heater_5_Tout', hout = 'Methanol_heater_5_Hout', dtmin = 'Methanol_heater_5_dTmin', alpha = 'Methanol_heater_5_alpha'},
  cooler_1 = qt{tin = 'Methanol_cooler_1_Tin', hin = 'Methanol_cooler_1_Hin', tout = 'Methanol_cooler_1_Tout', hout = 'Methanol_cooler_1_Hout', dtmin = 'Methanol_cooler_1_dTmin', alpha = 'Methanol_cooler_1_alpha'},
  cooler_2 = qt{tin = 'Methanol_cooler_2_Tin', hin = 'Methanol_cooler_2_Hin', tout = 'Methanol_cooler_2_Tout', hout = 'Methanol_cooler_2_Hout', dtmin = 'Methanol_cooler_2_dTmin', alpha = 'Methanol_cooler_2_alpha'},
  MSC_cooler_1 = qt{tin = 'Methanol_MSC_cooler_1_Tin', hin = 'Methanol_MSC_cooler_1_Hin', tout = 'Methanol_MSC_cooler_1_Tout', hout = 'Methanol_MSC_cooler_1_Hout', dtmin = 'Methanol_MSC_cooler_1_dTmin', alpha = 'Methanol_MSC_cooler_1_alpha'},
  MSC_cooler_2 = qt{tin = 'Methanol_MSC_cooler_2_Tin', hin = 'Methanol_MSC_cooler_2_Hin', tout = 'Methanol_MSC_cooler_2_Tout', hout = 'Methanol_MSC_cooler_2_Hout', dtmin = 'Methanol_MSC_cooler_2_dTmin', alpha = 'Methanol_MSC_cooler_2_alpha'},
  HX_1 = qt{tin = 'Methanol_HX_1_Tin', hin = 'Methanol_HX_1_Hin', tout = 'Methanol_HX_1_Tout', hout = 'Methanol_HX_1_Hout', dtmin = 'Methanol_HX_1_dTmin', alpha = 'Methanol_HX_1_alpha'},
  HX_2 = qt{tin = 'Methanol_HX_2_Tin', hin = 'Methanol_HX_2_Hin', tout = 'Methanol_HX_2_Tout', hout = 'Methanol_HX_2_Hout', dtmin = 'Methanol_HX_2_dTmin', alpha = 'Methanol_HX_2_alpha'},
  HX_3 = qt{tin = 'Methanol_HX_3_Tin', hin = 'Methanol_HX_3_Hin', tout = 'Methanol_HX_3_Tout', hout = 'Methanol_HX_3_Hout', dtmin = 'Methanol_HX_3_dTmin', alpha = 'Methanol_HX_3_alpha'},
  R_1 = qt{tin = 'Methanol_R_1_Tin', hin = 'Methanol_R_1_Hin', tout = 'Methanol_R_1_Tout', hout = 'Methanol_R_1_Hout', dtmin = 'Methanol_R_1_dTmin', alpha = 'Methanol_R_1_alpha'},
  reb = qt{tin = 'Methanol_reb_Tin', hin = 'Methanol_reb_Hin', tout = 'Methanol_reb_Tout', hout = 'Methanol_reb_Hout', dtmin = 'Methanol_reb_dTmin', alpha = 'Methanol_reb_alpha'},
  cond = qt{tin = 'Methanol_cond_Tin', hin = 'Methanol_cond_Hin', tout = 'Methanol_cond_Tout', hout = 'Methanol_cond_Hout', dtmin = 'Methanol_cond_dTmin', alpha = 'Methanol_cond_alpha'},
})


et.inputs = {
Methanol_cost1 = {default = 0 },
Methanol_cost2 = {default = 0 },
Methanol_cinv1 = {default = 0 },
Methanol_cinv2 = {default = 0 },
Methanol_imp1 = {default = 0 },
Methanol_imp2 = {default = 0 },
Methanol_fmin = {default = 1 },
Methanol_fmax = {default = 1 },
Methanol_ELEC_Flow = {default = 32025.86471 },
Methanol_heater_1_Tin = {default = 25.0 },
Methanol_heater_1_Tout = {default = 700.0 },
Methanol_heater_1_Hin = {default = 0 },
Methanol_heater_1_Hout = {default = 9662.79484 },
Methanol_heater_1_dTmin = {default = 2.5 },
Methanol_heater_1_alpha = {default = 1 },
Methanol_heater_3_Tin = {default = 25.0 },
Methanol_heater_3_Tout = {default = 33.7975644 },
Methanol_heater_3_Hin = {default = 0 },
Methanol_heater_3_Hout = {default = 114.016569 },
Methanol_heater_3_dTmin = {default = 2.5 },
Methanol_heater_3_alpha = {default = 1 },
Methanol_heater_4_Tin = {default = 33.7975644 },
Methanol_heater_4_Tout = {default = 94.9629521 },
Methanol_heater_4_Hin = {default = 0 },
Methanol_heater_4_Hout = {default = 5166.04347 },
Methanol_heater_4_dTmin = {default = 2.5 },
Methanol_heater_4_alpha = {default = 1 },
Methanol_heater_5_Tin = {default = 94.9629521 },
Methanol_heater_5_Tout = {default = 700.0 },
Methanol_heater_5_Hin = {default = 0 },
Methanol_heater_5_Hout = {default = 3332.57776 },
Methanol_heater_5_dTmin = {default = 2.5 },
Methanol_heater_5_alpha = {default = 1 },
Methanol_cooler_1_Tin = {default = 700.021398 },
Methanol_cooler_1_Tout = {default = 25.0 },
Methanol_cooler_1_Hin = {default = 0 },
Methanol_cooler_1_Hout = {default = -10945.0531 },
Methanol_cooler_1_dTmin = {default = 2.5 },
Methanol_cooler_1_alpha = {default = 1 },
Methanol_cooler_2_Tin = {default = 700.021398 },
Methanol_cooler_2_Tout = {default = 25.0 },
Methanol_cooler_2_Hin = {default = 0 },
Methanol_cooler_2_Hout = {default = -3445.01521 },
Methanol_cooler_2_dTmin = {default = 2.5 },
Methanol_cooler_2_alpha = {default = 1 },
Methanol_MSC_cooler_1_Tin = {default = 207.329046 },
Methanol_MSC_cooler_1_Tout = {default = 25.0 },
Methanol_MSC_cooler_1_Hin = {default = 0 },
Methanol_MSC_cooler_1_Hout = {default = -672.664443 },
Methanol_MSC_cooler_1_dTmin = {default = 2.5 },
Methanol_MSC_cooler_1_alpha = {default = 1 },
Methanol_MSC_cooler_2_Tin = {default = 207.401247 },
Methanol_MSC_cooler_2_Tout = {default = 25.0 },
Methanol_MSC_cooler_2_Hin = {default = 0 },
Methanol_MSC_cooler_2_Hout = {default = -675.120921 },
Methanol_MSC_cooler_2_dTmin = {default = 2.5 },
Methanol_MSC_cooler_2_alpha = {default = 1 },
Methanol_HX_1_Tin = {default = 207.656056 },
Methanol_HX_1_Tout = {default = 250.0 },
Methanol_HX_1_Hin = {default = 0 },
Methanol_HX_1_Hout = {default = 159.335927 },
Methanol_HX_1_dTmin = {default = 2.5 },
Methanol_HX_1_alpha = {default = 1 },
Methanol_HX_2_Tin = {default = 250.011953 },
Methanol_HX_2_Tout = {default = 50.0 },
Methanol_HX_2_Hin = {default = 0 },
Methanol_HX_2_Hout = {default = -3802.07109 },
Methanol_HX_2_dTmin = {default = 2.5 },
Methanol_HX_2_alpha = {default = 1 },
Methanol_HX_3_Tin = {default = 52.5239904 },
Methanol_HX_3_Tout = {default = 250.0 },
Methanol_HX_3_Hin = {default = 0 },
Methanol_HX_3_Hout = {default = 2233.05923 },
Methanol_HX_3_dTmin = {default = 2.5 },
Methanol_HX_3_alpha = {default = 1 },
Methanol_R_1_Tin = {default = 250.011953 },
Methanol_R_1_Tout = {default = 250.011953 },
Methanol_R_1_Hin = {default = 0 },
Methanol_R_1_Hout = {default = -2523.17368 },
Methanol_R_1_dTmin = {default = 2.5 },
Methanol_R_1_alpha = {default = 1 },
Methanol_reb_Tin = {default = 77.3036885 },
Methanol_reb_Tout = {default = 91.2973447 },
Methanol_reb_Hin = {default = 0 },
Methanol_reb_Hout = {default = 1879.57604 },
Methanol_reb_dTmin = {default = 2.5 },
Methanol_reb_alpha = {default = 1 },
Methanol_cond_Tin = {default = 63.9245458 },
Methanol_cond_Tout = {default = 58.7832494 },
Methanol_cond_Hin = {default = 0 },
Methanol_cond_Hout = {default = -1802.74722 },
Methanol_cond_dTmin = {default = 2.5 },
Methanol_cond_alpha = {default = 1 },
}
et.outputs = {
}

return et
