knitr::opts_chunk$set(echo = F)
if (!requireNamespace("devtools"))
  install.packages('devtools')
if (!require("ipesedisplay"))
  devtools::install_git("https://gitlab:x9hrpufByd9LA8-SnLCi@gitlab.epfl.ch/ipese/r/ipese-packages/ipesedisplay.git")
if (!require("reticulate"))
  install.packages("reticulate")
if (!require("DiagrammeRsvg"))
  install.packages('DiagrammeRsvg')
if(!require('dplyr'))
  install.packages("dplyr", dependencies = T)
if(!require('plotly'))
  install.packages("plotly", dependencies = T)
if(!require('knitr'))
  install.packages("knitr", dependencies = T)
if(!require('ggplot2'))
  install.packages("ggplot2", dependencies = T)
if(!require('tidyr'))
  install.packages("tidyr", dependencies = T)
if(!require('tibble'))
  install.packages("tibble", dependencies = T)

library(ipesedisplay)
library(reticulate)
library(DiagrammeR)
library(DiagrammeRsvg)
library(jsonlite)
library(dplyr)
library(plotly)
library(knitr)
library(ggplot2)
library(tidyr)
library(tibble)
library(purrr)

venv <- NULL
if (length(rmarkdown::metadata$venv) > 0) {venv <- rmarkdown::metadata$venv} else {venv <- "./venv"}

virtualenv_create(venv)
virtualenv_install(venv, "..")
use_virtualenv(venv, required = T)

data <- NULL

knitr::opts_chunk$set(echo=T)
knitr::opts_chunk$set(error=F)
knitr::opts_chunk$set(message=F)
knitr::opts_chunk$set(warning=F)

def.chunk.hook  <- knitr::knit_hooks$get("chunk")
knitr::knit_hooks$set(chunk = function(x, options) {
  x <- def.chunk.hook(x, options)
  ifelse(options$size != "normalsize", paste0("\n \\", options$size,"\n\n", x, "\n\n \\normalsize"), x)
})

py_run_string("from pyxosmose.rosmose import *")

ro <- py$Rosmose()

options("scipen"=100, "digits"=4)
knitr::knit_engines$set(rosmose = function(options) {
  code <- paste(options$code, collapse = "\n")
  file_name <- knitr::current_input()
  result <- ro$retrieve_type(code, file_name)
  if(result[[1]] == T) {
    if(result[[2]] == 'custom_view'){
      result[[3]]
    } else if(result[[2]] == 'display_et'){
      options$engine <- "r"
      knitr::engine_output(options, out = list(display_graph(result[[3]], paste0("images/", result[[4]], ".svg"))))
    }
    else {
      code
    }
  } else {
    if(length(result) > 1) {
      if(result[[2]] == 'osmose_solve'){
        data <<- fromJSON(result[[3]], flatten=FALSE)
        ""
      }
    }
  }
})
