/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumtunneling.view;

import edu.colorado.phet.common.jfreechartphet.FastPathRenderer;
import edu.colorado.phet.common.phetcommon.math.Complex;
import edu.colorado.phet.quantumtunneling.QTConstants;
import edu.colorado.phet.quantumtunneling.QTResources;
import edu.colorado.phet.quantumtunneling.color.QTColorScheme;
import edu.colorado.phet.quantumtunneling.enums.IRView;
import edu.colorado.phet.quantumtunneling.model.AbstractPotential;
import edu.colorado.phet.quantumtunneling.model.AbstractWave;
import edu.colorado.phet.quantumtunneling.model.PlaneWave;
import edu.colorado.phet.quantumtunneling.model.WaveFunctionSolution;
import edu.colorado.phet.quantumtunneling.model.WavePacket;
import edu.colorado.phet.quantumtunneling.util.LightweightComplex;
import edu.colorado.phet.quantumtunneling.view.PhaseRenderer;
import edu.colorado.phet.quantumtunneling.view.PositionAxis;
import edu.colorado.phet.quantumtunneling.view.QTXYPlot;
import java.util.Observable;
import java.util.Observer;
import org.jfree.chart.axis.Axis;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.renderer.xy.AbstractXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class WaveFunctionPlot
extends QTXYPlot
implements Observer {
    private AbstractWave _wave;
    private double _dx;
    private XYSeries _incidentRealSeries;
    private XYSeries _incidentImaginarySeries;
    private XYSeries _incidentMagnitudeSeries;
    private XYSeries _reflectedRealSeries;
    private XYSeries _reflectedImaginarySeries;
    private XYSeries _reflectedMagnitudeSeries;
    private XYSeries _phaseSeries;
    private XYSeries _probabilityDensitySeries;
    private int _incidentRealIndex;
    private int _incidentImaginaryIndex;
    private int _incidentMagnitudeIndex;
    private int _reflectedRealIndex;
    private int _reflectedImaginaryIndex;
    private int _reflectedMagnitudeIndex;
    private int _phaseIndex;
    private IRView _irView;
    XYItemRenderer _incidentRealRenderer;

    public WaveFunctionPlot() {
        String string = QTResources.getString("axis.waveFunction");
        int n = 0;
        this._incidentRealIndex = n++;
        this._incidentRealSeries = new XYSeries((Comparable)((Object)"incident real"), false);
        Cloneable cloneable = new XYSeriesCollection();
        ((XYSeriesCollection)cloneable).addSeries(this._incidentRealSeries);
        this.setDataset(this._incidentRealIndex, (XYDataset)((Object)cloneable));
        AbstractXYItemRenderer abstractXYItemRenderer = new FastPathRenderer();
        this._incidentRealRenderer = abstractXYItemRenderer;
        abstractXYItemRenderer.setPaint(QTConstants.COLOR_SCHEME.getRealColor());
        abstractXYItemRenderer.setStroke(QTConstants.REAL_STROKE);
        this.setRenderer(this._incidentRealIndex, abstractXYItemRenderer);
        this._incidentImaginaryIndex = n++;
        this._incidentImaginarySeries = new XYSeries((Comparable)((Object)"incident imaginary"), false);
        cloneable = new XYSeriesCollection();
        ((XYSeriesCollection)cloneable).addSeries(this._incidentImaginarySeries);
        this.setDataset(this._incidentImaginaryIndex, (XYDataset)((Object)cloneable));
        abstractXYItemRenderer = new FastPathRenderer();
        abstractXYItemRenderer.setPaint(QTConstants.COLOR_SCHEME.getImaginaryColor());
        abstractXYItemRenderer.setStroke(QTConstants.IMAGINARY_STROKE);
        this.setRenderer(this._incidentImaginaryIndex, abstractXYItemRenderer);
        this._incidentMagnitudeIndex = n++;
        this._incidentMagnitudeSeries = new XYSeries((Comparable)((Object)"incident magnitude"), false);
        cloneable = new XYSeriesCollection();
        ((XYSeriesCollection)cloneable).addSeries(this._incidentMagnitudeSeries);
        this.setDataset(this._incidentMagnitudeIndex, (XYDataset)((Object)cloneable));
        abstractXYItemRenderer = new FastPathRenderer();
        abstractXYItemRenderer.setPaint(QTConstants.COLOR_SCHEME.getMagnitudeColor());
        abstractXYItemRenderer.setStroke(QTConstants.MAGNITUDE_STROKE);
        this.setRenderer(this._incidentMagnitudeIndex, abstractXYItemRenderer);
        this._reflectedRealIndex = n++;
        this._reflectedRealSeries = new XYSeries((Comparable)((Object)"reflected real"), false);
        cloneable = new XYSeriesCollection();
        ((XYSeriesCollection)cloneable).addSeries(this._reflectedRealSeries);
        this.setDataset(this._reflectedRealIndex, (XYDataset)((Object)cloneable));
        abstractXYItemRenderer = new FastPathRenderer();
        abstractXYItemRenderer.setPaint(QTConstants.COLOR_SCHEME.getRealColor());
        abstractXYItemRenderer.setStroke(QTConstants.REAL_STROKE);
        this.setRenderer(this._reflectedRealIndex, abstractXYItemRenderer);
        this._reflectedImaginaryIndex = n++;
        this._reflectedImaginarySeries = new XYSeries((Comparable)((Object)"reflected imaginary"), false);
        cloneable = new XYSeriesCollection();
        ((XYSeriesCollection)cloneable).addSeries(this._reflectedImaginarySeries);
        this.setDataset(this._reflectedImaginaryIndex, (XYDataset)((Object)cloneable));
        abstractXYItemRenderer = new FastPathRenderer();
        abstractXYItemRenderer.setPaint(QTConstants.COLOR_SCHEME.getImaginaryColor());
        abstractXYItemRenderer.setStroke(QTConstants.IMAGINARY_STROKE);
        this.setRenderer(this._reflectedImaginaryIndex, abstractXYItemRenderer);
        this._reflectedMagnitudeIndex = n++;
        this._reflectedMagnitudeSeries = new XYSeries((Comparable)((Object)"reflected magnitude"), false);
        cloneable = new XYSeriesCollection();
        ((XYSeriesCollection)cloneable).addSeries(this._reflectedMagnitudeSeries);
        this.setDataset(this._reflectedMagnitudeIndex, (XYDataset)((Object)cloneable));
        abstractXYItemRenderer = new FastPathRenderer();
        abstractXYItemRenderer.setPaint(QTConstants.COLOR_SCHEME.getMagnitudeColor());
        abstractXYItemRenderer.setStroke(QTConstants.MAGNITUDE_STROKE);
        this.setRenderer(this._reflectedMagnitudeIndex, abstractXYItemRenderer);
        this._phaseIndex = n++;
        this._phaseSeries = new XYSeries((Comparable)((Object)"phase"), false);
        cloneable = new XYSeriesCollection();
        ((XYSeriesCollection)cloneable).addSeries(this._phaseSeries);
        this.setDataset(this._phaseIndex, (XYDataset)((Object)cloneable));
        abstractXYItemRenderer = new PhaseRenderer();
        this.setRenderer(this._phaseIndex, abstractXYItemRenderer);
        this._probabilityDensitySeries = new XYSeries((Comparable)((Object)"probability density"), false);
        cloneable = new PositionAxis();
        this.setDomainAxis((ValueAxis)cloneable);
        this.setDomainGridlinesVisible(true);
        this.setDomainGridlinePaint(QTConstants.COLOR_SCHEME.getGridlineColor());
        cloneable = new NumberAxis(string);
        this.setRangeAxis((ValueAxis)cloneable);
        this.setRangeAxisLocation(AxisLocation.BOTTOM_OR_LEFT);
        this.setRangeGridlinesVisible(true);
        this.setRangeGridlinePaint(QTConstants.COLOR_SCHEME.getGridlineColor());
        ((Axis)cloneable).setLabelFont(QTConstants.AXIS_LABEL_FONT);
        ((ValueAxis)cloneable).setRange(QTConstants.DEFAULT_WAVE_FUNCTION_RANGE);
        ((Axis)cloneable).setTickLabelPaint(QTConstants.COLOR_SCHEME.getTickColor());
        ((Axis)cloneable).setTickMarkPaint(QTConstants.COLOR_SCHEME.getTickColor());
        this.setBackgroundPaint(QTConstants.COLOR_SCHEME.getChartColor());
        this._wave = null;
        this._irView = IRView.SUM;
        this._dx = 1.0;
    }

    public void setColorScheme(QTColorScheme qTColorScheme) {
        this.setBackgroundPaint(qTColorScheme.getChartColor());
        this.getDomainAxis().setTickLabelPaint(qTColorScheme.getTickColor());
        this.getDomainAxis().setTickMarkPaint(qTColorScheme.getTickColor());
        this.getRangeAxis().setTickLabelPaint(qTColorScheme.getTickColor());
        this.getRangeAxis().setTickMarkPaint(qTColorScheme.getTickColor());
        this.setDomainGridlinePaint(qTColorScheme.getGridlineColor());
        this.setRangeGridlinePaint(qTColorScheme.getGridlineColor());
        this.getRenderer(this._incidentRealIndex).setPaint(qTColorScheme.getRealColor());
        this.getRenderer(this._incidentImaginaryIndex).setPaint(qTColorScheme.getImaginaryColor());
        this.getRenderer(this._incidentMagnitudeIndex).setPaint(qTColorScheme.getMagnitudeColor());
        this.getRenderer(this._reflectedRealIndex).setPaint(qTColorScheme.getRealColor());
        this.getRenderer(this._reflectedImaginaryIndex).setPaint(qTColorScheme.getImaginaryColor());
        this.getRenderer(this._reflectedMagnitudeIndex).setPaint(qTColorScheme.getMagnitudeColor());
    }

    public void setDx(double d) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("dx must be > 0: " + d);
        }
        this._dx = d;
        this.updateDatasets();
    }

    public XYSeries getProbabilityDensitySeries() {
        return this._probabilityDensitySeries;
    }

    public void setWave(AbstractWave abstractWave) {
        if (this._wave != null) {
            this._wave.deleteObserver(this);
        }
        this._wave = abstractWave;
        this._wave.addObserver(this);
        this.updateDatasets();
    }

    public void setRealVisible(boolean bl) {
        this.getRenderer(this._incidentRealIndex).setSeriesVisible(new Boolean(bl));
        this.getRenderer(this._reflectedRealIndex).setSeriesVisible(new Boolean(bl));
    }

    public void setImaginaryVisible(boolean bl) {
        this.getRenderer(this._incidentImaginaryIndex).setSeriesVisible(new Boolean(bl));
        this.getRenderer(this._reflectedImaginaryIndex).setSeriesVisible(new Boolean(bl));
    }

    public void setMagnitudeVisible(boolean bl) {
        this.getRenderer(this._incidentMagnitudeIndex).setSeriesVisible(new Boolean(bl));
        this.getRenderer(this._reflectedMagnitudeIndex).setSeriesVisible(new Boolean(bl));
    }

    public void setPhaseVisible(boolean bl) {
        this.getRenderer(this._phaseIndex).setSeriesVisible(new Boolean(bl));
    }

    public void setIRView(IRView iRView) {
        this._irView = iRView;
        this.updateDatasets();
    }

    public void update(Observable observable, Object object) {
        if (this._wave != null && observable == this._wave) {
            this.updateDatasets();
        }
    }

    private void updateDatasets() {
        if (this._wave != null && this._wave.isInitialized()) {
            this.setSeriesNotify(false);
            if (this._wave instanceof PlaneWave) {
                this.updateDataSet((PlaneWave)this._wave);
            } else if (this._wave instanceof WavePacket) {
                this.updateDataSet((WavePacket)this._wave);
            }
            this.setSeriesNotify(true);
        }
    }

    private void updateDataSet(PlaneWave planeWave) {
        this.clearAllSeries();
        AbstractPotential abstractPotential = planeWave.getPotentialEnergy();
        int n = abstractPotential.getNumberOfRegions();
        double d = abstractPotential.getStart(0);
        double d2 = abstractPotential.getEnd(n - 1) + this._dx;
        for (double d3 = d; d3 < d2; d3 += this._dx) {
            Complex complex;
            WaveFunctionSolution waveFunctionSolution = planeWave.solveWaveFunction(d3);
            if (waveFunctionSolution == null) continue;
            if (this._irView == IRView.SEPARATE) {
                Complex complex2;
                Complex complex3;
                complex = waveFunctionSolution.getIncidentPart();
                if (complex != null) {
                    this._incidentRealSeries.add(d3, complex.getReal());
                    this._incidentImaginarySeries.add(d3, complex.getImaginary());
                    this._incidentMagnitudeSeries.add(d3, complex.getAbs());
                }
                if ((complex3 = waveFunctionSolution.getReflectedPart()) != null) {
                    this._reflectedRealSeries.add(d3, complex3.getReal());
                    this._reflectedImaginarySeries.add(d3, complex3.getImaginary());
                    this._reflectedMagnitudeSeries.add(d3, complex3.getAbs());
                }
                if ((complex2 = waveFunctionSolution.getSum()) == null) continue;
                this._probabilityDensitySeries.add(d3, complex2.getAbs() * complex2.getAbs());
                continue;
            }
            complex = waveFunctionSolution.getSum();
            if (complex == null) continue;
            this._incidentRealSeries.add(d3, complex.getReal());
            this._incidentImaginarySeries.add(d3, complex.getImaginary());
            this._incidentMagnitudeSeries.add(d3, complex.getAbs());
            this._phaseSeries.add(d3, complex.getAbs());
            this._phaseSeries.add(d3, complex.getPhase());
            this._probabilityDensitySeries.add(d3, complex.getAbs() * complex.getAbs());
        }
    }

    private void updateDataSet(WavePacket wavePacket) {
        this.clearAllSeries();
        double[] dArray = wavePacket.getPositionValues();
        LightweightComplex[] lightweightComplexArray = wavePacket.getWaveFunctionValues();
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            double d = dArray[i];
            if (!QTConstants.POSITION_RANGE.contains(d)) continue;
            LightweightComplex lightweightComplex = lightweightComplexArray[i];
            this._incidentRealSeries.add(d, lightweightComplex.getReal());
            this._incidentImaginarySeries.add(d, lightweightComplex.getImaginary());
            this._incidentMagnitudeSeries.add(d, lightweightComplex.getAbs());
            this._phaseSeries.add(d, lightweightComplex.getAbs());
            this._phaseSeries.add(d, lightweightComplex.getPhase());
            this._probabilityDensitySeries.add(d, lightweightComplex.getAbs() * lightweightComplex.getAbs());
        }
    }

    private void clearAllSeries() {
        this._incidentRealSeries.clear();
        this._incidentImaginarySeries.clear();
        this._incidentMagnitudeSeries.clear();
        this._reflectedRealSeries.clear();
        this._reflectedImaginarySeries.clear();
        this._reflectedMagnitudeSeries.clear();
        this._phaseSeries.clear();
        this._probabilityDensitySeries.clear();
    }

    private void setSeriesNotify(boolean bl) {
        this._incidentRealSeries.setNotify(bl);
        this._incidentImaginarySeries.setNotify(bl);
        this._incidentMagnitudeSeries.setNotify(bl);
        this._reflectedRealSeries.setNotify(bl);
        this._reflectedImaginarySeries.setNotify(bl);
        this._reflectedMagnitudeSeries.setNotify(bl);
        this._phaseSeries.setNotify(bl);
        this._probabilityDensitySeries.setNotify(bl);
    }
}

