/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumtunneling.view;

import edu.colorado.phet.quantumtunneling.QTConstants;
import edu.colorado.phet.quantumtunneling.model.AbstractPotential;
import edu.colorado.phet.quantumtunneling.model.EigenstateSolver;
import edu.colorado.phet.quantumtunneling.model.WavePacket;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.util.ArrayList;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CrosshairState;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.AbstractXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRendererState;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.RectangleEdge;

public class TotalEnergyRenderer
extends AbstractXYItemRenderer {
    private static final Color MASK_COLOR = new Color(255, 0, 0, 255);
    private WavePacket _wavePacket;
    private AbstractPotential _potentialEnergy;
    private Color _centerColor;
    private Color _edgeColor;
    private GeneralPath _path = new GeneralPath();
    private AffineTransform _xform = new AffineTransform();
    private Rectangle2D _rectangle = new Rectangle2D.Double();

    public TotalEnergyRenderer() {
        this.setColor(QTConstants.COLOR_SCHEME.getTotalEnergyColor());
    }

    public void setColor(Color color) {
        this._centerColor = color;
        this._edgeColor = new Color(this._centerColor.getRed(), this._centerColor.getGreen(), this._centerColor.getBlue(), 5);
    }

    public void setWavePacket(WavePacket wavePacket) {
        this._wavePacket = wavePacket;
    }

    public void setPotentialEnergy(AbstractPotential abstractPotential) {
        this._potentialEnergy = abstractPotential;
    }

    public void drawItem(Graphics2D graphics2D, XYItemRendererState xYItemRendererState, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n, int n2, CrosshairState crosshairState, int n3) {
        if (n2 != 0) {
            return;
        }
        if (this._wavePacket == null || this._potentialEnergy == null) {
            return;
        }
        if (!this.getItemVisible(n, n2)) {
            return;
        }
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        double d = this._wavePacket.getCenter();
        double d2 = xYDataset.getYValue(n, n2);
        double d3 = this._potentialEnergy.getEnergyAt(d);
        if (d2 <= d3) {
            this.drawDashedLine(graphics2D, xYItemRendererState, rectangle2D, plotRenderingInfo, xYPlot, valueAxis, valueAxis2, xYDataset, n, n2);
        } else if (this._potentialEnergy.isInWell(d)) {
            this.drawBandAndEigenstates(graphics2D, xYItemRendererState, rectangle2D, plotRenderingInfo, xYPlot, valueAxis, valueAxis2, xYDataset, n, n2);
        } else {
            this.drawBand(graphics2D, xYItemRendererState, rectangle2D, plotRenderingInfo, xYPlot, valueAxis, valueAxis2, xYDataset, n, n2);
        }
    }

    private void drawDashedLine(Graphics2D graphics2D, XYItemRendererState xYItemRendererState, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n, int n2) {
        double d = valueAxis.getLowerBound();
        double d2 = valueAxis.getUpperBound();
        double d3 = xYDataset.getYValue(n, n2);
        RectangleEdge rectangleEdge = xYPlot.getDomainAxisEdge();
        RectangleEdge rectangleEdge2 = xYPlot.getRangeAxisEdge();
        double d4 = valueAxis.valueToJava2D(d, rectangle2D, rectangleEdge);
        double d5 = valueAxis.valueToJava2D(d2, rectangle2D, rectangleEdge);
        double d6 = valueAxis2.valueToJava2D(d3, rectangle2D, rectangleEdge2);
        graphics2D.setPaint(this.getSeriesPaint(n));
        graphics2D.setStroke(QTConstants.TOTAL_ENERGY_DASHED_STROKE);
        this._path.reset();
        this._path.moveTo((float)d4, (float)d6);
        this._path.lineTo((float)d5, (float)d6);
        graphics2D.draw(this._path);
    }

    private void drawBandAndEigenstates(Graphics2D graphics2D, XYItemRendererState xYItemRendererState, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n, int n2) {
        EigenstateSolver.PotentialEvaluator potentialEvaluator = new EigenstateSolver.PotentialEvaluator(){

            public double evaluate(double d) {
                return TotalEnergyRenderer.this._potentialEnergy.getEnergyAt(d);
            }
        };
        double d = this._wavePacket.getCenter();
        double d2 = valueAxis.getLowerBound();
        double d3 = valueAxis.getUpperBound();
        double d4 = xYDataset.getYValue(n, n2);
        double d5 = valueAxis2.getLowerBound();
        double d6 = this._potentialEnergy.getTopOfWellAt(d);
        RectangleEdge rectangleEdge = xYPlot.getDomainAxisEdge();
        RectangleEdge rectangleEdge2 = xYPlot.getRangeAxisEdge();
        double d7 = valueAxis.valueToJava2D(d2, rectangle2D, rectangleEdge);
        double d8 = valueAxis.valueToJava2D(d3, rectangle2D, rectangleEdge);
        double d9 = valueAxis2.valueToJava2D(d5, rectangle2D, rectangleEdge2);
        double d10 = valueAxis2.valueToJava2D(d4, rectangle2D, rectangleEdge2);
        double d11 = valueAxis2.valueToJava2D(d6, rectangle2D, rectangleEdge2);
        EigenstateSolver eigenstateSolver = new EigenstateSolver(0.038099826839242096, d2, d3, 1000, potentialEvaluator);
        ArrayList<Double> arrayList = new ArrayList<Double>();
        int n3 = 0;
        boolean bl = false;
        while (!bl) {
            try {
                double d12 = eigenstateSolver.getEnergy(n3);
                if (d12 > d6) {
                    bl = true;
                } else {
                    arrayList.add(new Double(d12));
                }
            }
            catch (EigenstateSolver.EigenstateException eigenstateException) {
                bl = true;
                System.err.println(eigenstateException.getMessage());
            }
            ++n3;
        }
        int n4 = (int)d8 + 1;
        int n5 = (int)d9 + 1;
        BufferedImage bufferedImage = new BufferedImage(n4, n5, 2);
        Object object = bufferedImage.createGraphics();
        this.drawBand((Graphics2D)object, xYItemRendererState, rectangle2D, plotRenderingInfo, xYPlot, valueAxis, valueAxis2, xYDataset, n, n2);
        object = new BufferedImage(n4, n5, 2);
        Object object2 = ((BufferedImage)object).createGraphics();
        ((Graphics2D)object2).setComposite(AlphaComposite.Src);
        ((Graphics2D)object2).setPaint(MASK_COLOR);
        this._rectangle.setRect(0.0, 0.0, n4, d11);
        ((Graphics2D)object2).fill(this._rectangle);
        ((Graphics2D)object2).setPaint(this.getSeriesPaint(n));
        ((Graphics2D)object2).setStroke(QTConstants.EIGENSTATE_STROKE);
        for (Double d13 : arrayList) {
            double d14 = valueAxis2.valueToJava2D(d13, rectangle2D, rectangleEdge2);
            this._path.reset();
            this._path.moveTo((float)d7, (float)d14);
            this._path.lineTo((float)d8, (float)d14);
            ((Graphics2D)object2).draw(this._path);
        }
        object2 = new BufferedImage(n4, n5, 2);
        Object object3 = ((BufferedImage)object2).createGraphics();
        ((Graphics2D)object3).setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        this._xform.setToIdentity();
        ((Graphics2D)object3).drawRenderedImage(bufferedImage, this._xform);
        ((Graphics2D)object3).setComposite(AlphaComposite.DstIn);
        ((Graphics2D)object3).drawRenderedImage((RenderedImage)object, this._xform);
        this._xform.setToIdentity();
        graphics2D.drawRenderedImage((RenderedImage)object2, this._xform);
        if (d4 < d6) {
            this.drawDashedLine(graphics2D, xYItemRendererState, rectangle2D, plotRenderingInfo, xYPlot, valueAxis, valueAxis2, xYDataset, n, n2);
        } else {
            object3 = TotalEnergyRenderer.darkenColor(this.getSeriesPaint(n));
            graphics2D.setPaint((Paint)object3);
            graphics2D.setStroke(QTConstants.AVERAGE_TOTAL_ENERGY_STROKE);
            this._path.reset();
            this._path.moveTo((float)d7, (float)d10);
            this._path.lineTo((float)d8, (float)d10);
            graphics2D.draw(this._path);
        }
    }

    private void drawBand(Graphics2D graphics2D, XYItemRendererState xYItemRendererState, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n, int n2) {
        double d = this._wavePacket.getCenter();
        double d2 = this._wavePacket.getWidth();
        double d3 = valueAxis.getLowerBound();
        double d4 = valueAxis.getUpperBound();
        double d5 = xYDataset.getYValue(n, n2);
        double d6 = this._potentialEnergy.getEnergyAt(d);
        double d7 = Math.sqrt(11.37126 * (d5 - d6) / 0.433243036944);
        double d8 = 1.316424 / d2 * Math.sqrt(2.0 * (d5 - d6) / 5.68563);
        double d9 = 0.866486073888 / (5.68563 * d2 * d2);
        double d10 = d5 + d8 + d9;
        double d11 = d5 - d8 + d9;
        if (d7 * d2 <= 2.0) {
            d11 = d6;
        }
        RectangleEdge rectangleEdge = xYPlot.getDomainAxisEdge();
        RectangleEdge rectangleEdge2 = xYPlot.getRangeAxisEdge();
        double d12 = valueAxis.valueToJava2D(d3, rectangle2D, rectangleEdge);
        double d13 = valueAxis.valueToJava2D(d4, rectangle2D, rectangleEdge);
        double d14 = valueAxis2.valueToJava2D(d10, rectangle2D, rectangleEdge2);
        double d15 = valueAxis2.valueToJava2D(d11, rectangle2D, rectangleEdge2);
        double d16 = valueAxis2.valueToJava2D(d5, rectangle2D, rectangleEdge2);
        double d17 = Math.max(d13 - d12, 1.0);
        double d18 = Math.max(d16 - d14, 1.0);
        double d19 = Math.max(d15 - d16, 1.0);
        Object object = new Rectangle2D.Double(d12, d14, d17, d18 + 1.0);
        Rectangle2D.Double double_ = new Rectangle2D.Double(d12, d16, d17, d19);
        GradientPaint gradientPaint = new GradientPaint((float)d12, (float)d14, this._edgeColor, (float)d12, (float)(d14 + d18), this._centerColor);
        GradientPaint gradientPaint2 = new GradientPaint((float)d12, (float)d16, this._centerColor, (float)d12, (float)(d16 + d19), this._edgeColor);
        graphics2D.setPaint(gradientPaint);
        graphics2D.fill((Shape)object);
        graphics2D.setPaint(gradientPaint2);
        graphics2D.fill(double_);
        object = TotalEnergyRenderer.darkenColor(this.getSeriesPaint(n));
        graphics2D.setPaint((Paint)object);
        graphics2D.setStroke(QTConstants.AVERAGE_TOTAL_ENERGY_STROKE);
        this._path.reset();
        this._path.moveTo((float)d12, (float)d16);
        this._path.lineTo((float)d13, (float)d16);
        graphics2D.draw(this._path);
    }

    private static Paint darkenColor(Paint paint) {
        Paint paint2 = paint;
        if (paint instanceof Color) {
            Color color = (Color)paint;
            int n = color.getRed();
            int n2 = color.getGreen();
            int n3 = color.getBlue();
            int n4 = color.getAlpha();
            n = Math.max(0, n - 50);
            n2 = Math.max(0, n2 - 50);
            n3 = Math.max(0, n3 - 50);
            paint2 = new Color(n, n2, n3, n4);
        }
        return paint2;
    }
}

