/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumtunneling.view;

import edu.colorado.phet.quantumtunneling.QTConstants;
import edu.colorado.phet.quantumtunneling.model.AbstractPotential;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.chart.plot.XYPlot;

public class QTRegionMarkerManager
implements Observer {
    private ArrayList _plots = new ArrayList();
    private AbstractPotential _potentialEnergy = null;
    private Color _markerColor = QTConstants.COLOR_SCHEME.getRegionMarkerColor();

    public void setMarkerColor(Color color) {
        this._markerColor = color;
        this.updateRegionMarkers();
    }

    public void setPotentialEnergy(AbstractPotential abstractPotential) {
        if (this._potentialEnergy != null) {
            this._potentialEnergy.deleteObserver(this);
        }
        this._potentialEnergy = abstractPotential;
        this._potentialEnergy.addObserver(this);
        this.updateRegionMarkers();
    }

    public void addPlot(XYPlot xYPlot) {
        this._plots.add(xYPlot);
        this.updateRegionMarkers();
    }

    public void update(Observable observable, Object object) {
        if (observable == this._potentialEnergy) {
            this.updateRegionMarkers();
        }
    }

    private void updateRegionMarkers() {
        this.clearRegionMarkers();
        if (this._potentialEnergy != null) {
            int n = this._potentialEnergy.getNumberOfRegions();
            for (int i = 1; i < n; ++i) {
                double d = this._potentialEnergy.getStart(i);
                this.addRegionMarker(d);
            }
        }
    }

    private void addRegionMarker(double d) {
        ValueMarker valueMarker = new ValueMarker(d);
        valueMarker.setPaint(this._markerColor);
        valueMarker.setStroke(QTConstants.REGION_MARKER_STROKE);
        for (XYPlot xYPlot : this._plots) {
            xYPlot.addDomainMarker(valueMarker);
        }
    }

    private void clearRegionMarkers() {
        for (XYPlot xYPlot : this._plots) {
            xYPlot.clearDomainMarkers();
        }
    }
}

