/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumtunneling.view;

import edu.colorado.phet.common.jfreechartphet.FastPathRenderer;
import edu.colorado.phet.quantumtunneling.QTConstants;
import edu.colorado.phet.quantumtunneling.QTResources;
import edu.colorado.phet.quantumtunneling.color.QTColorScheme;
import edu.colorado.phet.quantumtunneling.view.PositionAxis;
import edu.colorado.phet.quantumtunneling.view.QTXYPlot;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class ProbabilityDensityPlot
extends QTXYPlot {
    public ProbabilityDensityPlot(XYSeries xYSeries) {
        String string = QTResources.getString("axis.probabilityDensity");
        XYSeriesCollection xYSeriesCollection = new XYSeriesCollection();
        xYSeriesCollection.addSeries(xYSeries);
        FastPathRenderer fastPathRenderer = new FastPathRenderer();
        fastPathRenderer.setSeriesPaint(0, QTConstants.COLOR_SCHEME.getProbabilityDensityColor());
        fastPathRenderer.setSeriesStroke(0, QTConstants.PROBABILITY_DENSITY_STROKE);
        PositionAxis positionAxis = new PositionAxis();
        NumberAxis numberAxis = new NumberAxis(string);
        numberAxis.setLabelFont(QTConstants.AXIS_LABEL_FONT);
        numberAxis.setRange(QTConstants.DEFAULT_PROBABILITY_DENSITY_RANGE);
        numberAxis.setTickLabelPaint(QTConstants.COLOR_SCHEME.getTickColor());
        numberAxis.setTickMarkPaint(QTConstants.COLOR_SCHEME.getTickColor());
        this.setRangeAxisLocation(AxisLocation.BOTTOM_OR_LEFT);
        this.setBackgroundPaint(QTConstants.COLOR_SCHEME.getChartColor());
        this.setDomainGridlinesVisible(true);
        this.setRangeGridlinesVisible(true);
        this.setDomainGridlinePaint(QTConstants.COLOR_SCHEME.getGridlineColor());
        this.setRangeGridlinePaint(QTConstants.COLOR_SCHEME.getGridlineColor());
        this.setDataset(xYSeriesCollection);
        this.setRenderer(fastPathRenderer);
        this.setDomainAxis(positionAxis);
        this.setRangeAxis(numberAxis);
    }

    public void setColorScheme(QTColorScheme qTColorScheme) {
        this.setBackgroundPaint(qTColorScheme.getChartColor());
        this.getDomainAxis().setTickLabelPaint(qTColorScheme.getTickColor());
        this.getDomainAxis().setTickMarkPaint(qTColorScheme.getTickColor());
        this.getRangeAxis().setTickLabelPaint(qTColorScheme.getTickColor());
        this.getRangeAxis().setTickMarkPaint(qTColorScheme.getTickColor());
        this.setDomainGridlinePaint(qTColorScheme.getGridlineColor());
        this.setRangeGridlinePaint(qTColorScheme.getGridlineColor());
        this.getRenderer().setSeriesPaint(0, qTColorScheme.getProbabilityDensityColor());
    }
}

