/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumtunneling.view;

import edu.colorado.phet.common.jfreechartphet.FastPathRenderer;
import edu.colorado.phet.quantumtunneling.QTConstants;
import edu.colorado.phet.quantumtunneling.QTResources;
import edu.colorado.phet.quantumtunneling.color.QTColorScheme;
import edu.colorado.phet.quantumtunneling.enums.Direction;
import edu.colorado.phet.quantumtunneling.model.AbstractPotential;
import edu.colorado.phet.quantumtunneling.model.PlaneWave;
import edu.colorado.phet.quantumtunneling.model.TotalEnergy;
import edu.colorado.phet.quantumtunneling.model.WavePacket;
import edu.colorado.phet.quantumtunneling.view.PositionAxis;
import edu.colorado.phet.quantumtunneling.view.QTXYPlot;
import edu.colorado.phet.quantumtunneling.view.TotalEnergyRenderer;
import java.util.Observable;
import java.util.Observer;
import org.jfree.chart.axis.Axis;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.Range;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class EnergyPlot
extends QTXYPlot
implements Observer {
    private AbstractPotential _potentialEnergy;
    private TotalEnergy _totalEnergy;
    private WavePacket _wavePacket;
    private PlaneWave _planeWave;
    private double _previousWavePacketWidth = Double.NaN;
    private double _previousWavePacketCenter = Double.NaN;
    private Direction _previousPlaneWaveDirection = null;
    private XYSeries _totalEnergySeries;
    private XYSeries _potentialEnergySeries;
    private XYItemRenderer _planeWaveRenderer;
    private TotalEnergyRenderer _wavePacketRenderer;
    private int _totalEnergyIndex;
    private int _potentialEnergyIndex;

    public EnergyPlot() {
        String string = QTResources.getString("axis.energy") + " (" + QTResources.getString("units.energy") + ")";
        String string2 = QTResources.getString("legend.potentialEnergy");
        String string3 = QTResources.getString("legend.totalEnergy");
        int n = 0;
        this._potentialEnergySeries = new XYSeries((Comparable)((Object)string2), false);
        this._potentialEnergyIndex = n++;
        Cloneable cloneable = new XYSeriesCollection();
        cloneable.addSeries(this._potentialEnergySeries);
        this.setDataset(this._potentialEnergyIndex, (XYDataset)((Object)cloneable));
        Cloneable cloneable2 = new FastPathRenderer();
        cloneable2.setPaint(QTConstants.COLOR_SCHEME.getPotentialEnergyColor());
        cloneable2.setStroke(QTConstants.POTENTIAL_ENERGY_STROKE);
        this.setRenderer(this._potentialEnergyIndex, (XYItemRenderer)((Object)cloneable2));
        this._totalEnergySeries = new XYSeries((Comparable)((Object)string3), false);
        this._totalEnergyIndex = n++;
        cloneable = new XYSeriesCollection();
        cloneable.addSeries(this._totalEnergySeries);
        this.setDataset(this._totalEnergyIndex, (XYDataset)((Object)cloneable));
        this._planeWaveRenderer = new FastPathRenderer();
        this._planeWaveRenderer.setPaint(QTConstants.COLOR_SCHEME.getTotalEnergyColor());
        this._planeWaveRenderer.setStroke(QTConstants.TOTAL_ENERGY_SOLID_STROKE);
        this._wavePacketRenderer = new TotalEnergyRenderer();
        this._wavePacketRenderer.setPaint(QTConstants.COLOR_SCHEME.getTotalEnergyColor());
        this._wavePacketRenderer.setStroke(QTConstants.TOTAL_ENERGY_DASHED_STROKE);
        this.setRenderer(this._totalEnergyIndex, this._wavePacketRenderer);
        cloneable = new PositionAxis();
        cloneable2 = new NumberAxis(string);
        ((Axis)cloneable2).setLabelFont(QTConstants.AXIS_LABEL_FONT);
        ((ValueAxis)cloneable2).setRange(QTConstants.ENERGY_RANGE.getLowerBound() * 1.05, QTConstants.ENERGY_RANGE.getUpperBound() * 1.05);
        ((Axis)cloneable2).setTickLabelPaint(QTConstants.COLOR_SCHEME.getTickColor());
        ((Axis)cloneable2).setTickMarkPaint(QTConstants.COLOR_SCHEME.getTickColor());
        this.setRangeAxisLocation(AxisLocation.BOTTOM_OR_LEFT);
        this.setBackgroundPaint(QTConstants.COLOR_SCHEME.getChartColor());
        this.setDomainGridlinesVisible(true);
        this.setRangeGridlinesVisible(true);
        this.setDomainGridlinePaint(QTConstants.COLOR_SCHEME.getGridlineColor());
        this.setRangeGridlinePaint(QTConstants.COLOR_SCHEME.getGridlineColor());
        this.setDomainAxis((ValueAxis)cloneable);
        this.setRangeAxis((ValueAxis)cloneable2);
    }

    public void setColorScheme(QTColorScheme qTColorScheme) {
        this.setBackgroundPaint(qTColorScheme.getChartColor());
        this.getDomainAxis().setTickLabelPaint(qTColorScheme.getTickColor());
        this.getDomainAxis().setTickMarkPaint(qTColorScheme.getTickColor());
        this.getRangeAxis().setTickLabelPaint(qTColorScheme.getTickColor());
        this.getRangeAxis().setTickMarkPaint(qTColorScheme.getTickColor());
        this.setDomainGridlinePaint(qTColorScheme.getGridlineColor());
        this.setRangeGridlinePaint(qTColorScheme.getGridlineColor());
        this.getRenderer(this._potentialEnergyIndex).setPaint(qTColorScheme.getPotentialEnergyColor());
        this.getRenderer(this._totalEnergyIndex).setPaint(qTColorScheme.getTotalEnergyColor());
        this._planeWaveRenderer.setPaint(qTColorScheme.getTotalEnergyColor());
        this._wavePacketRenderer.setColor(qTColorScheme.getTotalEnergyColor());
    }

    public void setTotalEnergy(TotalEnergy totalEnergy) {
        if (this._totalEnergy != null) {
            this._totalEnergy.deleteObserver(this);
        }
        this._totalEnergy = totalEnergy;
        this._totalEnergy.addObserver(this);
        this.updateTotalEnergy();
    }

    public void setPotentialEnergy(AbstractPotential abstractPotential) {
        if (this._potentialEnergy != null) {
            this._potentialEnergy.deleteObserver(this);
        }
        this._potentialEnergy = abstractPotential;
        this._potentialEnergy.addObserver(this);
        this._wavePacketRenderer.setPotentialEnergy(abstractPotential);
        this.updatePotentialEnergy();
        this.updateTotalEnergy();
    }

    public void setWavePacket(WavePacket wavePacket) {
        if (this._wavePacket != null) {
            this._wavePacket.deleteObserver(this);
        }
        this._wavePacket = wavePacket;
        this._wavePacket.addObserver(this);
        this._wavePacketRenderer.setWavePacket(wavePacket);
        this.updateTotalEnergy();
    }

    public void setPlaneWave(PlaneWave planeWave) {
        if (this._planeWave != null) {
            this._planeWave.deleteObserver(this);
        }
        this._planeWave = planeWave;
        this._planeWave.addObserver(this);
        this._previousPlaneWaveDirection = this._planeWave.getDirection();
        this.updateTotalEnergy();
    }

    public void showWavePacket() {
        this.useWavePacketRenderer(true);
    }

    public void showPlaneWave() {
        this.useWavePacketRenderer(false);
    }

    private void useWavePacketRenderer(boolean bl) {
        if (bl) {
            this.setRenderer(this._totalEnergyIndex, this._wavePacketRenderer);
        } else {
            this.setRenderer(this._totalEnergyIndex, this._planeWaveRenderer);
        }
        this.updateTotalEnergy();
    }

    public void update(Observable observable, Object object) {
        if (observable == this._potentialEnergy) {
            this.updatePotentialEnergy();
            this.updateTotalEnergy();
        } else if (observable == this._totalEnergy) {
            this.updateTotalEnergy();
        } else if (observable == this._wavePacket) {
            if (this._wavePacket.getWidth() != this._previousWavePacketWidth || this._wavePacket.getCenter() != this._previousWavePacketCenter) {
                this.updateTotalEnergy();
            }
        } else if (observable == this._planeWave && this._planeWave.getDirection() != this._previousPlaneWaveDirection) {
            this.updateTotalEnergy();
        }
    }

    private void updateTotalEnergy() {
        if (this._totalEnergy != null) {
            Range range = this.getDomainAxis().getRange();
            this._totalEnergySeries.setNotify(false);
            this._totalEnergySeries.clear();
            this._totalEnergySeries.add(range.getLowerBound(), this._totalEnergy.getEnergy());
            this._totalEnergySeries.add(range.getUpperBound(), this._totalEnergy.getEnergy());
            this._totalEnergySeries.setNotify(true);
            if (this._wavePacket != null && this._wavePacket.isInitialized()) {
                this._previousWavePacketWidth = this._wavePacket.getWidth();
                this._previousWavePacketCenter = this._wavePacket.getCenter();
            }
            if (this._planeWave != null && this._planeWave.isInitialized()) {
                if (this._planeWave.isSolutionZero(this._totalEnergy, this._potentialEnergy)) {
                    this._planeWaveRenderer.setStroke(QTConstants.TOTAL_ENERGY_DASHED_STROKE);
                } else {
                    this._planeWaveRenderer.setStroke(QTConstants.TOTAL_ENERGY_SOLID_STROKE);
                }
                this._previousPlaneWaveDirection = this._planeWave.getDirection();
            }
        }
    }

    private void updatePotentialEnergy() {
        if (this._potentialEnergy != null) {
            this._potentialEnergySeries.setNotify(false);
            this._potentialEnergySeries.clear();
            int n = this._potentialEnergy.getNumberOfRegions();
            for (int i = 0; i < n; ++i) {
                double d = this._potentialEnergy.getStart(i);
                double d2 = this._potentialEnergy.getEnd(i);
                double d3 = this._potentialEnergy.getEnergy(i);
                this._potentialEnergySeries.add(d, d3);
                this._potentialEnergySeries.add(d2, d3);
            }
            this._potentialEnergySeries.setNotify(true);
        }
    }
}

