/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumtunneling.persistence;

import edu.colorado.phet.common.phetcommon.util.IProguardKeepClass;
import edu.colorado.phet.quantumtunneling.enums.Direction;
import edu.colorado.phet.quantumtunneling.enums.IRView;
import edu.colorado.phet.quantumtunneling.enums.PotentialType;
import edu.colorado.phet.quantumtunneling.enums.WaveType;
import edu.colorado.phet.quantumtunneling.model.ConstantPotential;
import edu.colorado.phet.quantumtunneling.model.DoubleBarrierPotential;
import edu.colorado.phet.quantumtunneling.model.PotentialRegion;
import edu.colorado.phet.quantumtunneling.model.SingleBarrierPotential;
import edu.colorado.phet.quantumtunneling.model.StepPotential;
import edu.colorado.phet.quantumtunneling.model.TotalEnergy;
import edu.colorado.phet.quantumtunneling.persistence.QTRegionConfig;

public class QTModuleConfig
implements IProguardKeepClass {
    private boolean _clockRunning;
    private double _totalEnergy;
    private double _minRegionWidth;
    private QTRegionConfig[] _constantRegions;
    private QTRegionConfig[] _stepRegions;
    private QTRegionConfig[] _singleBarrierRegions;
    private QTRegionConfig[] _doubleBarrierRegions;
    private String _potentialTypeName;
    private boolean _showValuesSelected;
    private boolean _rtpSelected;
    private boolean _realSelected;
    private boolean _imaginarySelected;
    private boolean _magnitudeSelected;
    private boolean _phaseSelected;
    private String _irViewName;
    private String _directionName;
    private String _waveTypeName;
    private double _packetWidth;
    private double _packetCenter;
    private int _waveFunctionZoomIndex;
    private int _probabilityDensityZoomIndex;

    public void setClockRunning(boolean bl) {
        this._clockRunning = bl;
    }

    public boolean isClockRunning() {
        return this._clockRunning;
    }

    public QTRegionConfig[] getConstantRegions() {
        return this._constantRegions;
    }

    public void setConstantRegions(QTRegionConfig[] qTRegionConfigArray) {
        this._constantRegions = qTRegionConfigArray;
    }

    public QTRegionConfig[] getDoubleBarrierRegions() {
        return this._doubleBarrierRegions;
    }

    public void setDoubleBarrierRegions(QTRegionConfig[] qTRegionConfigArray) {
        this._doubleBarrierRegions = qTRegionConfigArray;
    }

    public QTRegionConfig[] getSingleBarrierRegions() {
        return this._singleBarrierRegions;
    }

    public void setSingleBarrierRegions(QTRegionConfig[] qTRegionConfigArray) {
        this._singleBarrierRegions = qTRegionConfigArray;
    }

    public QTRegionConfig[] getStepRegions() {
        return this._stepRegions;
    }

    public void setStepRegions(QTRegionConfig[] qTRegionConfigArray) {
        this._stepRegions = qTRegionConfigArray;
    }

    public boolean isImaginarySelected() {
        return this._imaginarySelected;
    }

    public void setImaginarySelected(boolean bl) {
        this._imaginarySelected = bl;
    }

    public String getDirectionName() {
        return this._directionName;
    }

    public void setDirectionName(String string) {
        this._directionName = string;
    }

    public boolean isMagnitudeSelected() {
        return this._magnitudeSelected;
    }

    public void setMagnitudeSelected(boolean bl) {
        this._magnitudeSelected = bl;
    }

    public double getPacketCenter() {
        return this._packetCenter;
    }

    public void setPacketCenter(double d) {
        this._packetCenter = d;
    }

    public double getPacketWidth() {
        return this._packetWidth;
    }

    public void setPacketWidth(double d) {
        this._packetWidth = d;
    }

    public boolean isPhaseSelected() {
        return this._phaseSelected;
    }

    public void setPhaseSelected(boolean bl) {
        this._phaseSelected = bl;
    }

    public boolean isRealSelected() {
        return this._realSelected;
    }

    public void setRealSelected(boolean bl) {
        this._realSelected = bl;
    }

    public String getIrViewName() {
        return this._irViewName;
    }

    public void setIrViewName(String string) {
        this._irViewName = string;
    }

    public double getTotalEnergy() {
        return this._totalEnergy;
    }

    public void setTotalEnergy(double d) {
        this._totalEnergy = d;
    }

    public String getWaveTypeName() {
        return this._waveTypeName;
    }

    public void setWaveTypeName(String string) {
        this._waveTypeName = string;
    }

    public String getPotentialTypeName() {
        return this._potentialTypeName;
    }

    public void setPotentialTypeName(String string) {
        this._potentialTypeName = string;
    }

    public double getMinRegionWidth() {
        return this._minRegionWidth;
    }

    public void setMinRegionWidth(double d) {
        this._minRegionWidth = d;
    }

    public int getWaveFunctionZoomIndex() {
        return this._waveFunctionZoomIndex;
    }

    public void setWaveFunctionZoomIndex(int n) {
        this._waveFunctionZoomIndex = n;
    }

    public int getProbabilityDensityZoomIndex() {
        return this._probabilityDensityZoomIndex;
    }

    public void setProbabilityDensityZoomIndex(int n) {
        this._probabilityDensityZoomIndex = n;
    }

    public boolean isShowValuesSelected() {
        return this._showValuesSelected;
    }

    public void setShowValuesSelected(boolean bl) {
        this._showValuesSelected = bl;
    }

    public boolean isRtpSelected() {
        return this._rtpSelected;
    }

    public void setRtpSelected(boolean bl) {
        this._rtpSelected = bl;
    }

    public void savePotentialType(PotentialType potentialType) {
        this.setPotentialTypeName(potentialType.getName());
    }

    public PotentialType loadPotentialType() {
        return PotentialType.getByName(this.getPotentialTypeName());
    }

    public void saveIRView(IRView iRView) {
        this.setIrViewName(iRView.getName());
    }

    public IRView loadIRView() {
        return IRView.getByName(this.getIrViewName());
    }

    public void saveDirection(Direction direction) {
        this.setDirectionName(direction.getName());
    }

    public Direction loadDirection() {
        return Direction.getByName(this.getDirectionName());
    }

    public void saveWaveType(WaveType waveType) {
        this.setWaveTypeName(waveType.getName());
    }

    public WaveType loadWaveType() {
        return WaveType.getByName(this.getWaveTypeName());
    }

    public void saveTotalEnergy(TotalEnergy totalEnergy) {
        this.setTotalEnergy(totalEnergy.getEnergy());
    }

    public TotalEnergy loadTotalEnergy() {
        return new TotalEnergy(this.getTotalEnergy());
    }

    public void saveConstantPotential(ConstantPotential constantPotential) {
        this.setConstantRegions(this.toRegionConfigs(constantPotential.getRegions()));
    }

    public ConstantPotential loadConstantPotential() {
        ConstantPotential constantPotential = new ConstantPotential();
        constantPotential.setMinRegionWidth(this._minRegionWidth);
        constantPotential.setRegions(this.toPotentialRegions(this._constantRegions));
        return constantPotential;
    }

    public void saveStepPotential(StepPotential stepPotential) {
        this.setStepRegions(this.toRegionConfigs(stepPotential.getRegions()));
    }

    public StepPotential loadStepPotential() {
        StepPotential stepPotential = new StepPotential();
        stepPotential.setMinRegionWidth(this._minRegionWidth);
        stepPotential.setRegions(this.toPotentialRegions(this._stepRegions));
        return stepPotential;
    }

    public void saveSingleBarrierPotential(SingleBarrierPotential singleBarrierPotential) {
        this.setSingleBarrierRegions(this.toRegionConfigs(singleBarrierPotential.getRegions()));
    }

    public SingleBarrierPotential loadSingleBarrierPotential() {
        SingleBarrierPotential singleBarrierPotential = new SingleBarrierPotential();
        singleBarrierPotential.setMinRegionWidth(this._minRegionWidth);
        singleBarrierPotential.setRegions(this.toPotentialRegions(this._singleBarrierRegions));
        return singleBarrierPotential;
    }

    public void saveDoubleBarrierPotential(DoubleBarrierPotential doubleBarrierPotential) {
        this.setDoubleBarrierRegions(this.toRegionConfigs(doubleBarrierPotential.getRegions()));
    }

    public DoubleBarrierPotential loadDoubleBarrierPotential() {
        DoubleBarrierPotential doubleBarrierPotential = new DoubleBarrierPotential();
        doubleBarrierPotential.setMinRegionWidth(this._minRegionWidth);
        doubleBarrierPotential.setRegions(this.toPotentialRegions(this._doubleBarrierRegions));
        return doubleBarrierPotential;
    }

    private QTRegionConfig[] toRegionConfigs(PotentialRegion[] potentialRegionArray) {
        QTRegionConfig[] qTRegionConfigArray = new QTRegionConfig[potentialRegionArray.length];
        for (int i = 0; i < potentialRegionArray.length; ++i) {
            QTRegionConfig qTRegionConfig;
            qTRegionConfigArray[i] = qTRegionConfig = new QTRegionConfig(potentialRegionArray[i]);
        }
        return qTRegionConfigArray;
    }

    private PotentialRegion[] toPotentialRegions(QTRegionConfig[] qTRegionConfigArray) {
        PotentialRegion[] potentialRegionArray = new PotentialRegion[qTRegionConfigArray.length];
        for (int i = 0; i < qTRegionConfigArray.length; ++i) {
            potentialRegionArray[i] = qTRegionConfigArray[i].toPotentialRegion();
        }
        return potentialRegionArray;
    }
}

