/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumtunneling.module;

import edu.colorado.phet.common.jfreechartphet.piccolo.XYPlotNode;
import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.model.clock.IClock;
import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.common.piccolophet.help.AbstractHelpItem;
import edu.colorado.phet.common.piccolophet.help.HelpBalloon;
import edu.colorado.phet.common.piccolophet.help.HelpPane;
import edu.colorado.phet.common.piccolophet.nodes.mediabuttons.PiccoloClockControlPanel;
import edu.colorado.phet.quantumtunneling.QTConstants;
import edu.colorado.phet.quantumtunneling.QTResources;
import edu.colorado.phet.quantumtunneling.color.QTColorScheme;
import edu.colorado.phet.quantumtunneling.control.ConfigureEnergyDialog;
import edu.colorado.phet.quantumtunneling.control.PotentialEnergyControls;
import edu.colorado.phet.quantumtunneling.control.QTControlPanel;
import edu.colorado.phet.quantumtunneling.control.TotalEnergyDragHandle;
import edu.colorado.phet.quantumtunneling.control.ZoomControl;
import edu.colorado.phet.quantumtunneling.enums.Direction;
import edu.colorado.phet.quantumtunneling.enums.IRView;
import edu.colorado.phet.quantumtunneling.enums.PotentialType;
import edu.colorado.phet.quantumtunneling.enums.WaveType;
import edu.colorado.phet.quantumtunneling.model.AbstractPotential;
import edu.colorado.phet.quantumtunneling.model.ConstantPotential;
import edu.colorado.phet.quantumtunneling.model.DoubleBarrierPotential;
import edu.colorado.phet.quantumtunneling.model.IWavePacketSolver;
import edu.colorado.phet.quantumtunneling.model.PlaneWave;
import edu.colorado.phet.quantumtunneling.model.QTClock;
import edu.colorado.phet.quantumtunneling.model.RichardsonSolver;
import edu.colorado.phet.quantumtunneling.model.SingleBarrierPotential;
import edu.colorado.phet.quantumtunneling.model.StepPotential;
import edu.colorado.phet.quantumtunneling.model.TotalEnergy;
import edu.colorado.phet.quantumtunneling.model.WavePacket;
import edu.colorado.phet.quantumtunneling.module.QTAbstractModule;
import edu.colorado.phet.quantumtunneling.persistence.QTModuleConfig;
import edu.colorado.phet.quantumtunneling.view.AbstractProbabilityNode;
import edu.colorado.phet.quantumtunneling.view.EnergyLegend;
import edu.colorado.phet.quantumtunneling.view.EnergyPlot;
import edu.colorado.phet.quantumtunneling.view.ProbabilityDensityPlot;
import edu.colorado.phet.quantumtunneling.view.QTCombinedChart;
import edu.colorado.phet.quantumtunneling.view.QTCombinedChartNode;
import edu.colorado.phet.quantumtunneling.view.QTMarkerNode;
import edu.colorado.phet.quantumtunneling.view.QTRegionMarkerManager;
import edu.colorado.phet.quantumtunneling.view.WaveFunctionPlot;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.event.PInputEventListener;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.Dimension;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.Serializable;
import java.util.Observable;
import java.util.Observer;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;

public class QTModule
extends QTAbstractModule
implements Observer {
    private static final Dimension CANVAS_RENDERING_SIZE = new Dimension(1000, 1000);
    private TotalEnergy _totalEnergy;
    private AbstractPotential _potentialEnergy;
    private ConstantPotential _constantPotential;
    private StepPotential _stepPotential;
    private SingleBarrierPotential _singleBarrierPotential;
    private DoubleBarrierPotential _doubleBarrierPotential;
    private PlaneWave _planeWave;
    private WavePacket _wavePacket;
    private PhetPCanvas _canvas;
    private PNode _parentNode;
    private EnergyLegend _legend;
    private QTCombinedChartNode _chartNode;
    private QTCombinedChart _chart;
    private QTRegionMarkerManager _regionMarkerManager;
    private AbstractProbabilityNode.ReflectionProbabilityNode _reflectionProbabilityNode;
    private AbstractProbabilityNode.TransmissionProbabilityNode _transmissionProbabilityNode;
    private EnergyPlot _energyPlot;
    private WaveFunctionPlot _waveFunctionPlot;
    private ProbabilityDensityPlot _probabilityDensityPlot;
    private XYPlotNode _energyPlotNode;
    private XYPlotNode _waveFunctionPlotNode;
    private XYPlotNode _probabilityDensityPlotNode;
    private QTMarkerNode _energyMarkerNode;
    private QTMarkerNode _waveFunctionMarkerNode;
    private QTMarkerNode _probabilityDensityMarkerNode;
    private PSwing _configureButton;
    private PSwing _measureButton;
    private QTControlPanel _controlPanel;
    private ConfigureEnergyDialog _configureEnergyDialog;
    private TotalEnergyDragHandle _totalEnergyControl;
    private PotentialEnergyControls _potentialEnergyControls;
    private PSwing _waveFunctionZoomControl;
    private PSwing _probabilityDensityZoomControl;
    private PiccoloClockControlPanel _clockControls;
    private QTColorScheme _colorScheme;
    private boolean _isMeasuring;

    public QTModule() {
        super(QTResources.getString("title.quantumTunneling"), new QTClock(), false);
        this.setLogoPanel(null);
        this._planeWave = new PlaneWave();
        this._planeWave.setEnabled(false);
        this.addClockListener(this._planeWave);
        this._wavePacket = new WavePacket();
        this._wavePacket.setEnabled(false);
        this.addClockListener(this._wavePacket);
        EventListener eventListener = new EventListener();
        this._canvas = new PhetPCanvas(CANVAS_RENDERING_SIZE);
        this._canvas.setBackground(QTConstants.CANVAS_BACKGROUND);
        this._canvas.setName("QTModule PhetPCanvas");
        this.setSimulationPanel(this._canvas);
        this._parentNode = new PNode();
        this._canvas.addScreenChild(this._parentNode);
        this._chart = new QTCombinedChart();
        this._chart.setBackgroundPaint(QTConstants.CANVAS_BACKGROUND);
        this._chartNode = new QTCombinedChartNode(this._chart);
        this._parentNode.addChild(this._chartNode);
        this._legend = new EnergyLegend();
        this._parentNode.addChild(this._legend);
        this._chartNode.setBuffered(true);
        this._energyPlot = new EnergyPlot();
        this._waveFunctionPlot = new WaveFunctionPlot();
        this._probabilityDensityPlot = new ProbabilityDensityPlot(this._waveFunctionPlot.getProbabilityDensitySeries());
        Object object = this._chart.getRenderingHints();
        this._energyMarkerNode = new QTMarkerNode(this._energyPlot);
        this._energyMarkerNode.setRenderingHints((RenderingHints)object);
        this._parentNode.addChild(this._energyMarkerNode);
        this._waveFunctionMarkerNode = new QTMarkerNode(this._waveFunctionPlot);
        this._waveFunctionMarkerNode.setRenderingHints((RenderingHints)object);
        this._parentNode.addChild(this._waveFunctionMarkerNode);
        this._probabilityDensityMarkerNode = new QTMarkerNode(this._probabilityDensityPlot);
        this._probabilityDensityMarkerNode.setRenderingHints((RenderingHints)object);
        this._parentNode.addChild(this._probabilityDensityMarkerNode);
        this._energyPlotNode = new XYPlotNode(this._energyPlot);
        this._energyPlotNode.setRenderingHints((RenderingHints)object);
        this._energyPlotNode.setName("energyPlotNode");
        this._parentNode.addChild(this._energyPlotNode);
        this._waveFunctionPlotNode = new XYPlotNode(this._waveFunctionPlot);
        this._waveFunctionPlotNode.setRenderingHints((RenderingHints)object);
        this._waveFunctionPlotNode.setName("waveFunctionPlotNode");
        this._parentNode.addChild(this._waveFunctionPlotNode);
        this._probabilityDensityPlotNode = new XYPlotNode(this._probabilityDensityPlot);
        this._probabilityDensityPlotNode.setRenderingHints((RenderingHints)object);
        this._probabilityDensityPlotNode.setName("probabilityDensityPlotNode");
        this._parentNode.addChild(this._probabilityDensityPlotNode);
        this._regionMarkerManager = new QTRegionMarkerManager();
        this._regionMarkerManager.addPlot(this._energyPlot);
        this._regionMarkerManager.addPlot(this._waveFunctionPlot);
        this._regionMarkerManager.addPlot(this._probabilityDensityPlot);
        this._reflectionProbabilityNode = new AbstractProbabilityNode.ReflectionProbabilityNode();
        this._parentNode.addChild(this._reflectionProbabilityNode);
        this._transmissionProbabilityNode = new AbstractProbabilityNode.TransmissionProbabilityNode();
        this._parentNode.addChild(this._transmissionProbabilityNode);
        this._controlPanel = new QTControlPanel(this);
        this.setControlPanel(this._controlPanel);
        this._clockControls = new PiccoloClockControlPanel(this.getClock());
        this._clockControls.setRewindButtonVisible(true);
        this._clockControls.setTimeDisplayVisible(true);
        this._clockControls.setTimeFormat("0.0");
        this._clockControls.setTimeColumns(8);
        this._clockControls.setUnits(QTResources.getString("units.time"));
        this._clockControls.setRewindButtonTooltip(QTResources.getString("button.restart"));
        this.setClockControlPanel(this._clockControls);
        this.addClockListener(new ClockAdapter(){

            public void simulationTimeReset(ClockEvent clockEvent) {
                QTModule.this.handleClockReset();
            }
        });
        object = new JButton(QTResources.getString("button.configureEnergy"));
        ((JComponent)object).setOpaque(false);
        ((AbstractButton)object).addActionListener(eventListener);
        this._configureButton = new PSwing((JComponent)object);
        object = new JButton(QTResources.getString("button.measure"));
        ((JComponent)object).setOpaque(false);
        ((AbstractButton)object).addActionListener(eventListener);
        this._measureButton = new PSwing((JComponent)object);
        object = new PBasicInputEventHandler(){
            private boolean _clockIsRunning = false;

            public void mousePressed(PInputEvent pInputEvent) {
                this._clockIsRunning = QTModule.this.getClock().isRunning();
                if (this._clockIsRunning) {
                    QTModule.this.getClock().pause();
                }
            }

            public void mouseReleased(PInputEvent pInputEvent) {
                if (this._clockIsRunning) {
                    QTModule.this.getClock().start();
                }
            }
        };
        this._totalEnergyControl = new TotalEnergyDragHandle(this._chartNode);
        this._totalEnergyControl.setXAxisPosition(QTConstants.POSITION_RANGE.getUpperBound() - 1.0);
        this._totalEnergyControl.addInputEventListener((PInputEventListener)object);
        this._potentialEnergyControls = new PotentialEnergyControls(this._chartNode);
        this._potentialEnergyControls.addInputEventListener((PInputEventListener)object);
        object = new ZoomControl(1, QTConstants.WAVE_FUNCTION_ZOOM_SPECS, 3);
        ((ZoomControl)object).addPlot(this._chart.getWaveFunctionPlot());
        ((ZoomControl)object).addPlot(this._waveFunctionPlot);
        this._waveFunctionZoomControl = new PSwing((JComponent)object);
        Serializable serializable = new ZoomControl(1, QTConstants.PROBABILITY_DENSITY_ZOOM_SPECS, 3);
        ((ZoomControl)serializable).addPlot(this._chart.getProbabilityDensityPlot());
        ((ZoomControl)serializable).addPlot(this._probabilityDensityPlot);
        this._probabilityDensityZoomControl = new PSwing((JComponent)serializable);
        this._parentNode.addChild(this._configureButton);
        this._parentNode.addChild(this._measureButton);
        this._parentNode.addChild(this._totalEnergyControl);
        this._parentNode.addChild(this._potentialEnergyControls);
        this._parentNode.addChild(this._waveFunctionZoomControl);
        this._parentNode.addChild(this._probabilityDensityZoomControl);
        object = this.getDefaultHelpPane();
        serializable = new HelpBalloon((JComponent)object, QTResources.getString("help.configure"), HelpBalloon.RIGHT_CENTER, 20.0);
        ((HelpPane)object).add((AbstractHelpItem)serializable);
        ((AbstractHelpItem)serializable).pointAt(this._configureButton, this._canvas);
        HelpBalloon helpBalloon = new HelpBalloon((JComponent)object, QTResources.getString("help.dragHandle"), HelpBalloon.RIGHT_TOP, 20.0);
        ((HelpPane)object).add(helpBalloon);
        helpBalloon.pointAt(this._totalEnergyControl, this._canvas);
        HelpBalloon helpBalloon2 = new HelpBalloon((JComponent)object, QTResources.getString("help.zoom"), HelpBalloon.LEFT_CENTER, 30.0);
        ((HelpPane)object).add(helpBalloon2);
        helpBalloon2.pointAt(this._waveFunctionZoomControl, this._canvas);
        HelpBalloon helpBalloon3 = new HelpBalloon((JComponent)object, QTResources.getString("help.restart"), HelpBalloon.BOTTOM_CENTER, 80.0);
        ((HelpPane)object).add(helpBalloon3);
        helpBalloon3.pointAt(this._clockControls.getRewindButton(), this._clockControls.getButtonCanvas());
        this.reset();
        this.updateCanvasLayout();
        this._canvas.addComponentListener(eventListener);
    }

    private void updateCanvasLayout() {
        double d = this._legend.getFullBounds().getHeight();
        double d2 = this._canvas.getWidth() - 20;
        double d3 = (double)this._canvas.getHeight() - (d + 20.0 + 10.0);
        this._chartNode.setBounds(0.0, 0.0, d2, d3);
        Cloneable cloneable = new AffineTransform();
        ((AffineTransform)cloneable).translate(10.0, 10.0 + d + 10.0);
        ((AffineTransform)cloneable).translate(0.0, 0.0);
        this._chartNode.setTransform((AffineTransform)cloneable);
        this._chartNode.updateChartRenderingInfo();
        cloneable = this._chartNode.localToGlobal(this._chartNode.getEnergyPlotBounds());
        Rectangle2D rectangle2D = this._chartNode.localToGlobal(this._chartNode.getWaveFunctionPlotBounds());
        Rectangle2D rectangle2D2 = this._chartNode.localToGlobal(this._chartNode.getProbabilityDensityPlotBounds());
        if (this._energyPlotNode != null) {
            this._energyPlotNode.setOffset(0.0, 0.0);
            this._energyPlotNode.setDataArea((Rectangle2D)cloneable);
        }
        if (this._waveFunctionPlotNode != null) {
            this._waveFunctionPlotNode.setOffset(0.0, 0.0);
            this._waveFunctionPlotNode.setDataArea(rectangle2D);
        }
        if (this._probabilityDensityPlotNode != null) {
            this._probabilityDensityPlotNode.setOffset(0.0, 0.0);
            this._probabilityDensityPlotNode.setDataArea(rectangle2D2);
        }
        if (this._energyMarkerNode != null) {
            this._energyMarkerNode.setOffset(0.0, 0.0);
            this._energyMarkerNode.setDataArea((Rectangle2D)cloneable);
        }
        if (this._waveFunctionMarkerNode != null) {
            this._waveFunctionMarkerNode.setOffset(0.0, 0.0);
            this._waveFunctionMarkerNode.setDataArea(rectangle2D);
        }
        if (this._probabilityDensityMarkerNode != null) {
            this._probabilityDensityMarkerNode.setOffset(0.0, 0.0);
            this._probabilityDensityMarkerNode.setDataArea(rectangle2D2);
        }
        this._totalEnergyControl.updateDragBounds();
        this._potentialEnergyControls.updateDragBounds();
        Cloneable cloneable2 = this._chartNode.nodeToEnergy(new Point2D.Double(0.0, 0.0));
        Point2D point2D = this._chartNode.nodeToEnergy(new Point2D.Double(1.0, 0.0));
        double d4 = point2D.getX() - ((Point2D)cloneable2).getX();
        this._waveFunctionPlot.setDx(d4);
        cloneable2 = this._chartNode.nodeToEnergy(new Point2D.Double(0.0, 0.0));
        point2D = this._chartNode.nodeToEnergy(new Point2D.Double(2.0, 0.0));
        d4 = point2D.getX() - ((Point2D)cloneable2).getX();
        this._wavePacket.setDx(d4);
        cloneable2 = new AffineTransform();
        ((AffineTransform)cloneable2).translate(((RectangularShape)cloneable).getX(), 10.0);
        ((AffineTransform)cloneable2).translate(0.0, 0.0);
        this._legend.setTransform((AffineTransform)cloneable2);
        cloneable2 = new AffineTransform();
        ((AffineTransform)cloneable2).translate(((RectangularShape)cloneable).getX() + ((RectangularShape)cloneable).getWidth(), 10.0);
        ((AffineTransform)cloneable2).translate(-this._configureButton.getWidth(), 0.0);
        this._configureButton.setTransform((AffineTransform)cloneable2);
        cloneable2 = new AffineTransform();
        ((AffineTransform)cloneable2).translate(rectangle2D2.getX(), (double)this._canvas.getHeight() - this._measureButton.getHeight() - 10.0);
        ((AffineTransform)cloneable2).translate(0.0, 0.0);
        this._measureButton.setTransform((AffineTransform)cloneable2);
        cloneable2 = new AffineTransform();
        ((AffineTransform)cloneable2).translate(rectangle2D.getX() + 3.0, rectangle2D.getY() + 3.0);
        ((AffineTransform)cloneable2).translate(0.0, 0.0);
        this._waveFunctionZoomControl.setTransform((AffineTransform)cloneable2);
        cloneable2 = new AffineTransform();
        ((AffineTransform)cloneable2).translate(rectangle2D2.getX() + 3.0, rectangle2D2.getY() + 3.0);
        ((AffineTransform)cloneable2).translate(0.0, 0.0);
        this._probabilityDensityZoomControl.setTransform((AffineTransform)cloneable2);
        this.updateRtpLayout();
    }

    public boolean hasHelp() {
        return true;
    }

    public void reset() {
        TotalEnergy totalEnergy = new TotalEnergy(0.8);
        this.setTotalEnergy(totalEnergy);
        this._constantPotential = new ConstantPotential();
        this._stepPotential = new StepPotential();
        this._singleBarrierPotential = new SingleBarrierPotential();
        this._doubleBarrierPotential = new DoubleBarrierPotential();
        this._energyPlot.setWavePacket(this._wavePacket);
        this._energyPlot.setPlaneWave(this._planeWave);
        this._controlPanel.setPotentialType(PotentialType.SINGLE_BARRIER);
        this._controlPanel.setShowValuesSelected(false);
        this._controlPanel.setRtpSelected(false);
        this._controlPanel.setRealSelected(true);
        this._controlPanel.setImaginarySelected(false);
        this._controlPanel.setMagnitudeSelected(false);
        this._controlPanel.setPhaseSelected(false);
        this._controlPanel.setIRView(IRView.SUM);
        this._controlPanel.setDirection(Direction.LEFT_TO_RIGHT);
        this._controlPanel.setWaveType(WaveType.PACKET);
        this._controlPanel.setPacketWidth(0.5);
        this._controlPanel.setPacketCenter(-2.0);
        ((ZoomControl)this._waveFunctionZoomControl.getComponent()).setZoomIndex(3);
        ((ZoomControl)this._probabilityDensityZoomControl.getComponent()).setZoomIndex(3);
    }

    public QTModuleConfig save() {
        QTModuleConfig qTModuleConfig = new QTModuleConfig();
        qTModuleConfig.setClockRunning(this.getClock().isRunning());
        qTModuleConfig.saveTotalEnergy(this._totalEnergy);
        qTModuleConfig.setMinRegionWidth(this._constantPotential.getMinRegionWidth());
        qTModuleConfig.saveConstantPotential(this._constantPotential);
        qTModuleConfig.saveStepPotential(this._stepPotential);
        qTModuleConfig.saveSingleBarrierPotential(this._singleBarrierPotential);
        qTModuleConfig.saveDoubleBarrierPotential(this._doubleBarrierPotential);
        qTModuleConfig.savePotentialType(this._controlPanel.getPotentialType());
        qTModuleConfig.setShowValuesSelected(this._controlPanel.isShowValuesSelected());
        qTModuleConfig.setRtpSelected(this._controlPanel.isRtpSelected());
        qTModuleConfig.setRealSelected(this._controlPanel.isRealSelected());
        qTModuleConfig.setImaginarySelected(this._controlPanel.isImaginarySelected());
        qTModuleConfig.setMagnitudeSelected(this._controlPanel.isMagnitudeSelected());
        qTModuleConfig.setPhaseSelected(this._controlPanel.isPhaseSelected());
        qTModuleConfig.saveIRView(this._controlPanel.getIRView());
        qTModuleConfig.saveDirection(this._controlPanel.getDirection());
        qTModuleConfig.saveWaveType(this._controlPanel.getWaveType());
        qTModuleConfig.setPacketWidth(this._controlPanel.getPacketWidth());
        qTModuleConfig.setPacketCenter(this._controlPanel.getPacketCenter());
        qTModuleConfig.setWaveFunctionZoomIndex(((ZoomControl)this._waveFunctionZoomControl.getComponent()).getZoomIndex());
        qTModuleConfig.setProbabilityDensityZoomIndex(((ZoomControl)this._probabilityDensityZoomControl.getComponent()).getZoomIndex());
        return qTModuleConfig;
    }

    public void load(QTModuleConfig qTModuleConfig) {
        if (this.isActive()) {
            if (qTModuleConfig.isClockRunning()) {
                this.getClock().start();
            } else {
                this.getClock().pause();
            }
        }
        this.setTotalEnergy(qTModuleConfig.loadTotalEnergy());
        this.setConstantPotential(qTModuleConfig.loadConstantPotential());
        this.setStepPotential(qTModuleConfig.loadStepPotential());
        this.setSingleBarrierPotential(qTModuleConfig.loadSingleBarrierPotential());
        this.setDoubleBarrierPotential(qTModuleConfig.loadDoubleBarrierPotential());
        this._controlPanel.setPotentialType(qTModuleConfig.loadPotentialType());
        this._controlPanel.setShowValuesSelected(qTModuleConfig.isShowValuesSelected());
        this._controlPanel.setRtpSelected(qTModuleConfig.isRtpSelected());
        this._controlPanel.setRealSelected(qTModuleConfig.isRealSelected());
        this._controlPanel.setImaginarySelected(qTModuleConfig.isImaginarySelected());
        this._controlPanel.setMagnitudeSelected(qTModuleConfig.isMagnitudeSelected());
        this._controlPanel.setPhaseSelected(qTModuleConfig.isPhaseSelected());
        this._controlPanel.setIRView(qTModuleConfig.loadIRView());
        this._controlPanel.setDirection(qTModuleConfig.loadDirection());
        this._controlPanel.setWaveType(qTModuleConfig.loadWaveType());
        this._controlPanel.setPacketWidth(qTModuleConfig.getPacketWidth());
        this._controlPanel.setPacketCenter(qTModuleConfig.getPacketCenter());
        ((ZoomControl)this._waveFunctionZoomControl.getComponent()).setZoomIndex(qTModuleConfig.getWaveFunctionZoomIndex());
        ((ZoomControl)this._probabilityDensityZoomControl.getComponent()).setZoomIndex(qTModuleConfig.getProbabilityDensityZoomIndex());
    }

    private void handleConfigureButton() {
        if (this._configureEnergyDialog == null) {
            boolean bl = this.getClock().isRunning();
            this.getClock().pause();
            this._configureEnergyDialog = new ConfigureEnergyDialog(this.getFrame(), this, this._totalEnergy, this._potentialEnergy, this._wavePacket, this._planeWave, this._colorScheme);
            this._configureEnergyDialog.show();
            this._configureEnergyDialog.cleanup();
            this._configureEnergyDialog = null;
            if (bl) {
                this.getClock().start();
            }
        }
    }

    private void handleMeasureButton() {
        this._isMeasuring = true;
        this.setMeasureEnabled(true);
        this._isMeasuring = false;
    }

    public void setPotentialType(PotentialType potentialType) {
        AbstractPotential abstractPotential = null;
        if (potentialType == PotentialType.CONSTANT) {
            abstractPotential = this._constantPotential;
        } else if (potentialType == PotentialType.STEP) {
            abstractPotential = this._stepPotential;
        } else if (potentialType == PotentialType.SINGLE_BARRIER) {
            abstractPotential = this._singleBarrierPotential;
        } else if (potentialType == PotentialType.DOUBLE_BARRIER) {
            abstractPotential = this._doubleBarrierPotential;
        } else {
            throw new IllegalStateException("unsupported potential type: " + potentialType);
        }
        this.setPotentialEnergy(abstractPotential);
    }

    public void setPotentialEnergy(AbstractPotential abstractPotential) {
        if (abstractPotential instanceof ConstantPotential) {
            this._constantPotential = (ConstantPotential)abstractPotential;
        } else if (abstractPotential instanceof StepPotential) {
            this._stepPotential = (StepPotential)abstractPotential;
        } else if (abstractPotential instanceof SingleBarrierPotential) {
            this._singleBarrierPotential = (SingleBarrierPotential)abstractPotential;
        } else if (abstractPotential instanceof DoubleBarrierPotential) {
            this._doubleBarrierPotential = (DoubleBarrierPotential)abstractPotential;
        } else {
            throw new IllegalArgumentException("unsupported potential type: " + abstractPotential.getClass().getName());
        }
        if (this._potentialEnergy != null) {
            this._potentialEnergy.deleteObserver(this);
        }
        this._potentialEnergy = abstractPotential;
        this._potentialEnergy.addObserver(this);
        this._energyPlot.setPotentialEnergy(this._potentialEnergy);
        this._regionMarkerManager.setPotentialEnergy(this._potentialEnergy);
        this._controlPanel.setPotentialEnergy(this._potentialEnergy);
        this._potentialEnergyControls.setPotentialEnergy(this._potentialEnergy);
        this._planeWave.setPotentialEnergy(this._potentialEnergy);
        this._wavePacket.setPotentialEnergy(this._potentialEnergy);
        this.resetClock();
    }

    public void setConstantPotential(ConstantPotential constantPotential) {
        if (this._potentialEnergy == this._constantPotential) {
            this.setPotentialEnergy(constantPotential);
        } else {
            this._constantPotential = constantPotential;
        }
    }

    public void setStepPotential(StepPotential stepPotential) {
        if (this._potentialEnergy == this._stepPotential) {
            this.setPotentialEnergy(stepPotential);
        } else {
            this._stepPotential = stepPotential;
        }
    }

    public void setSingleBarrierPotential(SingleBarrierPotential singleBarrierPotential) {
        if (this._potentialEnergy == this._singleBarrierPotential) {
            this.setPotentialEnergy(singleBarrierPotential);
        } else {
            this._singleBarrierPotential = singleBarrierPotential;
        }
    }

    public void setDoubleBarrierPotential(DoubleBarrierPotential doubleBarrierPotential) {
        if (this._potentialEnergy == this._doubleBarrierPotential) {
            this.setPotentialEnergy(doubleBarrierPotential);
        } else {
            this._doubleBarrierPotential = doubleBarrierPotential;
        }
    }

    public void setTotalEnergy(TotalEnergy totalEnergy) {
        if (this._totalEnergy != null) {
            this._totalEnergy.deleteObserver(this);
        }
        this._totalEnergy = totalEnergy;
        this._totalEnergy.addObserver(this);
        this.resetClock();
        this._energyPlot.setTotalEnergy(this._totalEnergy);
        this._totalEnergyControl.setTotalEnergy(this._totalEnergy);
        this._planeWave.setTotalEnergy(this._totalEnergy);
        this._wavePacket.setTotalEnergy(this._totalEnergy);
    }

    public void setValuesVisible(boolean bl) {
        this._totalEnergyControl.setValueVisible(bl);
        this._potentialEnergyControls.setValuesVisible(bl);
    }

    public void setWaveType(WaveType waveType) {
        this.resetClock();
        if (waveType == WaveType.PLANE) {
            this._planeWave.setEnabled(true);
            this._wavePacket.setEnabled(false);
            this._energyPlot.showPlaneWave();
            this._waveFunctionPlot.setWave(this._planeWave);
            this._reflectionProbabilityNode.setWave(this._planeWave);
            this._transmissionProbabilityNode.setWave(this._planeWave);
        } else {
            this._planeWave.setEnabled(false);
            this._wavePacket.setEnabled(true);
            this._energyPlot.showWavePacket();
            this._waveFunctionPlot.setWave(this._wavePacket);
            this._reflectionProbabilityNode.setWave(this._wavePacket);
            this._transmissionProbabilityNode.setWave(this._wavePacket);
        }
    }

    public void setRealVisible(boolean bl) {
        this._waveFunctionPlot.setRealVisible(bl);
    }

    public void setImaginaryVisible(boolean bl) {
        this._waveFunctionPlot.setImaginaryVisible(bl);
    }

    public void setMagnitudeVisible(boolean bl) {
        this._waveFunctionPlot.setMagnitudeVisible(bl);
    }

    public void setPhaseVisible(boolean bl) {
        this._waveFunctionPlot.setPhaseVisible(bl);
    }

    public void setDirection(Direction direction) {
        this._planeWave.setNotifyEnabled(false);
        this._wavePacket.setNotifyEnabled(false);
        this._planeWave.setDirection(direction);
        this._wavePacket.setDirection(direction);
        this.resetClock();
        this._planeWave.setNotifyEnabled(true);
        this._wavePacket.setNotifyEnabled(true);
        this.updateRtpLayout();
    }

    public void setIRView(IRView iRView) {
        this._waveFunctionPlot.setIRView(iRView);
    }

    public void setWavePacketWidth(double d) {
        this.resetClock();
        this._wavePacket.setWidth(d);
    }

    public void setWavePacketCenter(double d) {
        this.resetClock();
        this._wavePacket.setCenter(d);
    }

    public void setMeasureEnabled(boolean bl) {
        IClock iClock = this.getClock();
        boolean bl2 = false;
        if (iClock.isRunning()) {
            bl2 = true;
            iClock.pause();
        }
        this.getClock().pause();
        this._planeWave.setMeasureEnabled(bl);
        this._wavePacket.setMeasureEnabled(bl);
        if (bl2) {
            this.getClock().start();
        }
    }

    private void resetClock() {
        this.getClock().resetSimulationTime();
    }

    private void handleClockReset() {
        this.setMeasureEnabled(false);
    }

    public void setColorScheme(QTColorScheme qTColorScheme) {
        this._colorScheme = qTColorScheme;
        this._chart.setColorScheme(qTColorScheme);
        this._energyPlot.setColorScheme(qTColorScheme);
        this._waveFunctionPlot.setColorScheme(qTColorScheme);
        this._probabilityDensityPlot.setColorScheme(qTColorScheme);
        this._controlPanel.setColorScheme(qTColorScheme);
        this._totalEnergyControl.setValueColor(qTColorScheme.getAnnotationColor());
        this._potentialEnergyControls.setValueColor(qTColorScheme.getAnnotationColor());
        this._legend.setColorScheme(qTColorScheme);
        this._regionMarkerManager.setMarkerColor(qTColorScheme.getRegionMarkerColor());
        this._reflectionProbabilityNode.setColorScheme(qTColorScheme);
        this._transmissionProbabilityNode.setColorScheme(qTColorScheme);
    }

    public RichardsonSolver getRichardsonSolver() {
        RichardsonSolver richardsonSolver = null;
        IWavePacketSolver iWavePacketSolver = this._wavePacket.getSolver();
        if (iWavePacketSolver instanceof RichardsonSolver) {
            richardsonSolver = (RichardsonSolver)iWavePacketSolver;
        }
        return richardsonSolver;
    }

    public void setRtpVisible(boolean bl) {
        this._reflectionProbabilityNode.setVisible(bl);
        this._transmissionProbabilityNode.setVisible(bl);
    }

    private void updateRtpLayout() {
        Rectangle2D rectangle2D = this._chartNode.localToGlobal(this._chartNode.getProbabilityDensityPlotBounds());
        PBounds pBounds = this._probabilityDensityZoomControl.getFullBounds();
        Direction direction = this._planeWave.getDirection();
        AbstractProbabilityNode abstractProbabilityNode = null;
        AbstractProbabilityNode abstractProbabilityNode2 = null;
        if (direction == Direction.LEFT_TO_RIGHT) {
            abstractProbabilityNode = this._reflectionProbabilityNode;
            abstractProbabilityNode2 = this._transmissionProbabilityNode;
        } else {
            abstractProbabilityNode = this._transmissionProbabilityNode;
            abstractProbabilityNode2 = this._reflectionProbabilityNode;
        }
        double d = pBounds.getMaxX() + 15.0;
        double d2 = rectangle2D.getY() + 15.0;
        abstractProbabilityNode.setOffset(d, d2);
        d = rectangle2D.getX() + rectangle2D.getWidth() - 60.0 - 15.0;
        abstractProbabilityNode2.setOffset(d, d2);
    }

    public void update(Observable observable, Object object) {
        if (observable == this._potentialEnergy || observable == this._totalEnergy && !this._isMeasuring) {
            this.resetClock();
        }
    }

    private class EventListener
    extends ComponentAdapter
    implements ActionListener {
        private EventListener() {
        }

        public void componentResized(ComponentEvent componentEvent) {
            if (componentEvent.getSource() == QTModule.this._canvas) {
                QTModule.this.updateCanvasLayout();
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == QTModule.this._configureButton.getComponent()) {
                QTModule.this.handleConfigureButton();
            } else if (actionEvent.getSource() == QTModule.this._measureButton.getComponent()) {
                QTModule.this.handleMeasureButton();
            }
        }
    }
}

