/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumtunneling.model;

import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.model.clock.ClockListener;
import edu.colorado.phet.quantumtunneling.enums.Direction;
import edu.colorado.phet.quantumtunneling.model.AbstractPlaneSolver;
import edu.colorado.phet.quantumtunneling.model.AbstractPotential;
import edu.colorado.phet.quantumtunneling.model.AbstractWave;
import edu.colorado.phet.quantumtunneling.model.IWavePacketSolver;
import edu.colorado.phet.quantumtunneling.model.RichardsonSolver;
import edu.colorado.phet.quantumtunneling.model.SolverFactory;
import edu.colorado.phet.quantumtunneling.model.TotalEnergy;
import edu.colorado.phet.quantumtunneling.util.Distribution;
import edu.colorado.phet.quantumtunneling.util.LightweightComplex;
import java.util.Observable;
import java.util.Observer;
import java.util.Random;

public class WavePacket
extends AbstractWave
implements ClockListener,
Observer {
    private TotalEnergy _te = null;
    private AbstractPotential _pe = null;
    private Direction _direction = Direction.LEFT_TO_RIGHT;
    private boolean _enabled = true;
    private double _width = 0.5;
    private double _center = -2.0;
    private IWavePacketSolver _solver = new RichardsonSolver(this);
    private boolean _measureEnabled = false;
    private double _saveCenter = this._center;
    private double _saveWidth = this._width;
    private double _saveTotalEnergy = 0.0;
    private AbstractPlaneSolver _planeSolver = null;

    public boolean isInitialized() {
        return this._te != null && this._pe != null;
    }

    public double getReflectionProbability() {
        double d = -1.0;
        if (this._planeSolver != null) {
            double d2;
            boolean bl;
            double d3 = this._te.getEnergy();
            boolean bl2 = bl = d3 < (d2 = this._pe.getEnergyAt(this._center));
            if (!bl) {
                boolean bl3;
                boolean bl4;
                if (this._direction == Direction.LEFT_TO_RIGHT) {
                    bl4 = this._pe.isInFirstRegion(this._center);
                    bl3 = this._pe.isInLastRegion(this._center);
                } else {
                    bl4 = this._pe.isInLastRegion(this._center);
                    bl3 = this._pe.isInFirstRegion(this._center);
                }
                if (bl4) {
                    d = this._planeSolver.getReflectionProbability();
                } else if (bl3) {
                    d = 0.0;
                }
            }
        }
        return d;
    }

    public IWavePacketSolver getSolver() {
        return this._solver;
    }

    public void setDx(double d) {
        this._solver.setDx(d);
    }

    public double[] getPositionValues() {
        return this._solver.getPositionValues();
    }

    public LightweightComplex[] getWaveFunctionValues() {
        return this._solver.getWaveFunctionValues();
    }

    public void setEnabled(boolean bl) {
        if (bl != this._enabled) {
            this._enabled = bl;
        }
    }

    public boolean isEnabled() {
        return this._enabled;
    }

    public void setWidth(double d) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("width must be > 0: " + d);
        }
        this._width = d;
        this.update();
    }

    public double getWidth() {
        return this._width;
    }

    public void setCenter(double d) {
        this._center = d;
        this.update();
    }

    public double getCenter() {
        return this._center;
    }

    public void setTotalEnergy(TotalEnergy totalEnergy) {
        if (this._te != null) {
            this._te.deleteObserver(this);
        }
        this._te = totalEnergy;
        this._te.addObserver(this);
        this.updatePlaneSolver();
        this.update();
    }

    public TotalEnergy getTotalEnergy() {
        return this._te;
    }

    public void setPotentialEnergy(AbstractPotential abstractPotential) {
        if (this._pe != null) {
            this._pe.deleteObserver(this);
        }
        this._pe = abstractPotential;
        this._pe.addObserver(this);
        this.updatePlaneSolver();
        this.update();
    }

    public AbstractPotential getPotentialEnergy() {
        return this._pe;
    }

    public void setDirection(Direction direction) {
        this._direction = direction;
        this.updatePlaneSolver();
        this.update();
    }

    public Direction getDirection() {
        return this._direction;
    }

    public void setMeasureEnabled(boolean bl) {
        boolean bl2 = this._measureEnabled;
        this._measureEnabled = bl;
        if (bl) {
            if (!bl2) {
                this._saveCenter = this._center;
                this._saveWidth = this._width;
                this._saveTotalEnergy = this._te.getEnergy();
            }
            double d = this.chooseRandomPosition();
            this.setCenter(d);
            this.setWidth(0.1);
            this.adjustTotalEnergyIfInForbiddenRegion(d);
        } else if (!bl && bl2) {
            this.setCenter(this._saveCenter);
            this.setWidth(this._saveWidth);
            this._te.setEnergy(this._saveTotalEnergy);
        }
        this.update();
    }

    private void adjustTotalEnergyIfInForbiddenRegion(double d) {
        this.setEnabled(false);
        double d2 = this._te.getEnergy();
        double d3 = this._pe.getEnergyAt(d);
        if (d2 < d3) {
            this._te.setEnergy(d3 + 0.1);
        }
        this.setEnabled(true);
    }

    private double chooseRandomPosition() {
        double d = 0.0;
        double[] dArray = this._solver.getPositionValues();
        LightweightComplex[] lightweightComplexArray = this._solver.getWaveFunctionValues();
        if (dArray.length > 1) {
            double d2 = dArray[1] - dArray[0];
            Distribution distribution = new Distribution();
            for (int i = 0; i < dArray.length; ++i) {
                double d3 = lightweightComplexArray[i].getAbs();
                double d4 = d3 * d3 * d2;
                distribution.add(new Double(dArray[i]), d4);
            }
            Distribution.DistributionAccessor distributionAccessor = new Distribution.DistributionAccessor(distribution, new Random());
            Object object = distributionAccessor.nextObject();
            d = object != null ? ((Double)object).doubleValue() : this.getCenter();
        }
        return d;
    }

    private void updatePlaneSolver() {
        if (this.isInitialized()) {
            this._planeSolver = SolverFactory.createSolver(this._te, this._pe, this._direction);
        }
    }

    public void update(Observable observable, Object object) {
        if (this._enabled) {
            this.update();
        }
    }

    private void update() {
        if (this._planeSolver != null) {
            this._planeSolver.update();
        }
        this._solver.update();
        this.notifyObservers();
    }

    public void clockTicked(ClockEvent clockEvent) {
        if (this._enabled && this.isInitialized()) {
            this._solver.propagate();
            this.notifyObservers();
        }
    }

    public void clockStarted(ClockEvent clockEvent) {
    }

    public void clockPaused(ClockEvent clockEvent) {
    }

    public void simulationTimeChanged(ClockEvent clockEvent) {
    }

    public void simulationTimeReset(ClockEvent clockEvent) {
        if (this._enabled && this.isInitialized()) {
            this.update();
        }
    }
}

