/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumtunneling.model;

import edu.colorado.phet.quantumtunneling.model.AbstractPotential;

public class StepPotential
extends AbstractPotential {
    public StepPotential() {
        super(2);
        this.setRegion(0, this.getMinPosition(), 0.0, 0.0);
        this.setRegion(1, this.getEnd(0), this.getMaxPosition(), 0.5);
    }

    public StepPotential(StepPotential stepPotential) {
        super(stepPotential);
    }

    public boolean setStepPosition(double d) {
        if (d == this.getMinPosition() || d == this.getMaxPosition()) {
            throw new IllegalArgumentException("position cannot be at min or max range");
        }
        boolean bl = false;
        if (d - this.getStart(0) >= this.getMinRegionWidth() && this.getEnd(1) - d >= this.getMinRegionWidth()) {
            this.setEnd(0, d);
            this.setStart(1, d);
            this.validateRegions();
            bl = true;
        }
        return bl;
    }

    public double getStepPosition() {
        return this.getStart(1);
    }
}

