/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumtunneling.model;

import edu.colorado.phet.quantumtunneling.enums.Direction;
import edu.colorado.phet.quantumtunneling.model.AbstractPotential;
import edu.colorado.phet.quantumtunneling.model.IWavePacketSolver;
import edu.colorado.phet.quantumtunneling.model.WavePacket;
import edu.colorado.phet.quantumtunneling.util.LightweightComplex;

public class RichardsonSolver
implements IWavePacketSolver {
    private static boolean PRINT_DEBUG = false;
    private static final double[] DAMPING_COEFFICIENTS = new double[]{0.001, 0.005, 0.01, 0.025, 0.05, 0.075, 0.1, 0.15, 0.3, 0.5, 0.7, 0.85, 0.9, 0.925, 0.95, 0.975, 0.99, 0.995, 0.999};
    private WavePacket _wavePacket;
    private double _mass;
    private double _hbar;
    private double _dx;
    private double _dt;
    private int _steps;
    private double[] _positions;
    private LightweightComplex[] _Psi;
    private LightweightComplex[] _EtoV;
    private LightweightComplex _alpha;
    private LightweightComplex _beta;
    private int _thresholdStart;
    private int _thresholding;
    private boolean _isZero;

    public RichardsonSolver(WavePacket wavePacket) {
        this._wavePacket = wavePacket;
        this._mass = 5.68563;
        this._hbar = 0.658212;
        this._steps = 40;
        this._dx = 1.0;
        this._dt = 0.0025;
        this.update();
    }

    public double[] getPositionValues() {
        return this._positions;
    }

    public LightweightComplex[] getWaveFunctionValues() {
        return this._Psi;
    }

    public void setDx(double d) {
        this._dx = d;
        this.update();
    }

    public double getDx() {
        return this._dx;
    }

    public void setDt(double d) {
        this._dt = d;
        this.update();
    }

    public double getDt() {
        return this._dt;
    }

    public void setHbar(double d) {
        this._hbar = d;
        this.update();
    }

    public double getHbar() {
        return this._hbar;
    }

    public void setMass(double d) {
        this._mass = d;
        this.update();
    }

    public double getMass() {
        return this._mass;
    }

    public void setSteps(int n) {
        this._steps = n;
        this.update();
    }

    public int getSteps() {
        return this._steps;
    }

    public void update() {
        this.reset();
    }

    private void reset() {
        if (!this._wavePacket.isInitialized()) {
            return;
        }
        this._isZero = this.isSolutionZero();
        double d = this._wavePacket.getWidth();
        double d2 = this._wavePacket.getCenter();
        double d3 = this._wavePacket.getTotalEnergy().getEnergy();
        double d4 = this._wavePacket.getPotentialEnergy().getEnergyAt(d2);
        double d5 = Math.sqrt(2.0 * (d3 - d4) / this._mass);
        if (this._wavePacket.getDirection() == Direction.RIGHT_TO_LEFT) {
            d5 *= -1.0;
        }
        AbstractPotential abstractPotential = this._wavePacket.getPotentialEnergy();
        int n = abstractPotential.getNumberOfRegions();
        int n2 = (int)((abstractPotential.getEnd(n - 1) - abstractPotential.getStart(0)) / this._dx) + 1;
        int n3 = (int)((double)n2 * 2.5);
        int n4 = 10 * DAMPING_COEFFICIENTS.length;
        double d6 = abstractPotential.getStart(0) - this._dx * (double)n3 - this._dx * (double)n4;
        double d7 = abstractPotential.getEnd(n - 1) + this._dx * (double)n3 + this._dx * (double)n4;
        int n5 = (int)((d7 - d6) / this._dx) + 1;
        if (PRINT_DEBUG) {
            System.out.print("DEBUG: RichardsonSolver.reset ");
            System.out.print(" samples=" + n5);
            System.out.print(" visible=" + n2);
            System.out.print(" extra=" + 2 * n3);
            System.out.print(" damped=" + 2 * n4);
            System.out.print(" minX=" + d6 + " maxX=" + d7 + " dx=" + this._dx);
            System.out.println();
        }
        this._thresholdStart = n3 + n4 - 1;
        this._thresholding = n5 - n3 - n4 - 1;
        double d8 = this._hbar * this._dt / (this._mass * this._dx * this._dx);
        this._alpha = new LightweightComplex(0.5 * (1.0 + Math.cos(d8 / 2.0)), -0.5 * Math.sin(d8 / 2.0));
        this._beta = new LightweightComplex(Math.sin(d8 / 4.0) * Math.sin(d8 / 4.0), 0.5 * Math.sin(d8 / 2.0));
        this._positions = new double[n5];
        this._Psi = new LightweightComplex[n5];
        this._EtoV = new LightweightComplex[n5];
        LightweightComplex lightweightComplex = new LightweightComplex(1.0 / (Math.pow(Math.PI, 0.25) * Math.sqrt(d)), 0.0);
        for (int i = 0; i < n5; ++i) {
            double d9;
            this._positions[i] = d9 = d6 + (double)i * this._dx;
            if (this._isZero) {
                this._Psi[i] = new LightweightComplex(0.0, 0.0);
                this._EtoV[i] = new LightweightComplex(0.0, 0.0);
                continue;
            }
            double d10 = Math.exp(-((d9 - d2) / d) * ((d9 - d2) / d) / 2.0);
            this._Psi[i] = new LightweightComplex(d10 * Math.cos(this._mass * d5 * (d9 - d2) / this._hbar), d10 * Math.sin(this._mass * d5 * (d9 - d2) / this._hbar));
            this._Psi[i].multiply(lightweightComplex);
            double d11 = this.getPotentialEnergy(d9) * this._dt / this._hbar;
            this._EtoV[i] = new LightweightComplex(Math.cos(d11), -Math.sin(d11));
        }
    }

    protected double getPotentialEnergy(double d) {
        return this._wavePacket.getPotentialEnergy().getEnergyAt(d);
    }

    public void propagate() {
        this.propagate(this._steps);
    }

    private void propagate(int n) {
        double d = this._alpha._real;
        double d2 = this._alpha._imaginary;
        double d3 = this._beta._real;
        double d4 = this._beta._imaginary;
        int n2 = this._Psi.length;
        for (int i = 0; i < n; ++i) {
            double d5;
            double d6;
            double d7;
            double d8;
            double d9;
            double d10;
            double d11;
            double d12;
            int n3;
            for (n3 = 0; n3 < n2 - 1; n3 += 2) {
                d12 = this._Psi[n3]._real;
                d11 = this._Psi[n3]._imaginary;
                d10 = this._Psi[n3 + 1]._real;
                d9 = this._Psi[n3 + 1]._imaginary;
                d8 = d * d12 - d2 * d11;
                d7 = d * d11 + d2 * d12;
                d6 = d3 * d10 - d4 * d9;
                d5 = d3 * d9 + d4 * d10;
                this._Psi[n3]._real = d8 + d6;
                this._Psi[n3]._imaginary = d7 + d5;
                d8 = d * d10 - d2 * d9;
                d7 = d * d9 + d2 * d10;
                d6 = d3 * d12 - d4 * d11;
                d5 = d3 * d11 + d4 * d12;
                this._Psi[n3 + 1]._real = d8 + d6;
                this._Psi[n3 + 1]._imaginary = d7 + d5;
            }
            for (n3 = 1; n3 < n2 - 1; n3 += 2) {
                d12 = this._Psi[n3]._real;
                d11 = this._Psi[n3]._imaginary;
                d10 = this._Psi[n3 + 1]._real;
                d9 = this._Psi[n3 + 1]._imaginary;
                d8 = d * d12 - d2 * d11;
                d7 = d * d11 + d2 * d12;
                d6 = d3 * d10 - d4 * d9;
                d5 = d3 * d9 + d4 * d10;
                this._Psi[n3]._real = d8 + d6;
                this._Psi[n3]._imaginary = d7 + d5;
                d8 = d * d10 - d2 * d9;
                d7 = d * d9 + d2 * d10;
                d6 = d3 * d12 - d4 * d11;
                d5 = d3 * d11 + d4 * d12;
                this._Psi[n3 + 1]._real = d8 + d6;
                this._Psi[n3 + 1]._imaginary = d7 + d5;
            }
            d12 = this._Psi[n2 - 1]._real;
            d11 = this._Psi[n2 - 1]._imaginary;
            d10 = this._Psi[0]._real;
            d9 = this._Psi[0]._imaginary;
            d8 = d * d12 - d2 * d11;
            d7 = d * d11 + d2 * d12;
            d6 = d3 * d10 - d4 * d9;
            d5 = d3 * d9 + d4 * d10;
            this._Psi[n2 - 1]._real = d8 + d6;
            this._Psi[n2 - 1]._imaginary = d7 + d5;
            d8 = d * d10 - d2 * d9;
            d7 = d * d9 + d2 * d10;
            d6 = d3 * d12 - d4 * d11;
            d5 = d3 * d11 + d4 * d12;
            this._Psi[0]._real = d8 + d6;
            this._Psi[0]._imaginary = d7 + d5;
            for (n3 = 0; n3 < n2; ++n3) {
                d12 = this._Psi[n3]._real;
                d11 = this._Psi[n3]._imaginary;
                d10 = this._EtoV[n3]._real;
                d9 = this._EtoV[n3]._imaginary;
                this._Psi[n3]._real = d12 * d10 - d11 * d9;
                this._Psi[n3]._imaginary = d12 * d9 + d11 * d10;
            }
            d12 = this._Psi[n2 - 1]._real;
            d11 = this._Psi[n2 - 1]._imaginary;
            d10 = this._Psi[0]._real;
            d9 = this._Psi[0]._imaginary;
            d8 = d * d12 - d2 * d11;
            d7 = d * d11 + d2 * d12;
            d6 = d3 * d10 - d4 * d9;
            d5 = d3 * d9 + d4 * d10;
            this._Psi[n2 - 1]._real = d8 + d6;
            this._Psi[n2 - 1]._imaginary = d7 + d5;
            d8 = d * d10 - d2 * d9;
            d7 = d * d9 + d2 * d10;
            d6 = d3 * d12 - d4 * d11;
            d5 = d3 * d11 + d4 * d12;
            this._Psi[0]._real = d8 + d6;
            this._Psi[0]._imaginary = d7 + d5;
            for (n3 = 1; n3 < n2 - 1; n3 += 2) {
                d12 = this._Psi[n3]._real;
                d11 = this._Psi[n3]._imaginary;
                d10 = this._Psi[n3 + 1]._real;
                d9 = this._Psi[n3 + 1]._imaginary;
                d8 = d * d12 - d2 * d11;
                d7 = d * d11 + d2 * d12;
                d6 = d3 * d10 - d4 * d9;
                d5 = d3 * d9 + d4 * d10;
                this._Psi[n3]._real = d8 + d6;
                this._Psi[n3]._imaginary = d7 + d5;
                d8 = d * d10 - d2 * d9;
                d7 = d * d9 + d2 * d10;
                d6 = d3 * d12 - d4 * d11;
                d5 = d3 * d11 + d4 * d12;
                this._Psi[n3 + 1]._real = d8 + d6;
                this._Psi[n3 + 1]._imaginary = d7 + d5;
            }
            for (n3 = 0; n3 < n2 - 1; n3 += 2) {
                d12 = this._Psi[n3]._real;
                d11 = this._Psi[n3]._imaginary;
                d10 = this._Psi[n3 + 1]._real;
                d9 = this._Psi[n3 + 1]._imaginary;
                d8 = d * d12 - d2 * d11;
                d7 = d * d11 + d2 * d12;
                d6 = d3 * d10 - d4 * d9;
                d5 = d3 * d9 + d4 * d10;
                this._Psi[n3]._real = d8 + d6;
                this._Psi[n3]._imaginary = d7 + d5;
                d8 = d * d10 - d2 * d9;
                d7 = d * d9 + d2 * d10;
                d6 = d3 * d12 - d4 * d11;
                d5 = d3 * d11 + d4 * d12;
                this._Psi[n3 + 1]._real = d8 + d6;
                this._Psi[n3 + 1]._imaginary = d7 + d5;
            }
            this.applyDamping();
        }
        this.applyZeroThresholding();
    }

    private void applyDamping() {
        int n = 10 * DAMPING_COEFFICIENTS.length;
        if (this._Psi.length > n) {
            for (int i = 0; i < n; ++i) {
                double d = DAMPING_COEFFICIENTS[i / 10];
                this._Psi[i]._real *= d;
                this._Psi[i]._imaginary *= d;
                this._Psi[this._Psi.length - i - 1]._real *= d;
                this._Psi[this._Psi.length - i - 1]._imaginary *= d;
            }
        }
    }

    private void applyZeroThresholding() {
        if (!this._isZero) {
            int n;
            boolean bl = false;
            for (n = this._thresholdStart; n < this._thresholding; ++n) {
                if (!(Math.abs(this._Psi[n]._real) > 0.02) && !(Math.abs(this._Psi[n]._imaginary) > 0.02)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                for (n = 0; n < this._Psi.length; ++n) {
                    this._Psi[n]._real = 0.0;
                    this._Psi[n]._imaginary = 0.0;
                }
                this._isZero = true;
                if (PRINT_DEBUG) {
                    System.out.println("DEBUG: zero thresholding has been applied to wave function");
                }
            }
        }
    }

    protected boolean isSolutionZero() {
        int n;
        AbstractPotential abstractPotential;
        double d;
        double d2 = this._wavePacket.getTotalEnergy().getEnergy();
        return d2 < (d = (abstractPotential = this._wavePacket.getPotentialEnergy()).getEnergy(n = abstractPotential.getRegionIndexAt(this._wavePacket.getCenter())));
    }
}

