/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumtunneling.model;

import edu.colorado.phet.common.phetcommon.math.Complex;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.model.clock.ClockListener;
import edu.colorado.phet.quantumtunneling.enums.Direction;
import edu.colorado.phet.quantumtunneling.model.AbstractPlaneSolver;
import edu.colorado.phet.quantumtunneling.model.AbstractPotential;
import edu.colorado.phet.quantumtunneling.model.AbstractWave;
import edu.colorado.phet.quantumtunneling.model.SolverFactory;
import edu.colorado.phet.quantumtunneling.model.TotalEnergy;
import edu.colorado.phet.quantumtunneling.model.WaveFunctionSolution;
import java.util.Observable;
import java.util.Observer;

public class PlaneWave
extends AbstractWave
implements ClockListener,
Observer {
    private TotalEnergy _te = null;
    private AbstractPotential _pe = null;
    private AbstractPlaneSolver _solver = null;
    private Direction _direction = Direction.LEFT_TO_RIGHT;
    private boolean _enabled = true;
    private double _time = 0.0;
    private boolean _measureEnabled = false;

    public boolean isInitialized() {
        return this._te != null && this._pe != null && this._solver != null;
    }

    public double getReflectionProbability() {
        double d = -1.0;
        if (this._solver != null) {
            d = this._solver.getReflectionProbability();
        }
        return d;
    }

    public void setEnabled(boolean bl) {
        if (bl != this._enabled) {
            this._enabled = bl;
            this.updateSolver();
            this.notifyObservers();
        }
    }

    private double getTime() {
        return this._time;
    }

    public void setTotalEnergy(TotalEnergy totalEnergy) {
        if (this._te != null) {
            this._te.deleteObserver(this);
        }
        this._te = totalEnergy;
        this._te.addObserver(this);
        this.updateSolver();
        this.notifyObservers();
    }

    public void setPotentialEnergy(AbstractPotential abstractPotential) {
        if (this._pe != null) {
            this._pe.deleteObserver(this);
        }
        this._pe = abstractPotential;
        this._pe.addObserver(this);
        this.updateSolver();
        this.notifyObservers();
    }

    public AbstractPotential getPotentialEnergy() {
        return this._pe;
    }

    public void setDirection(Direction direction) {
        this._direction = direction;
        if (this._solver != null) {
            this._solver.setDirection(direction);
        }
    }

    public Direction getDirection() {
        return this._direction;
    }

    public WaveFunctionSolution solveWaveFunction(double d) {
        WaveFunctionSolution waveFunctionSolution = null;
        if (this._solver != null) {
            double d2 = this.getTime();
            waveFunctionSolution = this._measureEnabled ? new WaveFunctionSolution(d, d2, Complex.ZERO, Complex.ZERO) : this._solver.solve(d, d2);
        }
        return waveFunctionSolution;
    }

    private void updateSolver() {
        if (this._enabled && this._pe != null && this._te != null) {
            this._solver = SolverFactory.createSolver(this._te, this._pe, this._direction);
        }
    }

    public void setMeasureEnabled(boolean bl) {
        if (bl != this._measureEnabled) {
            this._measureEnabled = bl;
            this.notifyObservers();
        }
    }

    public boolean isSolutionZero(TotalEnergy totalEnergy, AbstractPotential abstractPotential) {
        return AbstractPlaneSolver.isSolutionZero(totalEnergy, abstractPotential, this._direction);
    }

    public void update(Observable observable, Object object) {
        if (this._enabled) {
            this._solver.update();
            this.notifyObservers();
        }
    }

    public void clockTicked(ClockEvent clockEvent) {
    }

    public void clockStarted(ClockEvent clockEvent) {
    }

    public void clockPaused(ClockEvent clockEvent) {
    }

    public void simulationTimeChanged(ClockEvent clockEvent) {
        if (this._enabled && this._te != null && this._pe != null) {
            this._time = clockEvent.getSimulationTime();
            this.notifyObservers();
        }
    }

    public void simulationTimeReset(ClockEvent clockEvent) {
    }
}

