/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumtunneling.model;

public class EigenstateSolver {
    private double[] v;
    private double hb;
    private double xmin;
    private double xmax;
    private int n;

    public EigenstateSolver(double d, double d2, double d3, int n, PotentialEvaluator potentialEvaluator) {
        this.hb = d;
        this.xmin = d2;
        this.xmax = d3;
        this.n = n;
        this.v = this.calculatePotential(potentialEvaluator);
    }

    public double getEnergy(int n) throws EigenstateException {
        return this.calculateEnergy(n);
    }

    private double[] calculatePotential(PotentialEvaluator potentialEvaluator) {
        double[] dArray = new double[this.n];
        double d = (this.xmax - this.xmin) / (double)(this.n - 1);
        for (int i = 1; i < this.n - 1; ++i) {
            double d2 = this.xmin + (double)i * d;
            dArray[i] = potentialEvaluator.evaluate(d2);
        }
        return dArray;
    }

    private double calculateEnergy(int n) throws EigenstateException {
        int n2;
        Tester tester = null;
        Tester tester2 = null;
        Tester tester3 = null;
        double d = 0.0;
        double d2 = this.hb * (double)(n + 1) * (double)(n + 1) * 10.0 / ((this.xmax - this.xmin) * (this.xmax - this.xmin));
        for (n2 = 0; n2 < 100 && !(tester2 = this.integrate(d2 *= 2.0)).isupper(n); ++n2) {
        }
        if (n2 == 100) {
            throw new EigenstateException("Upper bound not found, node=" + n);
        }
        double d3 = -this.hb * (double)(n + 1) * (double)(n + 1) * 10.0 / ((this.xmax - this.xmin) * (this.xmax - this.xmin));
        for (n2 = 0; n2 < 100 && (tester3 = this.integrate(d3 *= 2.0)).isupper(n); ++n2) {
        }
        if (n2 == 100) {
            throw new EigenstateException("Lower bound not found, node=" + n);
        }
        for (n2 = 0; n2 < 100 && tester3.node != tester2.node; ++n2) {
            d = 0.5 * (d2 + d3);
            tester = this.integrate(d);
            if (tester.isupper(n)) {
                d2 = d;
                tester2 = tester;
                continue;
            }
            d3 = d;
            tester3 = tester;
        }
        if (n2 == 100) {
            this.warn("No convergence in binary chop, node=" + n);
            return d;
        }
        for (n2 = 0; n2 < 100 && Math.abs(tester2.alogd - tester3.alogd) > 1.0E-10; ++n2) {
            d = d2 - (d2 - d3) * tester2.alogd / (tester3.alogd - tester2.alogd);
            if (d > d2 || d < d3) {
                d = 0.5 * (d2 + d3);
            }
            if ((tester = this.integrate(d)).isupper(n)) {
                d2 = d;
                tester2 = tester;
                continue;
            }
            d3 = d;
            tester3 = tester;
        }
        if (n2 == 100) {
            this.warn("No convergence in interpolation, node=" + n);
            return d;
        }
        return d;
    }

    private Tester integrate(double d) {
        double d2;
        int n;
        double d3 = 1.0 / this.hb;
        int n2 = (int)((double)this.n * 0.53);
        double d4 = (this.xmax - this.xmin) / (double)(this.n - 1);
        double d5 = d4 * d4 / 12.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = d4;
        double d9 = 0.0;
        double d10 = d4;
        int n3 = 0;
        double d11 = 0.0;
        double d12 = d3 * (this.v[1] - d);
        for (n = 2; n <= n2 + 1; ++n) {
            d6 = d7;
            d7 = d8;
            d2 = d11;
            d11 = d12;
            d12 = d3 * (this.v[n] - d);
            d8 = (d7 * (2.0 + 10.0 * d5 * d11) - d6 * (1.0 - d5 * d2)) / (1.0 - d5 * d12);
            if (n > n2 || !(d8 < 0.0 && d7 > 0.0) && (!(d8 > 0.0) || !(d7 < 0.0))) continue;
            ++n3;
        }
        double d13 = (d8 - d6) / (2.0 * d4 * d7);
        d7 = d9;
        d8 = d10;
        d11 = 0.0;
        d12 = d3 * (this.v[this.n - 2] - d);
        for (n = this.n - 3; n >= n2 - 1; --n) {
            d6 = d7;
            d7 = d8;
            d2 = d11;
            d11 = d12;
            d12 = d3 * (this.v[n] - d);
            d8 = (d7 * (2.0 + 10.0 * d5 * d11) - d6 * (1.0 - d5 * d2)) / (1.0 - d5 * d12);
            if (n < n2 || !(d8 < 0.0 && d7 > 0.0) && (!(d8 > 0.0) || !(d7 < 0.0))) continue;
            ++n3;
        }
        return new Tester(n3, d13 += (d8 - d6) / (2.0 * d4 * d7));
    }

    private void warn(String string) {
    }

    public static class EigenstateException
    extends Exception {
        public EigenstateException(String string) {
            super(string);
        }
    }

    public static interface PotentialEvaluator {
        public double evaluate(double var1);
    }

    private static class Tester {
        public int node;
        public double alogd;

        public Tester(int n, double d) {
            this.node = n;
            this.alogd = d;
        }

        public boolean isupper(int n) {
            return this.node > n || this.node == n && this.alogd < 0.0;
        }
    }
}

