/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumtunneling.model;

import edu.colorado.phet.common.phetcommon.math.Complex;
import edu.colorado.phet.common.phetcommon.math.MutableComplex;
import edu.colorado.phet.quantumtunneling.enums.Direction;
import edu.colorado.phet.quantumtunneling.model.AbstractPotential;
import edu.colorado.phet.quantumtunneling.model.TotalEnergy;
import edu.colorado.phet.quantumtunneling.model.WaveFunctionSolution;

public abstract class AbstractPlaneSolver {
    private TotalEnergy _te;
    private AbstractPotential _pe;
    private Direction _direction;
    private Complex[] _k;

    public AbstractPlaneSolver(TotalEnergy totalEnergy, AbstractPotential abstractPotential, Direction direction) {
        this._te = totalEnergy;
        this._pe = abstractPotential;
        this._direction = direction;
        this._k = new Complex[abstractPotential.getNumberOfRegions()];
        this.update();
    }

    public abstract WaveFunctionSolution solve(double var1, double var3);

    protected TotalEnergy getTotalEnergy() {
        return this._te;
    }

    protected AbstractPotential getPotentialEnergy() {
        return this._pe;
    }

    public void setDirection(Direction direction) {
        this._direction = direction;
        this.update();
    }

    protected boolean isLeftToRight() {
        return this._direction == Direction.LEFT_TO_RIGHT;
    }

    protected boolean isRightToLeft() {
        return this._direction == Direction.RIGHT_TO_LEFT;
    }

    public double getReflectionProbability() {
        double d = -1.0;
        if (!this.isSolutionZero()) {
            Complex complex = this.getB();
            d = complex.getReal() * complex.getReal() + complex.getImaginary() * complex.getImaginary();
            d = Math.min(1.0, d);
        }
        return d;
    }

    protected abstract Complex getB();

    protected double getBoundary(int n, int n2) {
        if (n + 1 != n2) {
            throw new IllegalArgumentException("regionIndex1 + 1 != regionIndex2");
        }
        if (this.isLeftToRight()) {
            return this._pe.getEnd(n);
        }
        return this._pe.getStart(this.flipRegionIndex(n));
    }

    protected Complex getK(int n) {
        if (n < 0 || n > this._k.length - 1) {
            throw new IndexOutOfBoundsException("regionIndex out of range: " + n);
        }
        if (this.isLeftToRight()) {
            return this._k[n];
        }
        return this._k[this.flipRegionIndex(n)].getMultiply(-1.0);
    }

    protected int flipRegionIndex(int n) {
        return this.getPotentialEnergy().getNumberOfRegions() - 1 - n;
    }

    public void update() {
        this.updateK();
        this.updateCoefficients();
    }

    private void updateK() {
        double d = this.getTotalEnergy().getEnergy();
        int n = this.getPotentialEnergy().getNumberOfRegions();
        for (int i = 0; i < n; ++i) {
            double d2 = this.getPotentialEnergy().getEnergy(i);
            this._k[i] = AbstractPlaneSolver.solveK(d, d2);
        }
    }

    protected abstract void updateCoefficients();

    protected boolean isSolutionZero() {
        return AbstractPlaneSolver.isSolutionZero(this.getTotalEnergy(), this.getPotentialEnergy(), this._direction);
    }

    public static boolean isSolutionZero(TotalEnergy totalEnergy, AbstractPotential abstractPotential, Direction direction) {
        boolean bl = false;
        double d = totalEnergy.getEnergy();
        int n = abstractPotential.getNumberOfRegions() - 1;
        if (direction == Direction.LEFT_TO_RIGHT && d < abstractPotential.getEnergy(0)) {
            bl = true;
        } else if (direction == Direction.RIGHT_TO_LEFT && d < abstractPotential.getEnergy(n)) {
            bl = true;
        }
        return bl;
    }

    private static Complex solveK(double d, double d2) {
        double d3 = Math.sqrt(26.246838449407836 * Math.abs(d - d2));
        double d4 = 0.0;
        double d5 = 0.0;
        if (d >= d2) {
            d4 = d3;
        } else {
            d5 = d3;
        }
        return new Complex(d4, d5);
    }

    protected static Complex commonTerm1(Complex complex, double d) {
        MutableComplex mutableComplex = new MutableComplex();
        mutableComplex.setValue(Complex.I);
        mutableComplex.multiply(complex);
        mutableComplex.multiply(d);
        mutableComplex.exp();
        return mutableComplex;
    }

    protected static Complex commonTerm2(Complex complex, double d) {
        MutableComplex mutableComplex = new MutableComplex();
        mutableComplex.setValue(Complex.I);
        mutableComplex.multiply(complex);
        mutableComplex.multiply(-d);
        mutableComplex.exp();
        return mutableComplex;
    }

    protected static Complex commonTerm3(TotalEnergy totalEnergy, double d) {
        double d2 = totalEnergy.getEnergy();
        MutableComplex mutableComplex = new MutableComplex();
        mutableComplex.setValue(Complex.I);
        mutableComplex.multiply(-1.0 * d2 * d / 0.658212);
        mutableComplex.exp();
        return mutableComplex;
    }
}

