/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumtunneling.control;

import edu.colorado.phet.common.phetcommon.application.PaintImmediateDialog;
import edu.colorado.phet.common.phetcommon.view.controls.DoubleSpinner;
import edu.colorado.phet.common.phetcommon.view.util.EasyGridBagLayout;
import edu.colorado.phet.common.phetcommon.view.util.SwingUtils;
import edu.colorado.phet.quantumtunneling.model.RichardsonSolver;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.DecimalFormat;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class RichardsonControlsDialog
extends PaintImmediateDialog {
    private static final Dimension SPINNER_SIZE = new Dimension(125, 25);
    private RichardsonSolver _solver;
    private DoubleSpinner _massSpinner;
    private DoubleSpinner _hbarSpinner;
    private DoubleSpinner _dtSpinner;
    private DoubleSpinner _stepsSpinner;
    private DoubleSpinner _dxSpinner;

    public RichardsonControlsDialog(Frame frame, RichardsonSolver richardsonSolver) {
        super(frame, "Richardson Controls");
        this._solver = richardsonSolver;
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        Object object = new JLabel("<html>Changes are only visible while the clock is running.<br>Reset All does not apply to these parameters.</html>");
        ((JComponent)object).setForeground(Color.RED);
        JLabel jLabel = new JLabel("mass:");
        this._massSpinner = new DoubleSpinner(this._solver.getMass(), 0.01, 1000.0, 0.01, "0.00", SPINNER_SIZE);
        JLabel jLabel2 = new JLabel("<html>eV/c<sup>2</sup></html>");
        DecimalFormat decimalFormat = new DecimalFormat("0.00");
        JLabel jLabel3 = new JLabel("(" + decimalFormat.format(0.01) + "-" + decimalFormat.format(1000.0) + ")");
        JLabel jLabel4 = new JLabel("hbar:");
        this._hbarSpinner = new DoubleSpinner(this._solver.getHbar(), 0.001, 100.0, 0.001, "0.000", SPINNER_SIZE);
        JLabel jLabel5 = new JLabel("eV fs");
        DecimalFormat decimalFormat2 = new DecimalFormat("0.000");
        JLabel jLabel6 = new JLabel("(" + decimalFormat2.format(0.001) + "-" + decimalFormat2.format(100.0) + ")");
        JLabel jLabel7 = new JLabel("dx:");
        this._dxSpinner = new DoubleSpinner(this._solver.getDx(), 1.0E-4, 1.0, 1.0E-4, "0.0000", SPINNER_SIZE);
        JLabel jLabel8 = new JLabel("nm");
        DecimalFormat decimalFormat3 = new DecimalFormat("0.0000");
        JLabel jLabel9 = new JLabel("(" + decimalFormat3.format(1.0E-4) + "-" + decimalFormat3.format(1.0) + ")");
        JLabel jLabel10 = new JLabel("dt:");
        this._dtSpinner = new DoubleSpinner(this._solver.getDt(), 1.0E-4, 10.0, 1.0E-4, "0.0000", SPINNER_SIZE);
        JLabel jLabel11 = new JLabel("fs");
        DecimalFormat decimalFormat4 = new DecimalFormat("0.0000");
        JLabel jLabel12 = new JLabel("(" + decimalFormat4.format(1.0E-4) + "-" + decimalFormat4.format(10.0) + ")");
        JLabel jLabel13 = new JLabel("steps per tick:");
        this._stepsSpinner = new DoubleSpinner(this._solver.getSteps(), 1.0, 100.0, 1.0, "0", SPINNER_SIZE);
        DecimalFormat decimalFormat5 = new DecimalFormat("0");
        JLabel jLabel14 = new JLabel("(" + decimalFormat5.format(1L) + "-" + decimalFormat5.format(100L) + ")");
        EasyGridBagLayout easyGridBagLayout = new EasyGridBagLayout(jPanel);
        jPanel.setLayout(easyGridBagLayout);
        int n = 0;
        easyGridBagLayout.addAnchoredComponent((Component)object, n, 0, 4, 2, 17);
        ++n;
        easyGridBagLayout.addAnchoredComponent(jLabel, ++n, 0, 13);
        easyGridBagLayout.addAnchoredComponent(this._massSpinner, n, 1, 17);
        easyGridBagLayout.addAnchoredComponent(jLabel2, n, 2, 17);
        easyGridBagLayout.addAnchoredComponent(jLabel3, n, 3, 17);
        easyGridBagLayout.addAnchoredComponent(jLabel4, ++n, 0, 13);
        easyGridBagLayout.addAnchoredComponent(this._hbarSpinner, n, 1, 17);
        easyGridBagLayout.addAnchoredComponent(jLabel5, n, 2, 17);
        easyGridBagLayout.addAnchoredComponent(jLabel6, n, 3, 17);
        easyGridBagLayout.addAnchoredComponent(jLabel7, ++n, 0, 13);
        easyGridBagLayout.addAnchoredComponent(this._dxSpinner, n, 1, 13);
        easyGridBagLayout.addAnchoredComponent(jLabel8, n, 2, 17);
        easyGridBagLayout.addAnchoredComponent(jLabel9, n, 3, 17);
        easyGridBagLayout.addAnchoredComponent(jLabel10, ++n, 0, 13);
        easyGridBagLayout.addAnchoredComponent(this._dtSpinner, n, 1, 17);
        easyGridBagLayout.addAnchoredComponent(jLabel11, n, 2, 17);
        easyGridBagLayout.addAnchoredComponent(jLabel12, n, 3, 17);
        easyGridBagLayout.addAnchoredComponent(jLabel13, ++n, 0, 13);
        easyGridBagLayout.addAnchoredComponent(this._stepsSpinner, n, 1, 17);
        easyGridBagLayout.addAnchoredComponent(jLabel14, n, 3, 17);
        ++n;
        this.getContentPane().add(jPanel);
        this.pack();
        SwingUtils.centerDialogInParent(this);
        object = new EventListener();
        this._massSpinner.addChangeListener((ChangeListener)object);
        this._hbarSpinner.addChangeListener((ChangeListener)object);
        this._dxSpinner.addChangeListener((ChangeListener)object);
        this._dtSpinner.addChangeListener((ChangeListener)object);
        this._stepsSpinner.addChangeListener((ChangeListener)object);
    }

    private void handleMassChange() {
        double d = this._massSpinner.getDoubleValue();
        if (d >= 0.01 && d <= 1000.0) {
            this._solver.setMass(d);
        } else {
            this.warnInvalidInput();
            this._massSpinner.setDoubleValue(this._solver.getMass());
        }
    }

    private void handleHbarChange() {
        double d = this._hbarSpinner.getDoubleValue();
        if (d >= 0.001 && d <= 100.0) {
            this._solver.setHbar(d);
        } else {
            this.warnInvalidInput();
            this._hbarSpinner.setDoubleValue(this._solver.getHbar());
        }
    }

    private void handleDxChange() {
        double d = this._dxSpinner.getDoubleValue();
        if (d >= 1.0E-4 && d <= 1.0) {
            this._solver.setDx(d);
        } else {
            this.warnInvalidInput();
            this._dxSpinner.setDoubleValue(this._solver.getDx());
        }
    }

    private void handleDtChange() {
        double d = this._dtSpinner.getDoubleValue();
        if (d >= 1.0E-4 && d <= 10.0) {
            this._solver.setDt(d);
        } else {
            this.warnInvalidInput();
            this._dtSpinner.setDoubleValue(this._solver.getDt());
        }
    }

    private void handleStepsChange() {
        int n = (int)this._stepsSpinner.getDoubleValue();
        if (n >= 1 && n <= 100) {
            this._solver.setSteps(n);
        } else {
            this.warnInvalidInput();
            this._stepsSpinner.setDoubleValue(this._solver.getSteps());
        }
    }

    private void warnInvalidInput() {
        Toolkit.getDefaultToolkit().beep();
    }

    private class EventListener
    implements ActionListener,
    ItemListener,
    ChangeListener {
        public void actionPerformed(ActionEvent actionEvent) {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            if (changeEvent.getSource() == RichardsonControlsDialog.this._massSpinner) {
                RichardsonControlsDialog.this.handleMassChange();
            } else if (changeEvent.getSource() == RichardsonControlsDialog.this._hbarSpinner) {
                RichardsonControlsDialog.this.handleHbarChange();
            } else if (changeEvent.getSource() == RichardsonControlsDialog.this._dxSpinner) {
                RichardsonControlsDialog.this.handleDxChange();
            } else if (changeEvent.getSource() == RichardsonControlsDialog.this._dtSpinner) {
                RichardsonControlsDialog.this.handleDtChange();
            } else if (changeEvent.getSource() == RichardsonControlsDialog.this._stepsSpinner) {
                RichardsonControlsDialog.this.handleStepsChange();
            }
        }

        public void itemStateChanged(ItemEvent itemEvent) {
        }
    }
}

