/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumtunneling.control;

import edu.colorado.phet.quantumtunneling.control.AbstractDragHandle;
import edu.colorado.phet.quantumtunneling.model.AbstractPotential;
import edu.colorado.phet.quantumtunneling.view.QTCombinedChartNode;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Observable;
import java.util.Observer;

public class RegionBoundaryDragHandle
extends AbstractDragHandle
implements Observer {
    private AbstractPotential _potentialEnergy;
    private int _regionIndex;
    private QTCombinedChartNode _chartNode;

    public RegionBoundaryDragHandle(QTCombinedChartNode qTCombinedChartNode) {
        super(0);
        this.setValueFormat("0.0");
        this._potentialEnergy = null;
        this._regionIndex = -1;
        this._chartNode = qTCombinedChartNode;
        this.addPropertyChangeListener(this);
        this.updateDragBounds();
    }

    public void cleanup() {
        if (this._potentialEnergy != null) {
            this._potentialEnergy.deleteObserver(this);
            this._potentialEnergy = null;
        }
    }

    public void setPotentialEnergy(AbstractPotential abstractPotential, int n) {
        if (this._potentialEnergy != null) {
            this._potentialEnergy.deleteObserver(this);
        }
        this._regionIndex = n;
        this._potentialEnergy = abstractPotential;
        this._potentialEnergy.addObserver(this);
        this.updatePosition();
        this.updateText();
    }

    public void updateDragBounds() {
        if (this._potentialEnergy != null) {
            double d;
            Rectangle2D rectangle2D = this._chartNode.getEnergyPlotBounds();
            double d2 = 0.0;
            double d3 = rectangle2D.getY();
            double d4 = 0.0;
            double d5 = rectangle2D.getHeight();
            double d6 = this._potentialEnergy.getMinRegionWidth();
            if (this._regionIndex == 0) {
                d = this._potentialEnergy.getStart(this._regionIndex) + d6;
                double d7 = this._potentialEnergy.getEnd(this._regionIndex + 1) - d6;
                Point2D point2D = this._chartNode.energyToNode(new Point2D.Double(d, 0.0));
                Point2D point2D2 = this._chartNode.energyToNode(new Point2D.Double(d7, 0.0));
                d2 = point2D.getX();
                d4 = point2D2.getX() - point2D.getX();
            } else {
                d = this._potentialEnergy.getEnd(this._regionIndex - 1) + d6;
                double d8 = this._potentialEnergy.getEnd(this._regionIndex + 1) - d6;
                Point2D point2D = this._chartNode.energyToNode(new Point2D.Double(d, 0.0));
                Point2D point2D3 = this._chartNode.energyToNode(new Point2D.Double(d8, 0.0));
                d2 = point2D.getX();
                d4 = point2D3.getX() - point2D.getX();
            }
            Rectangle2D rectangle2D2 = new Rectangle2D.Double(d2, d3, d4, d5);
            rectangle2D2 = this._chartNode.localToGlobal(rectangle2D2);
            this.setDragBounds(rectangle2D2);
            this.updatePosition();
        }
    }

    private void updatePosition() {
        if (this._potentialEnergy != null) {
            double d = this._potentialEnergy.getEnd(this._regionIndex);
            double d2 = this._potentialEnergy.getEnergy(this._regionIndex);
            double d3 = this._potentialEnergy.getEnergy(this._regionIndex + 1);
            double d4 = Math.min(d2, d3) + (Math.max(d2, d3) - Math.min(d2, d3)) / 2.0;
            Point2D.Double double_ = new Point2D.Double(d, d4);
            Point2D point2D = this._chartNode.energyToNode(double_);
            Point2D point2D2 = this._chartNode.localToGlobal(point2D);
            this.removePropertyChangeListener(this);
            this.setGlobalPosition(point2D2);
            this.addPropertyChangeListener(this);
        }
    }

    protected double getModelValue() {
        double d = 0.0;
        if (this._potentialEnergy != null) {
            d = this._potentialEnergy.getEnd(this._regionIndex);
        }
        return d;
    }

    protected void updateModel() {
        if (this._potentialEnergy != null) {
            this._potentialEnergy.deleteObserver(this);
            Point2D point2D = this.getGlobalPosition();
            Point2D point2D2 = this._chartNode.globalToLocal(point2D);
            Point2D point2D3 = this._chartNode.nodeToEnergy(point2D2);
            double d = point2D3.getX();
            boolean bl = this._potentialEnergy.adjustBoundary(this._regionIndex, d);
            if (!bl) {
                System.out.println("WARNINING: RegionBoundaryDragHandle.updatePotentialEnergy failed, regionIndex=" + this._regionIndex + " position=" + d);
            }
            this._potentialEnergy.addObserver(this);
        }
    }

    public void update(Observable observable, Object object) {
        if (observable == this._potentialEnergy) {
            this.updateDragBounds();
            this.updateText();
        }
    }
}

