/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumtunneling.control;

import edu.colorado.phet.common.phetcommon.application.PaintImmediateDialog;
import edu.colorado.phet.common.phetcommon.view.controls.DoubleSpinner;
import edu.colorado.phet.common.phetcommon.view.util.EasyGridBagLayout;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.phetcommon.view.util.PhetOptionPane;
import edu.colorado.phet.quantumtunneling.QTConstants;
import edu.colorado.phet.quantumtunneling.QTResources;
import edu.colorado.phet.quantumtunneling.color.QTColorScheme;
import edu.colorado.phet.quantumtunneling.control.PotentialComboBox;
import edu.colorado.phet.quantumtunneling.enums.PotentialType;
import edu.colorado.phet.quantumtunneling.model.AbstractPotential;
import edu.colorado.phet.quantumtunneling.model.BarrierPotential;
import edu.colorado.phet.quantumtunneling.model.PlaneWave;
import edu.colorado.phet.quantumtunneling.model.PotentialFactory;
import edu.colorado.phet.quantumtunneling.model.StepPotential;
import edu.colorado.phet.quantumtunneling.model.TotalEnergy;
import edu.colorado.phet.quantumtunneling.model.WavePacket;
import edu.colorado.phet.quantumtunneling.module.QTModule;
import edu.colorado.phet.quantumtunneling.view.EnergyPlot;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.ContainerOrderFocusTraversalPolicy;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.annotations.XYTextAnnotation;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.axis.TickUnitSource;
import org.jfree.chart.axis.TickUnits;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.ui.RectangleInsets;
import org.jfree.ui.TextAnchor;

public class ConfigureEnergyDialog
extends PaintImmediateDialog {
    private static final Dimension CHART_SIZE = new Dimension(450, 150);
    private static final double MIN_ENERGY = QTConstants.ENERGY_RANGE.getLowerBound();
    private static final double MAX_ENERGY = QTConstants.ENERGY_RANGE.getUpperBound();
    private static final Font AXIS_LABEL_FONT = new PhetFont(0, 16);
    private static final Font AXIS_TICK_LABEL_FONT = new PhetFont(0, 12);
    private static final Font ANNOTATION_FONT = new PhetFont(0, 14);
    private static final Dimension SPINNER_SIZE = new Dimension(65, 25);
    private TotalEnergy _totalEnergy;
    private AbstractPotential _potentialEnergy;
    private WavePacket _wavePacket;
    private PlaneWave _planeWave;
    private EnergyPlot _energyPlot;
    private JPanel _inputPanel;
    private PotentialComboBox _potentialComboBox;
    private DoubleSpinner _teSpinner;
    private ArrayList _peSpinners;
    private DoubleSpinner _stepSpinner;
    private ArrayList _widthSpinners;
    private ArrayList _positionSpinners;
    private JButton _applyButton;
    private JButton _closeButton;
    private QTModule _module;
    private EventListener _listener;
    private boolean _peChanged;
    private boolean _teChanged;
    private QTColorScheme _colorScheme;

    public ConfigureEnergyDialog(Frame frame, QTModule qTModule, TotalEnergy totalEnergy, AbstractPotential abstractPotential, WavePacket wavePacket, PlaneWave planeWave, QTColorScheme qTColorScheme) {
        super(frame);
        this._totalEnergy = new TotalEnergy(totalEnergy);
        this._potentialEnergy = PotentialFactory.clonePotentialEnergy(abstractPotential);
        this._wavePacket = wavePacket;
        this._planeWave = planeWave;
        this._colorScheme = qTColorScheme;
        this.setTitle(QTResources.getString("title.configureEnergy"));
        this.setModal(true);
        this.setResizable(false);
        this._module = qTModule;
        this._listener = new EventListener();
        this.createUI(frame);
        this.populateValues();
        this.setLocationRelativeTo(frame);
        this._peChanged = false;
        this._teChanged = false;
        this._applyButton.setEnabled(false);
    }

    public void cleanup() {
    }

    private void createUI(Frame frame) {
        JPanel jPanel = this.createChartPanel();
        this._inputPanel = new JPanel();
        this._inputPanel.add(this.createInputPanel());
        JPanel jPanel2 = this.createActionsPanel();
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)jPanel, "North");
        jPanel3.add((Component)new JSeparator(), "Center");
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.add((Component)jPanel3, "North");
        jPanel4.add((Component)this._inputPanel, "South");
        JPanel jPanel5 = new JPanel(new BorderLayout());
        jPanel5.add((Component)jPanel4, "North");
        jPanel5.add((Component)new JSeparator(), "Center");
        JPanel jPanel6 = new JPanel(new BorderLayout());
        jPanel6.add((Component)jPanel5, "North");
        jPanel6.add((Component)jPanel2, "South");
        jPanel6.setBorder(new EmptyBorder(10, 10, 0, 10));
        jPanel.setBorder(new EmptyBorder(0, 0, 5, 0));
        this._inputPanel.setBorder(new EmptyBorder(0, 0, 5, 0));
        this.getContentPane().add(jPanel6);
        this.pack();
    }

    private JPanel createChartPanel() {
        this._energyPlot = new EnergyPlot();
        this._energyPlot.setColorScheme(this._colorScheme);
        this._energyPlot.getDomainAxis().setLabelFont(AXIS_LABEL_FONT);
        this._energyPlot.getRangeAxis().setLabelFont(AXIS_LABEL_FONT);
        this._energyPlot.getDomainAxis().setTickLabelFont(AXIS_TICK_LABEL_FONT);
        this._energyPlot.getRangeAxis().setTickLabelFont(AXIS_TICK_LABEL_FONT);
        this._energyPlot.getDomainAxis().setLabelInsets(new RectangleInsets(10.0, 0.0, 0.0, 0.0));
        this._energyPlot.getRangeAxis().setLabelInsets(new RectangleInsets(0.0, 0.0, 0.0, 10.0));
        Cloneable cloneable = new TickUnits();
        cloneable.add(new NumberTickUnit(1.0, QTConstants.POSITION_TICK_FORMAT));
        this._energyPlot.getDomainAxis().setStandardTickUnits((TickUnitSource)((Object)cloneable));
        this._energyPlot.getDomainAxis().setAutoTickUnitSelection(true);
        cloneable = new TickUnits();
        cloneable.add(new NumberTickUnit(0.5, QTConstants.ENERGY_TICK_FORMAT));
        this._energyPlot.getRangeAxis().setStandardTickUnits((TickUnitSource)((Object)cloneable));
        this._energyPlot.getRangeAxis().setAutoTickUnitSelection(true);
        this._energyPlot.setTotalEnergy(this._totalEnergy);
        this._energyPlot.setPotentialEnergy(this._potentialEnergy);
        this._energyPlot.setWavePacket(this._wavePacket);
        this._energyPlot.setPlaneWave(this._planeWave);
        if (this._wavePacket.isEnabled()) {
            this._energyPlot.showWavePacket();
        } else {
            this._energyPlot.showPlaneWave();
        }
        cloneable = new JFreeChart(null, null, this._energyPlot, false);
        ChartPanel chartPanel = new ChartPanel((JFreeChart)cloneable);
        chartPanel.setPopupMenu(null);
        chartPanel.setMouseZoomable(false);
        chartPanel.setMinimumDrawWidth((int)CHART_SIZE.getWidth() - 1);
        chartPanel.setMinimumDrawHeight((int)CHART_SIZE.getHeight() - 1);
        chartPanel.setPreferredSize(CHART_SIZE);
        return chartPanel;
    }

    private JPanel createInputPanel() {
        JComponent jComponent;
        Object object;
        Object object2;
        JPanel jPanel = new JPanel();
        JComponent jComponent2 = new JLabel(QTResources.getString("label.potential"));
        this._potentialComboBox = new PotentialComboBox();
        this._potentialComboBox.setPotentialColor(this._colorScheme.getPotentialEnergyColor());
        this._potentialComboBox.addItemListener(this._listener);
        Serializable serializable = new JPanel();
        Serializable serializable2 = new EasyGridBagLayout((JPanel)serializable);
        ((Container)serializable).setLayout((LayoutManager)((Object)serializable2));
        ((EasyGridBagLayout)serializable2).addAnchoredComponent(jComponent2, 0, 1, 13);
        ((EasyGridBagLayout)serializable2).addAnchoredComponent(this._potentialComboBox, 0, 2, 17);
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)serializable, "West");
        jComponent2 = new JPanel();
        serializable = new EasyGridBagLayout((JPanel)jComponent2);
        ((EasyGridBagLayout)serializable).setMinimumWidth(1, 60);
        jComponent2.setLayout((LayoutManager)((Object)serializable));
        serializable2 = new JPanel();
        EasyGridBagLayout easyGridBagLayout = new EasyGridBagLayout((JPanel)serializable2);
        easyGridBagLayout.setMinimumWidth(0, 25);
        ((Container)serializable2).setLayout(easyGridBagLayout);
        int n = 0;
        ((EasyGridBagLayout)serializable).addComponent((Component)serializable2, 0, 0);
        JPanel jPanel2 = new JPanel();
        EasyGridBagLayout easyGridBagLayout2 = new EasyGridBagLayout(jPanel2);
        easyGridBagLayout2.setMinimumWidth(0, 25);
        jPanel2.setLayout(easyGridBagLayout2);
        int n2 = 1;
        ((EasyGridBagLayout)serializable).addComponent(jPanel2, 0, 2);
        JLabel jLabel = new JLabel(QTResources.getString("label.averageTotalEnergy"));
        this._teSpinner = new DoubleSpinner(0.0, -1.7976931348623157E308, Double.MAX_VALUE, 0.01, "0.00", SPINNER_SIZE);
        this._teSpinner.addChangeListener(this._listener);
        JLabel jLabel2 = new JLabel(QTResources.getString("units.energy"));
        easyGridBagLayout.addAnchoredComponent(jLabel, n, 0, 2, 1, 13);
        easyGridBagLayout.addComponent(this._teSpinner, n, 2);
        easyGridBagLayout.addComponent(jLabel2, n, 3);
        char c = QTResources.getChar("char.potentialEnergy", 'P');
        jLabel2 = new JLabel(QTResources.getString("label.potentialEnergy"));
        easyGridBagLayout.addAnchoredComponent(jLabel2, ++n, 0, 4, 1, 17);
        ++n;
        int n3 = this._potentialEnergy.getNumberOfRegions();
        this._peSpinners = new ArrayList();
        for (int i = 0; i < n3; ++i) {
            String string = String.valueOf(c) + String.valueOf(i + 1) + ":";
            object2 = new JLabel(string);
            object = new DoubleSpinner(0.0, -1.7976931348623157E308, Double.MAX_VALUE, 0.01, "0.00", SPINNER_SIZE);
            ((JSpinner)object).addChangeListener(this._listener);
            this._peSpinners.add(object);
            jComponent = new JLabel(QTResources.getString("units.energy"));
            easyGridBagLayout.addAnchoredComponent((Component)object2, n, 1, 13);
            easyGridBagLayout.addAnchoredComponent((Component)object, n, 2, 13);
            easyGridBagLayout.addAnchoredComponent(jComponent, n, 3, 17);
            ++n;
        }
        this._stepSpinner = null;
        if (this._potentialEnergy instanceof StepPotential) {
            jLabel2 = new JLabel(QTResources.getString("label.stepPosition"));
            this._stepSpinner = new DoubleSpinner(0.0, -1.7976931348623157E308, Double.MAX_VALUE, 0.1, "0.0", SPINNER_SIZE);
            this._stepSpinner.addChangeListener(this._listener);
            JLabel jLabel3 = new JLabel(QTResources.getString("units.position"));
            easyGridBagLayout.addAnchoredComponent(jLabel2, n, 0, 2, 1, 13);
            easyGridBagLayout.addComponent(this._stepSpinner, n, 2);
            easyGridBagLayout.addComponent(jLabel3, n, 3);
            ++n;
        }
        this._widthSpinners = null;
        this._positionSpinners = null;
        char c2 = QTResources.getChar("char.barrier", 'B');
        if (this._potentialEnergy instanceof BarrierPotential) {
            JComponent jComponent3;
            n3 = ((BarrierPotential)this._potentialEnergy).getNumberOfBarriers();
            this._positionSpinners = new ArrayList();
            JLabel jLabel4 = new JLabel(QTResources.getString("label.barrierPosition"));
            easyGridBagLayout2.addAnchoredComponent(jLabel4, n2, 0, 4, 1, 17);
            ++n2;
            for (int i = 0; i < n3; ++i) {
                object2 = String.valueOf(c2) + String.valueOf(i + 1) + ":";
                object = new JLabel((String)object2);
                jComponent = new DoubleSpinner(0.0, -1.7976931348623157E308, Double.MAX_VALUE, 0.1, "0.0", SPINNER_SIZE);
                ((JSpinner)jComponent).addChangeListener(this._listener);
                this._positionSpinners.add(jComponent);
                jComponent3 = new JLabel(QTResources.getString("units.position"));
                easyGridBagLayout2.addAnchoredComponent((Component)object, n2, 1, 13);
                easyGridBagLayout2.addAnchoredComponent(jComponent, n2, 2, 13);
                easyGridBagLayout2.addAnchoredComponent(jComponent3, n2, 3, 17);
                ++n2;
            }
            this._widthSpinners = new ArrayList();
            JLabel jLabel5 = new JLabel(QTResources.getString("label.barrierWidth"));
            easyGridBagLayout2.addAnchoredComponent(jLabel5, n2, 0, 4, 1, 17);
            ++n2;
            for (int i = 0; i < n3; ++i) {
                object = String.valueOf(c2) + String.valueOf(i + 1) + ":";
                jComponent = new JLabel((String)object);
                jComponent3 = new DoubleSpinner(0.0, -1.7976931348623157E308, Double.MAX_VALUE, 0.1, "0.0", SPINNER_SIZE);
                ((JSpinner)jComponent3).addChangeListener(this._listener);
                this._widthSpinners.add(jComponent3);
                JLabel jLabel6 = new JLabel(QTResources.getString("units.position"));
                easyGridBagLayout2.addAnchoredComponent(jComponent, n2, 1, 13);
                easyGridBagLayout2.addAnchoredComponent(jComponent3, n2, 2, 13);
                easyGridBagLayout2.addAnchoredComponent(jLabel6, n2, 3, 17);
                ++n2;
            }
        }
        serializable = new JPanel(new BorderLayout());
        ((Container)serializable).add(jPanel, "North");
        ((Container)serializable).add(jComponent2, "Center");
        ((Container)serializable).setFocusTraversalPolicy(new ContainerOrderFocusTraversalPolicy());
        return serializable;
    }

    private JPanel createActionsPanel() {
        this._applyButton = new JButton(QTResources.getString("button.apply"));
        this._applyButton.addActionListener(this._listener);
        this._closeButton = new JButton(QTResources.getString("button.close"));
        this._closeButton.addActionListener(this._listener);
        JPanel jPanel = new JPanel(new GridLayout(1, 2, 10, 0));
        jPanel.add(this._applyButton);
        jPanel.add(this._closeButton);
        JPanel jPanel2 = new JPanel(new FlowLayout());
        jPanel2.add(jPanel);
        return jPanel2;
    }

    private void populateValues() {
        int n;
        int n2;
        this._potentialComboBox.removeItemListener(this._listener);
        PotentialType potentialType = PotentialFactory.getPotentialType(this._potentialEnergy);
        this._potentialComboBox.setSelectedPotentialType(potentialType);
        this._potentialComboBox.addItemListener(this._listener);
        double d = this._totalEnergy.getEnergy();
        this._teSpinner.setValue(new Double(d));
        for (n2 = 0; n2 < this._peSpinners.size(); ++n2) {
            double d2 = this._potentialEnergy.getEnergy(n2);
            DoubleSpinner doubleSpinner = (DoubleSpinner)this._peSpinners.get(n2);
            doubleSpinner.setValue(new Double(d2));
        }
        if (this._stepSpinner != null) {
            double d3 = this._potentialEnergy.getStart(1);
            this._stepSpinner.setValue(new Double(d3));
        }
        if (this._widthSpinners != null) {
            for (n2 = 0; n2 < this._widthSpinners.size(); ++n2) {
                DoubleSpinner doubleSpinner = (DoubleSpinner)this._widthSpinners.get(n2);
                n = BarrierPotential.toRegionIndex(n2);
                double d4 = ((BarrierPotential)this._potentialEnergy).getWidth(n);
                doubleSpinner.setValue(new Double(d4));
            }
        }
        if (this._positionSpinners != null) {
            for (n2 = 0; n2 < this._positionSpinners.size(); ++n2) {
                DoubleSpinner doubleSpinner = (DoubleSpinner)this._positionSpinners.get(n2);
                n = BarrierPotential.toRegionIndex(n2);
                double d5 = ((BarrierPotential)this._potentialEnergy).getStart(n);
                doubleSpinner.setValue(new Double(d5));
            }
        }
    }

    private void rebuildInputPanel() {
        boolean bl = this.isVisible();
        if (bl) {
            this.setVisible(false);
        }
        this._inputPanel.removeAll();
        this._inputPanel.add(this.createInputPanel());
        this.populateValues();
        this.pack();
        if (bl) {
            this.setVisible(true);
        }
    }

    private void updateMarkersAndAnnotations() {
        char c = QTResources.getChar("char.potentialEnergy", 'P');
        char c2 = QTResources.getChar("char.barrier", 'B');
        boolean bl = this._potentialEnergy instanceof BarrierPotential;
        double d = this._energyPlot.getRangeAxis().getRange().getLowerBound();
        double d2 = this._energyPlot.getRangeAxis().getRange().getUpperBound();
        XYItemRenderer xYItemRenderer = this._energyPlot.getRenderer();
        xYItemRenderer.removeAnnotations();
        this._energyPlot.clearDomainMarkers();
        int n = this._potentialEnergy.getNumberOfRegions();
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                double d3 = this._potentialEnergy.getStart(i);
                ValueMarker valueMarker = new ValueMarker(d3);
                valueMarker.setPaint(this._colorScheme.getRegionMarkerColor());
                valueMarker.setStroke(QTConstants.REGION_MARKER_STROKE);
                this._energyPlot.addDomainMarker(valueMarker);
            }
            String string = String.valueOf(c) + String.valueOf(i + 1);
            double d4 = this._potentialEnergy.getMiddle(i);
            double d5 = d2 - 0.15;
            XYTextAnnotation xYTextAnnotation = new XYTextAnnotation(string, d4, d5);
            xYTextAnnotation.setFont(ANNOTATION_FONT);
            xYTextAnnotation.setPaint(this._colorScheme.getAnnotationColor());
            xYTextAnnotation.setTextAnchor(TextAnchor.TOP_CENTER);
            xYItemRenderer.addAnnotation(xYTextAnnotation);
            if (!bl || !BarrierPotential.isaBarrier(i)) continue;
            int n2 = BarrierPotential.toBarrierIndex(i);
            string = String.valueOf(c2) + String.valueOf(n2 + 1);
            d5 = d + 0.15;
            xYTextAnnotation = new XYTextAnnotation(string, d4, d5);
            xYTextAnnotation.setFont(ANNOTATION_FONT);
            xYTextAnnotation.setPaint(this._colorScheme.getAnnotationColor());
            xYTextAnnotation.setTextAnchor(TextAnchor.BOTTOM_CENTER);
            xYItemRenderer.addAnnotation(xYTextAnnotation);
        }
    }

    private void handleApply() {
        if (this._teChanged) {
            this._module.setTotalEnergy(new TotalEnergy(this._totalEnergy));
            this._teChanged = false;
        }
        if (this._peChanged) {
            this._module.setPotentialEnergy(PotentialFactory.clonePotentialEnergy(this._potentialEnergy));
            this._peChanged = false;
        }
        this._applyButton.setEnabled(false);
    }

    private void handleClose() {
        if (this._teChanged || this._peChanged) {
            String string = QTResources.getString("message.unsavedChanges");
            int n = PhetOptionPane.showYesNoCancelDialog(this, string);
            if (n == 0) {
                this.handleApply();
                this.dispose();
            }
            if (n == 1) {
                this.dispose();
            }
        } else {
            this.dispose();
        }
    }

    private void handlePotentialTypeChange() {
        PotentialType potentialType = this._potentialComboBox.getSelectedPotentialType();
        this._potentialEnergy = PotentialFactory.createPotentialEnergy(potentialType);
        this._energyPlot.setPotentialEnergy(this._potentialEnergy);
        this._peChanged = true;
        this._applyButton.setEnabled(true);
        this.rebuildInputPanel();
    }

    private void handleTotalEnergyChange() {
        double d = this._teSpinner.getDoubleValue();
        if (d >= MIN_ENERGY && d <= MAX_ENERGY) {
            this._totalEnergy.setEnergy(d);
            this._teChanged = true;
            this._applyButton.setEnabled(true);
        } else {
            this.warnInvalidInput();
            d = this._totalEnergy.getEnergy();
            this._teSpinner.setDoubleValue(d);
        }
    }

    private void handlePotentialEnergyChange(int n) {
        DoubleSpinner doubleSpinner = (DoubleSpinner)this._peSpinners.get(n);
        double d = doubleSpinner.getDoubleValue();
        if (d >= MIN_ENERGY && d <= MAX_ENERGY) {
            this._potentialEnergy.setEnergy(n, d);
            this.updateMarkersAndAnnotations();
            this._peChanged = true;
            this._applyButton.setEnabled(true);
        } else {
            this.warnInvalidInput();
            d = this._potentialEnergy.getEnergy(n);
            doubleSpinner.setDoubleValue(d);
        }
    }

    private void handleStepPositionChange() {
        if (this._potentialEnergy instanceof StepPotential) {
            StepPotential stepPotential = (StepPotential)this._potentialEnergy;
            double d = this._stepSpinner.getDoubleValue();
            boolean bl = stepPotential.setStepPosition(d);
            if (bl) {
                this.updateMarkersAndAnnotations();
                this._peChanged = true;
                this._applyButton.setEnabled(true);
            } else {
                this.warnInvalidInput();
                d = stepPotential.getStepPosition();
                this._stepSpinner.setDoubleValue(d);
            }
        }
    }

    private void handleBarrierWidthChange(int n) {
        if (this._potentialEnergy instanceof BarrierPotential) {
            BarrierPotential barrierPotential = (BarrierPotential)this._potentialEnergy;
            DoubleSpinner doubleSpinner = (DoubleSpinner)this._widthSpinners.get(n);
            double d = doubleSpinner.getDoubleValue();
            boolean bl = barrierPotential.setBarrierWidth(n, d);
            if (bl) {
                this.updateMarkersAndAnnotations();
                this._peChanged = true;
                this._applyButton.setEnabled(true);
            } else {
                this.warnInvalidInput();
                doubleSpinner.setDoubleValue(d);
            }
        }
    }

    private void handleBarrierPositionChange(int n) {
        if (this._potentialEnergy instanceof BarrierPotential) {
            BarrierPotential barrierPotential = (BarrierPotential)this._potentialEnergy;
            DoubleSpinner doubleSpinner = (DoubleSpinner)this._positionSpinners.get(n);
            double d = doubleSpinner.getDoubleValue();
            boolean bl = barrierPotential.setBarrierPosition(n, d);
            if (bl) {
                this.updateMarkersAndAnnotations();
                this._peChanged = true;
                this._applyButton.setEnabled(true);
            } else {
                this.warnInvalidInput();
                d = barrierPotential.getBarrierPosition(n);
                doubleSpinner.setDoubleValue(d);
            }
        }
    }

    private void warnInvalidInput() {
        Toolkit.getDefaultToolkit().beep();
    }

    private class EventListener
    implements ActionListener,
    ItemListener,
    ChangeListener {
        private EventListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == ConfigureEnergyDialog.this._applyButton) {
                ConfigureEnergyDialog.this.handleApply();
            } else if (actionEvent.getSource() == ConfigureEnergyDialog.this._closeButton) {
                ConfigureEnergyDialog.this.handleClose();
            } else {
                throw new IllegalArgumentException("unexpected event: " + actionEvent);
            }
        }

        public void stateChanged(ChangeEvent changeEvent) {
            if (changeEvent.getSource() == ConfigureEnergyDialog.this._teSpinner) {
                ConfigureEnergyDialog.this.handleTotalEnergyChange();
            } else if (ConfigureEnergyDialog.this._peSpinners.contains(changeEvent.getSource())) {
                ConfigureEnergyDialog.this.handlePotentialEnergyChange(ConfigureEnergyDialog.this._peSpinners.indexOf(changeEvent.getSource()));
            } else if (changeEvent.getSource() == ConfigureEnergyDialog.this._stepSpinner) {
                ConfigureEnergyDialog.this.handleStepPositionChange();
            } else if (ConfigureEnergyDialog.this._widthSpinners.contains(changeEvent.getSource())) {
                ConfigureEnergyDialog.this.handleBarrierWidthChange(ConfigureEnergyDialog.this._widthSpinners.indexOf(changeEvent.getSource()));
            } else if (ConfigureEnergyDialog.this._positionSpinners.contains(changeEvent.getSource())) {
                ConfigureEnergyDialog.this.handleBarrierPositionChange(ConfigureEnergyDialog.this._positionSpinners.indexOf(changeEvent.getSource()));
            } else {
                throw new IllegalArgumentException("unexpected event: " + changeEvent);
            }
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                if (itemEvent.getSource() == ConfigureEnergyDialog.this._potentialComboBox) {
                    ConfigureEnergyDialog.this.handlePotentialTypeChange();
                } else {
                    throw new IllegalArgumentException("unexpected event: " + itemEvent);
                }
            }
        }
    }
}

