/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumtunneling;

import edu.colorado.phet.common.phetcommon.application.ApplicationConstructor;
import edu.colorado.phet.common.phetcommon.application.PhetApplication;
import edu.colorado.phet.common.phetcommon.application.PhetApplicationConfig;
import edu.colorado.phet.common.phetcommon.application.PhetApplicationLauncher;
import edu.colorado.phet.common.phetcommon.util.persistence.XMLPersistenceManager;
import edu.colorado.phet.common.phetcommon.view.PhetFrame;
import edu.colorado.phet.common.phetcommon.view.PhetFrameWorkaround;
import edu.colorado.phet.common.phetcommon.view.menu.HelpMenu;
import edu.colorado.phet.common.phetcommon.view.util.PhetOptionPane;
import edu.colorado.phet.quantumtunneling.QTConstants;
import edu.colorado.phet.quantumtunneling.QTResources;
import edu.colorado.phet.quantumtunneling.color.BlackColorScheme;
import edu.colorado.phet.quantumtunneling.color.QTColorScheme;
import edu.colorado.phet.quantumtunneling.color.QTColorSchemeMenu;
import edu.colorado.phet.quantumtunneling.debug.RichardsonControlsMenuItem;
import edu.colorado.phet.quantumtunneling.module.QTModule;
import edu.colorado.phet.quantumtunneling.persistence.QTConfig;
import edu.colorado.phet.quantumtunneling.persistence.QTGlobalConfig;
import javax.swing.JMenu;

public class QuantumTunnelingApplication
extends PhetApplication {
    private QTModule _module;
    private XMLPersistenceManager _persistenceManager;
    private QTColorSchemeMenu _colorSchemeMenu;

    public QuantumTunnelingApplication(PhetApplicationConfig phetApplicationConfig) {
        super(phetApplicationConfig);
        this.initModules();
        this.initMenubar(phetApplicationConfig.getCommandLineArgs());
    }

    private void initModules() {
        this._module = new QTModule();
        this.addModule(this._module);
    }

    private void initMenubar(String[] stringArray) {
        PhetFrame phetFrame = this.getPhetFrame();
        phetFrame.addFileSaveLoadMenuItems();
        if (this._persistenceManager == null) {
            this._persistenceManager = new XMLPersistenceManager(phetFrame);
        }
        this._colorSchemeMenu = new QTColorSchemeMenu(this._module);
        if (QTConstants.COLOR_SCHEME instanceof BlackColorScheme) {
            this._colorSchemeMenu.selectBlack();
        } else {
            this._colorSchemeMenu.selectWhite();
        }
        this.getPhetFrame().addMenu(this._colorSchemeMenu);
        JMenu jMenu = this.getPhetFrame().getDeveloperMenu();
        jMenu.add(new RichardsonControlsMenuItem(this._module));
        HelpMenu helpMenu = this.getPhetFrame().getHelpMenu();
        if (helpMenu != null) {
            // empty if block
        }
    }

    protected PhetFrame createPhetFrame() {
        return new PhetFrameWorkaround(this);
    }

    public void save() {
        QTConfig qTConfig = new QTConfig();
        QTGlobalConfig qTGlobalConfig = new QTGlobalConfig();
        qTConfig.setGlobalConfig(qTGlobalConfig);
        qTGlobalConfig.setVersionNumber(this.getSimInfo().getVersion().toString());
        qTGlobalConfig.setColorSchemeName(this._colorSchemeMenu.getColorSchemeName());
        qTGlobalConfig.setColorScheme(this._colorSchemeMenu.getColorScheme());
        qTConfig.setModuleConfig(this._module.save());
        this._persistenceManager.save(qTConfig);
    }

    public void load() {
        Object object = this._persistenceManager.load();
        if (object != null) {
            if (object instanceof QTConfig) {
                QTConfig qTConfig = (QTConfig)object;
                QTGlobalConfig qTGlobalConfig = qTConfig.getGlobalConfig();
                String string = qTGlobalConfig.getColorSchemeName();
                QTColorScheme qTColorScheme = qTGlobalConfig.getColorScheme().toQTColorScheme();
                this._colorSchemeMenu.setColorScheme(string, qTColorScheme);
                this._module.load(qTConfig.getModuleConfig());
            } else {
                String string = QTResources.getString("message.notAConfigFile");
                PhetOptionPane.showErrorDialog(this.getPhetFrame(), string);
            }
        }
    }

    public static void main(String[] stringArray) {
        ApplicationConstructor applicationConstructor = new ApplicationConstructor(){

            public PhetApplication getApplication(PhetApplicationConfig phetApplicationConfig) {
                return new QuantumTunnelingApplication(phetApplicationConfig);
            }
        };
        PhetApplicationConfig phetApplicationConfig = new PhetApplicationConfig(stringArray, "quantum-tunneling");
        new PhetApplicationLauncher().launchSim(phetApplicationConfig, applicationConstructor);
    }
}

