/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.jfreechartphet;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CrosshairState;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.AbstractXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRendererState;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.RectangleEdge;

public class FastPathRenderer
extends AbstractXYItemRenderer {
    private GeneralPath _path = new GeneralPath();

    public void drawItem(Graphics2D graphics2D, XYItemRendererState xYItemRendererState, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n, int n2, CrosshairState crosshairState, int n3) {
        if (n2 != 0) {
            return;
        }
        if (!this.getItemVisible(n, n2)) {
            return;
        }
        RectangleEdge rectangleEdge = xYPlot.getDomainAxisEdge();
        RectangleEdge rectangleEdge2 = xYPlot.getRangeAxisEdge();
        boolean bl = false;
        this._path.reset();
        int n4 = xYDataset.getItemCount(n);
        for (int i = 0; i < n4; ++i) {
            double d = xYDataset.getXValue(n, i);
            double d2 = xYDataset.getYValue(n, i);
            if (Double.isNaN(d) || Double.isNaN(d2)) {
                bl = false;
                continue;
            }
            double d3 = valueAxis.valueToJava2D(d, rectangle2D, rectangleEdge);
            double d4 = valueAxis2.valueToJava2D(d2, rectangle2D, rectangleEdge2);
            if (Double.isNaN(d3) || Double.isNaN(d4)) {
                bl = false;
                continue;
            }
            float f = (float)d3;
            float f2 = (float)d4;
            if (xYPlot.getOrientation() == PlotOrientation.HORIZONTAL) {
                f = (float)d4;
                f2 = (float)d3;
            }
            if (!bl) {
                this._path.moveTo(f, f2);
            } else {
                this._path.lineTo(f, f2);
            }
            bl = true;
        }
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        if (object != RenderingHints.VALUE_ANTIALIAS_ON) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        graphics2D.setStroke(this.getSeriesStroke(n));
        graphics2D.setPaint(this.getSeriesPaint(n));
        graphics2D.draw(this._path);
        if (object != RenderingHints.VALUE_ANTIALIAS_ON) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
        }
    }
}

