/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.boundstates.view;

import edu.colorado.phet.boundstates.model.BSEigenstate;
import edu.colorado.phet.boundstates.model.BSModel;
import edu.colorado.phet.boundstates.model.BSSuperpositionCoefficients;
import edu.colorado.phet.boundstates.model.BSWaveFunctionCache;
import edu.colorado.phet.boundstates.view.BSAbstractBottomPlotter;
import edu.colorado.phet.boundstates.view.BSBottomPlot;
import edu.colorado.phet.common.phetcommon.math.Complex;
import edu.colorado.phet.common.phetcommon.math.MutableComplex;
import java.awt.geom.Point2D;
import org.jfree.data.xy.XYSeries;

class BSWaveFunctionPlotter
extends BSAbstractBottomPlotter {
    private BSBottomPlot _plot;
    private XYSeries _realSeries;
    private XYSeries _imaginarySeries;
    private XYSeries _magnitudeSeries;
    private XYSeries _phaseSeries;
    private XYSeries _probabilityDensitySeries;
    private MutableComplex[] _psiSum;
    private double _t;

    public BSWaveFunctionPlotter(BSBottomPlot bSBottomPlot) {
        super(bSBottomPlot);
        this._plot = bSBottomPlot;
        this._realSeries = bSBottomPlot.getRealSeries();
        this._imaginarySeries = bSBottomPlot.getImaginarySeries();
        this._magnitudeSeries = bSBottomPlot.getMagnitudeSeries();
        this._phaseSeries = bSBottomPlot.getPhaseSeries();
        this._probabilityDensitySeries = bSBottomPlot.getProbabilityDensitySeries();
    }

    public void notifyTimeChanged(double d) {
        this._t = d;
        this.updateTimeDependentSeries(this._t);
    }

    public void refreshAllSeries() {
        this.updateTimeDependentSeries(this._t);
        this.updateHiliteSeries();
    }

    private void updateTimeDependentSeries(double d) {
        BSWaveFunctionCache bSWaveFunctionCache = this.getCache();
        this.setTimeDependentSeriesNotify(false);
        this.clearTimeDependentSeries();
        if (bSWaveFunctionCache.getSize() > 0) {
            Complex[] complexArray = this.computeTimeDependentWaveFunction(d);
            if (complexArray != null) {
                double d2 = bSWaveFunctionCache.getMinPosition();
                double d3 = bSWaveFunctionCache.getMaxPosition();
                Point2D[] point2DArray = bSWaveFunctionCache.getItem(0).getPoints();
                assert (complexArray.length == point2DArray.length);
                for (int i = 0; i < complexArray.length; ++i) {
                    double d4 = point2DArray[i].getX();
                    if (!(d4 >= d2) || !(d4 <= d3)) continue;
                    Complex complex = complexArray[i];
                    if (this._plot.isRealSeriesVisible()) {
                        this._realSeries.add(d4, complex.getReal());
                    }
                    if (this._plot.isImaginarySeriesVisible()) {
                        this._imaginarySeries.add(d4, complex.getImaginary());
                    }
                    if (this._plot.isMagnitudeSeriesVisible()) {
                        this._magnitudeSeries.add(d4, complex.getAbs());
                    }
                    if (this._plot.isPhaseSeriesVisible()) {
                        this._phaseSeries.add(d4, complex.getAbs());
                        this._phaseSeries.add(d4, complex.getPhase());
                    }
                    if (!this._plot.isProbabilityDensitySeriesVisible()) continue;
                    this._probabilityDensitySeries.add(d4, complex.getAbs() * complex.getAbs());
                }
            }
            this.setTimeDependentSeriesNotify(true);
        }
    }

    private Complex[] computeTimeDependentWaveFunction(double d) {
        BSWaveFunctionCache bSWaveFunctionCache = this.getCache();
        if (bSWaveFunctionCache.getSize() > 0) {
            int n;
            int n2;
            BSModel bSModel = this._plot.getModel();
            BSEigenstate[] bSEigenstateArray = bSModel.getEigenstates();
            BSSuperpositionCoefficients bSSuperpositionCoefficients = bSModel.getSuperpositionCoefficients();
            assert (bSEigenstateArray.length == bSSuperpositionCoefficients.getNumberOfCoefficients());
            int n3 = bSWaveFunctionCache.getNumberOfPointsInEachWaveFunction();
            if (this._psiSum == null || n3 != this._psiSum.length) {
                this._psiSum = new MutableComplex[n3];
                for (n2 = 0; n2 < this._psiSum.length; ++n2) {
                    this._psiSum[n2] = new MutableComplex();
                }
            } else {
                for (n2 = 0; n2 < this._psiSum.length; ++n2) {
                    this._psiSum[n2].setValue(0.0);
                }
            }
            MutableComplex mutableComplex = new MutableComplex();
            MutableComplex mutableComplex2 = new MutableComplex();
            int n4 = bSWaveFunctionCache.getSize();
            for (int i = 0; i < n4; ++i) {
                BSWaveFunctionCache.Item item = bSWaveFunctionCache.getItem(i);
                n = item.getEigenstateIndex();
                Point2D[] point2DArray = item.getPoints();
                double d2 = bSEigenstateArray[n].getEnergy();
                mutableComplex2.setValue(Complex.I);
                mutableComplex2.multiply(-1.0 * d2 * d / 0.658);
                mutableComplex2.exp();
                double d3 = bSSuperpositionCoefficients.getCoefficient(n);
                double d4 = item.getNormalizationCoefficient();
                for (int j = 0; j < point2DArray.length; ++j) {
                    mutableComplex.setValue(point2DArray[j].getY());
                    mutableComplex.multiply(mutableComplex2);
                    if (d3 != 1.0) {
                        mutableComplex.multiply(d3);
                    }
                    if (d4 != 1.0) {
                        mutableComplex.multiply(d4);
                    }
                    this._psiSum[j].add(mutableComplex);
                }
            }
            double d5 = bSWaveFunctionCache.getSumScalingCoefficient();
            if (d5 != 1.0) {
                for (n = 0; n < this._psiSum.length; ++n) {
                    this._psiSum[n].multiply(d5);
                }
            }
        }
        return this._psiSum;
    }

    private void clearTimeDependentSeries() {
        this._realSeries.clear();
        this._imaginarySeries.clear();
        this._magnitudeSeries.clear();
        this._phaseSeries.clear();
        this._probabilityDensitySeries.clear();
    }

    private void setTimeDependentSeriesNotify(boolean bl) {
        this._realSeries.setNotify(bl);
        this._imaginarySeries.setNotify(bl);
        this._magnitudeSeries.setNotify(bl);
        this._phaseSeries.setNotify(bl);
        this._probabilityDensitySeries.setNotify(bl);
    }
}

