/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.boundstates.view;

import edu.colorado.phet.boundstates.BSConstants;
import edu.colorado.phet.boundstates.color.BSColorScheme;
import edu.colorado.phet.boundstates.enums.BSBottomPlotMode;
import edu.colorado.phet.boundstates.model.BSEigenstate;
import edu.colorado.phet.boundstates.model.BSModel;
import edu.colorado.phet.boundstates.model.BSSuperpositionCoefficients;
import edu.colorado.phet.boundstates.view.BSAbstractWaveFunctionEquation;
import java.awt.geom.AffineTransform;
import java.util.Observable;
import java.util.Observer;

public class BSSelectedEquation
extends BSAbstractWaveFunctionEquation
implements Observer {
    private AffineTransform _xform = new AffineTransform();

    public void setColorScheme(BSColorScheme bSColorScheme) {
        this.setHTMLColor(bSColorScheme.getEigenstateSelectionColor());
    }

    protected void updateDisplay() {
        BSModel bSModel = this.getModel();
        if (bSModel != null) {
            BSSuperpositionCoefficients bSSuperpositionCoefficients = bSModel.getSuperpositionCoefficients();
            int n = bSSuperpositionCoefficients.getNumberOfNonZeroCoefficients();
            String string = null;
            string = n == 0 ? "" : (n == 1 ? this.createSimpleString() : (this.getMode() == BSBottomPlotMode.AVERAGE_PROBABILITY_DENSITY ? this.createAverageProbabilityDensityString() : this.createSuperpositionString()));
            this.setHTML(string);
            this._xform.setToIdentity();
            this._xform.translate(this.getLocation().getX(), this.getLocation().getY());
            this._xform.translate(-this.getFullBounds().getWidth(), 0.0);
            this.setTransform(this._xform);
        }
    }

    public void update(Observable observable, Object object) {
        if (observable == this.getModel() && (object == null || object == "superpositionCoefficientsValues")) {
            this.updateDisplay();
        }
    }

    private String createSimpleString() {
        BSModel bSModel = this.getModel();
        BSSuperpositionCoefficients bSSuperpositionCoefficients = bSModel.getSuperpositionCoefficients();
        int n = bSSuperpositionCoefficients.getNumberOfCoefficients();
        int n2 = -1;
        for (int i = 0; i < n; ++i) {
            double d = bSSuperpositionCoefficients.getCoefficient(i);
            if (!(d > 0.0)) continue;
            n2 = i;
            break;
        }
        assert (n2 != -1);
        BSEigenstate bSEigenstate = bSModel.getEigenstate(n2);
        int n3 = bSEigenstate.getSubscript();
        String string = null;
        if (this.getMode() == BSBottomPlotMode.WAVE_FUNCTION) {
            string = "<html>\u03a8<sub>" + n3 + "</sub>(x,t)</html>";
        } else if (this.getMode() == BSBottomPlotMode.PROBABILITY_DENSITY || this.getMode() == BSBottomPlotMode.AVERAGE_PROBABILITY_DENSITY) {
            string = "<html>|\u03a8<sub>" + n3 + "</sub>(x,t)|<sup>2</sup></html>";
        } else {
            throw new UnsupportedOperationException("unsupported mode: " + this.getMode());
        }
        return string;
    }

    private String createSuperpositionString() {
        int n;
        BSModel bSModel = this.getModel();
        String string = "";
        BSSuperpositionCoefficients bSSuperpositionCoefficients = bSModel.getSuperpositionCoefficients();
        int n2 = 0;
        int n3 = bSSuperpositionCoefficients.getNumberOfCoefficients();
        for (n = 0; n < n3 && n2 < 3; ++n) {
            double d = bSSuperpositionCoefficients.getCoefficient(n);
            if (!(d > 0.0)) continue;
            if (n2 > 0) {
                string = string + "+";
            }
            BSEigenstate bSEigenstate = bSModel.getEigenstate(n);
            int n4 = bSEigenstate.getSubscript();
            string = string + BSConstants.COEFFICIENT_FORMAT.format(d);
            string = string + "\u03a8<sub>" + n4 + "</sub>(x,t)";
            ++n2;
        }
        n = bSSuperpositionCoefficients.getNumberOfNonZeroCoefficients();
        if (n > 3) {
            string = string + "+...";
        }
        if (this.getMode() == BSBottomPlotMode.PROBABILITY_DENSITY) {
            string = "|" + string + "|<sup>2</sup>";
        }
        String string2 = "<html>" + string + "<html>";
        return string2;
    }

    private String createAverageProbabilityDensityString() {
        int n;
        BSModel bSModel = this.getModel();
        String string = "";
        BSSuperpositionCoefficients bSSuperpositionCoefficients = bSModel.getSuperpositionCoefficients();
        int n2 = 0;
        int n3 = bSSuperpositionCoefficients.getNumberOfCoefficients();
        string = "(";
        for (n = 0; n < n3 && n2 < 3; ++n) {
            double d = bSSuperpositionCoefficients.getCoefficient(n);
            if (!(d > 0.0)) continue;
            if (n2 > 0) {
                string = string + "+";
            }
            BSEigenstate bSEigenstate = bSModel.getEigenstate(n);
            int n4 = bSEigenstate.getSubscript();
            string = string + "|\u03a8<sub>" + n4 + "</sub>(x,t)|<sup>2</sup>";
            ++n2;
        }
        n = bSSuperpositionCoefficients.getNumberOfNonZeroCoefficients();
        if (n > 3) {
            string = string + "+...";
        }
        string = string + ")/" + n;
        String string2 = "<html>" + string + "<html>";
        return string2;
    }
}

