/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.boundstates.view;

import edu.colorado.phet.boundstates.BSConstants;
import edu.colorado.phet.boundstates.color.BSColorScheme;
import edu.colorado.phet.boundstates.enums.BSBottomPlotMode;
import edu.colorado.phet.boundstates.model.BSEigenstate;
import edu.colorado.phet.boundstates.model.BSModel;
import edu.colorado.phet.boundstates.model.BSSuperpositionCoefficients;
import edu.colorado.phet.boundstates.view.BSCombinedChartNode;
import edu.colorado.phet.common.piccolophet.nodes.HTMLNode;
import edu.umd.cs.piccolo.PCanvas;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolox.nodes.PComposite;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Observable;
import java.util.Observer;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.event.AxisChangeEvent;
import org.jfree.chart.event.AxisChangeListener;

public class BSEigenstatesNode
extends PComposite
implements Observer {
    private BSModel _model = null;
    private int _hiliteIndex = -1;
    private PCanvas _canvas;
    private BSCombinedChartNode _chartNode;
    private HTMLNode _hiliteValueNode;
    private NumberFormat _differenceFormat;
    private boolean _bandSelectionEnabled = false;
    private int _selectedBandIndex = -1;

    public BSEigenstatesNode(BSCombinedChartNode bSCombinedChartNode, PCanvas pCanvas) {
        this._chartNode = bSCombinedChartNode;
        this._canvas = pCanvas;
        String string = "0.";
        for (int i = 0; i < 13; ++i) {
            string = string + "#";
        }
        this._differenceFormat = new DecimalFormat(string);
        this._hiliteValueNode = new HTMLNode();
        this._hiliteValueNode.setFont(BSConstants.HILITE_ENERGY_FONT);
        this._hiliteValueNode.setVisible(false);
        this._hiliteValueNode.setOffset(100.0, 100.0);
        this.addChild(this._hiliteValueNode);
        PBasicInputEventHandler pBasicInputEventHandler = new PBasicInputEventHandler(){

            public void mouseMoved(PInputEvent pInputEvent) {
                BSEigenstatesNode.this.handleHighlight(pInputEvent);
            }

            public void mouseExited(PInputEvent pInputEvent) {
                BSEigenstatesNode.this._model.setHilitedEigenstateIndex(-1);
                BSEigenstatesNode.this.setCursor(-1);
            }

            public void mousePressed(PInputEvent pInputEvent) {
                BSEigenstatesNode.this.handleSelection();
            }
        };
        this.addInputEventListener(pBasicInputEventHandler);
        ValueAxis valueAxis = this._chartNode.getCombinedChart().getEnergyPlot().getRangeAxis();
        valueAxis.addChangeListener(new AxisChangeListener(){

            public void axisChanged(AxisChangeEvent axisChangeEvent) {
                BSEigenstatesNode.this._model.setHilitedEigenstateIndex(-1);
            }
        });
        this.setColorScheme(BSConstants.COLOR_SCHEME);
    }

    public void setModel(BSModel bSModel) {
        if (bSModel != this._model) {
            if (this._model != null) {
                this._model.deleteObserver(this);
            }
            this._model = bSModel;
            this._model.addObserver(this);
            this.updateHiliteValueDisplay();
            this.updateBandSelection();
        }
    }

    public void setColorScheme(BSColorScheme bSColorScheme) {
        Color color = bSColorScheme.getChartColor();
        Color color2 = new Color(color.getRed(), color.getGreen(), color.getBlue(), 175);
        this._hiliteValueNode.setPaint(color2);
        this._hiliteValueNode.setHTMLColor(bSColorScheme.getEigenstateHiliteColor());
    }

    public void setMode(BSBottomPlotMode bSBottomPlotMode) {
        boolean bl = this._bandSelectionEnabled;
        boolean bl2 = this._bandSelectionEnabled = bSBottomPlotMode == BSBottomPlotMode.AVERAGE_PROBABILITY_DENSITY;
        if (bl || bSBottomPlotMode == BSBottomPlotMode.AVERAGE_PROBABILITY_DENSITY) {
            this._selectedBandIndex = -1;
            BSSuperpositionCoefficients bSSuperpositionCoefficients = this._model.getSuperpositionCoefficients();
            int n = bSSuperpositionCoefficients.getLowestNonZeroCoefficientIndex();
            if (this._bandSelectionEnabled) {
                this.selectBandByEigenstateIndex(n);
            } else {
                this.selectEigenstate(n);
            }
        }
    }

    private void selectEigenstate(int n) {
        BSSuperpositionCoefficients bSSuperpositionCoefficients = this._model.getSuperpositionCoefficients();
        int n2 = bSSuperpositionCoefficients.getNumberOfCoefficients();
        bSSuperpositionCoefficients.setNotifyEnabled(false);
        for (int i = 0; i < n2; ++i) {
            bSSuperpositionCoefficients.setCoefficient(i, 0.0);
        }
        bSSuperpositionCoefficients.setCoefficient(n, 1.0);
        bSSuperpositionCoefficients.setNotifyEnabled(true);
    }

    private void selectBandByEigenstateIndex(int n) {
        int n2 = this._model.getPotential().getNumberOfWells();
        int n3 = n / n2;
        this.selectBand(n3);
    }

    private void selectBand(int n) {
        BSSuperpositionCoefficients bSSuperpositionCoefficients = this._model.getSuperpositionCoefficients();
        int n2 = this._model.getPotential().getNumberOfWells();
        this._selectedBandIndex = n2 * this._selectedBandIndex + 1 > bSSuperpositionCoefficients.getNumberOfCoefficients() ? 0 : n;
        bSSuperpositionCoefficients.setBandCoefficients(this._selectedBandIndex, n2, 1.0);
    }

    private void handleSelection() {
        int n = this._model.getHilitedEigenstateIndex();
        if (n != -1) {
            this._model.setHilitedEigenstateIndex(-1);
            if (this._bandSelectionEnabled) {
                this.selectBandByEigenstateIndex(n);
            } else {
                this.selectEigenstate(n);
            }
        }
    }

    private void handleHighlight(PInputEvent pInputEvent) {
        Point2D point2D = pInputEvent.getPositionRelativeTo(this);
        Point2D point2D2 = this.localToGlobal(point2D);
        Point2D point2D3 = this._chartNode.globalToLocal(point2D2);
        Point2D point2D4 = this._chartNode.nodeToEnergy(point2D3);
        double d = point2D4.getY();
        int n = this._model.getClosestEigenstateIndex(d, 1.0);
        this._model.setHilitedEigenstateIndex(n);
        this.setCursor(n);
    }

    public void update(Observable observable, Object object) {
        if (observable == this._model) {
            if (object == "hilitedEnergy") {
                this.updateHiliteValueDisplay();
            } else if (object == "potential") {
                this.updateBandSelection();
            }
        }
    }

    public void updateBandSelection() {
        if (this._bandSelectionEnabled) {
            this.selectBand(this._selectedBandIndex);
        }
    }

    private void updateHiliteValueDisplay() {
        this._hiliteIndex = this._model.getHilitedEigenstateIndex();
        if (this._hiliteIndex == -1) {
            this._hiliteValueNode.setVisible(false);
        } else {
            this._hiliteValueNode.setVisible(true);
            String string = this.createValueString(this._hiliteIndex);
            this._hiliteValueNode.setHTML(string);
            double d = this._chartNode.getCombinedChart().getPositionRange().getLowerBound();
            double d2 = this._model.getEigenstate(this._hiliteIndex).getEnergy();
            Point2D point2D = this._chartNode.energyToNode(new Point2D.Double(d, d2));
            double d3 = point2D.getX() + 2.0;
            double d4 = point2D.getY() - this._hiliteValueNode.getHeight() - 1.0;
            this._hiliteValueNode.setOffset(d3, d4);
        }
    }

    private void setCursor(int n) {
        if (this._hiliteIndex == -1) {
            this._canvas.setCursor(BSConstants.DEFAULT_CURSOR);
        } else {
            this._canvas.setCursor(BSConstants.HAND_CURSOR);
        }
    }

    private String createValueString(int n) {
        BSEigenstate[] bSEigenstateArray = this._model.getEigenstates();
        double d = bSEigenstateArray[n].getEnergy();
        int n2 = bSEigenstateArray[n].getSubscript();
        NumberFormat numberFormat = this.createValueFormat(n);
        String string = numberFormat.format(d);
        return "<html> E<sub>" + n2 + "</sub> = " + string + "</html>";
    }

    private NumberFormat createValueFormat(int n) {
        int n2;
        double d;
        BSEigenstate[] bSEigenstateArray = this._model.getEigenstates();
        double d2 = bSEigenstateArray[n].getEnergy();
        double d3 = 1.0;
        if (n > 0) {
            d3 = Math.abs(d2 - bSEigenstateArray[n - 1].getEnergy());
        }
        if (n < bSEigenstateArray.length - 1 && (d = Math.abs(d2 - bSEigenstateArray[n + 1].getEnergy())) < d3) {
            d3 = d;
        }
        String string = this._differenceFormat.format(d3);
        int n3 = 0;
        if (string.charAt(0) != '0') {
            n3 = 2;
        } else {
            int n4 = string.indexOf(46);
            for (n2 = n4 + 1; n2 < string.length(); ++n2) {
                ++n3;
                char c = string.charAt(n2);
                if (c != '0') break;
            }
            if (n3 < 2) {
                n3 = 2;
            } else if (n3 > 12) {
                n3 = 12;
            }
        }
        String string2 = "0.";
        for (n2 = 0; n2 < n3; ++n2) {
            string2 = string2 + "0";
        }
        return new DecimalFormat(string2);
    }
}

