/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.boundstates.view;

import edu.colorado.phet.boundstates.model.BSWaveFunctionCache;
import edu.colorado.phet.boundstates.view.BSAbstractBottomPlotter;
import edu.colorado.phet.boundstates.view.BSBottomPlot;
import java.awt.geom.Point2D;
import org.jfree.data.xy.XYSeries;

class BSAverageProbabilityDensityPlotter
extends BSAbstractBottomPlotter {
    private XYSeries _probabilityDensitySeries;

    public BSAverageProbabilityDensityPlotter(BSBottomPlot bSBottomPlot) {
        super(bSBottomPlot);
        this._probabilityDensitySeries = bSBottomPlot.getProbabilityDensitySeries();
    }

    public void notifyTimeChanged(double d) {
    }

    public void refreshAllSeries() {
        this.updateProbabilityDensitySeries();
        this.updateHiliteSeries();
    }

    private void updateProbabilityDensitySeries() {
        BSWaveFunctionCache bSWaveFunctionCache = this.getCache();
        this._probabilityDensitySeries.setNotify(false);
        this._probabilityDensitySeries.clear();
        double d = bSWaveFunctionCache.getSize();
        if (d > 0.0) {
            double d2 = bSWaveFunctionCache.getMinPosition();
            double d3 = bSWaveFunctionCache.getMaxPosition();
            Point2D[] point2DArray = bSWaveFunctionCache.getItem(0).getPoints();
            for (int i = 0; i < point2DArray.length; ++i) {
                double d4 = point2DArray[i].getX();
                if (!(d4 >= d2) || !(d4 <= d3)) continue;
                double d5 = 0.0;
                int n = 0;
                while ((double)n < d) {
                    Point2D[] point2DArray2 = bSWaveFunctionCache.getItem(n).getPoints();
                    double d6 = Math.abs(point2DArray2[i].getY());
                    d5 += d6 * d6;
                    ++n;
                }
                double d7 = d5 / d;
                this._probabilityDensitySeries.add(d4, d7);
            }
        }
        this._probabilityDensitySeries.setNotify(true);
    }
}

