/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.boundstates.module;

import edu.colorado.phet.boundstates.enums.BSWellType;
import edu.colorado.phet.boundstates.module.BSPotentialSpec;
import edu.colorado.phet.common.phetcommon.util.DoubleRange;
import edu.colorado.phet.common.phetcommon.util.IntegerRange;

public abstract class BSAbstractModuleSpec {
    private String _id;
    private BSWellType[] _wellTypes;
    private BSWellType _defaultWellType;
    private boolean _numberOfWellsSupported;
    private boolean _offsetControlSupported;
    private boolean _superpositionControlsSupported;
    private boolean _particleControlsSupported;
    private boolean _magnifyingGlassSupported;
    private boolean _magnifyingGlassSelected;
    private DoubleRange _massMultiplierRange;
    private boolean _averageProbabilityDensitySupported;
    private boolean _fieldConstantSupported;
    private IntegerRange _numberOfWellsRange;
    private DoubleRange _fieldConstantRange;
    private BSPotentialSpec _asymmetricSpec;
    private BSPotentialSpec _coulomb1DSpec;
    private BSPotentialSpec _coulomb3DSpec;
    private BSPotentialSpec _harmonicOscillatorSpec;
    private BSPotentialSpec _squareSpec;
    private double _magnification;

    public String getId() {
        return this._id;
    }

    public void setId(String string) {
        this._id = string;
    }

    public void setNumberOfWellsSupported(boolean bl) {
        this._numberOfWellsSupported = bl;
    }

    public boolean isNumberOfWellsSupported() {
        return this._numberOfWellsSupported;
    }

    public boolean isOffsetControlSupported() {
        return this._offsetControlSupported;
    }

    protected void setOffsetControlSupported(boolean bl) {
        this._offsetControlSupported = bl;
    }

    public DoubleRange getMassMultiplierRange() {
        return this._massMultiplierRange;
    }

    protected void setMassMultiplierRange(DoubleRange doubleRange) {
        this._massMultiplierRange = doubleRange;
    }

    public IntegerRange getNumberOfWellsRange() {
        return this._numberOfWellsRange;
    }

    public void setNumberOfWellsRange(IntegerRange integerRange) {
        this._numberOfWellsRange = integerRange;
    }

    public void setFieldConstantRange(DoubleRange doubleRange) {
        this._fieldConstantRange = doubleRange;
    }

    public DoubleRange getFieldConstantRange() {
        return this._fieldConstantRange;
    }

    public boolean isParticleControlsSupported() {
        return this._particleControlsSupported;
    }

    protected void setParticleControlsSupported(boolean bl) {
        this._particleControlsSupported = bl;
    }

    public boolean isSuperpositionControlsSupported() {
        return this._superpositionControlsSupported;
    }

    protected void setSuperpositionControlsSupported(boolean bl) {
        this._superpositionControlsSupported = bl;
    }

    public BSWellType[] getWellTypes() {
        return this._wellTypes;
    }

    protected void setWellTypes(BSWellType[] bSWellTypeArray) {
        this._wellTypes = bSWellTypeArray;
    }

    public BSWellType getDefaultWellType() {
        return this._defaultWellType;
    }

    protected void setDefaultWellType(BSWellType bSWellType) {
        this._defaultWellType = bSWellType;
    }

    public void setAverageProbabilityDensityIsSupported(boolean bl) {
        this._averageProbabilityDensitySupported = bl;
    }

    public boolean isAverageProbabilityDensitySupported() {
        return this._averageProbabilityDensitySupported;
    }

    public boolean isMagnifyingGlassSupported() {
        return this._magnifyingGlassSupported;
    }

    protected void setMagnifyingGlassSupported(boolean bl) {
        this._magnifyingGlassSupported = bl;
    }

    public boolean isMagnifyingGlassSelected() {
        return this._magnifyingGlassSelected;
    }

    public void setFieldConstantSupported(boolean bl) {
        this._fieldConstantSupported = bl;
    }

    public boolean isFieldConstantSupported() {
        return this._fieldConstantSupported;
    }

    protected void setMagnifyingGlassSelected(boolean bl) {
        this._magnifyingGlassSelected = bl;
    }

    public double getMagnification() {
        return this._magnification;
    }

    protected void setMagnification(double d) {
        this._magnification = d;
    }

    public BSPotentialSpec getAsymmetricSpec() {
        return this._asymmetricSpec;
    }

    protected void setAsymmetricSpec(BSPotentialSpec bSPotentialSpec) {
        this._asymmetricSpec = bSPotentialSpec;
    }

    public BSPotentialSpec getCoulomb1DSpec() {
        return this._coulomb1DSpec;
    }

    protected void setCoulomb1DSpec(BSPotentialSpec bSPotentialSpec) {
        this._coulomb1DSpec = bSPotentialSpec;
    }

    public BSPotentialSpec getCoulomb3DSpec() {
        return this._coulomb3DSpec;
    }

    protected void setCoulomb3DSpec(BSPotentialSpec bSPotentialSpec) {
        this._coulomb3DSpec = bSPotentialSpec;
    }

    public BSPotentialSpec getHarmonicOscillatorSpec() {
        return this._harmonicOscillatorSpec;
    }

    protected void setHarmonicOscillatorSpec(BSPotentialSpec bSPotentialSpec) {
        this._harmonicOscillatorSpec = bSPotentialSpec;
    }

    public BSPotentialSpec getSquareSpec() {
        return this._squareSpec;
    }

    protected void setSquareSpec(BSPotentialSpec bSPotentialSpec) {
        this._squareSpec = bSPotentialSpec;
    }

    public BSPotentialSpec getRangeSpec(BSWellType bSWellType) {
        BSPotentialSpec bSPotentialSpec = null;
        if (bSWellType == BSWellType.ASYMMETRIC) {
            bSPotentialSpec = this._asymmetricSpec;
        } else if (bSWellType == BSWellType.COULOMB_1D) {
            bSPotentialSpec = this._coulomb1DSpec;
        } else if (bSWellType == BSWellType.COULOMB_3D) {
            bSPotentialSpec = this._coulomb3DSpec;
        } else if (bSWellType == BSWellType.HARMONIC_OSCILLATOR) {
            bSPotentialSpec = this._harmonicOscillatorSpec;
        } else if (bSWellType == BSWellType.SQUARE) {
            bSPotentialSpec = this._squareSpec;
        } else {
            throw new UnsupportedOperationException("unsupported well type: " + bSWellType);
        }
        return bSPotentialSpec;
    }
}

