/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.boundstates.model;

import edu.colorado.phet.boundstates.enums.BSWellType;
import edu.colorado.phet.boundstates.model.BSAbstractPotential;
import edu.colorado.phet.boundstates.model.BSEigenstate;
import edu.colorado.phet.boundstates.model.BSParticle;
import edu.colorado.phet.boundstates.model.SchmidtLeeSolver;
import java.util.ArrayList;

public class BSSquarePotential
extends BSAbstractPotential {
    private double _height;
    private double _width;
    private double _separation;

    public BSSquarePotential(BSParticle bSParticle, int n, double d, double d2, double d3, double d4) {
        super(bSParticle, n, d);
        this.setHeight(d2);
        this.setWidth(d3);
        this.setSeparation(d4);
    }

    public double getWidth() {
        return this._width;
    }

    public void setWidth(double d) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("invalid width: " + d);
        }
        if (d != this._width) {
            this._width = d;
            this.markEigenstatesDirty();
            this.notifyObservers();
        }
    }

    public double getHeight() {
        return this._height;
    }

    public void setHeight(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException("invalid heigth: " + d);
        }
        if (d != this._height) {
            this._height = d;
            this.markEigenstatesDirty();
            this.notifyObservers();
        }
    }

    public double getSeparation() {
        return this._separation;
    }

    public void setSeparation(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException("invalid separation: " + d);
        }
        if (d != this._separation) {
            this._separation = d;
            this.markEigenstatesDirty();
            this.notifyObservers();
        }
    }

    public BSWellType getWellType() {
        return BSWellType.SQUARE;
    }

    public boolean supportsMultipleWells() {
        return true;
    }

    public int getGroundStateSubscript() {
        return 1;
    }

    public double getEnergyAt(double d) {
        int n = this.getNumberOfWells();
        double d2 = this.getOffset();
        double d3 = this.getCenter();
        double d4 = this.getWidth() + this.getSeparation();
        double d5 = this.getWidth();
        double d6 = this.getHeight();
        double d7 = d2 + d6;
        for (int i = 1; i <= n; ++i) {
            double d8 = d4 * ((double)i - (double)(n + 1) / 2.0);
            if (!(d - d3 >= d8 - d5 / 2.0) || !(d - d3 <= d8 + d5 / 2.0)) continue;
            d7 = d2;
            break;
        }
        return d7 += this.getFieldConstant() * d;
    }

    public double getCenter(int n) {
        int n2 = this.getNumberOfWells();
        if (n < 0 || n > n2 - 1) {
            throw new IndexOutOfBoundsException("wellIndex out of range: " + n);
        }
        double d = this.getWidth();
        double d2 = this.getSeparation();
        double d3 = (double)n * (d + d2) + d / 2.0;
        d3 = n2 % 2 == 0 ? (d3 -= d * ((double)n2 / 2.0) + d2 * ((double)n2 / 2.0 - 1.0) + d2 / 2.0) : (d3 -= d * ((double)(n2 - 1) / 2.0) + d2 * ((double)(n2 - 1) / 2.0) + d / 2.0);
        return d3 += this.getCenter();
    }

    protected BSEigenstate[] calculateEigenstates() {
        SchmidtLeeSolver schmidtLeeSolver = this.getEigenstateSolver();
        ArrayList<BSEigenstate> arrayList = new ArrayList<BSEigenstate>();
        double d = this.getEnergyCutOff();
        int n = 0;
        boolean bl = false;
        while (!bl) {
            try {
                double d2 = schmidtLeeSolver.getEnergy(n);
                if (d2 <= d) {
                    int n2 = n + 1;
                    arrayList.add(new BSEigenstate(n2, d2));
                } else {
                    bl = true;
                }
            }
            catch (SchmidtLeeSolver.SchmidtLeeException schmidtLeeException) {
                System.err.println(schmidtLeeException.getClass() + ": " + schmidtLeeException.getMessage());
                bl = true;
            }
            ++n;
        }
        return arrayList.toArray(new BSEigenstate[arrayList.size()]);
    }
}

