/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.boundstates.model;

import edu.colorado.phet.boundstates.enums.BSWellType;
import edu.colorado.phet.boundstates.model.BSAbstractPotential;
import edu.colorado.phet.boundstates.model.BSCoulomb1DSolver;
import edu.colorado.phet.boundstates.model.BSEigenstate;
import edu.colorado.phet.boundstates.model.BSParticle;
import edu.colorado.phet.boundstates.model.SchmidtLeeSolver;
import java.awt.geom.Point2D;
import java.util.ArrayList;

public class BSCoulomb1DPotential
extends BSAbstractPotential {
    private double _spacing;

    public BSCoulomb1DPotential(BSParticle bSParticle, int n, double d, double d2) {
        super(bSParticle, n, d);
        this.setSpacing(d2);
    }

    public double getSpacing() {
        return this._spacing;
    }

    public void setSpacing(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException("invalid spacing: " + d);
        }
        if (d != this._spacing) {
            this._spacing = d;
            this.markEigenstatesDirty();
            this.notifyObservers();
        }
    }

    public Point2D[] getWaveFunctionPoints(BSEigenstate bSEigenstate, double d, double d2) {
        if (this.getNumberOfWells() == 1) {
            BSCoulomb1DSolver bSCoulomb1DSolver = new BSCoulomb1DSolver(this, this.getParticle());
            return bSCoulomb1DSolver.getWaveFunction(bSEigenstate.getSubscript(), d, d2, 1350);
        }
        return super.getWaveFunctionPoints(bSEigenstate, d, d2);
    }

    public double getNormalizationCoefficient(Point2D[] point2DArray, int n) {
        if (this.getNumberOfWells() == 1) {
            int n2 = n + 1;
            return 1.0 / BSCoulomb1DSolver.getScalingCoefficient(n2);
        }
        return super.getNormalizationCoefficient(point2DArray, n);
    }

    public BSWellType getWellType() {
        return BSWellType.COULOMB_1D;
    }

    public boolean supportsMultipleWells() {
        return true;
    }

    public int getGroundStateSubscript() {
        return 1;
    }

    public double getEnergyAt(double d) {
        double d2 = 0.0;
        int n = this.getNumberOfWells();
        double d3 = this.getSpacing();
        double d4 = this.getOffset();
        double d5 = this.getCenter();
        for (int i = 1; i <= n; ++i) {
            double d6 = d3 * ((double)i - (double)(n + 1) / 2.0);
            d2 += -1.44 / Math.abs(d - d5 - d6);
        }
        return d4 + (d2 += this.getFieldConstant() * d);
    }

    protected BSEigenstate[] calculateEigenstates() {
        if (this.getNumberOfWells() == 1) {
            return this.calculateEigenstatesAnalytic();
        }
        return this.calculateEigenstatesSchmidtLee();
    }

    private BSEigenstate[] calculateEigenstatesAnalytic() {
        double d;
        BSCoulomb1DSolver bSCoulomb1DSolver = new BSCoulomb1DSolver(this, this.getParticle());
        ArrayList<BSEigenstate> arrayList = new ArrayList<BSEigenstate>();
        int n = bSCoulomb1DSolver.getMaxEigenstates();
        double d2 = this.getEnergyCutOff();
        int n2 = this.getGroundStateSubscript();
        for (int i = 1; i <= n && (d = bSCoulomb1DSolver.getEnergy(i)) < d2; ++i) {
            arrayList.add(new BSEigenstate(n2, d));
            ++n2;
        }
        return arrayList.toArray(new BSEigenstate[arrayList.size()]);
    }

    private BSEigenstate[] calculateEigenstatesSchmidtLee() {
        SchmidtLeeSolver schmidtLeeSolver = this.getEigenstateSolver();
        ArrayList<BSEigenstate> arrayList = new ArrayList<BSEigenstate>();
        int n = this.getNumberOfWells();
        double d = this.getEnergyCutOff();
        int n2 = n;
        int n3 = this.getGroundStateSubscript();
        boolean bl = false;
        while (!bl) {
            for (int i = 0; !bl && i < n; ++i) {
                try {
                    double d2 = schmidtLeeSolver.getEnergy(n2);
                    if (d2 <= d) {
                        arrayList.add(new BSEigenstate(n3, d2));
                    } else {
                        bl = true;
                    }
                }
                catch (SchmidtLeeSolver.SchmidtLeeException schmidtLeeException) {
                    System.err.println(schmidtLeeException.getClass() + ": " + schmidtLeeException.getMessage());
                    bl = true;
                }
                ++n2;
                ++n3;
            }
            n2 += n;
        }
        return arrayList.toArray(new BSEigenstate[arrayList.size()]);
    }
}

