/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.boundstates.model;

import edu.colorado.phet.boundstates.enums.BSWellType;
import edu.colorado.phet.boundstates.model.BSAbstractPotential;
import edu.colorado.phet.boundstates.model.BSEigenstate;
import edu.colorado.phet.boundstates.model.BSParticle;
import edu.colorado.phet.boundstates.model.SchmidtLeeSolver;
import java.util.ArrayList;

public class BSAsymmetricPotential
extends BSAbstractPotential {
    private double _width;
    private double _height;

    public BSAsymmetricPotential(BSParticle bSParticle, double d, double d2, double d3) {
        super(bSParticle, 1, d);
        this.setHeight(d2);
        this.setWidth(d3);
    }

    public double getWidth() {
        return this._width;
    }

    public void setWidth(double d) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("invalid width: " + d);
        }
        if (d != this._width) {
            this._width = d;
            this.markEigenstatesDirty();
            this.notifyObservers();
        }
    }

    public double getHeight() {
        return this._height;
    }

    public void setHeight(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException("invalid height: " + d);
        }
        if (d != this._height) {
            this._height = d;
            this.markEigenstatesDirty();
            this.notifyObservers();
        }
    }

    public BSWellType getWellType() {
        return BSWellType.ASYMMETRIC;
    }

    public boolean supportsMultipleWells() {
        return false;
    }

    public int getGroundStateSubscript() {
        return 1;
    }

    public double getEnergyAt(double d) {
        assert (this.getNumberOfWells() == 1);
        double d2 = this.getOffset();
        double d3 = this.getCenter();
        double d4 = this.getWidth();
        double d5 = this.getHeight();
        double d6 = d2 + d5;
        if (Math.abs(d - d3) <= d4 / 2.0) {
            d6 = d2 + (d5 - Math.abs(d3 + d4 / 2.0 - d) * d5 / d4);
        }
        return d6;
    }

    protected BSEigenstate[] calculateEigenstates() {
        SchmidtLeeSolver schmidtLeeSolver = this.getEigenstateSolver();
        ArrayList<BSEigenstate> arrayList = new ArrayList<BSEigenstate>();
        double d = this.getOffset() + this._height;
        int n = 0;
        boolean bl = false;
        while (!bl) {
            try {
                int n2 = n + 1;
                double d2 = schmidtLeeSolver.getEnergy(n);
                if (d2 <= d) {
                    arrayList.add(new BSEigenstate(n2, d2));
                } else {
                    bl = true;
                }
            }
            catch (SchmidtLeeSolver.SchmidtLeeException schmidtLeeException) {
                System.err.println(schmidtLeeException.getClass() + ": " + schmidtLeeException.getMessage());
                bl = true;
            }
            ++n;
        }
        return arrayList.toArray(new BSEigenstate[arrayList.size()]);
    }
}

