/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.boundstates.draghandles;

import edu.colorado.phet.boundstates.BSResources;
import edu.colorado.phet.boundstates.draghandles.BSPotentialHandle;
import edu.colorado.phet.boundstates.model.BSCoulomb1DPotential;
import edu.colorado.phet.boundstates.module.BSPotentialSpec;
import edu.colorado.phet.boundstates.view.BSCombinedChartNode;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jfree.chart.axis.ValueAxis;

public class BSCoulomb1DSpacingHandle
extends BSPotentialHandle {
    public BSCoulomb1DSpacingHandle(BSCoulomb1DPotential bSCoulomb1DPotential, BSPotentialSpec bSPotentialSpec, BSCombinedChartNode bSCombinedChartNode) {
        super(bSCoulomb1DPotential, bSPotentialSpec, bSCombinedChartNode, 0);
        int n = bSPotentialSpec.getSpacingRange().getSignificantDecimalPlaces();
        String string = BSCoulomb1DSpacingHandle.createNumberFormat(n);
        this.setValueNumberFormat(string);
        this.setValuePattern(BSResources.getString("drag.spacing"));
        this.updateDragBounds();
    }

    public void updateDragBounds() {
        BSCoulomb1DPotential bSCoulomb1DPotential = (BSCoulomb1DPotential)this.getPotential();
        BSPotentialSpec bSPotentialSpec = this.getPotentialSpec();
        BSCombinedChartNode bSCombinedChartNode = this.getChartNode();
        if (bSCoulomb1DPotential.getCenter() != 0.0) {
            throw new UnsupportedOperationException("this implementation only supports potentials centered at 0");
        }
        int n = bSCoulomb1DPotential.getNumberOfWells();
        double d = bSPotentialSpec.getSpacingRange().getMin();
        double d2 = bSPotentialSpec.getSpacingRange().getMax();
        double d3 = 0.0;
        double d4 = 0.0;
        if (n % 2 == 0) {
            d3 = d / 2.0;
            d4 = d2 / 2.0;
        } else {
            d3 = d;
            d4 = d2;
        }
        double d5 = bSCombinedChartNode.positionToNode(d3);
        double d6 = bSCombinedChartNode.positionToNode(d4);
        ValueAxis valueAxis = bSCombinedChartNode.getEnergyPlot().getRangeAxis();
        double d7 = valueAxis.getLowerBound();
        double d8 = valueAxis.getUpperBound();
        double d9 = bSCombinedChartNode.energyToNode(d8);
        double d10 = bSCombinedChartNode.energyToNode(d7);
        double d11 = d6 - d5;
        double d12 = d10 - d9;
        Rectangle2D rectangle2D = new Rectangle2D.Double(d5, d9, d11, d12);
        rectangle2D = bSCombinedChartNode.localToGlobal(rectangle2D);
        this.setDragBounds(rectangle2D);
        this.updateView();
    }

    protected void updateModel() {
        BSCoulomb1DPotential bSCoulomb1DPotential = (BSCoulomb1DPotential)this.getPotential();
        BSPotentialSpec bSPotentialSpec = this.getPotentialSpec();
        bSCoulomb1DPotential.deleteObserver(this);
        Point2D point2D = this.getGlobalPosition();
        Point2D point2D2 = this.viewToModel(point2D);
        double d = point2D2.getX();
        double d2 = 0.0;
        int n = bSCoulomb1DPotential.getNumberOfWells();
        d2 = n % 2 == 0 ? 2.0 * d : d;
        int n2 = bSPotentialSpec.getSpacingRange().getSignificantDecimalPlaces();
        d2 = BSCoulomb1DSpacingHandle.round(d2, n2);
        bSCoulomb1DPotential.setSpacing(d2);
        this.setValueDisplay(d2);
        bSCoulomb1DPotential.addObserver(this);
        this.updateDragBounds();
    }

    protected void updateView() {
        BSCoulomb1DPotential bSCoulomb1DPotential = (BSCoulomb1DPotential)this.getPotential();
        this.removePropertyChangeListener(this);
        double d = bSCoulomb1DPotential.getSpacing();
        int n = bSCoulomb1DPotential.getNumberOfWells();
        double d2 = bSCoulomb1DPotential.getOffset() - 5.0;
        double d3 = 0.0;
        d3 = n % 2 == 0 ? d / 2.0 : d;
        Point2D.Double double_ = new Point2D.Double(d3, d2);
        Point2D point2D = this.modelToView(double_);
        this.setGlobalPosition(point2D);
        this.setValueDisplay(d);
        this.addPropertyChangeListener(this);
    }
}

