/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.boundstates.draghandles;

import edu.colorado.phet.boundstates.BSConstants;
import edu.colorado.phet.boundstates.BSResources;
import edu.colorado.phet.boundstates.draghandles.BSPotentialHandle;
import edu.colorado.phet.boundstates.model.BSCoulomb1DPotential;
import edu.colorado.phet.boundstates.module.BSPotentialSpec;
import edu.colorado.phet.boundstates.view.BSCombinedChartNode;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class BSCoulomb1DOffsetHandle
extends BSPotentialHandle {
    public BSCoulomb1DOffsetHandle(BSCoulomb1DPotential bSCoulomb1DPotential, BSPotentialSpec bSPotentialSpec, BSCombinedChartNode bSCombinedChartNode) {
        super(bSCoulomb1DPotential, bSPotentialSpec, bSCombinedChartNode, 1);
        int n = bSPotentialSpec.getOffsetRange().getSignificantDecimalPlaces();
        String string = BSCoulomb1DOffsetHandle.createNumberFormat(n);
        this.setValueNumberFormat(string);
        this.setValuePattern(BSResources.getString("drag.offset"));
        this.updateDragBounds();
    }

    public void updateDragBounds() {
        BSPotentialSpec bSPotentialSpec = this.getPotentialSpec();
        BSCombinedChartNode bSCombinedChartNode = this.getChartNode();
        double d = BSConstants.POSITION_VIEW_RANGE.getLowerBound();
        double d2 = BSConstants.POSITION_VIEW_RANGE.getUpperBound();
        double d3 = bSCombinedChartNode.positionToNode(d);
        double d4 = bSCombinedChartNode.positionToNode(d2);
        double d5 = bSPotentialSpec.getOffsetRange().getMin();
        double d6 = bSPotentialSpec.getOffsetRange().getMax();
        double d7 = bSCombinedChartNode.energyToNode(d6);
        double d8 = bSCombinedChartNode.energyToNode(d5);
        double d9 = d4 - d3;
        double d10 = d8 - d7;
        Rectangle2D rectangle2D = new Rectangle2D.Double(d3, d7, d9, d10);
        rectangle2D = bSCombinedChartNode.localToGlobal(rectangle2D);
        this.setDragBounds(rectangle2D);
        this.updateView();
    }

    protected void updateModel() {
        double d;
        BSCoulomb1DPotential bSCoulomb1DPotential = (BSCoulomb1DPotential)this.getPotential();
        BSPotentialSpec bSPotentialSpec = this.getPotentialSpec();
        bSCoulomb1DPotential.deleteObserver(this);
        Point2D point2D = this.getGlobalPosition();
        Point2D point2D2 = this.viewToModel(point2D);
        double d2 = d = point2D2.getY();
        int n = bSPotentialSpec.getOffsetRange().getSignificantDecimalPlaces();
        d2 = BSCoulomb1DOffsetHandle.round(d2, n);
        bSCoulomb1DPotential.setOffset(d2);
        this.setValueDisplay(d2);
        bSCoulomb1DPotential.addObserver(this);
    }

    protected void updateView() {
        BSCoulomb1DPotential bSCoulomb1DPotential = (BSCoulomb1DPotential)this.getPotential();
        this.removePropertyChangeListener(this);
        double d = bSCoulomb1DPotential.getOffset();
        double d2 = BSConstants.POSITION_VIEW_RANGE.getUpperBound() - 1.25;
        double d3 = d;
        Point2D.Double double_ = new Point2D.Double(d2, d3);
        Point2D point2D = this.modelToView(double_);
        this.setGlobalPosition(point2D);
        this.setValueDisplay(d);
        this.addPropertyChangeListener(this);
    }
}

