/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.boundstates.draghandles;

import edu.colorado.phet.boundstates.draghandles.BSAbstractDragManager;
import edu.colorado.phet.boundstates.draghandles.BSAbstractHandle;
import edu.colorado.phet.boundstates.draghandles.BSAbstractMarker;
import edu.colorado.phet.boundstates.draghandles.BSCoulomb1DOffsetHandle;
import edu.colorado.phet.boundstates.draghandles.BSCoulomb1DSpacingHandle;
import edu.colorado.phet.boundstates.draghandles.BSCoulomb1DSpacingMarker;
import edu.colorado.phet.boundstates.model.BSCoulomb1DPotential;
import edu.colorado.phet.boundstates.module.BSAbstractModuleSpec;
import edu.colorado.phet.boundstates.module.BSPotentialSpec;
import edu.colorado.phet.boundstates.view.BSCombinedChartNode;
import edu.umd.cs.piccolo.PNode;
import java.util.Observable;
import java.util.Observer;

public class BSCoulomb1DDragManager
extends BSAbstractDragManager
implements Observer {
    private BSCoulomb1DPotential _potential = null;
    private BSAbstractHandle _spacingHandle = null;

    public BSCoulomb1DDragManager(BSAbstractModuleSpec bSAbstractModuleSpec, BSCombinedChartNode bSCombinedChartNode) {
        super(bSAbstractModuleSpec, bSCombinedChartNode);
    }

    public void setPotential(BSCoulomb1DPotential bSCoulomb1DPotential) {
        this.removeAllHandlesAndMarkers();
        this._spacingHandle = null;
        if (this._potential != null) {
            this._potential.deleteObserver(this);
        }
        this._potential = bSCoulomb1DPotential;
        if (this._potential != null) {
            this._potential.addObserver(this);
        }
        if (bSCoulomb1DPotential != null) {
            PNode pNode;
            BSAbstractModuleSpec bSAbstractModuleSpec = this.getModuleSpec();
            BSPotentialSpec bSPotentialSpec = bSAbstractModuleSpec.getCoulomb1DSpec();
            BSCombinedChartNode bSCombinedChartNode = this.getChartNode();
            if (bSAbstractModuleSpec.isOffsetControlSupported()) {
                pNode = new BSCoulomb1DOffsetHandle(bSCoulomb1DPotential, bSPotentialSpec, bSCombinedChartNode);
                this.addHandle((BSAbstractHandle)pNode);
            }
            if (bSAbstractModuleSpec.getNumberOfWellsRange().getMax() > 1) {
                pNode = new BSCoulomb1DSpacingMarker(bSCoulomb1DPotential, bSCombinedChartNode);
                this.addMarker((BSAbstractMarker)pNode);
                this._spacingHandle = new BSCoulomb1DSpacingHandle(bSCoulomb1DPotential, bSPotentialSpec, bSCombinedChartNode);
                this.addHandle(this._spacingHandle);
                this.updateSpacingHandle();
            }
        }
    }

    public void update(Observable observable, Object object) {
        this.updateSpacingHandle();
    }

    private void updateSpacingHandle() {
        if (this._spacingHandle != null && this._potential != null) {
            this._spacingHandle.setVisible(this._potential.getNumberOfWells() > 1);
        }
    }
}

