/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.boundstates.draghandles;

import edu.colorado.phet.boundstates.color.BSColorScheme;
import edu.colorado.phet.boundstates.draghandles.BSAbstractHandle;
import edu.colorado.phet.boundstates.draghandles.BSAbstractMarker;
import edu.colorado.phet.boundstates.module.BSAbstractModuleSpec;
import edu.colorado.phet.boundstates.view.BSCombinedChartNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolox.nodes.PClip;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

public abstract class BSAbstractDragManager
extends PClip {
    private BSAbstractModuleSpec _moduleSpec;
    private BSCombinedChartNode _chartNode;
    private ArrayList _handles;
    private ArrayList _markers;

    public BSAbstractDragManager(BSAbstractModuleSpec bSAbstractModuleSpec, BSCombinedChartNode bSCombinedChartNode) {
        this._moduleSpec = bSAbstractModuleSpec;
        this._chartNode = bSCombinedChartNode;
        this._handles = new ArrayList();
        this._markers = new ArrayList();
    }

    protected BSAbstractModuleSpec getModuleSpec() {
        return this._moduleSpec;
    }

    protected BSCombinedChartNode getChartNode() {
        return this._chartNode;
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this.updateLayout();
        }
        super.setVisible(bl);
        this.setChildrenPickable(bl);
    }

    protected void addHandle(BSAbstractHandle bSAbstractHandle) {
        this._handles.add(bSAbstractHandle);
        super.addChild(bSAbstractHandle);
    }

    protected void addMarker(BSAbstractMarker bSAbstractMarker) {
        this._markers.add(bSAbstractMarker);
        super.addChild(bSAbstractMarker);
    }

    protected void removeAllHandlesAndMarkers() {
        this.removeAllChildren();
        this._handles.clear();
        this._markers.clear();
    }

    public void addChild(PNode pNode) {
        throw new UnsupportedOperationException("use addHandle or addMarker");
    }

    public void updateLayout() {
        Rectangle2D rectangle2D = this._chartNode.getEnergyPlotBounds();
        Rectangle2D rectangle2D2 = this._chartNode.localToGlobal(rectangle2D);
        Rectangle2D rectangle2D3 = this.globalToLocal(rectangle2D2);
        this.setPathTo(rectangle2D3);
        for (Object object : this._markers) {
            ((BSAbstractMarker)object).updateView();
        }
        for (BSAbstractHandle bSAbstractHandle : this._handles) {
            bSAbstractHandle.updateDragBounds();
        }
    }

    public void setColorScheme(BSColorScheme bSColorScheme) {
        for (Object object : this._handles) {
            ((BSAbstractHandle)object).setColorScheme(bSColorScheme);
        }
        for (BSAbstractMarker bSAbstractMarker : this._markers) {
            bSAbstractMarker.setColorScheme(bSColorScheme);
        }
    }

    public PNode getHelpNode() {
        PNode pNode = null;
        if (this._handles.size() > 0) {
            pNode = (PNode)this._handles.get(0);
        }
        return pNode;
    }
}

