/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.boundstates.dialog;

import edu.colorado.phet.boundstates.BSResources;
import edu.colorado.phet.boundstates.dialog.BSAbstractConfigureDialog;
import edu.colorado.phet.boundstates.model.BSHarmonicOscillatorPotential;
import edu.colorado.phet.boundstates.module.BSAbstractModuleSpec;
import edu.colorado.phet.boundstates.module.BSPotentialSpec;
import edu.colorado.phet.common.phetcommon.util.DoubleRange;
import edu.colorado.phet.common.phetcommon.view.controls.valuecontrol.LinearValueControl;
import edu.colorado.phet.common.phetcommon.view.util.EasyGridBagLayout;
import java.awt.Container;
import java.awt.Frame;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class BSHarmonicOscillatorDialog
extends BSAbstractConfigureDialog {
    private LinearValueControl _offsetControl;
    private LinearValueControl _angularFrequencyControl;

    public BSHarmonicOscillatorDialog(Frame frame, BSHarmonicOscillatorPotential bSHarmonicOscillatorPotential, BSAbstractModuleSpec bSAbstractModuleSpec) {
        super(frame, BSResources.getString("BSHarmonicOscillatorDialog.title"), bSHarmonicOscillatorPotential);
        JPanel jPanel = this.createInputPanel(bSAbstractModuleSpec);
        this.createUI(jPanel);
        this.updateControls();
    }

    protected JPanel createInputPanel(BSAbstractModuleSpec bSAbstractModuleSpec) {
        int n;
        String string;
        String string2;
        double d;
        double d2;
        double d3;
        Object object;
        BSPotentialSpec bSPotentialSpec = bSAbstractModuleSpec.getHarmonicOscillatorSpec();
        String string3 = BSResources.getString("units.angularFrequency");
        String string4 = BSResources.getString("units.energy");
        if (bSAbstractModuleSpec.isOffsetControlSupported()) {
            object = bSPotentialSpec.getOffsetRange();
            d3 = ((DoubleRange)object).getDefault();
            d2 = ((DoubleRange)object).getMin();
            d = ((DoubleRange)object).getMax();
            string2 = BSResources.getString("label.wellOffset");
            string = "0.0";
            n = 4;
            this._offsetControl = new LinearValueControl(d2, d, string2, string, string4);
            this._offsetControl.setValue(d3);
            this._offsetControl.setUpDownArrowDelta(0.1);
            this._offsetControl.setTextFieldColumns(n);
            this._offsetControl.setTextFieldEditable(true);
            this._offsetControl.setNotifyWhileAdjusting(false);
            this._offsetControl.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    BSHarmonicOscillatorDialog.this.handleOffsetChange();
                }
            });
        }
        object = bSPotentialSpec.getAngularFrequencyRange();
        d3 = ((DoubleRange)object).getDefault();
        d2 = ((DoubleRange)object).getMin();
        d = ((DoubleRange)object).getMax();
        string2 = BSResources.getString("label.wellAngularFrequency");
        string = "0.0";
        n = 4;
        this._angularFrequencyControl = new LinearValueControl(d2, d, string2, string, string3);
        this._angularFrequencyControl.setValue(d3);
        this._angularFrequencyControl.setUpDownArrowDelta(0.1);
        this._angularFrequencyControl.setTextFieldColumns(n);
        this._angularFrequencyControl.setTextFieldEditable(true);
        this._angularFrequencyControl.setNotifyWhileAdjusting(false);
        this._angularFrequencyControl.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                BSHarmonicOscillatorDialog.this.handleAngularFrequencyChange();
            }
        });
        object = new JPanel();
        EasyGridBagLayout easyGridBagLayout = new EasyGridBagLayout((JPanel)object);
        ((Container)object).setLayout(easyGridBagLayout);
        easyGridBagLayout.setAnchor(17);
        int n2 = 0;
        int n3 = 0;
        if (this._offsetControl != null) {
            easyGridBagLayout.addComponent(this._offsetControl, n2, n3);
            easyGridBagLayout.addFilledComponent(new JSeparator(), ++n2, n3, 2);
            ++n2;
        }
        easyGridBagLayout.addComponent(this._angularFrequencyControl, n2, n3);
        ++n2;
        return object;
    }

    protected void updateControls() {
        BSHarmonicOscillatorPotential bSHarmonicOscillatorPotential = (BSHarmonicOscillatorPotential)this.getPotential();
        if (this._offsetControl != null) {
            this._offsetControl.setValue(bSHarmonicOscillatorPotential.getOffset());
        }
        this._angularFrequencyControl.setValue(bSHarmonicOscillatorPotential.getAngularFrequency());
    }

    private void handleOffsetChange() {
        double d = this._offsetControl.getValue();
        this.setObservePotential(false);
        this.getPotential().setOffset(d);
        this.setObservePotential(true);
        this.adjustClockState(this._offsetControl);
    }

    private void handleAngularFrequencyChange() {
        double d = this._angularFrequencyControl.getValue();
        this.setObservePotential(false);
        ((BSHarmonicOscillatorPotential)this.getPotential()).setAngularFrequency(d);
        this.setObservePotential(true);
        this.adjustClockState(this._angularFrequencyControl);
    }
}

