/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.boundstates.dialog;

import edu.colorado.phet.boundstates.BSResources;
import edu.colorado.phet.boundstates.dialog.BSAbstractConfigureDialog;
import edu.colorado.phet.boundstates.model.BSAsymmetricPotential;
import edu.colorado.phet.boundstates.module.BSAbstractModuleSpec;
import edu.colorado.phet.boundstates.module.BSPotentialSpec;
import edu.colorado.phet.common.phetcommon.util.DoubleRange;
import edu.colorado.phet.common.phetcommon.view.controls.valuecontrol.LinearValueControl;
import edu.colorado.phet.common.phetcommon.view.util.EasyGridBagLayout;
import java.awt.Container;
import java.awt.Frame;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class BSAsymmetricDialog
extends BSAbstractConfigureDialog {
    private LinearValueControl _offsetControl;
    private LinearValueControl _heightControl;
    private LinearValueControl _widthControl;

    public BSAsymmetricDialog(Frame frame, BSAsymmetricPotential bSAsymmetricPotential, BSAbstractModuleSpec bSAbstractModuleSpec) {
        super(frame, BSResources.getString("BSAsymmetricDialog.title"), bSAsymmetricPotential);
        JPanel jPanel = this.createInputPanel(bSAbstractModuleSpec);
        this.createUI(jPanel);
        this.updateControls();
    }

    private JPanel createInputPanel(BSAbstractModuleSpec bSAbstractModuleSpec) {
        int n;
        String string;
        String string2;
        double d;
        double d2;
        double d3;
        Object object;
        BSPotentialSpec bSPotentialSpec = bSAbstractModuleSpec.getAsymmetricSpec();
        String string3 = BSResources.getString("units.position");
        String string4 = BSResources.getString("units.energy");
        if (bSAbstractModuleSpec.isOffsetControlSupported()) {
            object = bSPotentialSpec.getOffsetRange();
            d3 = ((DoubleRange)object).getDefault();
            d2 = ((DoubleRange)object).getMin();
            d = ((DoubleRange)object).getMax();
            string2 = BSResources.getString("label.wellOffset");
            string = "0.0";
            n = 4;
            this._offsetControl = new LinearValueControl(d2, d, string2, string, string4);
            this._offsetControl.setValue(d3);
            this._offsetControl.setUpDownArrowDelta(0.1);
            this._offsetControl.setTextFieldColumns(n);
            this._offsetControl.setTextFieldEditable(true);
            this._offsetControl.setNotifyWhileAdjusting(false);
            this._offsetControl.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    BSAsymmetricDialog.this.handleOffsetChange();
                }
            });
        }
        object = bSPotentialSpec.getHeightRange();
        d3 = ((DoubleRange)object).getDefault();
        d2 = ((DoubleRange)object).getMin();
        d = ((DoubleRange)object).getMax();
        string2 = BSResources.getString("label.wellHeight");
        string = "0.0";
        n = 4;
        this._heightControl = new LinearValueControl(d2, d, string2, string, string4);
        this._heightControl.setValue(d3);
        this._heightControl.setUpDownArrowDelta(0.1);
        this._heightControl.setTextFieldColumns(n);
        this._heightControl.setTextFieldEditable(true);
        this._heightControl.setNotifyWhileAdjusting(false);
        this._heightControl.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                BSAsymmetricDialog.this.handleHeightChange();
            }
        });
        object = bSPotentialSpec.getWidthRange();
        d3 = ((DoubleRange)object).getDefault();
        d2 = ((DoubleRange)object).getMin();
        d = ((DoubleRange)object).getMax();
        string2 = BSResources.getString("label.wellWidth");
        string = "0.0";
        n = 4;
        this._widthControl = new LinearValueControl(d2, d, string2, string, string3);
        this._widthControl.setValue(d3);
        this._widthControl.setUpDownArrowDelta(0.1);
        this._widthControl.setTextFieldColumns(n);
        this._widthControl.setTextFieldEditable(true);
        this._widthControl.setNotifyWhileAdjusting(false);
        this._widthControl.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                BSAsymmetricDialog.this.handleWidthChange();
            }
        });
        object = new JPanel();
        EasyGridBagLayout easyGridBagLayout = new EasyGridBagLayout((JPanel)object);
        ((Container)object).setLayout(easyGridBagLayout);
        easyGridBagLayout.setAnchor(17);
        int n2 = 0;
        int n3 = 0;
        if (this._offsetControl != null) {
            easyGridBagLayout.addComponent(this._offsetControl, n2, n3);
            ++n2;
        }
        easyGridBagLayout.addFilledComponent(new JSeparator(), n2, n3, 2);
        easyGridBagLayout.addComponent(this._heightControl, ++n2, n3);
        easyGridBagLayout.addFilledComponent(new JSeparator(), ++n2, n3, 2);
        easyGridBagLayout.addComponent(this._widthControl, ++n2, n3);
        ++n2;
        return object;
    }

    protected void updateControls() {
        BSAsymmetricPotential bSAsymmetricPotential = (BSAsymmetricPotential)this.getPotential();
        if (this._offsetControl != null) {
            this._offsetControl.setValue(bSAsymmetricPotential.getOffset());
        }
        this._heightControl.setValue(bSAsymmetricPotential.getHeight());
        this._widthControl.setValue(bSAsymmetricPotential.getWidth());
    }

    private void handleOffsetChange() {
        double d = this._offsetControl.getValue();
        this.setObservePotential(false);
        this.getPotential().setOffset(d);
        this.setObservePotential(true);
        this.adjustClockState(this._offsetControl);
    }

    private void handleHeightChange() {
        double d = this._heightControl.getValue();
        this.setObservePotential(false);
        ((BSAsymmetricPotential)this.getPotential()).setHeight(d);
        this.setObservePotential(true);
        this.adjustClockState(this._heightControl);
    }

    private void handleWidthChange() {
        double d = this._widthControl.getValue();
        this.setObservePotential(false);
        ((BSAsymmetricPotential)this.getPotential()).setWidth(d);
        this.setObservePotential(true);
        this.adjustClockState(this._widthControl);
    }
}

