/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.boundstates.control;

import edu.colorado.phet.boundstates.BSResources;
import edu.colorado.phet.boundstates.util.AxisSpec;
import edu.colorado.phet.common.phetcommon.util.PhetUtilities;
import edu.colorado.phet.common.phetcommon.view.util.EasyGridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.axis.TickUnits;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.Range;

public class ZoomControl
extends JPanel {
    private int _orientation;
    private ArrayList _plots;
    private ZoomSpec _zoomSpec;
    private int _zoomIndex;
    private JButton _zoomInButton;
    private JButton _zoomOutButton;

    public ZoomControl(int n) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("invalid orientation: " + n);
        }
        if (PhetUtilities.isMacintosh()) {
            this.setOpaque(false);
        }
        this._orientation = n;
        this._plots = new ArrayList();
        this._zoomSpec = null;
        ImageIcon imageIcon = new ImageIcon(BSResources.getImage("zoomIn.gif"));
        this._zoomInButton = new JButton(imageIcon);
        this._zoomInButton.setOpaque(false);
        this._zoomInButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ZoomControl.this.handleZoomIn();
            }
        });
        ImageIcon imageIcon2 = new ImageIcon(BSResources.getImage("zoomOut.gif"));
        this._zoomOutButton = new JButton(imageIcon2);
        this._zoomOutButton.setOpaque(false);
        this._zoomOutButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ZoomControl.this.handleZoomOut();
            }
        });
        EasyGridBagLayout easyGridBagLayout = new EasyGridBagLayout(this);
        this.setLayout(easyGridBagLayout);
        if (n == 0) {
            easyGridBagLayout.setInsets(new Insets(0, 0, 0, 2));
            easyGridBagLayout.addComponent(this._zoomInButton, 0, 0);
            easyGridBagLayout.addComponent(this._zoomOutButton, 0, 1);
        } else {
            easyGridBagLayout.setInsets(new Insets(0, 0, 2, 0));
            easyGridBagLayout.addComponent(this._zoomInButton, 0, 0);
            easyGridBagLayout.addComponent(this._zoomOutButton, 1, 0);
        }
        this.updateButtons();
    }

    public void setZoomSpec(ZoomSpec zoomSpec) {
        this._zoomSpec = zoomSpec;
        this._zoomIndex = zoomSpec.getDefaultIndex();
        this.updateAxis();
        this.updateButtons();
    }

    public void addPlot(XYPlot xYPlot) {
        if (!this._plots.contains(xYPlot)) {
            this._plots.add(xYPlot);
            if (this._zoomSpec != null) {
                this.updateAxis();
            }
        }
    }

    private void handleZoomIn() {
        --this._zoomIndex;
        this.updateAxis();
        this.updateButtons();
    }

    private void handleZoomOut() {
        ++this._zoomIndex;
        this.updateAxis();
        this.updateButtons();
    }

    private void updateAxis() {
        AxisSpec axisSpec = this._zoomSpec.getAxisSpec(this._zoomIndex);
        Range range = axisSpec.getRange();
        double d = axisSpec.getTickSpacing();
        DecimalFormat decimalFormat = axisSpec.getTickFormat();
        TickUnits tickUnits = new TickUnits();
        tickUnits.add(new NumberTickUnit(d, decimalFormat));
        for (XYPlot xYPlot : this._plots) {
            if (this._orientation == 0) {
                xYPlot.getDomainAxis().setRange(range);
                xYPlot.getDomainAxis().setStandardTickUnits(tickUnits);
                continue;
            }
            xYPlot.getRangeAxis().setRange(range);
            xYPlot.getRangeAxis().setStandardTickUnits(tickUnits);
        }
    }

    private void updateButtons() {
        this._zoomInButton.setEnabled(this._zoomSpec != null && this._zoomIndex > 0);
        this._zoomOutButton.setEnabled(this._zoomSpec != null && this._zoomIndex < this._zoomSpec.getNumberOfZoomLevels() - 1);
    }

    public static class ZoomSpec {
        private AxisSpec[] _axisSpecs;
        private int _defaultIndex;

        public ZoomSpec(AxisSpec[] axisSpecArray, int n) {
            assert (axisSpecArray.length > 0);
            assert (n < axisSpecArray.length);
            this._axisSpecs = axisSpecArray;
            this._defaultIndex = n;
        }

        public ZoomSpec(AxisSpec[] axisSpecArray) {
            this(axisSpecArray, 0);
        }

        public ZoomSpec(AxisSpec axisSpec) {
            this._axisSpecs = new AxisSpec[1];
            this._axisSpecs[0] = axisSpec;
            this._defaultIndex = 0;
        }

        public int getNumberOfZoomLevels() {
            return this._axisSpecs.length;
        }

        public int getDefaultIndex() {
            return this._defaultIndex;
        }

        public AxisSpec getAxisSpec(int n) {
            return this._axisSpecs[n];
        }
    }
}

